/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */
#ifndef POWERMACRODATA_H
#define POWERMACRODATA_H

#define MACHINE_TYPE_ONLY_TABLET        2
#define MACHINE_TYPE_PC_AND_TABLET      3

#define POWER_SUPPLY_TYPE_BATTERY       2

#define FIXES 60

#define STYLE_FONT_SCHEMA     "org.ukui.style"

#define PROC_MANAGER            "org.ukui.process-manager"
#define RESOURCE_LIMIT_ENABLE   "resourceLimitEnable"

#define SCREENSAVER_SCHEMA         "org.ukui.screensaver"
#define SLEEP_ACTIVATION_ENABLED   "sleepActivationEnabled"
#define CLOSE_ACTIVATION_ENABLED   "closeActivationEnabled"

#define POWER_MANAGER_SETTINGS   "org.ukui.power-manager"
//按电源键时执行
#define GSETTINGS_KEY_BUTTON_POWER             "buttonPower"
//空闲关闭显示器
#define GSETTINGS_KEY_SLEEP_DISPLAY_AC         "sleepDisplayAc"
#define GSETTINGS_KEY_SLEEP_DISPLAY_BATTERY    "sleepDisplayBattery"
//空闲睡眠
#define GSETTINGS_KEY_SLEEP_COMPUTER_AC        "sleepComputerAc"
#define GSETTINGS_KEY_SLEEP_COMPUTER_BATTERY   "sleepComputerBattery"
//盒盖事件触发操作
#define GSETTINGS_KEY_BUTTON_LID_AC            "buttonLidAc"
#define GSETTINGS_KEY_BUTTON_LID_BATTERY       "buttonLidBattery"
//电源策略(0:节能 1:平衡 2:性能)
#define GSETTINGS_KEY_POWER_POLICY_AC          "powerPolicyAc"
#define GSETTINGS_KEY_POWER_POLICY_BATTERY     "powerPolicyBattery"
//开启节能模式
#define GSETTINGS_KEY_BATTERY_SAVE_SWITCH      "batterySaveSwitch"
//低电量时自动开启节能模式
#define GSETTINGS_KEY_LOW_BATTERY_AUTO_SAVE    "lowBatteryAutoSave"
//节能模式降低亮度
#define GSETTINGS_KEY_BATTERY_SAVE_REDUCE_BRIGHTNESS    "batterySaveReduceBrightness"
//低电量百分百通知
#define GSETTINGS_KEY_PERCENTAGE_LOW           "percentageLow"
//极低电量
#define GSETTINGS_KEY_PERCENTAGE_ACTION        "percentageAction"
//极低电量时执行
#define GSETTINGS_KEY_ACTION_CRITICAL_BATTERY  "actionCriticalBattery"

#endif // POWERMACRODATA_H
