// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-simulator-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/disasm-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define __ masm.
#define BUF_SIZE (4096)

#ifdef VIXL_INCLUDE_SIMULATOR_AARCH32
// Run tests with the simulator.

#define SETUP() MacroAssembler masm(BUF_SIZE)

#define START() masm.GetBuffer()->Reset()

#define END() \
  __ Hlt(0);  \
  __ FinalizeCode();

// TODO: Run the tests in the simulator.
#define RUN()

#else  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32.

#define SETUP()                  \
  MacroAssembler masm(BUF_SIZE); \
  UseScratchRegisterScope harness_scratch;

#define START()                 \
  harness_scratch.Open(&masm);  \
  harness_scratch.ExcludeAll(); \
  masm.GetBuffer()->Reset();    \
  __ Push(r4);                  \
  __ Push(r5);                  \
  __ Push(r6);                  \
  __ Push(r7);                  \
  __ Push(r8);                  \
  __ Push(r9);                  \
  __ Push(r10);                 \
  __ Push(r11);                 \
  __ Push(lr);                  \
  harness_scratch.Include(ip);

#define END()                  \
  harness_scratch.Exclude(ip); \
  __ Pop(lr);                  \
  __ Pop(r11);                 \
  __ Pop(r10);                 \
  __ Pop(r9);                  \
  __ Pop(r8);                  \
  __ Pop(r7);                  \
  __ Pop(r6);                  \
  __ Pop(r5);                  \
  __ Pop(r4);                  \
  __ Bx(lr);                   \
  __ FinalizeCode();           \
  harness_scratch.Close();

#define RUN()                                                 \
  {                                                           \
    int pcs_offset = masm.IsUsingT32() ? 1 : 0;               \
    masm.GetBuffer()->SetExecutable();                        \
    ExecuteMemory(masm.GetBuffer()->GetStartAddress<byte*>(), \
                  masm.GetSizeOfCodeGenerated(),              \
                  pcs_offset);                                \
    masm.GetBuffer()->SetWritable();                          \
  }

#endif  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32

namespace vixl {
namespace aarch32 {

// List of instruction encodings:
#define FOREACH_INSTRUCTION(M) \
  M(Ldr)                       \
  M(Ldrb)                      \
  M(Str)                       \
  M(Strb)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` and
// `Inputs` have various layouts across generated tests so they absolutely
// cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Sign sign;
  Register rm;
  ShiftType shift;
  uint32_t amount;
  AddrMode addr_mode;
};

// Input data to feed to the instruction.
struct Inputs {
  uint32_t apsr;
  uint32_t rd;
  uint32_t rm;
  uint32_t memop[2];
};

// This structure contains all input data needed to test one specific encoding.
// It used to generate a loop over an instruction.
struct TestLoopData {
  // The `operands` fields represents the values to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
  // Array of values to be fed to the instruction.
  size_t input_size;
  const Inputs* inputs;
};

static const Inputs kCondition[] = {{NFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {CFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {VFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {CVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NCVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZCVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZCVFlag, 0xabababab, 0, {0, 0x77777777}}};

static const Inputs kPositiveOffset[] =
    {{NoFlag, 0xabababab, 2590, {0, 0x77777777}},
     {NoFlag, 0xabababab, 180, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3870, {0, 0x77777777}},
     {NoFlag, 0xabababab, 618, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2650, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2091, {0, 0x77777777}},
     {NoFlag, 0xabababab, 778, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 282, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 263, {0, 0x77777777}},
     {NoFlag, 0xabababab, 200, {0, 0x0cabba9e}}};

static const Inputs kNegativeOffset[] =
    {{NoFlag, 0xabababab, 3743, {0, 0x77777777}},
     {NoFlag, 0xabababab, 2475, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 1159, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2345, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3625, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2381, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 4037, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 778, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3880, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3384, {0, 0x77777777}}};

static const Inputs kPositivePostIndex[] =
    {{NoFlag, 0xabababab, 1526, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 365, {0, 0x55555555}},
     {NoFlag, 0xabababab, 1948, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 958, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 969, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2695, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2690, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 523, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2046, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2490, {0, 0x0cabba9e}}};

static const Inputs kNegativePostIndex[] =
    {{NoFlag, 0xabababab, 4093, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 1860, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3157, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3069, {0, 0x55555555}},
     {NoFlag, 0xabababab, 932, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3287, {0, 0x55555555}},
     {NoFlag, 0xabababab, 685, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3685, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3039, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2245, {0, 0x0badbeef}}};

static const Inputs kPositivePreIndex[] =
    {{NoFlag, 0xabababab, 719, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2933, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 263, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2086, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2728, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3399, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2532, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3626, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 612, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3811, {0, 0x77777777}}};

static const Inputs kNegativePreIndex[] =
    {{NoFlag, 0xabababab, 3564, {0, 0x77777777}},
     {NoFlag, 0xabababab, 766, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2365, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2462, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3439, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2810, {0, 0x77777777}},
     {NoFlag, 0xabababab, 2590, {0, 0x55555555}},
     {NoFlag, 0xabababab, 1527, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 523, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2290, {0, 0x77777777}}};


// A loop will be generated for each element of this array.
const TestLoopData kTests[] =
    {{{eq, r0, r1, plus, r8, LSR, 1, Offset},
      "eq r0 r1 plus r8 LSR 1 Offset",
      "Condition_eq_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ne, r0, r1, plus, r8, LSR, 1, Offset},
      "ne r0 r1 plus r8 LSR 1 Offset",
      "Condition_ne_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cs, r0, r1, plus, r8, LSR, 1, Offset},
      "cs r0 r1 plus r8 LSR 1 Offset",
      "Condition_cs_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cc, r0, r1, plus, r8, LSR, 1, Offset},
      "cc r0 r1 plus r8 LSR 1 Offset",
      "Condition_cc_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{mi, r0, r1, plus, r8, LSR, 1, Offset},
      "mi r0 r1 plus r8 LSR 1 Offset",
      "Condition_mi_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{pl, r0, r1, plus, r8, LSR, 1, Offset},
      "pl r0 r1 plus r8 LSR 1 Offset",
      "Condition_pl_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vs, r0, r1, plus, r8, LSR, 1, Offset},
      "vs r0 r1 plus r8 LSR 1 Offset",
      "Condition_vs_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vc, r0, r1, plus, r8, LSR, 1, Offset},
      "vc r0 r1 plus r8 LSR 1 Offset",
      "Condition_vc_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{hi, r0, r1, plus, r8, LSR, 1, Offset},
      "hi r0 r1 plus r8 LSR 1 Offset",
      "Condition_hi_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ls, r0, r1, plus, r8, LSR, 1, Offset},
      "ls r0 r1 plus r8 LSR 1 Offset",
      "Condition_ls_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ge, r0, r1, plus, r8, LSR, 1, Offset},
      "ge r0 r1 plus r8 LSR 1 Offset",
      "Condition_ge_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{lt, r0, r1, plus, r8, LSR, 1, Offset},
      "lt r0 r1 plus r8 LSR 1 Offset",
      "Condition_lt_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{gt, r0, r1, plus, r8, LSR, 1, Offset},
      "gt r0 r1 plus r8 LSR 1 Offset",
      "Condition_gt_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{le, r0, r1, plus, r8, LSR, 1, Offset},
      "le r0 r1 plus r8 LSR 1 Offset",
      "Condition_le_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r0, r1, plus, r8, LSR, 1, Offset},
      "al r0 r1 plus r8 LSR 1 Offset",
      "Condition_al_r0_r1_plus_r8_LSR_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r1, r0, plus, r5, ASR, 24, Offset},
      "al r1 r0 plus r5 ASR 24 Offset",
      "PositiveOffset_al_r1_r0_plus_r5_ASR_24_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r10, plus, r4, LSR, 31, Offset},
      "al r3 r10 plus r4 LSR 31 Offset",
      "PositiveOffset_al_r3_r10_plus_r4_LSR_31_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r10, plus, r0, ASR, 16, Offset},
      "al r12 r10 plus r0 ASR 16 Offset",
      "PositiveOffset_al_r12_r10_plus_r0_ASR_16_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r10, plus, r9, ASR, 19, Offset},
      "al r4 r10 plus r9 ASR 19 Offset",
      "PositiveOffset_al_r4_r10_plus_r9_ASR_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r11, plus, r4, LSR, 17, Offset},
      "al r1 r11 plus r4 LSR 17 Offset",
      "PositiveOffset_al_r1_r11_plus_r4_LSR_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r8, plus, r11, LSR, 22, Offset},
      "al r1 r8 plus r11 LSR 22 Offset",
      "PositiveOffset_al_r1_r8_plus_r11_LSR_22_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r4, plus, r9, ASR, 25, Offset},
      "al r1 r4 plus r9 ASR 25 Offset",
      "PositiveOffset_al_r1_r4_plus_r9_ASR_25_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r4, plus, r0, LSR, 32, Offset},
      "al r8 r4 plus r0 LSR 32 Offset",
      "PositiveOffset_al_r8_r4_plus_r0_LSR_32_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r7, plus, r4, LSR, 7, Offset},
      "al r12 r7 plus r4 LSR 7 Offset",
      "PositiveOffset_al_r12_r7_plus_r4_LSR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r10, plus, r14, ASR, 11, Offset},
      "al r0 r10 plus r14 ASR 11 Offset",
      "PositiveOffset_al_r0_r10_plus_r14_ASR_11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r10, plus, r11, LSR, 32, Offset},
      "al r6 r10 plus r11 LSR 32 Offset",
      "PositiveOffset_al_r6_r10_plus_r11_LSR_32_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r10, plus, r8, LSR, 12, Offset},
      "al r2 r10 plus r8 LSR 12 Offset",
      "PositiveOffset_al_r2_r10_plus_r8_LSR_12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r12, plus, r9, ASR, 29, Offset},
      "al r0 r12 plus r9 ASR 29 Offset",
      "PositiveOffset_al_r0_r12_plus_r9_ASR_29_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r2, plus, r1, LSR, 19, Offset},
      "al r3 r2 plus r1 LSR 19 Offset",
      "PositiveOffset_al_r3_r2_plus_r1_LSR_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r7, plus, r3, ASR, 29, Offset},
      "al r10 r7 plus r3 ASR 29 Offset",
      "PositiveOffset_al_r10_r7_plus_r3_ASR_29_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r14, plus, r1, ASR, 30, Offset},
      "al r4 r14 plus r1 ASR 30 Offset",
      "PositiveOffset_al_r4_r14_plus_r1_ASR_30_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r3, plus, r1, LSR, 5, Offset},
      "al r5 r3 plus r1 LSR 5 Offset",
      "PositiveOffset_al_r5_r3_plus_r1_LSR_5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r9, plus, r0, LSR, 11, Offset},
      "al r2 r9 plus r0 LSR 11 Offset",
      "PositiveOffset_al_r2_r9_plus_r0_LSR_11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r14, plus, r5, LSR, 23, Offset},
      "al r6 r14 plus r5 LSR 23 Offset",
      "PositiveOffset_al_r6_r14_plus_r5_LSR_23_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r9, plus, r12, LSR, 8, Offset},
      "al r7 r9 plus r12 LSR 8 Offset",
      "PositiveOffset_al_r7_r9_plus_r12_LSR_8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r11, plus, r6, ASR, 16, Offset},
      "al r14 r11 plus r6 ASR 16 Offset",
      "PositiveOffset_al_r14_r11_plus_r6_ASR_16_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r2, plus, r12, LSR, 5, Offset},
      "al r4 r2 plus r12 LSR 5 Offset",
      "PositiveOffset_al_r4_r2_plus_r12_LSR_5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r7, plus, r11, LSR, 32, Offset},
      "al r12 r7 plus r11 LSR 32 Offset",
      "PositiveOffset_al_r12_r7_plus_r11_LSR_32_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r2, plus, r9, ASR, 21, Offset},
      "al r11 r2 plus r9 ASR 21 Offset",
      "PositiveOffset_al_r11_r2_plus_r9_ASR_21_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r2, plus, r14, ASR, 11, Offset},
      "al r7 r2 plus r14 ASR 11 Offset",
      "PositiveOffset_al_r7_r2_plus_r14_ASR_11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r14, plus, r0, ASR, 2, Offset},
      "al r12 r14 plus r0 ASR 2 Offset",
      "PositiveOffset_al_r12_r14_plus_r0_ASR_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r12, plus, r3, ASR, 18, Offset},
      "al r0 r12 plus r3 ASR 18 Offset",
      "PositiveOffset_al_r0_r12_plus_r3_ASR_18_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r3, plus, r2, LSR, 4, Offset},
      "al r14 r3 plus r2 LSR 4 Offset",
      "PositiveOffset_al_r14_r3_plus_r2_LSR_4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r10, plus, r9, LSR, 20, Offset},
      "al r2 r10 plus r9 LSR 20 Offset",
      "PositiveOffset_al_r2_r10_plus_r9_LSR_20_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r14, plus, r12, LSR, 8, Offset},
      "al r4 r14 plus r12 LSR 8 Offset",
      "PositiveOffset_al_r4_r14_plus_r12_LSR_8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r4, plus, r5, ASR, 24, Offset},
      "al r10 r4 plus r5 ASR 24 Offset",
      "PositiveOffset_al_r10_r4_plus_r5_ASR_24_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r3, plus, r8, LSR, 22, Offset},
      "al r11 r3 plus r8 LSR 22 Offset",
      "PositiveOffset_al_r11_r3_plus_r8_LSR_22_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r2, plus, r10, ASR, 7, Offset},
      "al r7 r2 plus r10 ASR 7 Offset",
      "PositiveOffset_al_r7_r2_plus_r10_ASR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r9, plus, r6, ASR, 27, Offset},
      "al r8 r9 plus r6 ASR 27 Offset",
      "PositiveOffset_al_r8_r9_plus_r6_ASR_27_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r2, plus, r6, ASR, 10, Offset},
      "al r1 r2 plus r6 ASR 10 Offset",
      "PositiveOffset_al_r1_r2_plus_r6_ASR_10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r9, plus, r1, ASR, 19, Offset},
      "al r11 r9 plus r1 ASR 19 Offset",
      "PositiveOffset_al_r11_r9_plus_r1_ASR_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r2, plus, r10, ASR, 31, Offset},
      "al r3 r2 plus r10 ASR 31 Offset",
      "PositiveOffset_al_r3_r2_plus_r10_ASR_31_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r6, plus, r11, ASR, 12, Offset},
      "al r7 r6 plus r11 ASR 12 Offset",
      "PositiveOffset_al_r7_r6_plus_r11_ASR_12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r0, plus, r5, LSR, 10, Offset},
      "al r4 r0 plus r5 LSR 10 Offset",
      "PositiveOffset_al_r4_r0_plus_r5_LSR_10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r2, plus, r12, ASR, 22, Offset},
      "al r3 r2 plus r12 ASR 22 Offset",
      "PositiveOffset_al_r3_r2_plus_r12_ASR_22_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r7, plus, r0, ASR, 13, Offset},
      "al r11 r7 plus r0 ASR 13 Offset",
      "PositiveOffset_al_r11_r7_plus_r0_ASR_13_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r2, plus, r0, ASR, 9, Offset},
      "al r1 r2 plus r0 ASR 9 Offset",
      "PositiveOffset_al_r1_r2_plus_r0_ASR_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r3, plus, r11, ASR, 9, Offset},
      "al r6 r3 plus r11 ASR 9 Offset",
      "PositiveOffset_al_r6_r3_plus_r11_ASR_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r12, plus, r4, ASR, 4, Offset},
      "al r14 r12 plus r4 ASR 4 Offset",
      "PositiveOffset_al_r14_r12_plus_r4_ASR_4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r3, plus, r0, LSR, 14, Offset},
      "al r7 r3 plus r0 LSR 14 Offset",
      "PositiveOffset_al_r7_r3_plus_r0_LSR_14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r0, plus, r5, ASR, 4, Offset},
      "al r7 r0 plus r5 ASR 4 Offset",
      "PositiveOffset_al_r7_r0_plus_r5_ASR_4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r1, plus, r6, ASR, 13, Offset},
      "al r12 r1 plus r6 ASR 13 Offset",
      "PositiveOffset_al_r12_r1_plus_r6_ASR_13_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r9, plus, r5, ASR, 32, Offset},
      "al r14 r9 plus r5 ASR 32 Offset",
      "PositiveOffset_al_r14_r9_plus_r5_ASR_32_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r2, plus, r1, ASR, 24, Offset},
      "al r8 r2 plus r1 ASR 24 Offset",
      "PositiveOffset_al_r8_r2_plus_r1_ASR_24_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r10, plus, r7, ASR, 3, Offset},
      "al r8 r10 plus r7 ASR 3 Offset",
      "PositiveOffset_al_r8_r10_plus_r7_ASR_3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r1, plus, r11, LSR, 15, Offset},
      "al r3 r1 plus r11 LSR 15 Offset",
      "PositiveOffset_al_r3_r1_plus_r11_LSR_15_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r11, plus, r0, LSR, 19, Offset},
      "al r3 r11 plus r0 LSR 19 Offset",
      "PositiveOffset_al_r3_r11_plus_r0_LSR_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r0, plus, r9, ASR, 8, Offset},
      "al r12 r0 plus r9 ASR 8 Offset",
      "PositiveOffset_al_r12_r0_plus_r9_ASR_8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r8, plus, r2, ASR, 22, Offset},
      "al r5 r8 plus r2 ASR 22 Offset",
      "PositiveOffset_al_r5_r8_plus_r2_ASR_22_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r10, plus, r6, ASR, 17, Offset},
      "al r12 r10 plus r6 ASR 17 Offset",
      "PositiveOffset_al_r12_r10_plus_r6_ASR_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r10, plus, r9, ASR, 7, Offset},
      "al r14 r10 plus r9 ASR 7 Offset",
      "PositiveOffset_al_r14_r10_plus_r9_ASR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r7, plus, r0, ASR, 3, Offset},
      "al r2 r7 plus r0 ASR 3 Offset",
      "PositiveOffset_al_r2_r7_plus_r0_ASR_3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r6, plus, r12, LSR, 5, Offset},
      "al r1 r6 plus r12 LSR 5 Offset",
      "PositiveOffset_al_r1_r6_plus_r12_LSR_5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r8, plus, r7, LSR, 2, Offset},
      "al r9 r8 plus r7 LSR 2 Offset",
      "PositiveOffset_al_r9_r8_plus_r7_LSR_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r9, plus, r0, ASR, 23, Offset},
      "al r4 r9 plus r0 ASR 23 Offset",
      "PositiveOffset_al_r4_r9_plus_r0_ASR_23_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r9, plus, r10, LSR, 14, Offset},
      "al r6 r9 plus r10 LSR 14 Offset",
      "PositiveOffset_al_r6_r9_plus_r10_LSR_14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r0, plus, r2, ASR, 11, Offset},
      "al r14 r0 plus r2 ASR 11 Offset",
      "PositiveOffset_al_r14_r0_plus_r2_ASR_11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r2, plus, r0, LSR, 24, Offset},
      "al r8 r2 plus r0 LSR 24 Offset",
      "PositiveOffset_al_r8_r2_plus_r0_LSR_24_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r4, plus, r5, LSR, 5, Offset},
      "al r12 r4 plus r5 LSR 5 Offset",
      "PositiveOffset_al_r12_r4_plus_r5_LSR_5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r6, plus, r5, LSR, 11, Offset},
      "al r9 r6 plus r5 LSR 11 Offset",
      "PositiveOffset_al_r9_r6_plus_r5_LSR_11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r6, plus, r14, LSR, 4, Offset},
      "al r5 r6 plus r14 LSR 4 Offset",
      "PositiveOffset_al_r5_r6_plus_r14_LSR_4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r0, plus, r10, LSR, 15, Offset},
      "al r2 r0 plus r10 LSR 15 Offset",
      "PositiveOffset_al_r2_r0_plus_r10_LSR_15_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r5, plus, r1, LSR, 22, Offset},
      "al r9 r5 plus r1 LSR 22 Offset",
      "PositiveOffset_al_r9_r5_plus_r1_LSR_22_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r6, plus, r0, LSR, 26, Offset},
      "al r5 r6 plus r0 LSR 26 Offset",
      "PositiveOffset_al_r5_r6_plus_r0_LSR_26_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r6, plus, r5, ASR, 19, Offset},
      "al r9 r6 plus r5 ASR 19 Offset",
      "PositiveOffset_al_r9_r6_plus_r5_ASR_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r12, plus, r11, ASR, 3, Offset},
      "al r6 r12 plus r11 ASR 3 Offset",
      "PositiveOffset_al_r6_r12_plus_r11_ASR_3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r1, plus, r4, ASR, 30, Offset},
      "al r8 r1 plus r4 ASR 30 Offset",
      "PositiveOffset_al_r8_r1_plus_r4_ASR_30_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r10, plus, r5, LSR, 22, Offset},
      "al r3 r10 plus r5 LSR 22 Offset",
      "PositiveOffset_al_r3_r10_plus_r5_LSR_22_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r8, plus, r6, ASR, 8, Offset},
      "al r3 r8 plus r6 ASR 8 Offset",
      "PositiveOffset_al_r3_r8_plus_r6_ASR_8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r5, plus, r9, ASR, 26, Offset},
      "al r1 r5 plus r9 ASR 26 Offset",
      "PositiveOffset_al_r1_r5_plus_r9_ASR_26_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r14, plus, r0, LSR, 7, Offset},
      "al r6 r14 plus r0 LSR 7 Offset",
      "PositiveOffset_al_r6_r14_plus_r0_LSR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r2, plus, r14, LSR, 20, Offset},
      "al r8 r2 plus r14 LSR 20 Offset",
      "PositiveOffset_al_r8_r2_plus_r14_LSR_20_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r11, plus, r2, LSR, 16, Offset},
      "al r5 r11 plus r2 LSR 16 Offset",
      "PositiveOffset_al_r5_r11_plus_r2_LSR_16_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r3, plus, r9, ASR, 23, Offset},
      "al r6 r3 plus r9 ASR 23 Offset",
      "PositiveOffset_al_r6_r3_plus_r9_ASR_23_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r14, plus, r0, LSR, 9, Offset},
      "al r7 r14 plus r0 LSR 9 Offset",
      "PositiveOffset_al_r7_r14_plus_r0_LSR_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r0, plus, r14, ASR, 7, Offset},
      "al r2 r0 plus r14 ASR 7 Offset",
      "PositiveOffset_al_r2_r0_plus_r14_ASR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r12, plus, r5, LSR, 9, Offset},
      "al r9 r12 plus r5 LSR 9 Offset",
      "PositiveOffset_al_r9_r12_plus_r5_LSR_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r4, plus, r3, LSR, 14, Offset},
      "al r7 r4 plus r3 LSR 14 Offset",
      "PositiveOffset_al_r7_r4_plus_r3_LSR_14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r0, plus, r10, ASR, 20, Offset},
      "al r11 r0 plus r10 ASR 20 Offset",
      "PositiveOffset_al_r11_r0_plus_r10_ASR_20_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r0, plus, r1, LSR, 21, Offset},
      "al r11 r0 plus r1 LSR 21 Offset",
      "PositiveOffset_al_r11_r0_plus_r1_LSR_21_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r9, plus, r8, ASR, 14, Offset},
      "al r11 r9 plus r8 ASR 14 Offset",
      "PositiveOffset_al_r11_r9_plus_r8_ASR_14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r14, plus, r10, ASR, 10, Offset},
      "al r5 r14 plus r10 ASR 10 Offset",
      "PositiveOffset_al_r5_r14_plus_r10_ASR_10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r11, plus, r2, LSR, 12, Offset},
      "al r1 r11 plus r2 LSR 12 Offset",
      "PositiveOffset_al_r1_r11_plus_r2_LSR_12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r12, plus, r0, ASR, 7, Offset},
      "al r14 r12 plus r0 ASR 7 Offset",
      "PositiveOffset_al_r14_r12_plus_r0_ASR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r6, plus, r4, ASR, 2, Offset},
      "al r14 r6 plus r4 ASR 2 Offset",
      "PositiveOffset_al_r14_r6_plus_r4_ASR_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r8, plus, r1, ASR, 9, Offset},
      "al r4 r8 plus r1 ASR 9 Offset",
      "PositiveOffset_al_r4_r8_plus_r1_ASR_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r8, plus, r2, LSR, 2, Offset},
      "al r4 r8 plus r2 LSR 2 Offset",
      "PositiveOffset_al_r4_r8_plus_r2_LSR_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r11, plus, r14, LSR, 17, Offset},
      "al r0 r11 plus r14 LSR 17 Offset",
      "PositiveOffset_al_r0_r11_plus_r14_LSR_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r14, plus, r8, LSR, 31, Offset},
      "al r4 r14 plus r8 LSR 31 Offset",
      "PositiveOffset_al_r4_r14_plus_r8_LSR_31_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r12, plus, r7, ASR, 1, Offset},
      "al r1 r12 plus r7 ASR 1 Offset",
      "PositiveOffset_al_r1_r12_plus_r7_ASR_1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r6, plus, r10, LSR, 7, Offset},
      "al r12 r6 plus r10 LSR 7 Offset",
      "PositiveOffset_al_r12_r6_plus_r10_LSR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r5, plus, r11, LSR, 9, Offset},
      "al r1 r5 plus r11 LSR 9 Offset",
      "PositiveOffset_al_r1_r5_plus_r11_LSR_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r5, plus, r10, LSR, 16, Offset},
      "al r6 r5 plus r10 LSR 16 Offset",
      "PositiveOffset_al_r6_r5_plus_r10_LSR_16_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r8, plus, r14, ASR, 18, Offset},
      "al r6 r8 plus r14 ASR 18 Offset",
      "PositiveOffset_al_r6_r8_plus_r14_ASR_18_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r11, plus, r1, ASR, 20, Offset},
      "al r5 r11 plus r1 ASR 20 Offset",
      "PositiveOffset_al_r5_r11_plus_r1_ASR_20_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r12, minus, r11, LSR, 3, Offset},
      "al r6 r12 minus r11 LSR 3 Offset",
      "NegativeOffset_al_r6_r12_minus_r11_LSR_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, r6, ASR, 15, Offset},
      "al r4 r10 minus r6 ASR 15 Offset",
      "NegativeOffset_al_r4_r10_minus_r6_ASR_15_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r2, minus, r3, LSR, 4, Offset},
      "al r6 r2 minus r3 LSR 4 Offset",
      "NegativeOffset_al_r6_r2_minus_r3_LSR_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r10, minus, r11, LSR, 15, Offset},
      "al r9 r10 minus r11 LSR 15 Offset",
      "NegativeOffset_al_r9_r10_minus_r11_LSR_15_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r14, minus, r10, LSR, 6, Offset},
      "al r9 r14 minus r10 LSR 6 Offset",
      "NegativeOffset_al_r9_r14_minus_r10_LSR_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r14, minus, r8, LSR, 8, Offset},
      "al r9 r14 minus r8 LSR 8 Offset",
      "NegativeOffset_al_r9_r14_minus_r8_LSR_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r5, minus, r4, LSR, 30, Offset},
      "al r14 r5 minus r4 LSR 30 Offset",
      "NegativeOffset_al_r14_r5_minus_r4_LSR_30_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r10, minus, r4, LSR, 12, Offset},
      "al r2 r10 minus r4 LSR 12 Offset",
      "NegativeOffset_al_r2_r10_minus_r4_LSR_12_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r14, minus, r8, ASR, 3, Offset},
      "al r12 r14 minus r8 ASR 3 Offset",
      "NegativeOffset_al_r12_r14_minus_r8_ASR_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r1, minus, r10, LSR, 26, Offset},
      "al r7 r1 minus r10 LSR 26 Offset",
      "NegativeOffset_al_r7_r1_minus_r10_LSR_26_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r0, minus, r6, ASR, 23, Offset},
      "al r4 r0 minus r6 ASR 23 Offset",
      "NegativeOffset_al_r4_r0_minus_r6_ASR_23_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r7, minus, r3, LSR, 3, Offset},
      "al r10 r7 minus r3 LSR 3 Offset",
      "NegativeOffset_al_r10_r7_minus_r3_LSR_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r2, minus, r0, LSR, 3, Offset},
      "al r5 r2 minus r0 LSR 3 Offset",
      "NegativeOffset_al_r5_r2_minus_r0_LSR_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r9, minus, r3, ASR, 15, Offset},
      "al r10 r9 minus r3 ASR 15 Offset",
      "NegativeOffset_al_r10_r9_minus_r3_ASR_15_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r12, minus, r11, ASR, 30, Offset},
      "al r10 r12 minus r11 ASR 30 Offset",
      "NegativeOffset_al_r10_r12_minus_r11_ASR_30_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r10, minus, r8, LSR, 8, Offset},
      "al r3 r10 minus r8 LSR 8 Offset",
      "NegativeOffset_al_r3_r10_minus_r8_LSR_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r0, minus, r9, ASR, 15, Offset},
      "al r3 r0 minus r9 ASR 15 Offset",
      "NegativeOffset_al_r3_r0_minus_r9_ASR_15_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r11, minus, r10, ASR, 31, Offset},
      "al r8 r11 minus r10 ASR 31 Offset",
      "NegativeOffset_al_r8_r11_minus_r10_ASR_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r8, minus, r5, LSR, 10, Offset},
      "al r2 r8 minus r5 LSR 10 Offset",
      "NegativeOffset_al_r2_r8_minus_r5_LSR_10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r3, minus, r6, LSR, 24, Offset},
      "al r4 r3 minus r6 LSR 24 Offset",
      "NegativeOffset_al_r4_r3_minus_r6_LSR_24_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r2, minus, r12, ASR, 1, Offset},
      "al r14 r2 minus r12 ASR 1 Offset",
      "NegativeOffset_al_r14_r2_minus_r12_ASR_1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r12, minus, r10, ASR, 4, Offset},
      "al r4 r12 minus r10 ASR 4 Offset",
      "NegativeOffset_al_r4_r12_minus_r10_ASR_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r2, minus, r10, ASR, 16, Offset},
      "al r5 r2 minus r10 ASR 16 Offset",
      "NegativeOffset_al_r5_r2_minus_r10_ASR_16_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r8, minus, r2, LSR, 8, Offset},
      "al r4 r8 minus r2 LSR 8 Offset",
      "NegativeOffset_al_r4_r8_minus_r2_LSR_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r3, minus, r4, LSR, 11, Offset},
      "al r6 r3 minus r4 LSR 11 Offset",
      "NegativeOffset_al_r6_r3_minus_r4_LSR_11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r10, minus, r4, ASR, 31, Offset},
      "al r1 r10 minus r4 ASR 31 Offset",
      "NegativeOffset_al_r1_r10_minus_r4_ASR_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r8, minus, r0, ASR, 6, Offset},
      "al r14 r8 minus r0 ASR 6 Offset",
      "NegativeOffset_al_r14_r8_minus_r0_ASR_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r5, minus, r1, LSR, 14, Offset},
      "al r10 r5 minus r1 LSR 14 Offset",
      "NegativeOffset_al_r10_r5_minus_r1_LSR_14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r10, minus, r1, ASR, 20, Offset},
      "al r12 r10 minus r1 ASR 20 Offset",
      "NegativeOffset_al_r12_r10_minus_r1_ASR_20_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r10, minus, r8, LSR, 29, Offset},
      "al r3 r10 minus r8 LSR 29 Offset",
      "NegativeOffset_al_r3_r10_minus_r8_LSR_29_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r1, minus, r10, ASR, 31, Offset},
      "al r11 r1 minus r10 ASR 31 Offset",
      "NegativeOffset_al_r11_r1_minus_r10_ASR_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r12, minus, r7, ASR, 24, Offset},
      "al r2 r12 minus r7 ASR 24 Offset",
      "NegativeOffset_al_r2_r12_minus_r7_ASR_24_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r1, minus, r3, LSR, 30, Offset},
      "al r6 r1 minus r3 LSR 30 Offset",
      "NegativeOffset_al_r6_r1_minus_r3_LSR_30_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r11, minus, r10, ASR, 24, Offset},
      "al r8 r11 minus r10 ASR 24 Offset",
      "NegativeOffset_al_r8_r11_minus_r10_ASR_24_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r11, minus, r2, ASR, 9, Offset},
      "al r1 r11 minus r2 ASR 9 Offset",
      "NegativeOffset_al_r1_r11_minus_r2_ASR_9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r3, minus, r12, ASR, 2, Offset},
      "al r7 r3 minus r12 ASR 2 Offset",
      "NegativeOffset_al_r7_r3_minus_r12_ASR_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r8, minus, r12, ASR, 19, Offset},
      "al r11 r8 minus r12 ASR 19 Offset",
      "NegativeOffset_al_r11_r8_minus_r12_ASR_19_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r7, minus, r0, ASR, 2, Offset},
      "al r11 r7 minus r0 ASR 2 Offset",
      "NegativeOffset_al_r11_r7_minus_r0_ASR_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r0, minus, r6, ASR, 4, Offset},
      "al r12 r0 minus r6 ASR 4 Offset",
      "NegativeOffset_al_r12_r0_minus_r6_ASR_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r10, minus, r12, ASR, 9, Offset},
      "al r8 r10 minus r12 ASR 9 Offset",
      "NegativeOffset_al_r8_r10_minus_r12_ASR_9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r9, minus, r6, LSR, 20, Offset},
      "al r11 r9 minus r6 LSR 20 Offset",
      "NegativeOffset_al_r11_r9_minus_r6_LSR_20_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r3, minus, r0, ASR, 14, Offset},
      "al r11 r3 minus r0 ASR 14 Offset",
      "NegativeOffset_al_r11_r3_minus_r0_ASR_14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r7, minus, r14, LSR, 16, Offset},
      "al r6 r7 minus r14 LSR 16 Offset",
      "NegativeOffset_al_r6_r7_minus_r14_LSR_16_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r5, minus, r7, LSR, 32, Offset},
      "al r2 r5 minus r7 LSR 32 Offset",
      "NegativeOffset_al_r2_r5_minus_r7_LSR_32_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r5, minus, r6, ASR, 10, Offset},
      "al r7 r5 minus r6 ASR 10 Offset",
      "NegativeOffset_al_r7_r5_minus_r6_ASR_10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r5, minus, r4, ASR, 22, Offset},
      "al r10 r5 minus r4 ASR 22 Offset",
      "NegativeOffset_al_r10_r5_minus_r4_ASR_22_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r9, minus, r8, ASR, 3, Offset},
      "al r10 r9 minus r8 ASR 3 Offset",
      "NegativeOffset_al_r10_r9_minus_r8_ASR_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r10, minus, r8, LSR, 31, Offset},
      "al r12 r10 minus r8 LSR 31 Offset",
      "NegativeOffset_al_r12_r10_minus_r8_LSR_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r9, minus, r11, LSR, 24, Offset},
      "al r1 r9 minus r11 LSR 24 Offset",
      "NegativeOffset_al_r1_r9_minus_r11_LSR_24_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r10, minus, r4, LSR, 15, Offset},
      "al r2 r10 minus r4 LSR 15 Offset",
      "NegativeOffset_al_r2_r10_minus_r4_LSR_15_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r7, minus, r10, ASR, 7, Offset},
      "al r3 r7 minus r10 ASR 7 Offset",
      "NegativeOffset_al_r3_r7_minus_r10_ASR_7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r0, minus, r4, ASR, 23, Offset},
      "al r14 r0 minus r4 ASR 23 Offset",
      "NegativeOffset_al_r14_r0_minus_r4_ASR_23_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r3, minus, r10, LSR, 19, Offset},
      "al r4 r3 minus r10 LSR 19 Offset",
      "NegativeOffset_al_r4_r3_minus_r10_LSR_19_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r1, minus, r0, LSR, 31, Offset},
      "al r8 r1 minus r0 LSR 31 Offset",
      "NegativeOffset_al_r8_r1_minus_r0_LSR_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r4, minus, r5, LSR, 2, Offset},
      "al r3 r4 minus r5 LSR 2 Offset",
      "NegativeOffset_al_r3_r4_minus_r5_LSR_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r3, minus, r4, LSR, 22, Offset},
      "al r11 r3 minus r4 LSR 22 Offset",
      "NegativeOffset_al_r11_r3_minus_r4_LSR_22_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r5, minus, r1, LSR, 25, Offset},
      "al r9 r5 minus r1 LSR 25 Offset",
      "NegativeOffset_al_r9_r5_minus_r1_LSR_25_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r2, minus, r9, LSR, 24, Offset},
      "al r1 r2 minus r9 LSR 24 Offset",
      "NegativeOffset_al_r1_r2_minus_r9_LSR_24_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r8, minus, r14, ASR, 29, Offset},
      "al r1 r8 minus r14 ASR 29 Offset",
      "NegativeOffset_al_r1_r8_minus_r14_ASR_29_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r4, minus, r5, LSR, 17, Offset},
      "al r6 r4 minus r5 LSR 17 Offset",
      "NegativeOffset_al_r6_r4_minus_r5_LSR_17_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r10, minus, r11, ASR, 29, Offset},
      "al r6 r10 minus r11 ASR 29 Offset",
      "NegativeOffset_al_r6_r10_minus_r11_ASR_29_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, r7, ASR, 10, Offset},
      "al r4 r10 minus r7 ASR 10 Offset",
      "NegativeOffset_al_r4_r10_minus_r7_ASR_10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r4, minus, r7, LSR, 1, Offset},
      "al r6 r4 minus r7 LSR 1 Offset",
      "NegativeOffset_al_r6_r4_minus_r7_LSR_1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r7, minus, r8, ASR, 11, Offset},
      "al r2 r7 minus r8 ASR 11 Offset",
      "NegativeOffset_al_r2_r7_minus_r8_ASR_11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r7, minus, r14, ASR, 13, Offset},
      "al r9 r7 minus r14 ASR 13 Offset",
      "NegativeOffset_al_r9_r7_minus_r14_ASR_13_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r10, minus, r8, ASR, 27, Offset},
      "al r14 r10 minus r8 ASR 27 Offset",
      "NegativeOffset_al_r14_r10_minus_r8_ASR_27_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r14, minus, r1, ASR, 26, Offset},
      "al r10 r14 minus r1 ASR 26 Offset",
      "NegativeOffset_al_r10_r14_minus_r1_ASR_26_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r4, minus, r9, ASR, 20, Offset},
      "al r6 r4 minus r9 ASR 20 Offset",
      "NegativeOffset_al_r6_r4_minus_r9_ASR_20_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r6, minus, r11, ASR, 23, Offset},
      "al r0 r6 minus r11 ASR 23 Offset",
      "NegativeOffset_al_r0_r6_minus_r11_ASR_23_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r3, minus, r9, ASR, 4, Offset},
      "al r8 r3 minus r9 ASR 4 Offset",
      "NegativeOffset_al_r8_r3_minus_r9_ASR_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r1, minus, r8, LSR, 27, Offset},
      "al r7 r1 minus r8 LSR 27 Offset",
      "NegativeOffset_al_r7_r1_minus_r8_LSR_27_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r5, minus, r7, LSR, 18, Offset},
      "al r14 r5 minus r7 LSR 18 Offset",
      "NegativeOffset_al_r14_r5_minus_r7_LSR_18_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r7, minus, r3, LSR, 25, Offset},
      "al r12 r7 minus r3 LSR 25 Offset",
      "NegativeOffset_al_r12_r7_minus_r3_LSR_25_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, r14, LSR, 27, Offset},
      "al r4 r10 minus r14 LSR 27 Offset",
      "NegativeOffset_al_r4_r10_minus_r14_LSR_27_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r7, minus, r8, LSR, 3, Offset},
      "al r14 r7 minus r8 LSR 3 Offset",
      "NegativeOffset_al_r14_r7_minus_r8_LSR_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r9, minus, r5, LSR, 5, Offset},
      "al r6 r9 minus r5 LSR 5 Offset",
      "NegativeOffset_al_r6_r9_minus_r5_LSR_5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r11, minus, r1, LSR, 12, Offset},
      "al r10 r11 minus r1 LSR 12 Offset",
      "NegativeOffset_al_r10_r11_minus_r1_LSR_12_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r12, minus, r0, LSR, 28, Offset},
      "al r8 r12 minus r0 LSR 28 Offset",
      "NegativeOffset_al_r8_r12_minus_r0_LSR_28_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r6, minus, r2, LSR, 25, Offset},
      "al r0 r6 minus r2 LSR 25 Offset",
      "NegativeOffset_al_r0_r6_minus_r2_LSR_25_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r3, minus, r10, ASR, 4, Offset},
      "al r12 r3 minus r10 ASR 4 Offset",
      "NegativeOffset_al_r12_r3_minus_r10_ASR_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r10, minus, r12, LSR, 4, Offset},
      "al r0 r10 minus r12 LSR 4 Offset",
      "NegativeOffset_al_r0_r10_minus_r12_LSR_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r14, minus, r7, ASR, 1, Offset},
      "al r10 r14 minus r7 ASR 1 Offset",
      "NegativeOffset_al_r10_r14_minus_r7_ASR_1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r9, minus, r0, ASR, 14, Offset},
      "al r4 r9 minus r0 ASR 14 Offset",
      "NegativeOffset_al_r4_r9_minus_r0_ASR_14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r12, minus, r0, LSR, 8, Offset},
      "al r6 r12 minus r0 LSR 8 Offset",
      "NegativeOffset_al_r6_r12_minus_r0_LSR_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r9, minus, r3, LSR, 22, Offset},
      "al r6 r9 minus r3 LSR 22 Offset",
      "NegativeOffset_al_r6_r9_minus_r3_LSR_22_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r11, minus, r6, LSR, 21, Offset},
      "al r14 r11 minus r6 LSR 21 Offset",
      "NegativeOffset_al_r14_r11_minus_r6_LSR_21_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r14, minus, r0, LSR, 3, Offset},
      "al r5 r14 minus r0 LSR 3 Offset",
      "NegativeOffset_al_r5_r14_minus_r0_LSR_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r0, minus, r2, ASR, 17, Offset},
      "al r9 r0 minus r2 ASR 17 Offset",
      "NegativeOffset_al_r9_r0_minus_r2_ASR_17_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r10, minus, r4, ASR, 4, Offset},
      "al r14 r10 minus r4 ASR 4 Offset",
      "NegativeOffset_al_r14_r10_minus_r4_ASR_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r8, minus, r9, LSR, 6, Offset},
      "al r11 r8 minus r9 LSR 6 Offset",
      "NegativeOffset_al_r11_r8_minus_r9_LSR_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r4, minus, r12, ASR, 10, Offset},
      "al r9 r4 minus r12 ASR 10 Offset",
      "NegativeOffset_al_r9_r4_minus_r12_ASR_10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r12, minus, r5, ASR, 8, Offset},
      "al r8 r12 minus r5 ASR 8 Offset",
      "NegativeOffset_al_r8_r12_minus_r5_ASR_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r10, minus, r5, LSR, 32, Offset},
      "al r11 r10 minus r5 LSR 32 Offset",
      "NegativeOffset_al_r11_r10_minus_r5_LSR_32_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r3, minus, r9, ASR, 9, Offset},
      "al r6 r3 minus r9 ASR 9 Offset",
      "NegativeOffset_al_r6_r3_minus_r9_ASR_9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r12, minus, r2, ASR, 22, Offset},
      "al r1 r12 minus r2 ASR 22 Offset",
      "NegativeOffset_al_r1_r12_minus_r2_ASR_22_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r14, minus, r5, ASR, 18, Offset},
      "al r12 r14 minus r5 ASR 18 Offset",
      "NegativeOffset_al_r12_r14_minus_r5_ASR_18_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r14, minus, r9, LSR, 7, Offset},
      "al r12 r14 minus r9 LSR 7 Offset",
      "NegativeOffset_al_r12_r14_minus_r9_LSR_7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r3, minus, r0, LSR, 3, Offset},
      "al r9 r3 minus r0 LSR 3 Offset",
      "NegativeOffset_al_r9_r3_minus_r0_LSR_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r6, minus, r14, ASR, 4, Offset},
      "al r4 r6 minus r14 ASR 4 Offset",
      "NegativeOffset_al_r4_r6_minus_r14_ASR_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r12, minus, r6, LSR, 30, Offset},
      "al r0 r12 minus r6 LSR 30 Offset",
      "NegativeOffset_al_r0_r12_minus_r6_LSR_30_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r0, plus, r4, LSR, 26, PostIndex},
      "al r9 r0 plus r4 LSR 26 PostIndex",
      "PositivePostIndex_al_r9_r0_plus_r4_LSR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r1, plus, r9, LSR, 30, PostIndex},
      "al r2 r1 plus r9 LSR 30 PostIndex",
      "PositivePostIndex_al_r2_r1_plus_r9_LSR_30_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r7, plus, r8, LSR, 13, PostIndex},
      "al r11 r7 plus r8 LSR 13 PostIndex",
      "PositivePostIndex_al_r11_r7_plus_r8_LSR_13_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r11, plus, r3, ASR, 2, PostIndex},
      "al r5 r11 plus r3 ASR 2 PostIndex",
      "PositivePostIndex_al_r5_r11_plus_r3_ASR_2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r12, plus, r11, LSR, 27, PostIndex},
      "al r5 r12 plus r11 LSR 27 PostIndex",
      "PositivePostIndex_al_r5_r12_plus_r11_LSR_27_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r1, plus, r9, ASR, 5, PostIndex},
      "al r3 r1 plus r9 ASR 5 PostIndex",
      "PositivePostIndex_al_r3_r1_plus_r9_ASR_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r6, plus, r8, ASR, 9, PostIndex},
      "al r12 r6 plus r8 ASR 9 PostIndex",
      "PositivePostIndex_al_r12_r6_plus_r8_ASR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r12, plus, r8, ASR, 10, PostIndex},
      "al r4 r12 plus r8 ASR 10 PostIndex",
      "PositivePostIndex_al_r4_r12_plus_r8_ASR_10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r9, plus, r10, LSR, 7, PostIndex},
      "al r4 r9 plus r10 LSR 7 PostIndex",
      "PositivePostIndex_al_r4_r9_plus_r10_LSR_7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r7, plus, r3, LSR, 8, PostIndex},
      "al r6 r7 plus r3 LSR 8 PostIndex",
      "PositivePostIndex_al_r6_r7_plus_r3_LSR_8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r8, plus, r10, LSR, 2, PostIndex},
      "al r3 r8 plus r10 LSR 2 PostIndex",
      "PositivePostIndex_al_r3_r8_plus_r10_LSR_2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r4, plus, r1, ASR, 26, PostIndex},
      "al r3 r4 plus r1 ASR 26 PostIndex",
      "PositivePostIndex_al_r3_r4_plus_r1_ASR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r7, plus, r11, ASR, 28, PostIndex},
      "al r8 r7 plus r11 ASR 28 PostIndex",
      "PositivePostIndex_al_r8_r7_plus_r11_ASR_28_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r14, plus, r9, ASR, 17, PostIndex},
      "al r10 r14 plus r9 ASR 17 PostIndex",
      "PositivePostIndex_al_r10_r14_plus_r9_ASR_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r9, plus, r3, LSR, 19, PostIndex},
      "al r8 r9 plus r3 LSR 19 PostIndex",
      "PositivePostIndex_al_r8_r9_plus_r3_LSR_19_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r1, plus, r10, LSR, 20, PostIndex},
      "al r14 r1 plus r10 LSR 20 PostIndex",
      "PositivePostIndex_al_r14_r1_plus_r10_LSR_20_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r4, plus, r0, ASR, 29, PostIndex},
      "al r2 r4 plus r0 ASR 29 PostIndex",
      "PositivePostIndex_al_r2_r4_plus_r0_ASR_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r12, plus, r3, ASR, 26, PostIndex},
      "al r14 r12 plus r3 ASR 26 PostIndex",
      "PositivePostIndex_al_r14_r12_plus_r3_ASR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r14, plus, r0, LSR, 9, PostIndex},
      "al r1 r14 plus r0 LSR 9 PostIndex",
      "PositivePostIndex_al_r1_r14_plus_r0_LSR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r11, plus, r1, ASR, 24, PostIndex},
      "al r8 r11 plus r1 ASR 24 PostIndex",
      "PositivePostIndex_al_r8_r11_plus_r1_ASR_24_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r12, plus, r6, ASR, 11, PostIndex},
      "al r7 r12 plus r6 ASR 11 PostIndex",
      "PositivePostIndex_al_r7_r12_plus_r6_ASR_11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r6, plus, r9, ASR, 30, PostIndex},
      "al r10 r6 plus r9 ASR 30 PostIndex",
      "PositivePostIndex_al_r10_r6_plus_r9_ASR_30_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r0, plus, r7, ASR, 30, PostIndex},
      "al r9 r0 plus r7 ASR 30 PostIndex",
      "PositivePostIndex_al_r9_r0_plus_r7_ASR_30_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r14, plus, r7, LSR, 6, PostIndex},
      "al r5 r14 plus r7 LSR 6 PostIndex",
      "PositivePostIndex_al_r5_r14_plus_r7_LSR_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r7, plus, r5, ASR, 8, PostIndex},
      "al r9 r7 plus r5 ASR 8 PostIndex",
      "PositivePostIndex_al_r9_r7_plus_r5_ASR_8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r3, plus, r2, ASR, 10, PostIndex},
      "al r11 r3 plus r2 ASR 10 PostIndex",
      "PositivePostIndex_al_r11_r3_plus_r2_ASR_10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r3, plus, r10, ASR, 2, PostIndex},
      "al r1 r3 plus r10 ASR 2 PostIndex",
      "PositivePostIndex_al_r1_r3_plus_r10_ASR_2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r0, plus, r10, LSR, 12, PostIndex},
      "al r3 r0 plus r10 LSR 12 PostIndex",
      "PositivePostIndex_al_r3_r0_plus_r10_LSR_12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r11, plus, r5, LSR, 25, PostIndex},
      "al r6 r11 plus r5 LSR 25 PostIndex",
      "PositivePostIndex_al_r6_r11_plus_r5_LSR_25_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r7, plus, r12, LSR, 18, PostIndex},
      "al r0 r7 plus r12 LSR 18 PostIndex",
      "PositivePostIndex_al_r0_r7_plus_r12_LSR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r2, plus, r9, LSR, 14, PostIndex},
      "al r5 r2 plus r9 LSR 14 PostIndex",
      "PositivePostIndex_al_r5_r2_plus_r9_LSR_14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r9, plus, r12, LSR, 1, PostIndex},
      "al r8 r9 plus r12 LSR 1 PostIndex",
      "PositivePostIndex_al_r8_r9_plus_r12_LSR_1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r2, plus, r9, ASR, 9, PostIndex},
      "al r11 r2 plus r9 ASR 9 PostIndex",
      "PositivePostIndex_al_r11_r2_plus_r9_ASR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r0, plus, r3, LSR, 17, PostIndex},
      "al r14 r0 plus r3 LSR 17 PostIndex",
      "PositivePostIndex_al_r14_r0_plus_r3_LSR_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r4, plus, r9, ASR, 6, PostIndex},
      "al r5 r4 plus r9 ASR 6 PostIndex",
      "PositivePostIndex_al_r5_r4_plus_r9_ASR_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r5, plus, r2, ASR, 29, PostIndex},
      "al r8 r5 plus r2 ASR 29 PostIndex",
      "PositivePostIndex_al_r8_r5_plus_r2_ASR_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r10, plus, r3, LSR, 23, PostIndex},
      "al r4 r10 plus r3 LSR 23 PostIndex",
      "PositivePostIndex_al_r4_r10_plus_r3_LSR_23_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r11, plus, r12, LSR, 10, PostIndex},
      "al r7 r11 plus r12 LSR 10 PostIndex",
      "PositivePostIndex_al_r7_r11_plus_r12_LSR_10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r8, plus, r7, ASR, 1, PostIndex},
      "al r14 r8 plus r7 ASR 1 PostIndex",
      "PositivePostIndex_al_r14_r8_plus_r7_ASR_1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r2, plus, r4, ASR, 31, PostIndex},
      "al r11 r2 plus r4 ASR 31 PostIndex",
      "PositivePostIndex_al_r11_r2_plus_r4_ASR_31_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r12, plus, r11, ASR, 21, PostIndex},
      "al r5 r12 plus r11 ASR 21 PostIndex",
      "PositivePostIndex_al_r5_r12_plus_r11_ASR_21_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r9, plus, r11, LSR, 29, PostIndex},
      "al r3 r9 plus r11 LSR 29 PostIndex",
      "PositivePostIndex_al_r3_r9_plus_r11_LSR_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r10, plus, r1, LSR, 9, PostIndex},
      "al r4 r10 plus r1 LSR 9 PostIndex",
      "PositivePostIndex_al_r4_r10_plus_r1_LSR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r4, plus, r5, ASR, 21, PostIndex},
      "al r0 r4 plus r5 ASR 21 PostIndex",
      "PositivePostIndex_al_r0_r4_plus_r5_ASR_21_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r12, plus, r9, ASR, 3, PostIndex},
      "al r8 r12 plus r9 ASR 3 PostIndex",
      "PositivePostIndex_al_r8_r12_plus_r9_ASR_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r6, plus, r2, ASR, 2, PostIndex},
      "al r3 r6 plus r2 ASR 2 PostIndex",
      "PositivePostIndex_al_r3_r6_plus_r2_ASR_2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r11, plus, r2, ASR, 28, PostIndex},
      "al r12 r11 plus r2 ASR 28 PostIndex",
      "PositivePostIndex_al_r12_r11_plus_r2_ASR_28_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r10, plus, r11, LSR, 28, PostIndex},
      "al r4 r10 plus r11 LSR 28 PostIndex",
      "PositivePostIndex_al_r4_r10_plus_r11_LSR_28_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r10, plus, r9, ASR, 22, PostIndex},
      "al r7 r10 plus r9 ASR 22 PostIndex",
      "PositivePostIndex_al_r7_r10_plus_r9_ASR_22_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r6, plus, r11, LSR, 9, PostIndex},
      "al r5 r6 plus r11 LSR 9 PostIndex",
      "PositivePostIndex_al_r5_r6_plus_r11_LSR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r3, plus, r8, ASR, 26, PostIndex},
      "al r7 r3 plus r8 ASR 26 PostIndex",
      "PositivePostIndex_al_r7_r3_plus_r8_ASR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r9, plus, r8, LSR, 15, PostIndex},
      "al r7 r9 plus r8 LSR 15 PostIndex",
      "PositivePostIndex_al_r7_r9_plus_r8_LSR_15_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r14, plus, r12, ASR, 17, PostIndex},
      "al r0 r14 plus r12 ASR 17 PostIndex",
      "PositivePostIndex_al_r0_r14_plus_r12_ASR_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r12, plus, r14, ASR, 18, PostIndex},
      "al r11 r12 plus r14 ASR 18 PostIndex",
      "PositivePostIndex_al_r11_r12_plus_r14_ASR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r0, plus, r6, LSR, 17, PostIndex},
      "al r11 r0 plus r6 LSR 17 PostIndex",
      "PositivePostIndex_al_r11_r0_plus_r6_LSR_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r14, plus, r9, LSR, 29, PostIndex},
      "al r10 r14 plus r9 LSR 29 PostIndex",
      "PositivePostIndex_al_r10_r14_plus_r9_LSR_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r2, plus, r0, LSR, 6, PostIndex},
      "al r6 r2 plus r0 LSR 6 PostIndex",
      "PositivePostIndex_al_r6_r2_plus_r0_LSR_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r1, plus, r12, ASR, 5, PostIndex},
      "al r0 r1 plus r12 ASR 5 PostIndex",
      "PositivePostIndex_al_r0_r1_plus_r12_ASR_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r7, plus, r11, ASR, 11, PostIndex},
      "al r2 r7 plus r11 ASR 11 PostIndex",
      "PositivePostIndex_al_r2_r7_plus_r11_ASR_11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r4, plus, r3, ASR, 5, PostIndex},
      "al r1 r4 plus r3 ASR 5 PostIndex",
      "PositivePostIndex_al_r1_r4_plus_r3_ASR_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r2, plus, r6, LSR, 23, PostIndex},
      "al r0 r2 plus r6 LSR 23 PostIndex",
      "PositivePostIndex_al_r0_r2_plus_r6_LSR_23_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r11, plus, r0, ASR, 4, PostIndex},
      "al r2 r11 plus r0 ASR 4 PostIndex",
      "PositivePostIndex_al_r2_r11_plus_r0_ASR_4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r0, plus, r2, LSR, 9, PostIndex},
      "al r14 r0 plus r2 LSR 9 PostIndex",
      "PositivePostIndex_al_r14_r0_plus_r2_LSR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r1, plus, r3, LSR, 24, PostIndex},
      "al r12 r1 plus r3 LSR 24 PostIndex",
      "PositivePostIndex_al_r12_r1_plus_r3_LSR_24_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r10, plus, r11, ASR, 29, PostIndex},
      "al r1 r10 plus r11 ASR 29 PostIndex",
      "PositivePostIndex_al_r1_r10_plus_r11_ASR_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r6, plus, r0, LSR, 12, PostIndex},
      "al r5 r6 plus r0 LSR 12 PostIndex",
      "PositivePostIndex_al_r5_r6_plus_r0_LSR_12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r7, plus, r5, ASR, 17, PostIndex},
      "al r8 r7 plus r5 ASR 17 PostIndex",
      "PositivePostIndex_al_r8_r7_plus_r5_ASR_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r1, plus, r5, LSR, 26, PostIndex},
      "al r14 r1 plus r5 LSR 26 PostIndex",
      "PositivePostIndex_al_r14_r1_plus_r5_LSR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r0, plus, r11, ASR, 13, PostIndex},
      "al r7 r0 plus r11 ASR 13 PostIndex",
      "PositivePostIndex_al_r7_r0_plus_r11_ASR_13_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r8, plus, r1, ASR, 14, PostIndex},
      "al r0 r8 plus r1 ASR 14 PostIndex",
      "PositivePostIndex_al_r0_r8_plus_r1_ASR_14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r4, plus, r3, ASR, 4, PostIndex},
      "al r7 r4 plus r3 ASR 4 PostIndex",
      "PositivePostIndex_al_r7_r4_plus_r3_ASR_4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r2, plus, r11, LSR, 3, PostIndex},
      "al r5 r2 plus r11 LSR 3 PostIndex",
      "PositivePostIndex_al_r5_r2_plus_r11_LSR_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r7, plus, r1, ASR, 5, PostIndex},
      "al r2 r7 plus r1 ASR 5 PostIndex",
      "PositivePostIndex_al_r2_r7_plus_r1_ASR_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r14, plus, r6, LSR, 30, PostIndex},
      "al r8 r14 plus r6 LSR 30 PostIndex",
      "PositivePostIndex_al_r8_r14_plus_r6_LSR_30_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r8, plus, r14, ASR, 11, PostIndex},
      "al r5 r8 plus r14 ASR 11 PostIndex",
      "PositivePostIndex_al_r5_r8_plus_r14_ASR_11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r5, plus, r6, ASR, 22, PostIndex},
      "al r3 r5 plus r6 ASR 22 PostIndex",
      "PositivePostIndex_al_r3_r5_plus_r6_ASR_22_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r5, plus, r4, LSR, 9, PostIndex},
      "al r3 r5 plus r4 LSR 9 PostIndex",
      "PositivePostIndex_al_r3_r5_plus_r4_LSR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r1, plus, r11, LSR, 7, PostIndex},
      "al r7 r1 plus r11 LSR 7 PostIndex",
      "PositivePostIndex_al_r7_r1_plus_r11_LSR_7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r10, plus, r6, ASR, 3, PostIndex},
      "al r2 r10 plus r6 ASR 3 PostIndex",
      "PositivePostIndex_al_r2_r10_plus_r6_ASR_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r7, plus, r12, LSR, 5, PostIndex},
      "al r6 r7 plus r12 LSR 5 PostIndex",
      "PositivePostIndex_al_r6_r7_plus_r12_LSR_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r14, plus, r1, ASR, 18, PostIndex},
      "al r3 r14 plus r1 ASR 18 PostIndex",
      "PositivePostIndex_al_r3_r14_plus_r1_ASR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r9, plus, r12, LSR, 29, PostIndex},
      "al r1 r9 plus r12 LSR 29 PostIndex",
      "PositivePostIndex_al_r1_r9_plus_r12_LSR_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r2, plus, r0, LSR, 16, PostIndex},
      "al r9 r2 plus r0 LSR 16 PostIndex",
      "PositivePostIndex_al_r9_r2_plus_r0_LSR_16_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r9, plus, r2, ASR, 1, PostIndex},
      "al r8 r9 plus r2 ASR 1 PostIndex",
      "PositivePostIndex_al_r8_r9_plus_r2_ASR_1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r6, plus, r2, LSR, 6, PostIndex},
      "al r4 r6 plus r2 LSR 6 PostIndex",
      "PositivePostIndex_al_r4_r6_plus_r2_LSR_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r7, plus, r0, LSR, 25, PostIndex},
      "al r14 r7 plus r0 LSR 25 PostIndex",
      "PositivePostIndex_al_r14_r7_plus_r0_LSR_25_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r1, plus, r14, LSR, 9, PostIndex},
      "al r12 r1 plus r14 LSR 9 PostIndex",
      "PositivePostIndex_al_r12_r1_plus_r14_LSR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r6, plus, r5, ASR, 12, PostIndex},
      "al r1 r6 plus r5 ASR 12 PostIndex",
      "PositivePostIndex_al_r1_r6_plus_r5_ASR_12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r6, plus, r7, LSR, 22, PostIndex},
      "al r9 r6 plus r7 LSR 22 PostIndex",
      "PositivePostIndex_al_r9_r6_plus_r7_LSR_22_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r2, plus, r11, ASR, 31, PostIndex},
      "al r0 r2 plus r11 ASR 31 PostIndex",
      "PositivePostIndex_al_r0_r2_plus_r11_ASR_31_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r14, plus, r1, ASR, 3, PostIndex},
      "al r8 r14 plus r1 ASR 3 PostIndex",
      "PositivePostIndex_al_r8_r14_plus_r1_ASR_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r0, plus, r5, LSR, 3, PostIndex},
      "al r10 r0 plus r5 LSR 3 PostIndex",
      "PositivePostIndex_al_r10_r0_plus_r5_LSR_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r5, plus, r14, ASR, 28, PostIndex},
      "al r3 r5 plus r14 ASR 28 PostIndex",
      "PositivePostIndex_al_r3_r5_plus_r14_ASR_28_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r3, plus, r0, ASR, 23, PostIndex},
      "al r1 r3 plus r0 ASR 23 PostIndex",
      "PositivePostIndex_al_r1_r3_plus_r0_ASR_23_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r6, plus, r4, LSR, 8, PostIndex},
      "al r9 r6 plus r4 LSR 8 PostIndex",
      "PositivePostIndex_al_r9_r6_plus_r4_LSR_8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r14, plus, r0, LSR, 22, PostIndex},
      "al r10 r14 plus r0 LSR 22 PostIndex",
      "PositivePostIndex_al_r10_r14_plus_r0_LSR_22_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r12, plus, r2, ASR, 7, PostIndex},
      "al r10 r12 plus r2 ASR 7 PostIndex",
      "PositivePostIndex_al_r10_r12_plus_r2_ASR_7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r1, plus, r8, LSR, 27, PostIndex},
      "al r2 r1 plus r8 LSR 27 PostIndex",
      "PositivePostIndex_al_r2_r1_plus_r8_LSR_27_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r9, plus, r6, LSR, 23, PostIndex},
      "al r14 r9 plus r6 LSR 23 PostIndex",
      "PositivePostIndex_al_r14_r9_plus_r6_LSR_23_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r10, plus, r7, LSR, 27, PostIndex},
      "al r12 r10 plus r7 LSR 27 PostIndex",
      "PositivePostIndex_al_r12_r10_plus_r7_LSR_27_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r14, minus, r7, LSR, 30, PostIndex},
      "al r10 r14 minus r7 LSR 30 PostIndex",
      "NegativePostIndex_al_r10_r14_minus_r7_LSR_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r9, minus, r7, LSR, 11, PostIndex},
      "al r5 r9 minus r7 LSR 11 PostIndex",
      "NegativePostIndex_al_r5_r9_minus_r7_LSR_11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r3, minus, r5, ASR, 1, PostIndex},
      "al r4 r3 minus r5 ASR 1 PostIndex",
      "NegativePostIndex_al_r4_r3_minus_r5_ASR_1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r7, minus, r4, LSR, 3, PostIndex},
      "al r14 r7 minus r4 LSR 3 PostIndex",
      "NegativePostIndex_al_r14_r7_minus_r4_LSR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r3, minus, r4, ASR, 4, PostIndex},
      "al r11 r3 minus r4 ASR 4 PostIndex",
      "NegativePostIndex_al_r11_r3_minus_r4_ASR_4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r6, minus, r3, ASR, 5, PostIndex},
      "al r2 r6 minus r3 ASR 5 PostIndex",
      "NegativePostIndex_al_r2_r6_minus_r3_ASR_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r8, minus, r5, ASR, 31, PostIndex},
      "al r14 r8 minus r5 ASR 31 PostIndex",
      "NegativePostIndex_al_r14_r8_minus_r5_ASR_31_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r12, minus, r5, ASR, 21, PostIndex},
      "al r2 r12 minus r5 ASR 21 PostIndex",
      "NegativePostIndex_al_r2_r12_minus_r5_ASR_21_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r14, minus, r9, ASR, 12, PostIndex},
      "al r8 r14 minus r9 ASR 12 PostIndex",
      "NegativePostIndex_al_r8_r14_minus_r9_ASR_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r3, minus, r4, ASR, 20, PostIndex},
      "al r6 r3 minus r4 ASR 20 PostIndex",
      "NegativePostIndex_al_r6_r3_minus_r4_ASR_20_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r8, minus, r10, ASR, 28, PostIndex},
      "al r11 r8 minus r10 ASR 28 PostIndex",
      "NegativePostIndex_al_r11_r8_minus_r10_ASR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r10, minus, r12, ASR, 4, PostIndex},
      "al r3 r10 minus r12 ASR 4 PostIndex",
      "NegativePostIndex_al_r3_r10_minus_r12_ASR_4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r6, minus, r14, ASR, 23, PostIndex},
      "al r5 r6 minus r14 ASR 23 PostIndex",
      "NegativePostIndex_al_r5_r6_minus_r14_ASR_23_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r1, minus, r14, LSR, 28, PostIndex},
      "al r8 r1 minus r14 LSR 28 PostIndex",
      "NegativePostIndex_al_r8_r1_minus_r14_LSR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r5, minus, r8, ASR, 22, PostIndex},
      "al r1 r5 minus r8 ASR 22 PostIndex",
      "NegativePostIndex_al_r1_r5_minus_r8_ASR_22_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r0, minus, r10, LSR, 11, PostIndex},
      "al r14 r0 minus r10 LSR 11 PostIndex",
      "NegativePostIndex_al_r14_r0_minus_r10_LSR_11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r10, minus, r6, ASR, 25, PostIndex},
      "al r5 r10 minus r6 ASR 25 PostIndex",
      "NegativePostIndex_al_r5_r10_minus_r6_ASR_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r6, minus, r3, ASR, 19, PostIndex},
      "al r0 r6 minus r3 ASR 19 PostIndex",
      "NegativePostIndex_al_r0_r6_minus_r3_ASR_19_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r0, minus, r3, LSR, 23, PostIndex},
      "al r8 r0 minus r3 LSR 23 PostIndex",
      "NegativePostIndex_al_r8_r0_minus_r3_LSR_23_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r0, minus, r11, LSR, 17, PostIndex},
      "al r6 r0 minus r11 LSR 17 PostIndex",
      "NegativePostIndex_al_r6_r0_minus_r11_LSR_17_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r7, minus, r11, LSR, 9, PostIndex},
      "al r6 r7 minus r11 LSR 9 PostIndex",
      "NegativePostIndex_al_r6_r7_minus_r11_LSR_9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r4, minus, r5, LSR, 9, PostIndex},
      "al r0 r4 minus r5 LSR 9 PostIndex",
      "NegativePostIndex_al_r0_r4_minus_r5_LSR_9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r9, minus, r10, ASR, 18, PostIndex},
      "al r11 r9 minus r10 ASR 18 PostIndex",
      "NegativePostIndex_al_r11_r9_minus_r10_ASR_18_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r12, minus, r14, LSR, 32, PostIndex},
      "al r11 r12 minus r14 LSR 32 PostIndex",
      "NegativePostIndex_al_r11_r12_minus_r14_LSR_32_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r12, minus, r6, ASR, 7, PostIndex},
      "al r3 r12 minus r6 ASR 7 PostIndex",
      "NegativePostIndex_al_r3_r12_minus_r6_ASR_7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r8, minus, r2, ASR, 18, PostIndex},
      "al r11 r8 minus r2 ASR 18 PostIndex",
      "NegativePostIndex_al_r11_r8_minus_r2_ASR_18_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r0, minus, r6, LSR, 24, PostIndex},
      "al r7 r0 minus r6 LSR 24 PostIndex",
      "NegativePostIndex_al_r7_r0_minus_r6_LSR_24_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r8, minus, r0, ASR, 15, PostIndex},
      "al r11 r8 minus r0 ASR 15 PostIndex",
      "NegativePostIndex_al_r11_r8_minus_r0_ASR_15_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r8, minus, r0, LSR, 22, PostIndex},
      "al r1 r8 minus r0 LSR 22 PostIndex",
      "NegativePostIndex_al_r1_r8_minus_r0_LSR_22_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r2, minus, r10, ASR, 11, PostIndex},
      "al r3 r2 minus r10 ASR 11 PostIndex",
      "NegativePostIndex_al_r3_r2_minus_r10_ASR_11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r10, minus, r3, ASR, 1, PostIndex},
      "al r0 r10 minus r3 ASR 1 PostIndex",
      "NegativePostIndex_al_r0_r10_minus_r3_ASR_1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r14, minus, r8, LSR, 7, PostIndex},
      "al r10 r14 minus r8 LSR 7 PostIndex",
      "NegativePostIndex_al_r10_r14_minus_r8_LSR_7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r12, minus, r3, LSR, 3, PostIndex},
      "al r4 r12 minus r3 LSR 3 PostIndex",
      "NegativePostIndex_al_r4_r12_minus_r3_LSR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r4, minus, r7, ASR, 10, PostIndex},
      "al r2 r4 minus r7 ASR 10 PostIndex",
      "NegativePostIndex_al_r2_r4_minus_r7_ASR_10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r6, minus, r3, ASR, 32, PostIndex},
      "al r4 r6 minus r3 ASR 32 PostIndex",
      "NegativePostIndex_al_r4_r6_minus_r3_ASR_32_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r0, minus, r14, ASR, 12, PostIndex},
      "al r4 r0 minus r14 ASR 12 PostIndex",
      "NegativePostIndex_al_r4_r0_minus_r14_ASR_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r0, minus, r5, ASR, 28, PostIndex},
      "al r2 r0 minus r5 ASR 28 PostIndex",
      "NegativePostIndex_al_r2_r0_minus_r5_ASR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r11, minus, r8, LSR, 10, PostIndex},
      "al r1 r11 minus r8 LSR 10 PostIndex",
      "NegativePostIndex_al_r1_r11_minus_r8_LSR_10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r9, minus, r12, ASR, 24, PostIndex},
      "al r5 r9 minus r12 ASR 24 PostIndex",
      "NegativePostIndex_al_r5_r9_minus_r12_ASR_24_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r11, minus, r9, ASR, 28, PostIndex},
      "al r14 r11 minus r9 ASR 28 PostIndex",
      "NegativePostIndex_al_r14_r11_minus_r9_ASR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r8, minus, r3, ASR, 7, PostIndex},
      "al r1 r8 minus r3 ASR 7 PostIndex",
      "NegativePostIndex_al_r1_r8_minus_r3_ASR_7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r3, minus, r4, ASR, 7, PostIndex},
      "al r12 r3 minus r4 ASR 7 PostIndex",
      "NegativePostIndex_al_r12_r3_minus_r4_ASR_7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r4, minus, r5, LSR, 22, PostIndex},
      "al r10 r4 minus r5 LSR 22 PostIndex",
      "NegativePostIndex_al_r10_r4_minus_r5_LSR_22_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r14, minus, r6, LSR, 11, PostIndex},
      "al r3 r14 minus r6 LSR 11 PostIndex",
      "NegativePostIndex_al_r3_r14_minus_r6_LSR_11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r14, minus, r1, LSR, 31, PostIndex},
      "al r5 r14 minus r1 LSR 31 PostIndex",
      "NegativePostIndex_al_r5_r14_minus_r1_LSR_31_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r0, minus, r9, LSR, 9, PostIndex},
      "al r3 r0 minus r9 LSR 9 PostIndex",
      "NegativePostIndex_al_r3_r0_minus_r9_LSR_9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r4, minus, r8, LSR, 28, PostIndex},
      "al r0 r4 minus r8 LSR 28 PostIndex",
      "NegativePostIndex_al_r0_r4_minus_r8_LSR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r9, minus, r12, ASR, 32, PostIndex},
      "al r7 r9 minus r12 ASR 32 PostIndex",
      "NegativePostIndex_al_r7_r9_minus_r12_ASR_32_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r8, minus, r14, LSR, 20, PostIndex},
      "al r4 r8 minus r14 LSR 20 PostIndex",
      "NegativePostIndex_al_r4_r8_minus_r14_LSR_20_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r11, minus, r1, ASR, 1, PostIndex},
      "al r0 r11 minus r1 ASR 1 PostIndex",
      "NegativePostIndex_al_r0_r11_minus_r1_ASR_1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r2, minus, r0, ASR, 6, PostIndex},
      "al r6 r2 minus r0 ASR 6 PostIndex",
      "NegativePostIndex_al_r6_r2_minus_r0_ASR_6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r2, minus, r7, LSR, 26, PostIndex},
      "al r9 r2 minus r7 LSR 26 PostIndex",
      "NegativePostIndex_al_r9_r2_minus_r7_LSR_26_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r9, minus, r7, ASR, 25, PostIndex},
      "al r6 r9 minus r7 ASR 25 PostIndex",
      "NegativePostIndex_al_r6_r9_minus_r7_ASR_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r8, minus, r12, ASR, 10, PostIndex},
      "al r7 r8 minus r12 ASR 10 PostIndex",
      "NegativePostIndex_al_r7_r8_minus_r12_ASR_10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r11, minus, r12, LSR, 4, PostIndex},
      "al r4 r11 minus r12 LSR 4 PostIndex",
      "NegativePostIndex_al_r4_r11_minus_r12_LSR_4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r4, minus, r11, LSR, 31, PostIndex},
      "al r7 r4 minus r11 LSR 31 PostIndex",
      "NegativePostIndex_al_r7_r4_minus_r11_LSR_31_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r9, minus, r5, LSR, 14, PostIndex},
      "al r2 r9 minus r5 LSR 14 PostIndex",
      "NegativePostIndex_al_r2_r9_minus_r5_LSR_14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r3, minus, r0, LSR, 30, PostIndex},
      "al r14 r3 minus r0 LSR 30 PostIndex",
      "NegativePostIndex_al_r14_r3_minus_r0_LSR_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r1, minus, r11, ASR, 1, PostIndex},
      "al r12 r1 minus r11 ASR 1 PostIndex",
      "NegativePostIndex_al_r12_r1_minus_r11_ASR_1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r4, minus, r5, ASR, 32, PostIndex},
      "al r7 r4 minus r5 ASR 32 PostIndex",
      "NegativePostIndex_al_r7_r4_minus_r5_ASR_32_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r1, minus, r6, LSR, 32, PostIndex},
      "al r3 r1 minus r6 LSR 32 PostIndex",
      "NegativePostIndex_al_r3_r1_minus_r6_LSR_32_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r7, minus, r6, LSR, 4, PostIndex},
      "al r4 r7 minus r6 LSR 4 PostIndex",
      "NegativePostIndex_al_r4_r7_minus_r6_LSR_4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r9, minus, r11, LSR, 3, PostIndex},
      "al r10 r9 minus r11 LSR 3 PostIndex",
      "NegativePostIndex_al_r10_r9_minus_r11_LSR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r2, minus, r1, ASR, 12, PostIndex},
      "al r8 r2 minus r1 ASR 12 PostIndex",
      "NegativePostIndex_al_r8_r2_minus_r1_ASR_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r2, minus, r12, ASR, 30, PostIndex},
      "al r6 r2 minus r12 ASR 30 PostIndex",
      "NegativePostIndex_al_r6_r2_minus_r12_ASR_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r5, minus, r9, LSR, 22, PostIndex},
      "al r4 r5 minus r9 LSR 22 PostIndex",
      "NegativePostIndex_al_r4_r5_minus_r9_LSR_22_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r9, minus, r2, LSR, 3, PostIndex},
      "al r8 r9 minus r2 LSR 3 PostIndex",
      "NegativePostIndex_al_r8_r9_minus_r2_LSR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r1, minus, r9, ASR, 13, PostIndex},
      "al r14 r1 minus r9 ASR 13 PostIndex",
      "NegativePostIndex_al_r14_r1_minus_r9_ASR_13_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r11, minus, r3, ASR, 23, PostIndex},
      "al r12 r11 minus r3 ASR 23 PostIndex",
      "NegativePostIndex_al_r12_r11_minus_r3_ASR_23_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r12, minus, r11, LSR, 29, PostIndex},
      "al r1 r12 minus r11 LSR 29 PostIndex",
      "NegativePostIndex_al_r1_r12_minus_r11_LSR_29_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r1, minus, r6, ASR, 15, PostIndex},
      "al r3 r1 minus r6 ASR 15 PostIndex",
      "NegativePostIndex_al_r3_r1_minus_r6_ASR_15_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r0, minus, r6, ASR, 2, PostIndex},
      "al r7 r0 minus r6 ASR 2 PostIndex",
      "NegativePostIndex_al_r7_r0_minus_r6_ASR_2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r7, minus, r9, LSR, 14, PostIndex},
      "al r11 r7 minus r9 LSR 14 PostIndex",
      "NegativePostIndex_al_r11_r7_minus_r9_LSR_14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r10, minus, r4, ASR, 23, PostIndex},
      "al r14 r10 minus r4 ASR 23 PostIndex",
      "NegativePostIndex_al_r14_r10_minus_r4_ASR_23_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r12, minus, r4, ASR, 5, PostIndex},
      "al r10 r12 minus r4 ASR 5 PostIndex",
      "NegativePostIndex_al_r10_r12_minus_r4_ASR_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r11, minus, r3, LSR, 7, PostIndex},
      "al r10 r11 minus r3 LSR 7 PostIndex",
      "NegativePostIndex_al_r10_r11_minus_r3_LSR_7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r1, minus, r11, ASR, 6, PostIndex},
      "al r14 r1 minus r11 ASR 6 PostIndex",
      "NegativePostIndex_al_r14_r1_minus_r11_ASR_6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r7, minus, r4, ASR, 9, PostIndex},
      "al r12 r7 minus r4 ASR 9 PostIndex",
      "NegativePostIndex_al_r12_r7_minus_r4_ASR_9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r7, minus, r10, ASR, 21, PostIndex},
      "al r6 r7 minus r10 ASR 21 PostIndex",
      "NegativePostIndex_al_r6_r7_minus_r10_ASR_21_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r5, minus, r0, ASR, 28, PostIndex},
      "al r1 r5 minus r0 ASR 28 PostIndex",
      "NegativePostIndex_al_r1_r5_minus_r0_ASR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r8, minus, r0, ASR, 10, PostIndex},
      "al r2 r8 minus r0 ASR 10 PostIndex",
      "NegativePostIndex_al_r2_r8_minus_r0_ASR_10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r0, minus, r3, ASR, 24, PostIndex},
      "al r9 r0 minus r3 ASR 24 PostIndex",
      "NegativePostIndex_al_r9_r0_minus_r3_ASR_24_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r1, minus, r3, LSR, 14, PostIndex},
      "al r5 r1 minus r3 LSR 14 PostIndex",
      "NegativePostIndex_al_r5_r1_minus_r3_LSR_14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r14, minus, r1, ASR, 12, PostIndex},
      "al r3 r14 minus r1 ASR 12 PostIndex",
      "NegativePostIndex_al_r3_r14_minus_r1_ASR_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r2, minus, r1, LSR, 5, PostIndex},
      "al r4 r2 minus r1 LSR 5 PostIndex",
      "NegativePostIndex_al_r4_r2_minus_r1_LSR_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r6, minus, r4, LSR, 16, PostIndex},
      "al r12 r6 minus r4 LSR 16 PostIndex",
      "NegativePostIndex_al_r12_r6_minus_r4_LSR_16_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r12, minus, r3, ASR, 24, PostIndex},
      "al r9 r12 minus r3 ASR 24 PostIndex",
      "NegativePostIndex_al_r9_r12_minus_r3_ASR_24_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r10, minus, r7, ASR, 3, PostIndex},
      "al r5 r10 minus r7 ASR 3 PostIndex",
      "NegativePostIndex_al_r5_r10_minus_r7_ASR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r7, minus, r14, LSR, 3, PostIndex},
      "al r3 r7 minus r14 LSR 3 PostIndex",
      "NegativePostIndex_al_r3_r7_minus_r14_LSR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r14, minus, r5, LSR, 18, PostIndex},
      "al r7 r14 minus r5 LSR 18 PostIndex",
      "NegativePostIndex_al_r7_r14_minus_r5_LSR_18_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r12, minus, r14, ASR, 2, PostIndex},
      "al r6 r12 minus r14 ASR 2 PostIndex",
      "NegativePostIndex_al_r6_r12_minus_r14_ASR_2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r9, minus, r2, LSR, 28, PostIndex},
      "al r7 r9 minus r2 LSR 28 PostIndex",
      "NegativePostIndex_al_r7_r9_minus_r2_LSR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r0, minus, r9, ASR, 25, PostIndex},
      "al r8 r0 minus r9 ASR 25 PostIndex",
      "NegativePostIndex_al_r8_r0_minus_r9_ASR_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r9, minus, r4, ASR, 15, PostIndex},
      "al r2 r9 minus r4 ASR 15 PostIndex",
      "NegativePostIndex_al_r2_r9_minus_r4_ASR_15_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r7, minus, r2, ASR, 31, PostIndex},
      "al r11 r7 minus r2 ASR 31 PostIndex",
      "NegativePostIndex_al_r11_r7_minus_r2_ASR_31_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r4, minus, r2, ASR, 28, PostIndex},
      "al r7 r4 minus r2 ASR 28 PostIndex",
      "NegativePostIndex_al_r7_r4_minus_r2_ASR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r1, minus, r4, LSR, 21, PostIndex},
      "al r7 r1 minus r4 LSR 21 PostIndex",
      "NegativePostIndex_al_r7_r1_minus_r4_LSR_21_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r0, minus, r11, ASR, 5, PostIndex},
      "al r6 r0 minus r11 ASR 5 PostIndex",
      "NegativePostIndex_al_r6_r0_minus_r11_ASR_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r8, minus, r14, ASR, 7, PostIndex},
      "al r7 r8 minus r14 ASR 7 PostIndex",
      "NegativePostIndex_al_r7_r8_minus_r14_ASR_7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r12, minus, r6, LSR, 8, PostIndex},
      "al r1 r12 minus r6 LSR 8 PostIndex",
      "NegativePostIndex_al_r1_r12_minus_r6_LSR_8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r7, plus, r5, LSR, 28, PreIndex},
      "al r4 r7 plus r5 LSR 28 PreIndex",
      "PositivePreIndex_al_r4_r7_plus_r5_LSR_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r9, plus, r0, LSR, 17, PreIndex},
      "al r1 r9 plus r0 LSR 17 PreIndex",
      "PositivePreIndex_al_r1_r9_plus_r0_LSR_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r9, plus, r7, ASR, 17, PreIndex},
      "al r12 r9 plus r7 ASR 17 PreIndex",
      "PositivePreIndex_al_r12_r9_plus_r7_ASR_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r9, plus, r6, LSR, 2, PreIndex},
      "al r3 r9 plus r6 LSR 2 PreIndex",
      "PositivePreIndex_al_r3_r9_plus_r6_LSR_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r0, plus, r11, ASR, 9, PreIndex},
      "al r10 r0 plus r11 ASR 9 PreIndex",
      "PositivePreIndex_al_r10_r0_plus_r11_ASR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r6, plus, r12, ASR, 32, PreIndex},
      "al r1 r6 plus r12 ASR 32 PreIndex",
      "PositivePreIndex_al_r1_r6_plus_r12_ASR_32_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r2, plus, r14, ASR, 15, PreIndex},
      "al r5 r2 plus r14 ASR 15 PreIndex",
      "PositivePreIndex_al_r5_r2_plus_r14_ASR_15_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r3, plus, r7, LSR, 12, PreIndex},
      "al r4 r3 plus r7 LSR 12 PreIndex",
      "PositivePreIndex_al_r4_r3_plus_r7_LSR_12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r11, plus, r7, LSR, 3, PreIndex},
      "al r0 r11 plus r7 LSR 3 PreIndex",
      "PositivePreIndex_al_r0_r11_plus_r7_LSR_3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r12, plus, r8, ASR, 31, PreIndex},
      "al r2 r12 plus r8 ASR 31 PreIndex",
      "PositivePreIndex_al_r2_r12_plus_r8_ASR_31_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r2, plus, r9, ASR, 27, PreIndex},
      "al r8 r2 plus r9 ASR 27 PreIndex",
      "PositivePreIndex_al_r8_r2_plus_r9_ASR_27_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r4, plus, r7, ASR, 2, PreIndex},
      "al r9 r4 plus r7 ASR 2 PreIndex",
      "PositivePreIndex_al_r9_r4_plus_r7_ASR_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r3, plus, r1, ASR, 19, PreIndex},
      "al r4 r3 plus r1 ASR 19 PreIndex",
      "PositivePreIndex_al_r4_r3_plus_r1_ASR_19_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r9, plus, r11, ASR, 4, PreIndex},
      "al r2 r9 plus r11 ASR 4 PreIndex",
      "PositivePreIndex_al_r2_r9_plus_r11_ASR_4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r9, plus, r11, ASR, 22, PreIndex},
      "al r0 r9 plus r11 ASR 22 PreIndex",
      "PositivePreIndex_al_r0_r9_plus_r11_ASR_22_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r6, plus, r4, LSR, 29, PreIndex},
      "al r11 r6 plus r4 LSR 29 PreIndex",
      "PositivePreIndex_al_r11_r6_plus_r4_LSR_29_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r1, plus, r5, ASR, 2, PreIndex},
      "al r10 r1 plus r5 ASR 2 PreIndex",
      "PositivePreIndex_al_r10_r1_plus_r5_ASR_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r12, plus, r14, ASR, 9, PreIndex},
      "al r10 r12 plus r14 ASR 9 PreIndex",
      "PositivePreIndex_al_r10_r12_plus_r14_ASR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r8, plus, r14, ASR, 24, PreIndex},
      "al r11 r8 plus r14 ASR 24 PreIndex",
      "PositivePreIndex_al_r11_r8_plus_r14_ASR_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r14, plus, r8, ASR, 14, PreIndex},
      "al r12 r14 plus r8 ASR 14 PreIndex",
      "PositivePreIndex_al_r12_r14_plus_r8_ASR_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r2, plus, r1, ASR, 13, PreIndex},
      "al r14 r2 plus r1 ASR 13 PreIndex",
      "PositivePreIndex_al_r14_r2_plus_r1_ASR_13_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r10, plus, r6, ASR, 26, PreIndex},
      "al r11 r10 plus r6 ASR 26 PreIndex",
      "PositivePreIndex_al_r11_r10_plus_r6_ASR_26_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r10, plus, r12, LSR, 11, PreIndex},
      "al r14 r10 plus r12 LSR 11 PreIndex",
      "PositivePreIndex_al_r14_r10_plus_r12_LSR_11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r3, plus, r4, LSR, 19, PreIndex},
      "al r6 r3 plus r4 LSR 19 PreIndex",
      "PositivePreIndex_al_r6_r3_plus_r4_LSR_19_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r12, plus, r6, ASR, 11, PreIndex},
      "al r1 r12 plus r6 ASR 11 PreIndex",
      "PositivePreIndex_al_r1_r12_plus_r6_ASR_11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r14, plus, r0, ASR, 14, PreIndex},
      "al r8 r14 plus r0 ASR 14 PreIndex",
      "PositivePreIndex_al_r8_r14_plus_r0_ASR_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r4, plus, r12, ASR, 28, PreIndex},
      "al r6 r4 plus r12 ASR 28 PreIndex",
      "PositivePreIndex_al_r6_r4_plus_r12_ASR_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r11, plus, r10, LSR, 6, PreIndex},
      "al r7 r11 plus r10 LSR 6 PreIndex",
      "PositivePreIndex_al_r7_r11_plus_r10_LSR_6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r8, plus, r2, LSR, 2, PreIndex},
      "al r12 r8 plus r2 LSR 2 PreIndex",
      "PositivePreIndex_al_r12_r8_plus_r2_LSR_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r5, plus, r8, LSR, 23, PreIndex},
      "al r1 r5 plus r8 LSR 23 PreIndex",
      "PositivePreIndex_al_r1_r5_plus_r8_LSR_23_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r14, plus, r8, ASR, 11, PreIndex},
      "al r11 r14 plus r8 ASR 11 PreIndex",
      "PositivePreIndex_al_r11_r14_plus_r8_ASR_11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r14, plus, r8, ASR, 20, PreIndex},
      "al r4 r14 plus r8 ASR 20 PreIndex",
      "PositivePreIndex_al_r4_r14_plus_r8_ASR_20_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r11, plus, r1, ASR, 24, PreIndex},
      "al r6 r11 plus r1 ASR 24 PreIndex",
      "PositivePreIndex_al_r6_r11_plus_r1_ASR_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r3, plus, r4, ASR, 19, PreIndex},
      "al r0 r3 plus r4 ASR 19 PreIndex",
      "PositivePreIndex_al_r0_r3_plus_r4_ASR_19_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r10, plus, r0, ASR, 25, PreIndex},
      "al r2 r10 plus r0 ASR 25 PreIndex",
      "PositivePreIndex_al_r2_r10_plus_r0_ASR_25_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r2, plus, r5, LSR, 18, PreIndex},
      "al r3 r2 plus r5 LSR 18 PreIndex",
      "PositivePreIndex_al_r3_r2_plus_r5_LSR_18_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r8, plus, r10, ASR, 3, PreIndex},
      "al r6 r8 plus r10 ASR 3 PreIndex",
      "PositivePreIndex_al_r6_r8_plus_r10_ASR_3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r10, plus, r1, LSR, 19, PreIndex},
      "al r4 r10 plus r1 LSR 19 PreIndex",
      "PositivePreIndex_al_r4_r10_plus_r1_LSR_19_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r3, plus, r5, ASR, 13, PreIndex},
      "al r4 r3 plus r5 ASR 13 PreIndex",
      "PositivePreIndex_al_r4_r3_plus_r5_ASR_13_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r0, plus, r4, ASR, 3, PreIndex},
      "al r5 r0 plus r4 ASR 3 PreIndex",
      "PositivePreIndex_al_r5_r0_plus_r4_ASR_3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r2, plus, r7, ASR, 16, PreIndex},
      "al r9 r2 plus r7 ASR 16 PreIndex",
      "PositivePreIndex_al_r9_r2_plus_r7_ASR_16_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r1, plus, r9, ASR, 21, PreIndex},
      "al r4 r1 plus r9 ASR 21 PreIndex",
      "PositivePreIndex_al_r4_r1_plus_r9_ASR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r12, plus, r2, LSR, 9, PreIndex},
      "al r5 r12 plus r2 LSR 9 PreIndex",
      "PositivePreIndex_al_r5_r12_plus_r2_LSR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r7, plus, r11, LSR, 9, PreIndex},
      "al r10 r7 plus r11 LSR 9 PreIndex",
      "PositivePreIndex_al_r10_r7_plus_r11_LSR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r9, plus, r7, LSR, 32, PreIndex},
      "al r1 r9 plus r7 LSR 32 PreIndex",
      "PositivePreIndex_al_r1_r9_plus_r7_LSR_32_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r7, plus, r4, LSR, 23, PreIndex},
      "al r6 r7 plus r4 LSR 23 PreIndex",
      "PositivePreIndex_al_r6_r7_plus_r4_LSR_23_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r14, plus, r11, LSR, 17, PreIndex},
      "al r4 r14 plus r11 LSR 17 PreIndex",
      "PositivePreIndex_al_r4_r14_plus_r11_LSR_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r9, plus, r14, ASR, 17, PreIndex},
      "al r6 r9 plus r14 ASR 17 PreIndex",
      "PositivePreIndex_al_r6_r9_plus_r14_ASR_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r1, plus, r5, ASR, 8, PreIndex},
      "al r10 r1 plus r5 ASR 8 PreIndex",
      "PositivePreIndex_al_r10_r1_plus_r5_ASR_8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r3, plus, r4, ASR, 2, PreIndex},
      "al r12 r3 plus r4 ASR 2 PreIndex",
      "PositivePreIndex_al_r12_r3_plus_r4_ASR_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r0, plus, r11, LSR, 8, PreIndex},
      "al r14 r0 plus r11 LSR 8 PreIndex",
      "PositivePreIndex_al_r14_r0_plus_r11_LSR_8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r6, plus, r2, ASR, 15, PreIndex},
      "al r5 r6 plus r2 ASR 15 PreIndex",
      "PositivePreIndex_al_r5_r6_plus_r2_ASR_15_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r4, plus, r3, ASR, 4, PreIndex},
      "al r1 r4 plus r3 ASR 4 PreIndex",
      "PositivePreIndex_al_r1_r4_plus_r3_ASR_4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r4, plus, r9, LSR, 22, PreIndex},
      "al r8 r4 plus r9 LSR 22 PreIndex",
      "PositivePreIndex_al_r8_r4_plus_r9_LSR_22_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r2, plus, r6, LSR, 5, PreIndex},
      "al r0 r2 plus r6 LSR 5 PreIndex",
      "PositivePreIndex_al_r0_r2_plus_r6_LSR_5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r12, plus, r14, ASR, 21, PreIndex},
      "al r4 r12 plus r14 ASR 21 PreIndex",
      "PositivePreIndex_al_r4_r12_plus_r14_ASR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r3, plus, r5, LSR, 1, PreIndex},
      "al r4 r3 plus r5 LSR 1 PreIndex",
      "PositivePreIndex_al_r4_r3_plus_r5_LSR_1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r3, plus, r4, ASR, 15, PreIndex},
      "al r7 r3 plus r4 ASR 15 PreIndex",
      "PositivePreIndex_al_r7_r3_plus_r4_ASR_15_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r8, plus, r11, ASR, 5, PreIndex},
      "al r3 r8 plus r11 ASR 5 PreIndex",
      "PositivePreIndex_al_r3_r8_plus_r11_ASR_5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r6, plus, r1, LSR, 17, PreIndex},
      "al r11 r6 plus r1 LSR 17 PreIndex",
      "PositivePreIndex_al_r11_r6_plus_r1_LSR_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r4, plus, r0, LSR, 1, PreIndex},
      "al r12 r4 plus r0 LSR 1 PreIndex",
      "PositivePreIndex_al_r12_r4_plus_r0_LSR_1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r4, plus, r5, ASR, 12, PreIndex},
      "al r1 r4 plus r5 ASR 12 PreIndex",
      "PositivePreIndex_al_r1_r4_plus_r5_ASR_12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r0, plus, r2, LSR, 5, PreIndex},
      "al r14 r0 plus r2 LSR 5 PreIndex",
      "PositivePreIndex_al_r14_r0_plus_r2_LSR_5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r8, plus, r7, LSR, 10, PreIndex},
      "al r14 r8 plus r7 LSR 10 PreIndex",
      "PositivePreIndex_al_r14_r8_plus_r7_LSR_10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r6, plus, r4, ASR, 21, PreIndex},
      "al r8 r6 plus r4 ASR 21 PreIndex",
      "PositivePreIndex_al_r8_r6_plus_r4_ASR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r7, plus, r11, ASR, 8, PreIndex},
      "al r4 r7 plus r11 ASR 8 PreIndex",
      "PositivePreIndex_al_r4_r7_plus_r11_ASR_8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r0, plus, r10, LSR, 30, PreIndex},
      "al r3 r0 plus r10 LSR 30 PreIndex",
      "PositivePreIndex_al_r3_r0_plus_r10_LSR_30_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r8, plus, r5, ASR, 7, PreIndex},
      "al r7 r8 plus r5 ASR 7 PreIndex",
      "PositivePreIndex_al_r7_r8_plus_r5_ASR_7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r14, plus, r10, LSR, 20, PreIndex},
      "al r1 r14 plus r10 LSR 20 PreIndex",
      "PositivePreIndex_al_r1_r14_plus_r10_LSR_20_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r4, plus, r6, ASR, 24, PreIndex},
      "al r7 r4 plus r6 ASR 24 PreIndex",
      "PositivePreIndex_al_r7_r4_plus_r6_ASR_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r0, plus, r11, ASR, 9, PreIndex},
      "al r2 r0 plus r11 ASR 9 PreIndex",
      "PositivePreIndex_al_r2_r0_plus_r11_ASR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r5, plus, r6, ASR, 24, PreIndex},
      "al r4 r5 plus r6 ASR 24 PreIndex",
      "PositivePreIndex_al_r4_r5_plus_r6_ASR_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r0, plus, r3, ASR, 26, PreIndex},
      "al r9 r0 plus r3 ASR 26 PreIndex",
      "PositivePreIndex_al_r9_r0_plus_r3_ASR_26_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r8, plus, r12, ASR, 21, PreIndex},
      "al r3 r8 plus r12 ASR 21 PreIndex",
      "PositivePreIndex_al_r3_r8_plus_r12_ASR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r1, plus, r0, ASR, 22, PreIndex},
      "al r3 r1 plus r0 ASR 22 PreIndex",
      "PositivePreIndex_al_r3_r1_plus_r0_ASR_22_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r8, plus, r5, ASR, 25, PreIndex},
      "al r9 r8 plus r5 ASR 25 PreIndex",
      "PositivePreIndex_al_r9_r8_plus_r5_ASR_25_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r10, plus, r9, LSR, 2, PreIndex},
      "al r12 r10 plus r9 LSR 2 PreIndex",
      "PositivePreIndex_al_r12_r10_plus_r9_LSR_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r10, plus, r14, LSR, 11, PreIndex},
      "al r12 r10 plus r14 LSR 11 PreIndex",
      "PositivePreIndex_al_r12_r10_plus_r14_LSR_11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r11, plus, r6, LSR, 12, PreIndex},
      "al r1 r11 plus r6 LSR 12 PreIndex",
      "PositivePreIndex_al_r1_r11_plus_r6_LSR_12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r4, plus, r14, LSR, 14, PreIndex},
      "al r1 r4 plus r14 LSR 14 PreIndex",
      "PositivePreIndex_al_r1_r4_plus_r14_LSR_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r7, plus, r12, LSR, 14, PreIndex},
      "al r6 r7 plus r12 LSR 14 PreIndex",
      "PositivePreIndex_al_r6_r7_plus_r12_LSR_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r9, plus, r11, ASR, 9, PreIndex},
      "al r10 r9 plus r11 ASR 9 PreIndex",
      "PositivePreIndex_al_r10_r9_plus_r11_ASR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r8, plus, r7, ASR, 7, PreIndex},
      "al r12 r8 plus r7 ASR 7 PreIndex",
      "PositivePreIndex_al_r12_r8_plus_r7_ASR_7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r7, plus, r9, LSR, 11, PreIndex},
      "al r10 r7 plus r9 LSR 11 PreIndex",
      "PositivePreIndex_al_r10_r7_plus_r9_LSR_11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r1, plus, r7, LSR, 27, PreIndex},
      "al r14 r1 plus r7 LSR 27 PreIndex",
      "PositivePreIndex_al_r14_r1_plus_r7_LSR_27_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r7, plus, r8, ASR, 9, PreIndex},
      "al r4 r7 plus r8 ASR 9 PreIndex",
      "PositivePreIndex_al_r4_r7_plus_r8_ASR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r10, plus, r5, LSR, 10, PreIndex},
      "al r3 r10 plus r5 LSR 10 PreIndex",
      "PositivePreIndex_al_r3_r10_plus_r5_LSR_10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r0, plus, r8, ASR, 3, PreIndex},
      "al r3 r0 plus r8 ASR 3 PreIndex",
      "PositivePreIndex_al_r3_r0_plus_r8_ASR_3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r12, plus, r0, ASR, 9, PreIndex},
      "al r1 r12 plus r0 ASR 9 PreIndex",
      "PositivePreIndex_al_r1_r12_plus_r0_ASR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r3, plus, r5, ASR, 16, PreIndex},
      "al r14 r3 plus r5 ASR 16 PreIndex",
      "PositivePreIndex_al_r14_r3_plus_r5_ASR_16_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r5, plus, r2, ASR, 9, PreIndex},
      "al r0 r5 plus r2 ASR 9 PreIndex",
      "PositivePreIndex_al_r0_r5_plus_r2_ASR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r4, plus, r10, ASR, 32, PreIndex},
      "al r11 r4 plus r10 ASR 32 PreIndex",
      "PositivePreIndex_al_r11_r4_plus_r10_ASR_32_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r0, plus, r5, ASR, 5, PreIndex},
      "al r11 r0 plus r5 ASR 5 PreIndex",
      "PositivePreIndex_al_r11_r0_plus_r5_ASR_5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r5, plus, r2, ASR, 20, PreIndex},
      "al r8 r5 plus r2 ASR 20 PreIndex",
      "PositivePreIndex_al_r8_r5_plus_r2_ASR_20_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r0, plus, r7, LSR, 23, PreIndex},
      "al r5 r0 plus r7 LSR 23 PreIndex",
      "PositivePreIndex_al_r5_r0_plus_r7_LSR_23_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r11, plus, r2, LSR, 23, PreIndex},
      "al r7 r11 plus r2 LSR 23 PreIndex",
      "PositivePreIndex_al_r7_r11_plus_r2_LSR_23_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r10, plus, r1, ASR, 28, PreIndex},
      "al r0 r10 plus r1 ASR 28 PreIndex",
      "PositivePreIndex_al_r0_r10_plus_r1_ASR_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r7, plus, r10, ASR, 14, PreIndex},
      "al r8 r7 plus r10 ASR 14 PreIndex",
      "PositivePreIndex_al_r8_r7_plus_r10_ASR_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r12, plus, r11, LSR, 31, PreIndex},
      "al r8 r12 plus r11 LSR 31 PreIndex",
      "PositivePreIndex_al_r8_r12_plus_r11_LSR_31_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r12, plus, r8, LSR, 4, PreIndex},
      "al r11 r12 plus r8 LSR 4 PreIndex",
      "PositivePreIndex_al_r11_r12_plus_r8_LSR_4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r8, minus, r7, ASR, 31, PreIndex},
      "al r4 r8 minus r7 ASR 31 PreIndex",
      "NegativePreIndex_al_r4_r8_minus_r7_ASR_31_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r0, minus, r12, ASR, 12, PreIndex},
      "al r9 r0 minus r12 ASR 12 PreIndex",
      "NegativePreIndex_al_r9_r0_minus_r12_ASR_12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r1, minus, r9, ASR, 9, PreIndex},
      "al r3 r1 minus r9 ASR 9 PreIndex",
      "NegativePreIndex_al_r3_r1_minus_r9_ASR_9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r9, minus, r10, ASR, 27, PreIndex},
      "al r14 r9 minus r10 ASR 27 PreIndex",
      "NegativePreIndex_al_r14_r9_minus_r10_ASR_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r5, minus, r14, ASR, 25, PreIndex},
      "al r1 r5 minus r14 ASR 25 PreIndex",
      "NegativePreIndex_al_r1_r5_minus_r14_ASR_25_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r10, minus, r11, LSR, 7, PreIndex},
      "al r0 r10 minus r11 LSR 7 PreIndex",
      "NegativePreIndex_al_r0_r10_minus_r11_LSR_7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r9, minus, r1, LSR, 13, PreIndex},
      "al r6 r9 minus r1 LSR 13 PreIndex",
      "NegativePreIndex_al_r6_r9_minus_r1_LSR_13_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r10, minus, r9, LSR, 27, PreIndex},
      "al r11 r10 minus r9 LSR 27 PreIndex",
      "NegativePreIndex_al_r11_r10_minus_r9_LSR_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r1, minus, r11, ASR, 23, PreIndex},
      "al r6 r1 minus r11 ASR 23 PreIndex",
      "NegativePreIndex_al_r6_r1_minus_r11_ASR_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r2, minus, r11, ASR, 11, PreIndex},
      "al r0 r2 minus r11 ASR 11 PreIndex",
      "NegativePreIndex_al_r0_r2_minus_r11_ASR_11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r9, minus, r8, ASR, 9, PreIndex},
      "al r2 r9 minus r8 ASR 9 PreIndex",
      "NegativePreIndex_al_r2_r9_minus_r8_ASR_9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r9, minus, r4, LSR, 28, PreIndex},
      "al r14 r9 minus r4 LSR 28 PreIndex",
      "NegativePreIndex_al_r14_r9_minus_r4_LSR_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r14, minus, r11, LSR, 10, PreIndex},
      "al r5 r14 minus r11 LSR 10 PreIndex",
      "NegativePreIndex_al_r5_r14_minus_r11_LSR_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r2, minus, r14, ASR, 20, PreIndex},
      "al r10 r2 minus r14 ASR 20 PreIndex",
      "NegativePreIndex_al_r10_r2_minus_r14_ASR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r5, minus, r3, LSR, 16, PreIndex},
      "al r9 r5 minus r3 LSR 16 PreIndex",
      "NegativePreIndex_al_r9_r5_minus_r3_LSR_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r12, minus, r7, ASR, 20, PreIndex},
      "al r1 r12 minus r7 ASR 20 PreIndex",
      "NegativePreIndex_al_r1_r12_minus_r7_ASR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r11, minus, r4, ASR, 12, PreIndex},
      "al r10 r11 minus r4 ASR 12 PreIndex",
      "NegativePreIndex_al_r10_r11_minus_r4_ASR_12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r7, minus, r3, LSR, 4, PreIndex},
      "al r12 r7 minus r3 LSR 4 PreIndex",
      "NegativePreIndex_al_r12_r7_minus_r3_LSR_4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r14, minus, r6, ASR, 8, PreIndex},
      "al r1 r14 minus r6 ASR 8 PreIndex",
      "NegativePreIndex_al_r1_r14_minus_r6_ASR_8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r7, minus, r8, LSR, 8, PreIndex},
      "al r12 r7 minus r8 LSR 8 PreIndex",
      "NegativePreIndex_al_r12_r7_minus_r8_LSR_8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r10, minus, r5, ASR, 2, PreIndex},
      "al r7 r10 minus r5 ASR 2 PreIndex",
      "NegativePreIndex_al_r7_r10_minus_r5_ASR_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r4, minus, r6, ASR, 23, PreIndex},
      "al r11 r4 minus r6 ASR 23 PreIndex",
      "NegativePreIndex_al_r11_r4_minus_r6_ASR_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r2, minus, r3, ASR, 17, PreIndex},
      "al r5 r2 minus r3 ASR 17 PreIndex",
      "NegativePreIndex_al_r5_r2_minus_r3_ASR_17_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r14, minus, r5, LSR, 13, PreIndex},
      "al r1 r14 minus r5 LSR 13 PreIndex",
      "NegativePreIndex_al_r1_r14_minus_r5_LSR_13_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r14, minus, r7, LSR, 4, PreIndex},
      "al r0 r14 minus r7 LSR 4 PreIndex",
      "NegativePreIndex_al_r0_r14_minus_r7_LSR_4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r14, minus, r2, LSR, 12, PreIndex},
      "al r11 r14 minus r2 LSR 12 PreIndex",
      "NegativePreIndex_al_r11_r14_minus_r2_LSR_12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r10, minus, r14, LSR, 32, PreIndex},
      "al r2 r10 minus r14 LSR 32 PreIndex",
      "NegativePreIndex_al_r2_r10_minus_r14_LSR_32_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r14, minus, r2, LSR, 25, PreIndex},
      "al r8 r14 minus r2 LSR 25 PreIndex",
      "NegativePreIndex_al_r8_r14_minus_r2_LSR_25_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r7, minus, r14, LSR, 9, PreIndex},
      "al r0 r7 minus r14 LSR 9 PreIndex",
      "NegativePreIndex_al_r0_r7_minus_r14_LSR_9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r8, minus, r10, LSR, 15, PreIndex},
      "al r7 r8 minus r10 LSR 15 PreIndex",
      "NegativePreIndex_al_r7_r8_minus_r10_LSR_15_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r0, minus, r10, LSR, 21, PreIndex},
      "al r5 r0 minus r10 LSR 21 PreIndex",
      "NegativePreIndex_al_r5_r0_minus_r10_LSR_21_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r0, minus, r4, LSR, 16, PreIndex},
      "al r9 r0 minus r4 LSR 16 PreIndex",
      "NegativePreIndex_al_r9_r0_minus_r4_LSR_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r7, minus, r11, LSR, 30, PreIndex},
      "al r0 r7 minus r11 LSR 30 PreIndex",
      "NegativePreIndex_al_r0_r7_minus_r11_LSR_30_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r8, minus, r4, ASR, 26, PreIndex},
      "al r9 r8 minus r4 ASR 26 PreIndex",
      "NegativePreIndex_al_r9_r8_minus_r4_ASR_26_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r12, minus, r7, LSR, 9, PreIndex},
      "al r11 r12 minus r7 LSR 9 PreIndex",
      "NegativePreIndex_al_r11_r12_minus_r7_LSR_9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r2, minus, r10, LSR, 13, PreIndex},
      "al r3 r2 minus r10 LSR 13 PreIndex",
      "NegativePreIndex_al_r3_r2_minus_r10_LSR_13_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r10, minus, r2, LSR, 27, PreIndex},
      "al r8 r10 minus r2 LSR 27 PreIndex",
      "NegativePreIndex_al_r8_r10_minus_r2_LSR_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r5, minus, r12, LSR, 7, PreIndex},
      "al r7 r5 minus r12 LSR 7 PreIndex",
      "NegativePreIndex_al_r7_r5_minus_r12_LSR_7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r7, minus, r8, ASR, 14, PreIndex},
      "al r14 r7 minus r8 ASR 14 PreIndex",
      "NegativePreIndex_al_r14_r7_minus_r8_ASR_14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r12, minus, r3, ASR, 23, PreIndex},
      "al r1 r12 minus r3 ASR 23 PreIndex",
      "NegativePreIndex_al_r1_r12_minus_r3_ASR_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r9, minus, r8, ASR, 22, PreIndex},
      "al r6 r9 minus r8 ASR 22 PreIndex",
      "NegativePreIndex_al_r6_r9_minus_r8_ASR_22_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r11, minus, r2, ASR, 29, PreIndex},
      "al r5 r11 minus r2 ASR 29 PreIndex",
      "NegativePreIndex_al_r5_r11_minus_r2_ASR_29_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r1, minus, r10, ASR, 32, PreIndex},
      "al r4 r1 minus r10 ASR 32 PreIndex",
      "NegativePreIndex_al_r4_r1_minus_r10_ASR_32_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r4, minus, r3, ASR, 5, PreIndex},
      "al r8 r4 minus r3 ASR 5 PreIndex",
      "NegativePreIndex_al_r8_r4_minus_r3_ASR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r10, minus, r1, LSR, 13, PreIndex},
      "al r14 r10 minus r1 LSR 13 PreIndex",
      "NegativePreIndex_al_r14_r10_minus_r1_LSR_13_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r10, minus, r3, LSR, 32, PreIndex},
      "al r2 r10 minus r3 LSR 32 PreIndex",
      "NegativePreIndex_al_r2_r10_minus_r3_LSR_32_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r7, minus, r6, LSR, 17, PreIndex},
      "al r0 r7 minus r6 LSR 17 PreIndex",
      "NegativePreIndex_al_r0_r7_minus_r6_LSR_17_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r3, minus, r5, LSR, 2, PreIndex},
      "al r11 r3 minus r5 LSR 2 PreIndex",
      "NegativePreIndex_al_r11_r3_minus_r5_LSR_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r10, minus, r14, ASR, 1, PreIndex},
      "al r9 r10 minus r14 ASR 1 PreIndex",
      "NegativePreIndex_al_r9_r10_minus_r14_ASR_1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r4, minus, r12, LSR, 20, PreIndex},
      "al r1 r4 minus r12 LSR 20 PreIndex",
      "NegativePreIndex_al_r1_r4_minus_r12_LSR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r12, minus, r2, LSR, 31, PreIndex},
      "al r6 r12 minus r2 LSR 31 PreIndex",
      "NegativePreIndex_al_r6_r12_minus_r2_LSR_31_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r8, minus, r14, LSR, 20, PreIndex},
      "al r12 r8 minus r14 LSR 20 PreIndex",
      "NegativePreIndex_al_r12_r8_minus_r14_LSR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r12, minus, r1, ASR, 10, PreIndex},
      "al r0 r12 minus r1 ASR 10 PreIndex",
      "NegativePreIndex_al_r0_r12_minus_r1_ASR_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r10, minus, r8, LSR, 14, PreIndex},
      "al r2 r10 minus r8 LSR 14 PreIndex",
      "NegativePreIndex_al_r2_r10_minus_r8_LSR_14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r8, minus, r11, ASR, 22, PreIndex},
      "al r7 r8 minus r11 ASR 22 PreIndex",
      "NegativePreIndex_al_r7_r8_minus_r11_ASR_22_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r7, minus, r6, LSR, 26, PreIndex},
      "al r12 r7 minus r6 LSR 26 PreIndex",
      "NegativePreIndex_al_r12_r7_minus_r6_LSR_26_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r5, minus, r11, ASR, 2, PreIndex},
      "al r2 r5 minus r11 ASR 2 PreIndex",
      "NegativePreIndex_al_r2_r5_minus_r11_ASR_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r8, minus, r10, LSR, 1, PreIndex},
      "al r12 r8 minus r10 LSR 1 PreIndex",
      "NegativePreIndex_al_r12_r8_minus_r10_LSR_1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r11, minus, r9, ASR, 18, PreIndex},
      "al r8 r11 minus r9 ASR 18 PreIndex",
      "NegativePreIndex_al_r8_r11_minus_r9_ASR_18_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r1, minus, r0, ASR, 6, PreIndex},
      "al r7 r1 minus r0 ASR 6 PreIndex",
      "NegativePreIndex_al_r7_r1_minus_r0_ASR_6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r6, minus, r5, LSR, 12, PreIndex},
      "al r10 r6 minus r5 LSR 12 PreIndex",
      "NegativePreIndex_al_r10_r6_minus_r5_LSR_12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r12, minus, r2, ASR, 1, PreIndex},
      "al r8 r12 minus r2 ASR 1 PreIndex",
      "NegativePreIndex_al_r8_r12_minus_r2_ASR_1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r1, minus, r14, LSR, 30, PreIndex},
      "al r9 r1 minus r14 LSR 30 PreIndex",
      "NegativePreIndex_al_r9_r1_minus_r14_LSR_30_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r14, minus, r0, ASR, 2, PreIndex},
      "al r1 r14 minus r0 ASR 2 PreIndex",
      "NegativePreIndex_al_r1_r14_minus_r0_ASR_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r7, minus, r2, ASR, 26, PreIndex},
      "al r10 r7 minus r2 ASR 26 PreIndex",
      "NegativePreIndex_al_r10_r7_minus_r2_ASR_26_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r6, minus, r0, LSR, 29, PreIndex},
      "al r5 r6 minus r0 LSR 29 PreIndex",
      "NegativePreIndex_al_r5_r6_minus_r0_LSR_29_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r12, minus, r11, LSR, 11, PreIndex},
      "al r2 r12 minus r11 LSR 11 PreIndex",
      "NegativePreIndex_al_r2_r12_minus_r11_LSR_11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r0, minus, r10, LSR, 10, PreIndex},
      "al r5 r0 minus r10 LSR 10 PreIndex",
      "NegativePreIndex_al_r5_r0_minus_r10_LSR_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r6, minus, r2, LSR, 8, PreIndex},
      "al r3 r6 minus r2 LSR 8 PreIndex",
      "NegativePreIndex_al_r3_r6_minus_r2_LSR_8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r14, minus, r1, LSR, 5, PreIndex},
      "al r2 r14 minus r1 LSR 5 PreIndex",
      "NegativePreIndex_al_r2_r14_minus_r1_LSR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r7, minus, r5, LSR, 16, PreIndex},
      "al r2 r7 minus r5 LSR 16 PreIndex",
      "NegativePreIndex_al_r2_r7_minus_r5_LSR_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r2, minus, r7, ASR, 27, PreIndex},
      "al r1 r2 minus r7 ASR 27 PreIndex",
      "NegativePreIndex_al_r1_r2_minus_r7_ASR_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r0, minus, r12, LSR, 5, PreIndex},
      "al r8 r0 minus r12 LSR 5 PreIndex",
      "NegativePreIndex_al_r8_r0_minus_r12_LSR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r12, minus, r2, LSR, 10, PreIndex},
      "al r0 r12 minus r2 LSR 10 PreIndex",
      "NegativePreIndex_al_r0_r12_minus_r2_LSR_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r1, minus, r12, LSR, 26, PreIndex},
      "al r7 r1 minus r12 LSR 26 PreIndex",
      "NegativePreIndex_al_r7_r1_minus_r12_LSR_26_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r4, minus, r14, ASR, 30, PreIndex},
      "al r3 r4 minus r14 ASR 30 PreIndex",
      "NegativePreIndex_al_r3_r4_minus_r14_ASR_30_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r10, minus, r9, LSR, 1, PreIndex},
      "al r6 r10 minus r9 LSR 1 PreIndex",
      "NegativePreIndex_al_r6_r10_minus_r9_LSR_1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r0, minus, r12, LSR, 8, PreIndex},
      "al r4 r0 minus r12 LSR 8 PreIndex",
      "NegativePreIndex_al_r4_r0_minus_r12_LSR_8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r4, minus, r11, LSR, 32, PreIndex},
      "al r8 r4 minus r11 LSR 32 PreIndex",
      "NegativePreIndex_al_r8_r4_minus_r11_LSR_32_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r10, minus, r2, LSR, 23, PreIndex},
      "al r8 r10 minus r2 LSR 23 PreIndex",
      "NegativePreIndex_al_r8_r10_minus_r2_LSR_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r9, minus, r11, LSR, 27, PreIndex},
      "al r14 r9 minus r11 LSR 27 PreIndex",
      "NegativePreIndex_al_r14_r9_minus_r11_LSR_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r3, minus, r4, ASR, 28, PreIndex},
      "al r7 r3 minus r4 ASR 28 PreIndex",
      "NegativePreIndex_al_r7_r3_minus_r4_ASR_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r4, minus, r7, ASR, 19, PreIndex},
      "al r12 r4 minus r7 ASR 19 PreIndex",
      "NegativePreIndex_al_r12_r4_minus_r7_ASR_19_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r10, minus, r6, ASR, 6, PreIndex},
      "al r7 r10 minus r6 ASR 6 PreIndex",
      "NegativePreIndex_al_r7_r10_minus_r6_ASR_6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r0, minus, r4, ASR, 2, PreIndex},
      "al r2 r0 minus r4 ASR 2 PreIndex",
      "NegativePreIndex_al_r2_r0_minus_r4_ASR_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r7, minus, r14, ASR, 26, PreIndex},
      "al r3 r7 minus r14 ASR 26 PreIndex",
      "NegativePreIndex_al_r3_r7_minus_r14_ASR_26_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r8, minus, r1, ASR, 29, PreIndex},
      "al r7 r8 minus r1 ASR 29 PreIndex",
      "NegativePreIndex_al_r7_r8_minus_r1_ASR_29_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r14, minus, r3, LSR, 11, PreIndex},
      "al r11 r14 minus r3 LSR 11 PreIndex",
      "NegativePreIndex_al_r11_r14_minus_r3_LSR_11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r12, minus, r4, LSR, 20, PreIndex},
      "al r11 r12 minus r4 LSR 20 PreIndex",
      "NegativePreIndex_al_r11_r12_minus_r4_LSR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r11, minus, r10, ASR, 23, PreIndex},
      "al r8 r11 minus r10 ASR 23 PreIndex",
      "NegativePreIndex_al_r8_r11_minus_r10_ASR_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r10, minus, r5, ASR, 24, PreIndex},
      "al r2 r10 minus r5 ASR 24 PreIndex",
      "NegativePreIndex_al_r2_r10_minus_r5_ASR_24_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r7, minus, r1, ASR, 9, PreIndex},
      "al r5 r7 minus r1 ASR 9 PreIndex",
      "NegativePreIndex_al_r5_r7_minus_r1_ASR_9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r5, minus, r11, LSR, 16, PreIndex},
      "al r3 r5 minus r11 LSR 16 PreIndex",
      "NegativePreIndex_al_r3_r5_minus_r11_LSR_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r6, minus, r1, ASR, 27, PreIndex},
      "al r4 r6 minus r1 ASR 27 PreIndex",
      "NegativePreIndex_al_r4_r6_minus_r1_ASR_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r5, minus, r14, LSR, 5, PreIndex},
      "al r8 r5 minus r14 LSR 5 PreIndex",
      "NegativePreIndex_al_r8_r5_minus_r14_LSR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r7, minus, r2, LSR, 9, PreIndex},
      "al r11 r7 minus r2 LSR 9 PreIndex",
      "NegativePreIndex_al_r11_r7_minus_r2_LSR_9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r11, minus, r4, LSR, 29, PreIndex},
      "al r6 r11 minus r4 LSR 29 PreIndex",
      "NegativePreIndex_al_r6_r11_minus_r4_LSR_29_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r10, minus, r1, ASR, 10, PreIndex},
      "al r4 r10 minus r1 ASR 10 PreIndex",
      "NegativePreIndex_al_r4_r10_minus_r1_ASR_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r0, minus, r12, ASR, 18, PreIndex},
      "al r3 r0 minus r12 ASR 18 PreIndex",
      "NegativePreIndex_al_r3_r0_minus_r12_ASR_18_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r3, minus, r14, ASR, 14, PreIndex},
      "al r4 r3 minus r14 ASR 14 PreIndex",
      "NegativePreIndex_al_r4_r3_minus_r14_ASR_14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex}};

// We record all inputs to the instructions as outputs. This way, we also check
// that what shouldn't change didn't change.
struct TestResult {
  size_t output_size;
  const Inputs* outputs;
};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/simulator-cond-rd-memop-rs-shift-amount-1to32-ldr-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-shift-amount-1to32-ldrb-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-shift-amount-1to32-str-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-shift-amount-1to32-strb-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const MemOperand& memop);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  SETUP();
  masm.UseA32();
  START();

  // Data to compare to `reference`.
  TestResult* results[ARRAY_SIZE(kTests)];

  // Test cases for memory bound instructions may allocate a buffer and save its
  // address in this array.
  byte* scratch_memory_buffers[ARRAY_SIZE(kTests)];

  // Generate a loop for each element in `kTests`. Each loop tests one specific
  // instruction.
  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Allocate results on the heap for this test.
    results[i] = new TestResult;
    results[i]->outputs = new Inputs[kTests[i].input_size];
    results[i]->output_size = kTests[i].input_size;

    size_t input_stride = sizeof(kTests[i].inputs[0]) * kTests[i].input_size;
    VIXL_ASSERT(IsUint32(input_stride));

    scratch_memory_buffers[i] = NULL;

    Label loop;
    UseScratchRegisterScope scratch_registers(&masm);
    // Include all registers from r0 ro r12.
    scratch_registers.Include(RegisterList(0x1fff));

    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Sign sign = kTests[i].operands.sign;
    Register rm = kTests[i].operands.rm;
    ShiftType shift = kTests[i].operands.shift;
    uint32_t amount = kTests[i].operands.amount;
    AddrMode addr_mode = kTests[i].operands.addr_mode;
    MemOperand memop(rn, sign, rm, shift, amount, addr_mode);
    scratch_registers.Exclude(rd);
    scratch_registers.Exclude(rn);
    scratch_registers.Exclude(rm);

    // Allocate reserved registers for our own use.
    Register input_ptr = scratch_registers.Acquire();
    Register input_end = scratch_registers.Acquire();
    Register result_ptr = scratch_registers.Acquire();

    // Initialize `input_ptr` to the first element and `input_end` the address
    // after the array.
    __ Mov(input_ptr, Operand::From(kTests[i].inputs));
    __ Add(input_end, input_ptr, static_cast<uint32_t>(input_stride));
    __ Mov(result_ptr, Operand::From(results[i]->outputs));
    __ Bind(&loop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      Register saved_q_bit = temp_registers.Acquire();
      // Save the `Q` bit flag.
      __ Mrs(saved_q_bit, APSR);
      __ And(saved_q_bit, saved_q_bit, QFlag);
      // Set the `NZCV` and `Q` flags together.
      __ Ldr(nzcv_bits, MemOperand(input_ptr, offsetof(Inputs, apsr)));
      __ Orr(nzcv_bits, nzcv_bits, saved_q_bit);
      __ Msr(APSR_nzcvq, nzcv_bits);
    }
    __ Ldr(rd, MemOperand(input_ptr, offsetof(Inputs, rd)));
    __ Ldr(rm, MemOperand(input_ptr, offsetof(Inputs, rm)));
    // Allocate 4 bytes for the instruction to work with.
    scratch_memory_buffers[i] = new byte[4];
    {
      UseScratchRegisterScope temp_registers(&masm);

      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Write the expected data into the scratch buffer.
      __ Mov(base_register, Operand::From(scratch_memory_buffers[i]));
      __ Ldr(memop_tmp, MemOperand(input_ptr, offsetof(Inputs, memop) + 4));
      __ Str(memop_tmp, MemOperand(base_register));

      // Compute the address to put into the base register so that the
      // `MemOperand` points to the right location.
      // TODO: Support more kinds of `MemOperand`.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Add(base_register, base_register, memop_tmp);
          }
        }
      }
    }


    (masm.*instruction)(cond, rd, memop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      __ Mrs(nzcv_bits, APSR);
      // Only record the NZCV bits.
      __ And(nzcv_bits, nzcv_bits, NZCVFlag);
      __ Str(nzcv_bits, MemOperand(result_ptr, offsetof(Inputs, apsr)));
    }
    __ Str(rd, MemOperand(result_ptr, offsetof(Inputs, rd)));
    __ Str(rm, MemOperand(result_ptr, offsetof(Inputs, rm)));
    {
      UseScratchRegisterScope temp_registers(&masm);
      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Compute the address of the scratch buffer by from the base register. If
      // the instruction has updated the base register, we will be able to
      // record it.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Sub(base_register, base_register, memop_tmp);
          }
        }
      }

      // Record the value of the base register, as an offset from the scratch
      // buffer's address.
      __ Mov(memop_tmp, Operand::From(scratch_memory_buffers[i]));
      __ Sub(base_register, base_register, memop_tmp);
      __ Str(base_register, MemOperand(result_ptr, offsetof(Inputs, memop)));

      // Record the 32 bit word from memory.
      __ Ldr(memop_tmp, MemOperand(memop_tmp));
      __ Str(memop_tmp, MemOperand(result_ptr, offsetof(Inputs, memop) + 4));
    }


    // Advance the result pointer.
    __ Add(result_ptr, result_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    // Loop back until `input_ptr` is lower than `input_base`.
    __ Add(input_ptr, input_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    __ Cmp(input_ptr, input_end);
    __ B(ne, &loop);
  }

  END();

  RUN();

  if (Test::generate_test_trace()) {
    // Print the results.
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("const Inputs kOutputs_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (size_t j = 0; j < results[i]->output_size; j++) {
        printf("  { ");
        printf("0x%08" PRIx32, results[i]->outputs[j].apsr);
        printf(", ");
        printf("0x%08" PRIx32, results[i]->outputs[j].rd);
        printf(", ");
        printf("0x%08" PRIx32, results[i]->outputs[j].rm);
        printf(", ");
        printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
               results[i]->outputs[j].memop[0],
               results[i]->outputs[j].memop[1]);
        printf(" },\n");
      }
      printf("};\n");
    }
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kOutputs_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kOutputs_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else if (kCheckSimulatorTestResults) {
    // Check the results.
    unsigned total_error_count = 0;
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      bool instruction_has_errors = false;
      for (size_t j = 0; j < kTests[i].input_size; j++) {
        uint32_t apsr = results[i]->outputs[j].apsr;
        uint32_t rd = results[i]->outputs[j].rd;
        uint32_t rm = results[i]->outputs[j].rm;
        uint32_t memop[2] = {results[i]->outputs[j].memop[0],
                             results[i]->outputs[j].memop[1]};

        uint32_t apsr_input = kTests[i].inputs[j].apsr;
        uint32_t rd_input = kTests[i].inputs[j].rd;
        uint32_t rm_input = kTests[i].inputs[j].rm;
        uint32_t memop_input[2] = {kTests[i].inputs[j].memop[0],
                                   kTests[i].inputs[j].memop[1]};

        uint32_t apsr_ref = reference[i].outputs[j].apsr;
        uint32_t rd_ref = reference[i].outputs[j].rd;
        uint32_t rm_ref = reference[i].outputs[j].rm;
        uint32_t memop_ref[2] = {results[i]->outputs[j].memop[0],
                                 results[i]->outputs[j].memop[1]};


        if (((apsr != apsr_ref) || (rd != rd_ref) || (rm != rm_ref) ||
             ((memop[0] != memop_ref[0]) && (memop[1] != memop_ref[1]))) &&
            (++total_error_count <= kErrorReportLimit)) {
          // Print the instruction once even if it triggered multiple failures.
          if (!instruction_has_errors) {
            printf("Error(s) when testing \"%s %s\":\n",
                   mnemonic,
                   kTests[i].operands_description);
            instruction_has_errors = true;
          }
          // Print subsequent errors.
          printf("  Input:    ");
          printf("0x%08" PRIx32, apsr_input);
          printf(", ");
          printf("0x%08" PRIx32, rd_input);
          printf(", ");
          printf("0x%08" PRIx32, rm_input);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_input[0],
                 memop_input[1]);
          printf("\n");
          printf("  Expected: ");
          printf("0x%08" PRIx32, apsr_ref);
          printf(", ");
          printf("0x%08" PRIx32, rd_ref);
          printf(", ");
          printf("0x%08" PRIx32, rm_ref);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_ref[0],
                 memop_ref[1]);
          printf("\n");
          printf("  Found:    ");
          printf("0x%08" PRIx32, apsr);
          printf(", ");
          printf("0x%08" PRIx32, rd);
          printf(", ");
          printf("0x%08" PRIx32, rm);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}", memop[0], memop[1]);
          printf("\n\n");
        }
      }
    }

    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    VIXL_CHECK(total_error_count == 0);
  } else {
    VIXL_WARNING("Assembled the code, but did not run anything.\n");
  }

  for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
    delete[] results[i]->outputs;
    delete results[i];
    delete[] scratch_memory_buffers[i];
  }
}

// Instantiate tests for each instruction in the list.
// TODO: Remove this limitation by having a sandboxing mechanism.
#if defined(VIXL_HOST_POINTER_32)
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_SIMULATOR_COND_RD_MEMOP_RS_SHIFT_AMOUNT_1TO32_" #mnemonic    \
      "_A32",                                                               \
      &Test_##mnemonic);
#else
#define TEST(mnemonic)                                                   \
  void Test_##mnemonic() {                                               \
    VIXL_WARNING("This test can only run on a 32-bit host.\n");          \
    USE(TestHelper);                                                     \
  }                                                                      \
  Test test_##mnemonic(                                                  \
      "AARCH32_SIMULATOR_COND_RD_MEMOP_RS_SHIFT_AMOUNT_1TO32_" #mnemonic \
      "_A32",                                                            \
      &Test_##mnemonic);
#endif

FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
