/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: kb_config_menu.c,v 1.2 2000/03/12 12:58:54 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include <GL/glut.h>

#include "xracer.h"
#include "xracer-mode.h"
#include "xracer-text.h"
#include "xracer-log.h"
#include "xracer-game.h"
#include "xracer-menu.h"

static int posn = 0;		/* Current cursor position in screen. */
static void *font = 0;		/* Standard font. */
static int height = 0;		/* Font height. */

static int save_settings = 0;	/* If true, save settings when leaving mode. */

/* Program-level menu initialization. */
void
xrKeyboardConfigurationMenuInit ()
{
  /* Select a font for drawing menus in. */
  font = xrTextFindFont ("crillee", 24);
  xrLogAssert (font != 0);

  height = xrTextGetHeight (font);
}

static void
start_mode (const void *args)
{
  posn = 2;
}

static void
end_mode ()
{
  if (save_settings)
    {
      /* XXX do something */
    }
}

static void
display ()
{
  /* Clear display buffers. */
  glClear (GL_COLOR_BUFFER_BIT);

  /* Switch to orthographic projection. */
  glMatrixMode (GL_PROJECTION);
  glPushMatrix ();
  glLoadIdentity ();
  glOrtho (0, (GLdouble) xrWidth, 0, (GLdouble) xrHeight, 0, 1000);
  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
  glLoadIdentity ();

  /* Enable alpha blending for text. */
  glEnable (GL_BLEND);
  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  /* Draw the menu. */
  xrTextPrintf (font, 64, 64, "Press Space or Return to modify a setting");
  xrTextPrintf (font, 64, 128+0*height, "Save settings");
  xrTextPrintf (font, 64, 128+1*height, "Cancel");
  xrTextPrintf (font, 64, 128+2*height, "Quit ..... Q");
  xrTextPrintf (font, 32, 128+posn*height, ">");

  glDisable (GL_BLEND);

  /* Restore matrices. */
  glMatrixMode (GL_MODELVIEW);
  glPopMatrix ();
  glMatrixMode (GL_PROJECTION);
  glPopMatrix ();
}

static int
keyboard (unsigned char key, int x, int y)
{
  switch (key)
    {
    case '\n':
    case '\r':
    case ' ':
      switch (posn)
	{
	case 0:
	  save_settings = 1;
	  xrEnterMenu (&xrConfigurationMenu, 0);
	  return 1;
	case 1:
	  xrEnterMenu (&xrConfigurationMenu, 0);
	  return 1;
	}
      break;
    }

  return 0;
}

static int
special (int special, int x, int y)
{
  switch (special)
    {
    case GLUT_KEY_UP:
      if (posn > 0)
	posn--;
      return 1;
    case GLUT_KEY_DOWN:
      if (posn < 1)
	posn++;
      return 1;
    }

  return 0;
}

struct xrMode xrKeyboardConfigurationMenuMode = {
  name: "keyboard configuration menu",
  start_mode: start_mode,
  end_mode: end_mode,
  display: display,
  keyboard: keyboard,
  special: special
};
