INCLUDE(CheckCSourceCompiles)
INCLUDE(CheckCCompilerFlag)
INCLUDE(CheckFunctionExists)
INCLUDE(CheckIncludeFile)
INCLUDE(CheckSymbolExists)
INCLUDE(CheckTypeSize)
INCLUDE(CheckLibraryExists)

FIND_PROGRAM(CPP_PROG NAMES cpp)

# Platform-specific include files (POSIX, Win32)
CHECK_INCLUDE_FILE(locale.h HAVE_LOCALE_H)
CHECK_INCLUDE_FILE(libgen.h HAVE_LIBGEN_H)
CHECK_INCLUDE_FILE(unistd.h HAVE_UNISTD_H)
CHECK_INCLUDE_FILE(direct.h HAVE_DIRECT_H)
CHECK_INCLUDE_FILE(stdint.h HAVE_STDINT_H)

CHECK_SYMBOL_EXISTS(abort "stdlib.h" HAVE_ABORT)

CHECK_FUNCTION_EXISTS(getcwd HAVE_GETCWD)
CHECK_FUNCTION_EXISTS(toascii HAVE_TOASCII)

CHECK_LIBRARY_EXISTS(dl dlopen "" HAVE_LIBDL)

IF (HAVE_LIBDL)
    SET(LIBDL "dl")
ELSE (HAVE_LIBDL)
    SET(LIBDL "")
ENDIF (HAVE_LIBDL)

CONFIGURE_FILE(libyasm-stdint.h.cmake
               ${CMAKE_CURRENT_BINARY_DIR}/libyasm-stdint.h)
CONFIGURE_FILE(config.h.cmake ${CMAKE_CURRENT_BINARY_DIR}/config.h)

ADD_DEFINITIONS(-DHAVE_CONFIG_H)

INCLUDE(FindPythonInterp)
IF (NOT PYTHON_EXECUTABLE)
    MESSAGE(FATAL_ERROR "Could not find Python executable")
ENDIF (NOT PYTHON_EXECUTABLE)

IF (CMAKE_COMPILER_IS_GNUCXX)
    CHECK_C_COMPILER_FLAG(-pipe C_ACCEPTS_PIPE)
    CHECK_C_COMPILER_FLAG(-ansi C_ACCEPTS_ANSI)
    CHECK_C_COMPILER_FLAG(-pedantic C_ACCEPTS_PEDANTIC)
    CHECK_C_COMPILER_FLAG(-Wall C_ACCEPTS_WALL)
    CHECK_C_COMPILER_FLAG(-Wno-unused-parameter C_ACCEPTS_WNOUNUSEDPARAM)

    IF (C_ACCEPTS_PIPE)
        ADD_DEFINITIONS(-pipe)
    ENDIF (C_ACCEPTS_PIPE)

    IF (C_ACCEPTS_ANSI)
        ADD_DEFINITIONS(-ansi)
    ENDIF (C_ACCEPTS_ANSI)

    IF (C_ACCEPTS_PEDANTIC)
        ADD_DEFINITIONS(-pedantic)
    ENDIF (C_ACCEPTS_PEDANTIC)

    IF (C_ACCEPTS_WALL)
        ADD_DEFINITIONS(-Wall)
    ENDIF (C_ACCEPTS_WALL)

    IF (C_ACCEPTS_WNOUNUSEDPARAM)
        ADD_DEFINITIONS(-Wno-unused-parameter)
    ENDIF (C_ACCEPTS_WNOUNUSEDPARAM)
ENDIF (CMAKE_COMPILER_IS_GNUCXX)

# Disable some annoying Visual Studio warnings
IF (MSVC)
    ADD_DEFINITIONS(-D_CRT_SECURE_NO_WARNINGS)
    ADD_DEFINITIONS(-D_CRT_NONSTDC_NO_WARNINGS)
ENDIF (MSVC)
