/* CSL - Common Sound Layer
 * Copyright (C) 2001 Jeff Tranter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This example illustrates the CSL option parsing functions. It
 * it recommended that you use these to save work and provide
 * common option parsing.
 */

#include <stdio.h>
#include <csl/csl.h>

int main (int argc, char **argv)
{
  CslErrorType error;
  CslDriver *driver;
  CslOptions options = { 0 };

  /* With no options, show usage */
  if (argc <= 1)
  {
	  printf("options:\n%s\n", csl_options_describe(0));
	  return 0;
  }

  /* parse the options */  
  csl_options_parse (&options, &argc, &argv);

  /* set debug mask using any passed debug options */
  csl_set_debug_mask (options.debug_flags);

  /* initialize the driver */
  error = csl_driver_init (NULL, &driver);
  if (error)
	  csl_error ("unable to initialize driver: %s", csl_strerror (error));

  /* show the selected options */
  printf("        float? %d\n", options.float_samples);
  printf("       signed? %d\n", options.signed_samples);
  printf("     unsigned? %d\n", options.unsigned_samples);
  printf("   big endian? %d\n", options.big_endian);
  printf("little endian? %d\n", options.little_endian);
  printf("         bits: %d\n", options.n_bits);
  printf("     channels: %d\n", options.n_channels);
  printf("         rate: %d\n", options.rate);
  printf("  debug flags: %d\n", options.debug_flags);
  printf("    endianess: %d\n", options.endianess);
  printf("   PCM format: %s\n", csl_describe_pcm_format(options.pcm_format));

  if (driver != NULL)
	  csl_driver_shutdown (driver);
  
  return 0;
}
