
GEGLQT_CONFIG = TRUE # Must always be set in this file. Used to detect if the file was found or not

GEGLQT_PROJECTNAME = gegl-qt
GEGLQT_VERSION = 0.0.7
GEGLQT_PROJECTBRIEF = "Integration library for using GEGL in Qt based applications"

GEGLQT_API_VERSION = 0.1
GEGLQT_BASELIBNAME = gegl-qt4
GEGLQT_LIBNAME = $$GEGLQT_BASELIBNAME-$$GEGLQT_API_VERSION

GEGLQT_QML_API_NAME = GeglQt4
GEGLQT_QML_API_VERSION_MAJOR = 0
GEGLQT_QML_API_VERSION_MINOR = 1
GEGLQT_QML_API_VERSION = 0.1

OBJECTS_DIR = .obj
MOC_DIR = .moc

# Can be used to specify custom install prefix
isEmpty(GEGLQT_INSTALL_PREFIX) {
    GEGLQT_INSTALL_PREFIX = /usr
}

!isEmpty(GEGLQT_INTEGRATION_CHECK) {
    # Build for integration check
    # Compile examples and tests against an installed gegl-qt version
    USE_EXTERNAL_GEGLQT = yes
}

# Paths for installing files
GEGL_LIBDIR = $$system(pkg-config --variable libdir gegl)
GEGL_INSTALL_OPERATIONS = $$system(pkg-config --variable pluginsdir gegl)
isEmpty(GEGL_INSTALL_OPERATIONS) {
    GEGL_INSTALL_OPERATIONS = $$GEGL_LIBDIR/gegl-0.1/
}

# Optional deps
HAVE_QT_DECLARATIVE = yes
!system(pkg-config QtDeclarative){
    !build_pass:system(echo "QtDeclarative not found - no QML support")
    HAVE_QT_DECLARATIVE = no
}

HAVE_PYSIDE = yes
!system(pkg-config pyside){
    !build_pass:system(echo "PySide not found - no Python support")
    HAVE_PYSIDE = no
}

HAVE_DOXYGEN = yes
DOXYGEN = $$system(which doxygen)
isEmpty(DOXYGEN){
    !build_pass:system(echo "doxygen not found - no documentation")
    HAVE_DOXYGEN = no
}

HAVE_PDFLATEX = yes
PDFLATEX = $$system(which pdflatex)
isEmpty(PDFLATEX){
    !build_pass:system(echo "pdflatex not found - no PDF documentation")
    HAVE_PDFLATEX = no
}

GEGLQT_INSTALL_BIN = $$GEGLQT_INSTALL_PREFIX/bin
GEGLQT_INSTALL_HEADERS = $$GEGLQT_INSTALL_PREFIX/include
GEGLQT_INSTALL_LIBS = $$GEGLQT_INSTALL_PREFIX/lib
GEGLQT_INSTALL_DATA = $$GEGLQT_INSTALL_PREFIX/share

contains(HAVE_QT_DECLARATIVE, yes) {
    # Need to be conditionally included in python binding generation
    GEGLQT_DECLARATIVE_INCLUDE = "$$LITERAL_HASH\\include <GeglQtDeclarative>"
    GEGLQT_DECLARATIVE_TYPESYSTEM = "<object-type name=\\\"NodeViewDeclarativeItem\\\"/>"
    GEGLQT_DECLARATIVE_PKGCONFIG = "QtDeclarative"
}

# Variables that can be substituted in .in files
SUBST_VARIABLES += \
    GEGLQT_API_VERSION \
    GEGLQT_VERSION \
    GEGLQT_BASELIBNAME \
    GEGLQT_LIBNAME \
    GEGLQT_INSTALL_PREFIX \
    GEGLQT_INSTALL_BIN \
    GEGLQT_INSTALL_HEADERS \
    GEGLQT_INSTALL_LIBS \
    GEGLQT_INSTALL_DATA \
    GEGLQT_DECLARATIVE_INCLUDE \
    GEGLQT_DECLARATIVE_TYPESYSTEM \
    GEGLQT_DECLARATIVE_PKGCONFIG \
    GEGLQT_PROJECTBRIEF \
    GEGLQT_PROJECTNAME \

# Generate the specified file from its .in template, and substitute variables
# Variables to be substituted in .in files must be of the form @VARIABLE_NAME@
defineTest(outputFile) {
    out = $$OUT_PWD/$$1
    in = $$PWD/$${1}.in

    !exists($$in) {
        error($$in does not exist!)
        return(false)
    }

    variables = $$SUBST_VARIABLES

    command = "sed"
    for(var, variables) {
       command += "-e \"s:@$$var@:$$eval($$var):g\""
    }
    command += $$in > $$out

    system(mkdir -p $$dirname(out))
    system($$command)
    system(chmod --reference=$$in $$out)

    return(true)
}

# Same as outputFile, just for multiple files
defineTest(outputFiles) {
    files = $$ARGS

    for(file, files) {
        !outputFile($$file):return(false)
    }

    return(true)
}
