/* GimpPluginWindow Widget 
 * Copyright (C) 1998-1999 Shawn T. Amundson
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.             
 *                                                                              
 * This library is distributed in the hope that it will be useful,              
 * but WITHOUT ANY WARRANTY; without even the implied warranty of               
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */                                                                             

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>
#include "tb_help.xpm"
#include "gimppluginwindow.h"
#include "gimppreview.h"
#include <stdio.h>

static void gimp_plugin_window_class_init     (GimpPluginWindowClass *klass);
static void gimp_plugin_window_init           (GimpPluginWindow *window);
static void gimp_plugin_window_add            (GtkContainer *container, 
					       GtkWidget *widget);
static void gimp_plugin_window_remove         (GtkContainer *container, 
					       GtkWidget *widget);

enum {
  CLICKED_OK,
  CLICKED_CANCEL,
  LAST_SIGNAL
};

typedef gint (*GimpPluginWindowSignal) (GtkObject *object,
					gpointer data);

static void gimp_plugin_window_marshal_signal (GtkObject     *object,
					       GtkSignalFunc func,
					       gpointer      func_data,
					       GtkArg        *args);
static GtkWindow *parent_class;
static guint plugin_window_signals[LAST_SIGNAL] = { 0 };

GtkType    
gimp_plugin_window_get_type (void)
{
  static GtkType window_type = 0;

  if (!window_type)
    {
      GtkTypeInfo window_info =
      {
	"GimpPluginWindow",
	sizeof (GimpPluginWindow),
	sizeof (GimpPluginWindowClass),
	(GtkClassInitFunc) gimp_plugin_window_class_init,
	(GtkObjectInitFunc) gimp_plugin_window_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };

      window_type = gtk_type_unique (gtk_window_get_type (), &window_info);
    }

  return window_type;
}

static void
gimp_plugin_window_class_init (GimpPluginWindowClass *klass)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkContainerClass *container_class;
  GtkWindowClass *window_class;

  object_class = GTK_OBJECT_CLASS (klass);
  widget_class = GTK_WIDGET_CLASS (klass);
  container_class = GTK_CONTAINER_CLASS (klass);
  window_class = GTK_WINDOW_CLASS (klass);

  container_class->add = gimp_plugin_window_add;
  container_class->remove = gimp_plugin_window_remove;
  container_class->forall = NULL;

  parent_class = gtk_type_class (gtk_window_get_type ());
  
  plugin_window_signals[CLICKED_OK] = 
    gtk_signal_new("clicked_ok",
		   GTK_RUN_LAST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET (GimpPluginWindowClass, clicked_ok),
		   gtk_signal_default_marshaller,
		   GTK_TYPE_NONE, 0);
  plugin_window_signals[CLICKED_CANCEL] = 
    gtk_signal_new("clicked_cancel",
		   GTK_RUN_LAST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET (GimpPluginWindowClass, clicked_cancel),
		   gimp_plugin_window_marshal_signal,
		   GTK_TYPE_BOOL, 0);

  gtk_object_class_add_signals (object_class, plugin_window_signals, LAST_SIGNAL);

  klass->clicked_ok = NULL;
  klass->clicked_cancel = NULL;

}

static void
gimp_plugin_window_marshal_signal (GtkObject     *object,
				   GtkSignalFunc func,
				   gpointer      func_data,
				   GtkArg        *args)
{
  GimpPluginWindowSignal rfunc;
  gint *return_val;

  rfunc = (GimpPluginWindowSignal) func;
  return_val = GTK_RETLOC_BOOL (args[0]);

  *return_val = (* rfunc) (object, func_data);		   
}

static gint
gimp_plugin_window_ok_callback (GtkButton *button, gpointer data)
{
  gtk_signal_emit(GTK_OBJECT (data), plugin_window_signals[CLICKED_OK]);

  return TRUE;
}

static gint
gimp_plugin_window_cancel_callback (GtkButton *button, gpointer data)
{
  gint return_val = 0;

  gtk_signal_emit(GTK_OBJECT (data), plugin_window_signals[CLICKED_CANCEL], &return_val);

  if (!return_val)
    gtk_widget_destroy(GTK_WIDGET(data));

  return TRUE;
}

static void
gimp_plugin_window_init (GimpPluginWindow *window)
{
}

GtkWidget* 
gimp_plugin_window_new (GimpPluginWindowType type, const char* title, 
			GimpDrawable *drawable)
{
  GtkWidget *widget;
  GtkWidget *vbox;
  GtkWidget *hbuttonbox;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;
  GtkWidget *packer;
  GtkWidget *button_help;
  GtkWidget *pixmap_help;
  GdkPixmap *help_gdkpixmap;
  GdkBitmap *help_gdkbitmap;
  GtkWidget *hbox_bottom;
  GimpPluginWindow *window;
  
  widget = GTK_WIDGET (gtk_type_new (gimp_plugin_window_get_type ()));
  window = (GimpPluginWindow *)widget;
  window->drawable = drawable;


  vbox = gtk_vbox_new(0, 16);
  (GTK_CONTAINER_CLASS (parent_class)->add)(GTK_CONTAINER (window), vbox);
  gtk_container_border_width (GTK_CONTAINER (vbox), 8);

  packer = gtk_packer_new();
  gtk_box_pack_start (GTK_BOX (vbox), packer, FALSE, FALSE, 0);

  window->preview = gimp_preview_new(window->drawable);
  gtk_container_add(GTK_CONTAINER(packer), window->preview);

  window->child_container = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME(window->child_container), GTK_SHADOW_NONE);
  gtk_box_pack_start_defaults (GTK_BOX (vbox), window->child_container); 

  /* Bottom button area */
  hbox_bottom = gtk_hbox_new(0,0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox_bottom, FALSE, TRUE, 0); 

  /* Help button */
  button_help = gtk_button_new();
  gtk_box_pack_start (GTK_BOX (hbox_bottom), button_help, FALSE, FALSE, 0);

  gtk_widget_realize(button_help);
  help_gdkpixmap = gdk_pixmap_create_from_xpm_d (button_help->window,
						 &help_gdkbitmap,
						 &button_help->style->bg[GTK_STATE_NORMAL],
						 tb_help_xpm);
  pixmap_help = gtk_pixmap_new(help_gdkpixmap, help_gdkbitmap );
  gtk_container_add(GTK_CONTAINER(button_help), pixmap_help);

  /* OK and Cancel Buttons */
  hbuttonbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox), 8);
  gtk_box_pack_end (GTK_BOX (hbox_bottom), hbuttonbox, FALSE, TRUE, 0); 

  button_ok = gtk_button_new_with_label ("Ok");
  button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_container_add(GTK_CONTAINER (hbuttonbox), button_ok);
  gtk_container_add(GTK_CONTAINER (hbuttonbox), button_cancel);
  
  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked",
		      GTK_SIGNAL_FUNC (gimp_plugin_window_ok_callback), 
		      (gpointer) window); 
  gtk_signal_connect (GTK_OBJECT (button_cancel), "clicked",
		      GTK_SIGNAL_FUNC (gimp_plugin_window_cancel_callback), 
		      (gpointer) window); 

  GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button_ok);

  /* Show everything */
  gtk_widget_show (pixmap_help);
  gtk_widget_show (button_help);
  gtk_widget_show (button_ok);
  gtk_widget_show (button_cancel);
  gtk_widget_show (hbuttonbox);
  gtk_widget_show (hbox_bottom); 
  gtk_widget_show (window->preview);
  gtk_widget_show (packer);
  gtk_widget_show (window->child_container);
  gtk_widget_show (vbox);

  gtk_window_set_title(GTK_WINDOW (widget), title);
  gtk_window_position (GTK_WINDOW (widget), GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize (widget, 250, -1);

  return widget;
}

static void
gimp_plugin_window_add (GtkContainer *container, GtkWidget *widget)
{
  GimpPluginWindow *window;

  window = (GimpPluginWindow*) container;
  gtk_container_add (GTK_CONTAINER (window->child_container), widget);
}

static void
gimp_plugin_window_remove (GtkContainer *container, GtkWidget *widget)
{
  GimpPluginWindow *window;

  window = (GimpPluginWindow*) container;
  gtk_container_remove (GTK_CONTAINER (window->child_container), widget);
}

