#!/usr/bin/perl
# Written by Bryan Livingston for Net-fu
# Released under GPL
# Use at your own risk.

# The purpose of this program is to take the net-fu commands through STANDARD CGI and pass them
# to the script-fu server, then output the file to the user

# You will need to change the values IP_ADDR and IP_PORT below.

use IO::Socket;
use CGI qw(:standard);

$MAGIC =   'G';
$IP_ADDR = "127.0.0.1";
$IP_PORT = "10008";

# connect to the server
$remote = IO::Socket::INET->new(
	Proto => "tcp",
	PeerAddr => $IP_ADDR,
	PeerPort => $IP_PORT
) || print_error("Unable to connect to server");
$remote->autoflush(1);

# check params
if(length(param("text")) > 25) {
   print_error("Text String too long");
}
if(param("fontsize") > 150) {
   print_error("Font too big");
}

# build the command
$command = param("script") . " \"" . param("text") . "\" " . param("fontsize") 
 . " \"" . param("fontname") . "\" ";
@names = param;
$ct = 4;
$num_params = @names;
while ($ct < $num_params) {
   if($names[$ct] =~ /^color/) {
      $command = $command . "'(" . param($names[$ct]) . " " . param($names[$ct + 1]) . " " . param($names[$ct + 2]) . ") ";
      $ct += 3;
   } elsif ($names[$ct] =~ /^toggle/) {
      if (param($names[$ct]) eq "on") {
         $command = $command . "TRUE ";
      } else {
         $command = $command . "FALSE ";
      }
      $ct++;
   } else {
      if(param($names[$ct]) =~ /[^0-9\-]/) {
         $command = $command . "\"" . param($names[$ct]) . "\" ";
      } else {
         $command = $command . param($names[$ct]) . " ";
      }
      $ct++;
   }
}

# send the command
$len = length($command) + 9;
printf $remote "$MAGIC%c%c(net-fu-$command)",$len >> 8,$len & 0xFF;

# get the results
#if(getc($remote) != $MAGIC) { print_error; }
getc($remote);
getc($remote);
getc($remote);
$len = ord getc($remote);

$command = "";

while ($len > 0) {
   $command = $command . getc($remote);
   $len--;
}

# send the results
if($command =~ /.*\/(.*)$/) {
   print_result($1);
} else {
   print_error("Incorrect results returned");
}

close $remote;

sub print_error {
print header,start_html;
print <<out_head;
<HEAD><TITLE>Net-fu Error</TITLE></HEAD>
<BODY> 
out_head

print "An error has occoured: $_[0]<br>Please check your parameters and try again.";
print end_html;
die "$_[0]";
}

sub print_result {
print header;
print <<out_head;
<HEAD><TITLE>Net-fu Output</TITLE></HEAD>
<BODY> 
<CENTER>
out_head

print "<img src=http://$IP_ADDR/net-fu/tmp/$_[0]>";
print "<br><a href=ftp://$IP_ADDR/pub/tmp/$_[0]>(Shift-)Click here</a> to download.";

print <<out_foot;
</CENTER>
<A href=http://www.gimp.org><IMG align=right border=0 SRC=../images/gfx_gimp.gif></A>
</BODY></HTML>
out_foot
}

