/*********************************************************************************/
/* Lighting Effects 0.1.1 -- image filter plug-in for The Gimp program           */
/* Copyright (C) 1996-98 Tom Bech                                                */
/* Copyright (C) 1996-98 Federico Mena Quintero                                  */
/*===============================================================================*/
/* E-mail: tomb@gimp.org (Tom) or quartic@gimp.org (Federico)                    */
/* You can contact the original The Gimp authors at gimp@xcf.berkeley.edu        */
/*===============================================================================*/
/* This program is free software; you can redistribute it and/or modify it under */
/* the terms of the GNU General Public License as published by the Free Software */
/* Foundation; either version 2 of the License, or (at your option) any later    */
/* version.                                                                      */
/*===============================================================================*/
/* This program is distributed in the hope that it will be useful, but WITHOUT   */
/* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS */
/* FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.*/
/*===============================================================================*/
/* You should have received a copy of the GNU General Public License along with  */
/* this program (read the "COPYING" file); if not, write to the Free Software    */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                     */
/*===============================================================================*/
/* In other words, you can't sue us for whatever happens while using this ;)     */
/*********************************************************************************/

#include "lighting_main.h"

/* Global variables */
/* ================ */

LightingValues mapvals;

/******************/
/* Implementation */
/******************/

void lighting_interactive    (GDrawable *drawable);
void lighting_noninteractive (GDrawable *drawable);

/*************************************/
/* Set parameters to standard values */
/*************************************/

void set_default_settings(void)
{
  gck_vector3_set(&mapvals.viewpoint,   0.5, 0.5, 0.25);
  gck_vector3_set(&mapvals.planenormal, 0.0, 0.0, 1.0);
  
  gck_vector3_set(&mapvals.lightsource.position,  1.0, 0.0, 1.0);
  gck_vector3_set(&mapvals.lightsource.direction, -1.0, -1.0, 1.0);

  gck_rgb_set(&mapvals.lightsource.color, 1.0, 1.0, 1.0);
  mapvals.lightsource.intensity = 1.0;
  mapvals.lightsource.type = POINT_LIGHT;

  mapvals.material.ambient_int = 0.3;
  mapvals.material.diffuse_int = 1.0;
  mapvals.material.diffuse_ref = 0.4;
  mapvals.material.specular_ref = 0.6;
  mapvals.material.highlight = 27.0;

  mapvals.pixel_treshold = 0.25;
  mapvals.max_depth = 3.0;
  mapvals.preview_zoom_factor = 1.0;
  
/*  mapvals.bumptype=0; */
  mapvals.bumpmaptype=0;
  mapvals.bumpmin=0.0;
  mapvals.bumpmax=0.1;

  mapvals.antialiasing = FALSE;
  mapvals.create_new_image = FALSE;
  mapvals.transparent_background = FALSE;
  mapvals.tooltips_enabled = FALSE;
  mapvals.bump_mapped=FALSE;
  mapvals.env_mapped=FALSE;
  mapvals.ref_mapped=FALSE;
  mapvals.previewquality=FALSE;
  
  mapvals.bumpmap_id=-1;
  mapvals.envmap_id=-1;
}

MAIN();

static void query(void)
{
  static GParamDef args[] =
    {
      { PARAM_INT32, "run_mode", "Interactive" },
      { PARAM_IMAGE, "image", "Input image" },
      { PARAM_DRAWABLE, "drawable", "Input drawable" },
    };

  static GParamDef *return_vals = NULL;
  static gint nargs = sizeof (args) / sizeof (args[0]);
  static gint nreturn_vals = 0;

  gimp_install_procedure ("plug_in_lighting",
			  "Apply various lighting effects to an image",
			  "No help yet",
			  "Tom Bech & Federico Mena Quintero",
			  "Tom Bech & Federico Mena Quintero",
			  "1996-97",
			  "<Image>/Filters/Light Effects/Lighting Effects",
			  "RGB*",
			  PROC_PLUG_IN,
			  nargs, nreturn_vals,
			  args, return_vals);
}

static void run(gchar   *name,
                gint     nparams,
                GParam  *param,
                gint    *nreturn_vals,
                GParam **return_vals)
{
  static GParam values[1];
  GDrawable *drawable;
  GRunModeType run_mode;
  GStatusType status = STATUS_SUCCESS;

  run_mode = param[0].data.d_int32;

  *nreturn_vals = 1;
  *return_vals = values;

  values[0].type = PARAM_STATUS;
  values[0].data.d_status = status;

  /* Set default values */
  /* ================== */

  set_default_settings();

  /* Possibly retrieve data */
  /* ====================== */

  gimp_get_data ("plug_in_lighting", &mapvals);

  /* Get the specified drawable */
  /* ========================== */
  
  drawable = gimp_drawable_get (param[2].data.d_drawable);

  mapvals.drawable_id=drawable->id;

  if (status == STATUS_SUCCESS)
    {
      /* Make sure that the drawable is RGBA or RGB color */
      /* ================================================ */

      if (gimp_drawable_color(drawable->id))
	{
	  /* Set the tile cache size */
          /* ======================= */

	  gimp_tile_cache_ntiles(TILE_CACHE_SIZE);
          
          switch (run_mode)
            {
              case RUN_INTERACTIVE:
                lighting_interactive(drawable);
                gimp_set_data("plug_in_lighting", &mapvals, sizeof(LightingValues));
              break;
              case RUN_WITH_LAST_VALS:
                image_setup(drawable,FALSE);
                compute_image();
                break;
              default:
                break;
            }
        }
      else
        status = STATUS_EXECUTION_ERROR;
    }

  values[0].data.d_status = status;
  gimp_drawable_detach (drawable);
}

GPlugInInfo PLUG_IN_INFO =
{
  NULL,    /* init_proc */
  NULL,    /* quit_proc */
  query,   /* query_proc */
  run,     /* run_proc */
};

void lighting_interactive(GDrawable *drawable)
{
  gchar **argv;
  gint argc;

  argc = 1;
  argv = g_new (gchar *, 1);
  argv[0] = g_strdup ("lighting");

  gtk_init (&argc, &argv);

  /* Create application window */
  /* ========================= */

  create_main_dialog();
  
  /* Prepare images */
  /* ============== */

  image_setup(drawable,TRUE);
  
  /* Gtk main event loop */
  /* =================== */
  
  gtk_main();
  gdk_flush();
}

void lighting_noninteractive(GDrawable *drawable)
{
  printf("Noninteractive not yet implemented! Sorry.\n");
}

