/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_TYPE_UTILS_H__
#define __GTK_TYPE_UTILS_H__


#include <gdk/gdk.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct _GtkArg       GtkArg;
typedef struct _GtkObject    GtkObject;   /* forward declaration of object type */
typedef struct _GtkTypeInfo  GtkTypeInfo;

typedef void (*GtkClassInitFunc)  (gpointer klass);
typedef void (*GtkObjectInitFunc) (gpointer object);
typedef void (*GtkArgFunc) (GtkObject *object, GtkArg *arg);
typedef gint (*GtkFunction) (gpointer data);


struct _GtkArg
{
  GtkArgType type;
  char *name;

  union {
    gchar c;
    gshort s;
    gint i;
    glong l;
    gpointer p;
    GtkObject *o;
    GtkFunction f;
    struct {
      GtkFunction f;
      gpointer d;
    } signal;
  } d;
};

struct _GtkTypeInfo
{
  gchar *type_name;
  guint object_size;
  guint class_size;
  GtkClassInitFunc class_init_func;
  GtkObjectInitFunc object_init_func;
  GtkArgFunc arg_func;
};


guint    gtk_type_unique            (guint        parent_type,
				     GtkTypeInfo *type_info);
gchar*   gtk_type_name              (guint        type);
guint    gtk_type_from_name         (gchar       *name);
guint    gtk_type_parent            (guint        type);
gpointer gtk_type_class             (guint        type);
gpointer gtk_type_new               (guint        type);
void     gtk_type_describe_heritage (guint        type);
void     gtk_type_describe_tree     (guint        type,
				     gint         show_size);
gint     gtk_type_is_a              (guint        type,
				     guint        is_a_type);
void     gtk_type_set_arg           (GtkObject   *object,
				     guint        type,
				     GtkArg      *arg);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_TYPE_UTILS_H__ */
