#!/bin/sh
exec gp.scm $0 $*
!#

(define-proc
  "gimple-console"
  "Blurb"
  "Description"
  "Help"
  "Author"
  "Copyright"
  "Date"
  "<Toolbox>/Gimple/console"
  #f
  'extension
  '()
  '()
  (lambda ()
    (define win (gtk-window-new 'toplevel))
    (gtk-window-set-title win "Gimple Console")
    (define box (gtk-vbox-new #f 0))
    (gtk-container-add win box)
    (define text (gtk-text-new #f #f))
    (gtk-box-pack-start box text)
    (define entry (gtk-entry-new))
    (gtk-box-pack-start box entry #f)
    (gtk-widget-show-all win)
    (gtk-signal-connect entry "activate"
                        (lambda ()
                          (let* ((intxt (gtk-entry-get-text entry))
                                 (exp (call-with-input-string intxt read))
                                 (ev (eval exp))
                                 (outxt (with-output-to-string (lambda ()
                                                                 (write ev)
                                                                 (newline)))))
                            (gtk-entry-set-text entry "")
                            (gtk-text-insert text #f #f #f outxt
                                             (string-length outxt)))))
    (gtk-main)))
