/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1999 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "procedural_db.h"

#include "channel_ops.h"
#include "drawable.h"
#include "gimage.h"

static ProcRecord channel_ops_offset_proc;
static ProcRecord channel_ops_duplicate_proc;

void
register_channel_ops_procs (void)
{
  procedural_db_register (&channel_ops_offset_proc);
  procedural_db_register (&channel_ops_duplicate_proc);
}

static Argument *
channel_ops_offset_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gboolean wrap_around;
  gint32 fill_type;
  gint32 offset_x;
  gint32 offset_y;
  GimpImage *gimage;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  wrap_around = args[1].value.pdb_int ? TRUE : FALSE;

  fill_type = args[2].value.pdb_int;
  if (fill_type < OFFSET_BACKGROUND || fill_type > OFFSET_TRANSPARENT)
    success = FALSE;

  offset_x = args[3].value.pdb_int;

  offset_y = args[4].value.pdb_int;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
      offset (gimage, drawable, wrap_around, fill_type, offset_x, offset_y);
    }

  return procedural_db_return_args (&channel_ops_offset_proc, success);
}

static ProcArg channel_ops_offset_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The drawable to offset"
  },
  {
    PDB_INT32,
    "wrap_around",
    "wrap image around or fill vacated regions"
  },
  {
    PDB_INT32,
    "fill_type",
    "fill vacated regions of drawable with background or transparent: OFFSET_BACKGROUND (0) or OFFSET_TRANSPARENT (1)"
  },
  {
    PDB_INT32,
    "offset_x",
    "offset by this amount in X direction"
  },
  {
    PDB_INT32,
    "offset_y",
    "offset by this amount in Y direction"
  }
};

static ProcRecord channel_ops_offset_proc =
{
  "gimp_channel_ops_offset",
  "Offset the drawable by the specified amounts in the X and Y directions",
  "This procedure offsets the specified drawable by the amounts specified by 'offset_x' and 'offset_y'. If 'wrap_around' is set to TRUE, then portions of the drawable which are offset out of bounds are wrapped around. Alternatively, the undefined regions of the drawable can be filled with transparency or the background color, as specified by the 'fill_type' parameter.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1997",
  PDB_INTERNAL,
  5,
  channel_ops_offset_inargs,
  0,
  NULL,
  { { channel_ops_offset_invoker } }
};

static Argument *
channel_ops_duplicate_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpImage *new_gimage = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    success = (new_gimage = duplicate (gimage)) != NULL;

  return_args = procedural_db_return_args (&channel_ops_duplicate_proc, success);

  if (success)
    return_args[1].value.pdb_int = pdb_image_to_id (new_gimage);

  return return_args;
}

static ProcArg channel_ops_duplicate_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg channel_ops_duplicate_outargs[] =
{
  {
    PDB_IMAGE,
    "new_image",
    "The new, duplicated image"
  }
};

static ProcRecord channel_ops_duplicate_proc =
{
  "gimp_channel_ops_duplicate",
  "Duplicate the specified image",
  "This procedure duplicates the specified image, copying all layers, channels, and image information.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1997",
  PDB_INTERNAL,
  1,
  channel_ops_duplicate_inargs,
  1,
  channel_ops_duplicate_outargs,
  { { channel_ops_duplicate_invoker } }
};
