/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpgradientselect_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

void
gimp_gradients_popup (gchar *gradients_callback,
		      gchar *popup_title,
		      gchar *initial_gradient,
		      gint   sample_size)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_gradients_popup",
				    &nreturn_vals,
				    PARAM_STRING, gradients_callback,
				    PARAM_STRING, popup_title,
				    PARAM_STRING, initial_gradient,
				    PARAM_INT32, sample_size,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_gradients_close_popup (gchar *gradients_callback)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_gradients_close_popup",
				    &nreturn_vals,
				    PARAM_STRING, gradients_callback,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_gradients_set_popup (gchar *gradients_callback,
			  gchar *gradient_name)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_gradients_set_popup",
				    &nreturn_vals,
				    PARAM_STRING, gradients_callback,
				    PARAM_STRING, gradient_name,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gchar *
_gimp_gradients_get_gradient_data (gchar    *name,
				   gint      sample_size,
				   gint     *width,
				   gdouble **grad_data)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *ret_name = NULL;

  return_vals = gimp_run_procedure ("gimp_gradients_get_gradient_data",
				    &nreturn_vals,
				    PARAM_STRING, name,
				    PARAM_INT32, sample_size,
				    PARAM_END);

  *width = 0;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      ret_name = g_strdup (return_vals[1].data.d_string);
      *width = return_vals[2].data.d_int32;
      *grad_data = g_new (gdouble, *width);
      memcpy (*grad_data, return_vals[3].data.d_floatarray,
	      *width * sizeof (gdouble));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_name;
}
