/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1999 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "procedural_db.h"

#include "gimage.h"
#include "pathsP.h"

static ProcRecord path_list_proc;
static ProcRecord path_get_points_proc;
static ProcRecord path_get_current_proc;
static ProcRecord path_set_current_proc;
static ProcRecord path_set_points_proc;
static ProcRecord path_stroke_current_proc;

void
register_paths_procs (void)
{
  procedural_db_register (&path_list_proc);
  procedural_db_register (&path_get_points_proc);
  procedural_db_register (&path_get_current_proc);
  procedural_db_register (&path_set_current_proc);
  procedural_db_register (&path_set_points_proc);
  procedural_db_register (&path_stroke_current_proc);
}

static Argument *
path_list_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 num_paths = 0;
  gchar **paths_list = NULL;
  PathsList *plist;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      plist = gimage->paths;
    
      if (plist && plist->bz_paths)
	{
	  gint    count = 0;
	  GSList *pl    = plist->bz_paths;
    
	  num_paths = g_slist_length (pl);
    
	  paths_list = g_new (gchar *, num_paths);
	  while (pl)
	    {
	      PATHP pptr = pl->data;
	      paths_list[count++] = g_strdup (pptr->name->str);
	      pl = pl->next;
	    }
	}
    }

  return_args = procedural_db_return_args (&path_list_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_paths;
      return_args[2].value.pdb_pointer = paths_list;
    }

  return return_args;
}

static ProcArg path_list_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to list the paths from"
  }
};

static ProcArg path_list_outargs[] =
{
  {
    PDB_INT32,
    "num_paths",
    "The number of paths returned"
  },
  {
    PDB_STRINGARRAY,
    "paths_list",
    "List of the paths belonging to this image"
  }
};

static ProcRecord path_list_proc =
{
  "gimp_path_list",
  "List the paths associated with the passed image.",
  "List the paths associated with the passed image.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  1,
  path_list_inargs,
  2,
  path_list_outargs,
  { { path_list_invoker } }
};

static Argument *
path_get_points_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gchar *pname;
  gint32 num_pdetails = 0;
  gdouble *pnts = NULL;
  PathsList *plist;
  PATHP pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      pname = (gchar *) args[1].value.pdb_pointer;
      success = pname != NULL;
    }

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
	  
      if (plist && plist->bz_paths)
	{
	  GSList *pl = plist->bz_paths;
    
	  while (pl)
	    {
	      pptr = pl->data;
    
	      if (strcmp (pname, pptr->name->str) == 0)
	        break; /* Found the path */
    
	      pl = pl->next;
	      pptr = NULL;
	    }
    
	  if (pl && pptr)
	    {
	      GSList  *points_list;
	      gint     pcount = 0;
    
	      points_list = pptr->path_details;
	      if (points_list)
	        {
	          num_pdetails = g_slist_length (points_list) * 3;
    
	          pnts = g_new (gdouble, num_pdetails);
    
	          /* fill points and types in */
	          while (points_list)
	            {
	              PATHPOINTP ppoint = points_list->data;
	              pnts[pcount] = ppoint->x;
	              pnts[pcount + 1] = ppoint->y;
	              pnts[pcount + 2] = (gfloat) ppoint->type; /* Bit of fiddle but should be understandable why it was done */
	              pcount += 3;
	              points_list = points_list->next;
	            }
	        }        
	      else
	        success = FALSE;
	    }
	  else
	    success = FALSE;
	}
    }

  return_args = procedural_db_return_args (&path_get_points_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = pptr->pathtype;
      return_args[2].value.pdb_int = pptr->closed;
      return_args[3].value.pdb_int = num_pdetails;
      return_args[4].value.pdb_pointer = pnts;
    }

  return return_args;
}

static ProcArg path_get_points_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to list the paths from"
  },
  {
    PDB_STRING,
    "pathname",
    "the name of the path whose points should be listed"
  }
};

static ProcArg path_get_points_outargs[] =
{
  {
    PDB_INT32,
    "paths_type",
    "The type of the path. Currently only one type (1 = Bezier) is supported"
  },
  {
    PDB_INT32,
    "path_closed",
    "Return if the path is closed. {0=path open, 1= path closed}"
  },
  {
    PDB_INT32,
    "num_path_point_details",
    "The number of points returned. Each point is made up of (x,y,pnt_type) of floats"
  },
  {
    PDB_FLOATARRAY,
    "points_pairs",
    "The points in the path represented as 3 floats. The first is the x pos, next is the y pos, last is the type of the pnt. The type field is dependant on the path type. For beziers (type 1 paths) the type can either be {1.0= BEZIER_ANCHOR, 2.0= BEZIER_CONTROL}. Note all points are returned in pixel resolution"
  }
};

static ProcRecord path_get_points_proc =
{
  "gimp_path_get_points",
  "List the points associated with the named path.",
  "List the points associated with the named path.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  path_get_points_inargs,
  4,
  path_get_points_outargs,
  { { path_get_points_invoker } }
};

static Argument *
path_get_current_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  PathsList *plist;
  PATHP pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
    
      if (plist && plist->bz_paths && plist->last_selected_row >= 0)
	pptr = (PATHP) g_slist_nth_data (plist->bz_paths, plist->last_selected_row);
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&path_get_current_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (pptr->name->str);

  return return_args;
}

static ProcArg path_get_current_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to get the current paths from"
  }
};

static ProcArg path_get_current_outargs[] =
{
  {
    PDB_STRING,
    "current_path_name",
    "The name of the current path"
  }
};

static ProcRecord path_get_current_proc =
{
  "gimp_path_get_current",
  "The name of the current path. Error if no paths.",
  "The name of the current path. Error if no paths.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  1,
  path_get_current_inargs,
  1,
  path_get_current_outargs,
  { { path_get_current_invoker } }
};

static Argument *
path_set_current_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gchar *pname;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      pname = (gchar *) args[1].value.pdb_pointer;
      success = pname != NULL;
    }

  if (success)
    success = paths_set_path (gimage, pname);

  return procedural_db_return_args (&path_set_current_proc, success);
}

static ProcArg path_set_current_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to list set the paths in"
  },
  {
    PDB_STRING,
    "set_current_path_name",
    "The name of the path to set the current path to"
  }
};

static ProcRecord path_set_current_proc =
{
  "gimp_path_set_current",
  "List the paths associated with the passed image.",
  "List the paths associated with the passed image.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  path_set_current_inargs,
  0,
  NULL,
  { { path_set_current_invoker } }
};

static Argument *
path_set_points_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gchar *pname = NULL;
  gint32 ptype;
  gint32 numpoints = 0;
  gdouble *pnts;
  gboolean pclosed = FALSE;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      pname = (gchar *) args[1].value.pdb_pointer;
      success = pname != NULL;
    }

  ptype = args[2].value.pdb_int;

  if (success)
    {
      numpoints = args[3].value.pdb_int;
      success = numpoints > 0;
    }

  pnts = (gdouble *) args[4].value.pdb_pointer;

  if (success)
    {
      if ((numpoints / 2) % 3 == 0)
	pclosed = TRUE;
      else if ((numpoints / 2) % 3 != 2)
	success = FALSE;
    
      if (success && !paths_set_path_points (gimage, pname, ptype, pclosed,
	                                     numpoints, pnts))
	success = FALSE;
    }

  return procedural_db_return_args (&path_set_points_proc, success);
}

static ProcArg path_set_points_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to set the paths in"
  },
  {
    PDB_STRING,
    "pathname",
    "The name of the path to create (if it exists then all current points are removed). This will not be set as the current path. You will have to do a gimp_set_current_path after creating the path to make it current."
  },
  {
    PDB_INT32,
    "ptype",
    "The type of the path. Currently only one type (1 = Bezier) is supported"
  },
  {
    PDB_INT32,
    "num_path_points",
    "The number of points in the path. Each point is made up of (x,y) of floats. Currently only the creation of bezier curves is allowed. The type parameter must be set to (1) to indicate a BEZIER type curve. For BEZIERS. Note the that points must be given in the following order... ACCACCAC ... If the path is not closed the last control point is missed off. Points consist of three control points (control/anchor/control) so for a curve that is not closed there must be at least two points passed (2 x,y pairs). If num_path_pnts % 3 = 0 then the path is assumed to be closed and the points are ACCACCACCACC."
  },
  {
    PDB_FLOATARRAY,
    "points_pairs",
    "The points in the path represented as 3 floats. The first is the x pos, next is the y pos, last is the type of the pnt. The type field is dependant on the path type. For beziers (type 1 paths) the type can either be {1.0= BEZIER_ANCHOR, 2.0= BEZIER_CONTROL}. Note all points are returned in pixel resolution"
  }
};

static ProcRecord path_set_points_proc =
{
  "gimp_path_set_points",
  "Set the points associated with the named path.",
  "Set the points associated with the named path.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  5,
  path_set_points_inargs,
  0,
  NULL,
  { { path_set_points_invoker } }
};

static Argument *
path_stroke_current_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  PathsList *plist;
  PATHP pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
    
      if (plist && plist->bz_paths && plist->last_selected_row >= 0)
	{
	  if ((pptr = (PATHP) g_slist_nth_data (plist->bz_paths,
	                                        plist->last_selected_row)))
	          
	    paths_stroke (gimage, plist, pptr); /* Found the path to stroke.. */
	  else
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&path_stroke_current_proc, success);
}

static ProcArg path_stroke_current_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image which contains the path to stroke"
  }
};

static ProcRecord path_stroke_current_proc =
{
  "gimp_path_stroke_current",
  "Stroke the current path in the passed image.",
  "Stroke the current path in the passed image.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  1,
  path_stroke_current_inargs,
  0,
  NULL,
  { { path_stroke_current_invoker } }
};
