#include <ex/ostream.p.h>

GtkType _ex_ostream_type;
static void ex_ostream_class_init (ExOstreamClass* klass);
static void ex_ostream_init (ExOstream* ostream);
static guint _ex_ostream_signal_putstring;
static guint _ex_ostream_signal_flush;
static guint _ex_ostream_signal_close;
static void _ex_ostream_demarshall_0P (GtkObject*, GtkSignalFunc, gpointer, GtkArg*);
typedef void (*_ExOstreamHandler_0P)(GtkObject*, gpointer, gpointer);
static void _ex_ostream_demarshall_0 (GtkObject*, GtkSignalFunc, gpointer, GtkArg*);
typedef void (*_ExOstreamHandler_0)(GtkObject*, gpointer);
static void _ex_ostream_demarshall_0P (
	GtkObject* object,
	GtkSignalFunc func,
	gpointer user_data,
	GtkArg* args){
	(void)args;
	((_ExOstreamHandler_0P)func)(object,
		GTK_VALUE_POINTER(args[0]),
	user_data);
}
static void _ex_ostream_demarshall_0 (
	GtkObject* object,
	GtkSignalFunc func,
	gpointer user_data,
	GtkArg* args){
	(void)args;
	((_ExOstreamHandler_0)func)(object,
	user_data);
}
#ifdef GCG_IMPL
#	include GCG_IMPL
#else
#	include "ostream.i.c"
#endif

void _ex_ostream_init_type (void){
	static GtkTypeInfo info = {
		"ExOstream",
		sizeof (ExOstream),
		sizeof (ExOstreamClass),
		(GtkClassInitFunc) ex_ostream_class_init,
		(GtkObjectInitFunc) ex_ostream_init,
		NULL,
		NULL,
		NULL,
	};
	if (!_ex_ostream_type)
		_ex_ostream_type = gtk_type_unique (GTK_TYPE_OBJECT, &info);
}

static void ex_ostream_class_init (ExOstreamClass* klass){
	GtkObjectClass* obklass = (GtkObjectClass*) klass;
	(void) obklass;
	_ex_ostream_signal_putstring =
	gtk_signal_new("putstring",
		GTK_RUN_FIRST,
		obklass->type,
		GTK_SIGNAL_OFFSET (ExOstreamClass, putstring),
		_ex_ostream_demarshall_0P,
		GTK_TYPE_NONE,
		1,
		GTK_TYPE_POINTER);
	gtk_object_class_add_signals(obklass,
		&_ex_ostream_signal_putstring,
		1);
	_ex_ostream_signal_flush =
	gtk_signal_new("flush",
		GTK_RUN_FIRST,
		obklass->type,
		GTK_SIGNAL_OFFSET (ExOstreamClass, flush),
		_ex_ostream_demarshall_0,
		GTK_TYPE_NONE,
		0);
	gtk_object_class_add_signals(obklass,
		&_ex_ostream_signal_flush,
		1);
	_ex_ostream_signal_close =
	gtk_signal_new("close",
		GTK_RUN_FIRST,
		obklass->type,
		GTK_SIGNAL_OFFSET (ExOstreamClass, close),
		_ex_ostream_demarshall_0,
		GTK_TYPE_NONE,
		0);
	gtk_object_class_add_signals(obklass,
		&_ex_ostream_signal_close,
		1);
#ifdef OSTREAM_CLASS_INIT
	OSTREAM_CLASS_INIT (klass);
#endif
}

static void ex_ostream_init (ExOstream* ostream){
	(void) ostream;
#ifdef OSTREAM_INIT
	OSTREAM_INIT (ostream);
#endif
}

void ex_ostream_putchar (
	ExOstream* ostream,
	gchar c){
	g_assert (ostream);
	g_assert (EX_IS_OSTREAM(ostream));
	((ExOstreamClass*)((GtkObject*) ostream)->klass)->putchar (ostream, c);
}

void ex_ostream_connect_putstring (
	ExOstreamHandler_putstring handler,
	gpointer user_data,
	ExOstream* ostream){
	g_assert (ostream);
	g_assert (EX_IS_OSTREAM(ostream));
	gtk_signal_connect((GtkObject*)ostream,
		"putstring",
		(GtkSignalFunc)handler,
		user_data);
}

void ex_ostream_putstring (
	ExOstream* ostream,
	gchar* str){
	g_assert (ostream);
	g_assert (EX_IS_OSTREAM(ostream));
	{
	GtkArg args[1];
	GTK_VALUE_POINTER(args[0]) = str;
	gtk_signal_emitv((GtkObject*)ostream, _ex_ostream_signal_putstring, args);
	}
}

void ex_ostream_connect_flush (
	ExOstreamHandler_flush handler,
	gpointer user_data,
	ExOstream* ostream){
	g_assert (ostream);
	g_assert (EX_IS_OSTREAM(ostream));
	gtk_signal_connect((GtkObject*)ostream,
		"flush",
		(GtkSignalFunc)handler,
		user_data);
}

void ex_ostream_flush (
	ExOstream* ostream){
	g_assert (ostream);
	g_assert (EX_IS_OSTREAM(ostream));
	{
	gtk_signal_emitv((GtkObject*)ostream, _ex_ostream_signal_flush, NULL);
	}
}

void ex_ostream_connect_close (
	ExOstreamHandler_close handler,
	gpointer user_data,
	ExOstream* ostream){
	g_assert (ostream);
	g_assert (EX_IS_OSTREAM(ostream));
	gtk_signal_connect((GtkObject*)ostream,
		"close",
		(GtkSignalFunc)handler,
		user_data);
}

void ex_ostream_close (
	ExOstream* ostream){
	g_assert (ostream);
	g_assert (EX_IS_OSTREAM(ostream));
	{
	gtk_signal_emitv((GtkObject*)ostream, _ex_ostream_signal_close, NULL);
	}
}

