/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1999 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "procedural_db.h"

#include "airbrush.h"
#include "blend.h"
#include "bucket_fill.h"
#include "by_color_select.h"
#include "channel.h"
#include "clone.h"
#include "color_picker.h"
#include "convolve.h"
#include "crop.h"
#include "dodgeburn.h"
#include "drawable.h"
#include "ellipse_select.h"
#include "eraser.h"
#include "flip_tool.h"
#include "free_select.h"
#include "fuzzy_select.h"
#include "gimpimage.h"
#include "paint_core.h"
#include "paint_funcs.h"
#include "paintbrush.h"
#include "pencil.h"
#include "perspective_tool.h"
#include "rect_select.h"
#include "rotate_tool.h"
#include "scale_tool.h"
#include "shear_tool.h"
#include "smudge.h"
#include "tile_manager_pvt.h"
#include "transform_core.h"
#include "undo.h"

static ProcRecord airbrush_proc;
static ProcRecord airbrush_default_proc;
static ProcRecord blend_proc;
static ProcRecord bucket_fill_proc;
static ProcRecord by_color_select_proc;
static ProcRecord clone_proc;
static ProcRecord clone_default_proc;
static ProcRecord color_picker_proc;
static ProcRecord convolve_proc;
static ProcRecord convolve_default_proc;
static ProcRecord crop_proc;
static ProcRecord dodgeburn_proc;
static ProcRecord dodgeburn_default_proc;
static ProcRecord ellipse_select_proc;
static ProcRecord eraser_proc;
static ProcRecord eraser_default_proc;
static ProcRecord flip_proc;
static ProcRecord free_select_proc;
static ProcRecord fuzzy_select_proc;
static ProcRecord paintbrush_proc;
static ProcRecord paintbrush_default_proc;
static ProcRecord pencil_proc;
static ProcRecord perspective_proc;
static ProcRecord rect_select_proc;
static ProcRecord rotate_proc;
static ProcRecord scale_proc;
static ProcRecord shear_proc;
static ProcRecord smudge_proc;
static ProcRecord smudge_default_proc;

void
register_tools_procs (void)
{
  procedural_db_register (&airbrush_proc);
  procedural_db_register (&airbrush_default_proc);
  procedural_db_register (&blend_proc);
  procedural_db_register (&bucket_fill_proc);
  procedural_db_register (&by_color_select_proc);
  procedural_db_register (&clone_proc);
  procedural_db_register (&clone_default_proc);
  procedural_db_register (&color_picker_proc);
  procedural_db_register (&convolve_proc);
  procedural_db_register (&convolve_default_proc);
  procedural_db_register (&crop_proc);
  procedural_db_register (&dodgeburn_proc);
  procedural_db_register (&dodgeburn_default_proc);
  procedural_db_register (&ellipse_select_proc);
  procedural_db_register (&eraser_proc);
  procedural_db_register (&eraser_default_proc);
  procedural_db_register (&flip_proc);
  procedural_db_register (&free_select_proc);
  procedural_db_register (&fuzzy_select_proc);
  procedural_db_register (&paintbrush_proc);
  procedural_db_register (&paintbrush_default_proc);
  procedural_db_register (&pencil_proc);
  procedural_db_register (&perspective_proc);
  procedural_db_register (&rect_select_proc);
  procedural_db_register (&rotate_proc);
  procedural_db_register (&scale_proc);
  procedural_db_register (&shear_proc);
  procedural_db_register (&smudge_proc);
  procedural_db_register (&smudge_default_proc);
}

static Argument *
airbrush_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  pressure = args[1].value.pdb_float;
  if (pressure < 0.0 || pressure > 100.0)
    success = FALSE;

  num_strokes = args[2].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[3].value.pdb_pointer;

  if (success)
    success = airbrush_non_gui (drawable, pressure, num_strokes, strokes);

  return procedural_db_return_args (&airbrush_proc, success);
}

static ProcArg airbrush_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_FLOAT,
    "pressure",
    "The pressure of the airbrush strokes (0 <= pressure <= 100)"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord airbrush_proc =
{
  "gimp_airbrush",
  "Paint in the current brush with varying pressure. Paint application is time-dependent.",
  "This tool simulates the use of an airbrush. Paint pressure represents the relative intensity of the paint application. High pressure results in a thicker layer of paint while low pressure results in a thinner layer.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  4,
  airbrush_inargs,
  0,
  NULL,
  { { airbrush_invoker } }
};

static Argument *
airbrush_default_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = airbrush_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&airbrush_default_proc, success);
}

static ProcArg airbrush_default_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord airbrush_default_proc =
{
  "gimp_airbrush_default",
  "Paint in the current brush with varying pressure. Paint application is time-dependent.",
  "This tool simulates the use of an airbrush. It is similar to gimp_airbrush except that the pressure is derived from the airbrush tools options box. It the option has not been set the default for the option will be used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  3,
  airbrush_default_inargs,
  0,
  NULL,
  { { airbrush_default_invoker } }
};

static Argument *
blend_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 blend_mode;
  gint32 paint_mode;
  gint32 gradient_type;
  gdouble opacity;
  gdouble offset;
  gint32 repeat;
  gboolean supersample;
  gint32 max_depth;
  gdouble threshold;
  gdouble x1;
  gdouble y1;
  gdouble x2;
  gdouble y2;
  GimpImage *gimage;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  blend_mode = args[1].value.pdb_int;
  if (blend_mode < FG_BG_RGB_MODE || blend_mode > CUSTOM_MODE)
    success = FALSE;

  paint_mode = args[2].value.pdb_int;
  if (paint_mode < NORMAL_MODE || paint_mode > DIVIDE_MODE)
    success = FALSE;

  gradient_type = args[3].value.pdb_int;
  if (gradient_type < LINEAR || gradient_type > SPIRAL_ANTICLOCKWISE)
    success = FALSE;

  opacity = args[4].value.pdb_float;
  if (opacity < 0.0 || opacity > 100.0)
    success = FALSE;

  offset = args[5].value.pdb_float;
  if (offset < 0.0)
    success = FALSE;

  repeat = args[6].value.pdb_int;
  if (repeat < REPEAT_NONE || repeat > REPEAT_TRIANGULAR)
    success = FALSE;

  supersample = args[7].value.pdb_int ? TRUE : FALSE;

  max_depth = args[8].value.pdb_int;
  if (supersample && (max_depth < 1 || max_depth > 9))
    success = FALSE;

  threshold = args[9].value.pdb_float;
  if (supersample && (threshold < 0.0 || threshold > 4.0))
    success = FALSE;

  x1 = args[10].value.pdb_float;

  y1 = args[11].value.pdb_float;

  x2 = args[12].value.pdb_float;

  y2 = args[13].value.pdb_float;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
      blend (gimage, drawable, blend_mode, paint_mode, gradient_type, opacity,
	     offset, repeat, supersample, max_depth, threshold, x1, y1, x2, y2,
	     NULL, NULL);
    }

  return procedural_db_return_args (&blend_proc, success);
}

static ProcArg blend_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "blend_mode",
    "The type of blend: { FG_BG_RGB (0), FG_BG_HSV (1), FG_TRANS (2), CUSTOM (3) }"
  },
  {
    PDB_INT32,
    "paint_mode",
    "The paint application mode: { NORMAL_MODE (0), DISSOLVE_MODE (1), BEHIND_MODE (2), MULTIPLY_MODE (3), SCREEN_MODE (4), OVERLAY_MODE (5), DIFFERENCE_MODE (6), ADDITION_MODE (7), SUBTRACT_MODE (8), DARKEN_ONLY_MODE (9), LIGHTEN_ONLY_MODE (10), HUE_MODE (11), SATURATION_MODE (12), COLOR_MODE (13), VALUE_MODE (14), DIVIDE_MODE (15) }"
  },
  {
    PDB_INT32,
    "gradient_type",
    "The type of gradient: { LINEAR (0), BILINEAR (1), RADIAL (2), SQUARE (3), CONICAL_SYMMETRIC (4), CONICAL_ASYMMETRIC (5), SHAPEBURST_ANGULAR (6), SHAPEBURST_SPHERICAL (7), SHAPEBURST_DIMPLED (8), SPIRAL_CLOCKWISE (9), SPIRAL_ANTICLOCKWISE (10) }"
  },
  {
    PDB_FLOAT,
    "opacity",
    "The opacity of the final blend (0 <= opacity <= 100)"
  },
  {
    PDB_FLOAT,
    "offset",
    "Offset relates to the starting and ending coordinates specified for the blend. This parameter is mode dependent (0 <= offset)"
  },
  {
    PDB_INT32,
    "repeat",
    "Repeat mode: { REPEAT_NONE (0), REPEAT_SAWTOOTH (1), REPEAT_TRIANGULAR (2) }"
  },
  {
    PDB_INT32,
    "supersample",
    "Do adaptive supersampling (TRUE or FALSE)"
  },
  {
    PDB_INT32,
    "max_depth",
    "Maximum recursion levels for supersampling"
  },
  {
    PDB_FLOAT,
    "threshold",
    "Supersampling threshold"
  },
  {
    PDB_FLOAT,
    "x1",
    "The x coordinate of this blend's starting point"
  },
  {
    PDB_FLOAT,
    "y1",
    "The y coordinate of this blend's starting point"
  },
  {
    PDB_FLOAT,
    "x2",
    "The x coordinate of this blend's ending point"
  },
  {
    PDB_FLOAT,
    "y2",
    "The y coordinate of this blend's ending point"
  }
};

static ProcRecord blend_proc =
{
  "gimp_blend",
  "Blend between the starting and ending coordinates with the specified blend mode and gradient type.",
  "This tool requires information on the paint application mode, the blend mode, and the gradient type. It creates the specified variety of blend using the starting and ending coordinates as defined for each gradient type.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  14,
  blend_inargs,
  0,
  NULL,
  { { blend_invoker } }
};

static Argument *
bucket_fill_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 fill_mode;
  gint32 paint_mode;
  gdouble opacity;
  gdouble threshold;
  gboolean sample_merged;
  gdouble x;
  gdouble y;
  GimpImage *gimage;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  fill_mode = args[1].value.pdb_int;
  if (fill_mode < FG_BUCKET_FILL || fill_mode > PATTERN_BUCKET_FILL)
    success = FALSE;

  paint_mode = args[2].value.pdb_int;
  if (paint_mode < NORMAL_MODE || paint_mode > DIVIDE_MODE)
    success = FALSE;

  opacity = args[3].value.pdb_float;
  if (opacity < 0.0 || opacity > 100.0)
    success = FALSE;

  threshold = args[4].value.pdb_float;
  if (threshold < 0.0 || threshold > 255.0)
    success = FALSE;

  sample_merged = args[5].value.pdb_int ? TRUE : FALSE;

  x = args[6].value.pdb_float;

  y = args[7].value.pdb_float;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
      bucket_fill (gimage, drawable, fill_mode, paint_mode, opacity,
		   threshold, sample_merged, x, y);
    }

  return procedural_db_return_args (&bucket_fill_proc, success);
}

static ProcArg bucket_fill_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "fill_mode",
    "The type of fill: { FG_BUCKET_FILL (0), BG_BUCKET_FILL (1), PATTERN_BUCKET_FILL (2) }"
  },
  {
    PDB_INT32,
    "paint_mode",
    "The paint application mode: { NORMAL_MODE (0), DISSOLVE_MODE (1), BEHIND_MODE (2), MULTIPLY_MODE (3), SCREEN_MODE (4), OVERLAY_MODE (5), DIFFERENCE_MODE (6), ADDITION_MODE (7), SUBTRACT_MODE (8), DARKEN_ONLY_MODE (9), LIGHTEN_ONLY_MODE (10), HUE_MODE (11), SATURATION_MODE (12), COLOR_MODE (13), VALUE_MODE (14), DIVIDE_MODE (15) }"
  },
  {
    PDB_FLOAT,
    "opacity",
    "The opacity of the final bucket fill (0 <= opacity <= 100)"
  },
  {
    PDB_FLOAT,
    "threshold",
    "The threshold determines how extensive the seed fill will be. It's value is specified in terms of intensity levels (0 <= threshold <= 255). This parameter is only valid when there is no selection in the specified image."
  },
  {
    PDB_INT32,
    "sample_merged",
    "Use the composite image, not the drawable"
  },
  {
    PDB_FLOAT,
    "x",
    "The x coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image."
  },
  {
    PDB_FLOAT,
    "y",
    "The y coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image."
  }
};

static ProcRecord bucket_fill_proc =
{
  "gimp_bucket_fill",
  "Fill the area specified either by the current selection if there is one, or by a seed fill starting at the specified coordinates.",
  "This tool requires information on the paint application mode, and the fill mode, which can either be in the foreground color, or in the currently active pattern. If there is no selection, a seed fill is executed at the specified coordinates and extends outward in keeping with the threshold parameter. If there is a selection in the target image, the threshold, sample merged, x, and y arguments are unused. If the sample_merged parameter is non-zero, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of merged sampling, the x,y coordinates are relative to the image's origin; otherwise, they are relative to the drawable's origin.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  8,
  bucket_fill_inargs,
  0,
  NULL,
  { { bucket_fill_invoker } }
};

static Argument *
by_color_select_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  guchar *color;
  gint32 threshold;
  gint32 operation;
  gboolean antialias;
  gboolean feather;
  gdouble feather_radius;
  gboolean sample_merged;
  GimpImage *gimage;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  color = (guchar *) args[1].value.pdb_pointer;

  threshold = args[2].value.pdb_int;
  if (threshold < 0 || threshold > 255)
    success = FALSE;

  operation = args[3].value.pdb_int;
  if (operation < ADD || operation > INTERSECT)
    success = FALSE;

  antialias = args[4].value.pdb_int ? TRUE : FALSE;

  feather = args[5].value.pdb_int ? TRUE : FALSE;

  feather_radius = args[6].value.pdb_float;

  sample_merged = args[7].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
      by_color_select (gimage, drawable, color, threshold, operation,
		       antialias, feather, feather_radius, sample_merged);
    }

  return procedural_db_return_args (&by_color_select_proc, success);
}

static ProcArg by_color_select_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_COLOR,
    "color",
    "The color to select"
  },
  {
    PDB_INT32,
    "threshold",
    "Threshold in intensity levels 0 <= threshold <= 255"
  },
  {
    PDB_INT32,
    "operation",
    "The selection operation: { ADD (0), SUB (1), REPLACE (2), INTERSECT (3) }"
  },
  {
    PDB_INT32,
    "antialias",
    "Antialiasing (TRUE or FALSE)"
  },
  {
    PDB_INT32,
    "feather",
    "Feather option for selections"
  },
  {
    PDB_FLOAT,
    "feather_radius",
    "Radius for feather operation"
  },
  {
    PDB_INT32,
    "sample_merged",
    "Use the composite image, not the drawable"
  }
};

static ProcRecord by_color_select_proc =
{
  "gimp_by_color_select",
  "Create a selection by selecting all pixels (in the specified drawable) with the same (or similar) color to that specified.",
  "This tool creates a selection over the specified image. A by-color selection is determined by the supplied color under the constraints of the specified threshold. Essentially, all pixels (in the drawable) that have color sufficiently close to the specified color (as determined by the threshold value) are included in the selection. The antialiasing parameter allows the final selection mask to contain intermediate values based on close misses to the threshold bar. Feathering can be enabled optionally and is controlled with the \"feather_radius\" parameter. If the sample_merged parameter is non-zero, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of a merged sampling, the supplied drawable is ignored.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  8,
  by_color_select_inargs,
  0,
  NULL,
  { { by_color_select_invoker } }
};

static Argument *
clone_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  GimpDrawable *src_drawable;
  gint32 clone_type;
  gdouble src_x;
  gdouble src_y;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  src_drawable = gimp_drawable_get_ID (args[1].value.pdb_int);
  if (src_drawable == NULL)
    success = FALSE;

  clone_type = args[2].value.pdb_int;
  if (clone_type < IMAGE_CLONE || clone_type > PATTERN_CLONE)
    success = FALSE;

  src_x = args[3].value.pdb_float;

  src_y = args[4].value.pdb_float;

  num_strokes = args[5].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[6].value.pdb_pointer;

  if (success)
    success = clone_non_gui (drawable, src_drawable, clone_type, src_x, src_y,
			     num_strokes, strokes);

  return procedural_db_return_args (&clone_proc, success);
}

static ProcArg clone_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_DRAWABLE,
    "src_drawable",
    "The source drawable"
  },
  {
    PDB_INT32,
    "clone_type",
    "The type of clone: { IMAGE_CLONE (0), PATTERN_CLONE (1) }"
  },
  {
    PDB_FLOAT,
    "src_x",
    "The x coordinate in the source image"
  },
  {
    PDB_FLOAT,
    "src_y",
    "The y coordinate in the source image"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord clone_proc =
{
  "gimp_clone",
  "Clone from the source to the dest drawable using the current brush",
  "This tool clones (copies) from the source drawable starting at the specified source coordinates to the dest drawable. If the \"clone_type\" argument is set to PATTERN-CLONE, then the current pattern is used as the source and the \"src_drawable\" argument is ignored. Pattern cloning assumes a tileable pattern and mods the sum of the src coordinates and subsequent stroke offsets with the width and height of the pattern. For image cloning, if the sum of the src coordinates and subsequent stroke offsets exceeds the extents of the src drawable, then no paint is transferred. The clone tool is capable of transforming between any image types including RGB->Indexed--although converting from any type to indexed is significantly slower.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  7,
  clone_inargs,
  0,
  NULL,
  { { clone_invoker } }
};

static Argument *
clone_default_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = clone_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&clone_default_proc, success);
}

static ProcArg clone_default_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord clone_default_proc =
{
  "gimp_clone_default",
  "Clone from the source to the dest drawable using the current brush",
  "This tool clones (copies) from the source drawable starting at the specified source coordinates to the dest drawable. This function performs exactly the same as the gimp_clone function except that the tools arguments are obtained from the clones option dialog. It this dialog has not been activated then the dialogs default values will be used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  3,
  clone_default_inargs,
  0,
  NULL,
  { { clone_default_invoker } }
};

static Argument *
color_picker_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpDrawable *drawable;
  gdouble x;
  gdouble y;
  gboolean sample_merged;
  gboolean sample_average;
  gdouble average_radius;
  gboolean save_color;
  guchar *color = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  drawable = gimp_drawable_get_ID (args[1].value.pdb_int);

  x = args[2].value.pdb_float;

  y = args[3].value.pdb_float;

  sample_merged = args[4].value.pdb_int ? TRUE : FALSE;

  sample_average = args[5].value.pdb_int ? TRUE : FALSE;

  average_radius = args[6].value.pdb_float;
  if (sample_average && (average_radius <= 0.0))
    success = FALSE;

  save_color = args[7].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      if (!sample_merged)
	if (!drawable || (drawable_gimage (drawable) != gimage))
	  success = FALSE;
    
      if (success)
	success = pick_color (gimage, drawable, (int) x, (int) y,
			      sample_merged, sample_average, average_radius,
			      save_color);
      if (success)
	{
	  color = g_new (guchar, 3);
	  color[RED_PIX] = col_value[RED_PIX];
	  color[GREEN_PIX] = col_value[GREEN_PIX];
	  color[BLUE_PIX] = col_value[BLUE_PIX];
	}
    }

  return_args = procedural_db_return_args (&color_picker_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = color;

  return return_args;
}

static ProcArg color_picker_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_FLOAT,
    "x",
    "x coordinate of upper-left corner of rectangle"
  },
  {
    PDB_FLOAT,
    "y",
    "y coordinate of upper-left corner of rectangle"
  },
  {
    PDB_INT32,
    "sample_merged",
    "Use the composite image, not the drawable"
  },
  {
    PDB_INT32,
    "sample_average",
    "Average the color of all the pixels in a specified radius"
  },
  {
    PDB_FLOAT,
    "average_radius",
    "The radius of pixels to average"
  },
  {
    PDB_INT32,
    "save_color",
    "Save the color to the active palette"
  }
};

static ProcArg color_picker_outargs[] =
{
  {
    PDB_COLOR,
    "color",
    "The return color"
  }
};

static ProcRecord color_picker_proc =
{
  "gimp_color_picker",
  "Determine the color at the given drawable coordinates",
  "This tool determines the color at the specified coordinates. The returned color is an RGB triplet even for grayscale and indexed drawables. If the coordinates lie outside of the extents of the specified drawable, then an error is returned. If the drawable has an alpha channel, the algorithm examines the alpha value of the drawable at the coordinates. If the alpha value is completely transparent (0), then an error is returned. If the sample_merged parameter is non-zero, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of a merged sampling, the supplied drawable is ignored.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  8,
  color_picker_inargs,
  1,
  color_picker_outargs,
  { { color_picker_invoker } }
};

static Argument *
convolve_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 convolve_type;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  pressure = args[1].value.pdb_float;
  if (pressure < 0.0 || pressure > 100.0)
    success = FALSE;

  convolve_type = args[2].value.pdb_int;
  if (convolve_type < BLUR_CONVOLVE || convolve_type > SHARPEN_CONVOLVE)
    success = FALSE;

  num_strokes = args[3].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[4].value.pdb_pointer;

  if (success)
    success = convolve_non_gui (drawable, pressure, convolve_type, num_strokes, strokes);

  return procedural_db_return_args (&convolve_proc, success);
}

static ProcArg convolve_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_FLOAT,
    "pressure",
    "The pressure: 0 <= pressure <= 100"
  },
  {
    PDB_INT32,
    "convolve_type",
    "Convolve type: { BLUR_CONVOLVE (0), SHARPEN_CONVOLVE (1) }"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord convolve_proc =
{
  "gimp_convolve",
  "Convolve (Blur, Sharpen) using the current brush.",
  "This tool convolves the specified drawable with either a sharpening or blurring kernel. The pressure parameter controls the magnitude of the operation. Like the paintbrush, this tool linearly interpolates between the specified stroke coordinates.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  5,
  convolve_inargs,
  0,
  NULL,
  { { convolve_invoker } }
};

static Argument *
convolve_default_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = convolve_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&convolve_default_proc, success);
}

static ProcArg convolve_default_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord convolve_default_proc =
{
  "gimp_convolve_default",
  "Convolve (Blur, Sharpen) using the current brush.",
  "This tool convolves the specified drawable with either a sharpening or blurring kernel. This function performs exactly the same as the gimp_convolve function except that the tools arguments are obtained from the convolve option dialog. It this dialog has not been activated then the dialogs default values will be used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  3,
  convolve_default_inargs,
  0,
  NULL,
  { { convolve_default_invoker } }
};

static Argument *
crop_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 new_width;
  gint32 new_height;
  gint32 offx;
  gint32 offy;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  new_width = args[1].value.pdb_int;
  if (new_width <= 0)
    success = FALSE;

  new_height = args[2].value.pdb_int;
  if (new_height <= 0)
    success = FALSE;

  offx = args[3].value.pdb_int;
  if (offx < 0)
    success = FALSE;

  offy = args[4].value.pdb_int;
  if (offy < 0)
    success = FALSE;

  if (success)
    {
      if (new_width > gimage->width || new_height > gimage->height ||
	  offx > (gimage->width - new_width) ||
	  offy > (gimage->height - new_height))
	success = FALSE;
      else
	crop_image (gimage, offx, offy, offx + new_width, offy + new_height,
		    FALSE, TRUE);
    }

  return procedural_db_return_args (&crop_proc, success);
}

static ProcArg crop_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "new_width",
    "New image width: (0 < new_width <= width)"
  },
  {
    PDB_INT32,
    "new_height",
    "New image height: (0 < new_height <= height)"
  },
  {
    PDB_INT32,
    "offx",
    "x offset: (0 <= offx <= (width - new_width))"
  },
  {
    PDB_INT32,
    "offy",
    "y offset: (0 <= offy <= (height - new_height))"
  }
};

static ProcRecord crop_proc =
{
  "gimp_crop",
  "Crop the image to the specified extents.",
  "This procedure crops the image so that it's new width and height are equal to the supplied parameters. Offsets are also provided which describe the position of the previous image's content. All channels and layers within the image are cropped to the new image extents; this includes the image selection mask. If any parameters are out of range, an error is returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  5,
  crop_inargs,
  0,
  NULL,
  { { crop_invoker } }
};

static Argument *
dodgeburn_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble exposure;
  gint32 dodgeburn_type;
  gint32 dodgeburn_mode;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  exposure = args[1].value.pdb_float;
  if (exposure < 0.0 || exposure > 100.0)
    success = FALSE;

  dodgeburn_type = args[2].value.pdb_int;
  if (dodgeburn_type < DODGE || dodgeburn_type > BURN)
    success = FALSE;

  dodgeburn_mode = args[3].value.pdb_int;
  if (dodgeburn_mode < DODGEBURN_HIGHLIGHTS || dodgeburn_mode > DODGEBURN_SHADOWS)
    success = FALSE;

  num_strokes = args[4].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[5].value.pdb_pointer;

  if (success)
    success = dodgeburn_non_gui (drawable, exposure, dodgeburn_type, dodgeburn_mode, num_strokes, strokes);

  return procedural_db_return_args (&dodgeburn_proc, success);
}

static ProcArg dodgeburn_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_FLOAT,
    "exposure",
    "The exposer of the strokes (0 <= exposure <= 100)"
  },
  {
    PDB_INT32,
    "dodgeburn_type",
    "The type either dodge or burn: { DODGE (0), BURN (1) }"
  },
  {
    PDB_INT32,
    "dodgeburn_mode",
    "The mode: { DODGEBURN_HIGHLIGHTS (0), DODGEBURN_MIDTONES (1), DODGEBURN_SHADOWS (2) }"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord dodgeburn_proc =
{
  "gimp_dodgeburn",
  "Dodgeburn image with varying exposure.",
  "Dodgebure. More details here later.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  6,
  dodgeburn_inargs,
  0,
  NULL,
  { { dodgeburn_invoker } }
};

static Argument *
dodgeburn_default_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = dodgeburn_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&dodgeburn_default_proc, success);
}

static ProcArg dodgeburn_default_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord dodgeburn_default_proc =
{
  "gimp_dodgeburn_default",
  "Dodgeburn image with varying exposure. This is the same as the gimp_dodgeburn function except that the exposure, type and mode are taken from the tools option dialog. If the dialog has not been activated then the defaults as used by the dialog will be used.",
  "Dodgebure. More details here later.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  3,
  dodgeburn_default_inargs,
  0,
  NULL,
  { { dodgeburn_default_invoker } }
};

static Argument *
ellipse_select_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gdouble x;
  gdouble y;
  gdouble width;
  gdouble height;
  gint32 operation;
  gboolean antialias;
  gboolean feather;
  gdouble feather_radius;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  x = args[1].value.pdb_float;

  y = args[2].value.pdb_float;

  width = args[3].value.pdb_float;
  if (width <= 0.0)
    success = FALSE;

  height = args[4].value.pdb_float;
  if (height <= 0.0)
    success = FALSE;

  operation = args[5].value.pdb_int;
  if (operation < ADD || operation > INTERSECT)
    success = FALSE;

  antialias = args[6].value.pdb_int ? TRUE : FALSE;

  feather = args[7].value.pdb_int ? TRUE : FALSE;

  feather_radius = args[8].value.pdb_float;

  if (success)
    ellipse_select (gimage, (int) x, (int) y, (int) width, (int) height,
		    operation, antialias, feather, feather_radius);

  return procedural_db_return_args (&ellipse_select_proc, success);
}

static ProcArg ellipse_select_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_FLOAT,
    "x",
    "x coordinate of upper-left corner of ellipse bounding box"
  },
  {
    PDB_FLOAT,
    "y",
    "y coordinate of upper-left corner of ellipse bounding box"
  },
  {
    PDB_FLOAT,
    "width",
    "The width of the ellipse: 0 < width"
  },
  {
    PDB_FLOAT,
    "height",
    "The height of the ellipse: 0 < height"
  },
  {
    PDB_INT32,
    "operation",
    "The selection operation: { ADD (0), SUB (1), REPLACE (2), INTERSECT (3) }"
  },
  {
    PDB_INT32,
    "antialias",
    "Antialiasing (TRUE or FALSE)"
  },
  {
    PDB_INT32,
    "feather",
    "Feather option for selections"
  },
  {
    PDB_FLOAT,
    "feather_radius",
    "Radius for feather operation"
  }
};

static ProcRecord ellipse_select_proc =
{
  "gimp_ellipse_select",
  "Create an elliptical selection over the specified image.",
  "This tool creates an elliptical selection over the specified image. The elliptical region can be either added to, subtracted from, or replace the contents of the previous selection mask. If antialiasing is turned on, the edges of the elliptical region will contain intermediate values which give the appearance of a sharper, less pixelized edge. This should be set as TRUE most of the time. If the feather option is enabled, the resulting selection is blurred before combining. The blur is a gaussian blur with the specified feather radius.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  9,
  ellipse_select_inargs,
  0,
  NULL,
  { { ellipse_select_invoker } }
};

static Argument *
eraser_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;
  gint32 hardness;
  gint32 method;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  hardness = args[3].value.pdb_int;
  if (hardness < HARD || hardness > SOFT)
    success = FALSE;

  method = args[4].value.pdb_int;
  if (method < CONSTANT || method > INCREMENTAL)
    success = FALSE;

  if (success)
    success = eraser_non_gui (drawable, num_strokes, strokes, hardness, method);

  return procedural_db_return_args (&eraser_proc, success);
}

static ProcArg eraser_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  },
  {
    PDB_INT32,
    "hardness",
    "HARD (0) or SOFT (1)"
  },
  {
    PDB_INT32,
    "method",
    "CONTINUOUS (0) or INCREMENTAL (1)"
  }
};

static ProcRecord eraser_proc =
{
  "gimp_eraser",
  "Erase using the current brush.",
  "This tool erases using the current brush mask. If the specified drawable contains an alpha channel, then the erased pixels will become transparent. Otherwise, the eraser tool replaces the contents of the drawable with the background color. Like paintbrush, this tool linearly interpolates between the specified stroke coordinates.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  5,
  eraser_inargs,
  0,
  NULL,
  { { eraser_invoker } }
};

static Argument *
eraser_default_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = eraser_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&eraser_default_proc, success);
}

static ProcArg eraser_default_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord eraser_default_proc =
{
  "gimp_eraser_default",
  "Erase using the current brush.",
  "This tool erases using the current brush mask. This function performs exactly the same as the gimp_eraser function except that the tools arguments are obtained from the eraser option dialog. It this dialog has not been activated then the dialogs default values will be used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  3,
  eraser_default_inargs,
  0,
  NULL,
  { { eraser_default_invoker } }
};

static Argument *
flip_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gint32 flip_type;
  GimpImage *gimage;
  TileManager *float_tiles, *new_tiles;
  Layer *layer;
  int new_layer;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  flip_type = args[1].value.pdb_int;
  if (flip_type < VERTICAL || flip_type > UNKNOWN)
    success = FALSE;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
    
      /* Start a transform undo group */
      undo_push_group_start (gimage, TRANSFORM_CORE_UNDO); 
    
      /* Cut/Copy from the specified drawable */
      float_tiles = transform_core_cut (gimage, drawable, &new_layer);
    
      /* flip the buffer */
      switch (flip_type)
	{
	case ORIENTATION_HORIZONTAL:
	case ORIENTATION_VERTICAL:
	  new_tiles = flip_tool_flip (gimage, drawable, float_tiles, -1, flip_type);
	  break;
	default:
	  new_tiles = NULL;
	  break;
	}
    
      /* free the cut/copied buffer */
      tile_manager_destroy (float_tiles);
    
      if (new_tiles)
	{
	  layer = transform_core_paste (gimage, drawable, new_tiles, new_layer);
	  success = (layer != NULL);
	}
      else
	success = FALSE;
    
      /* push the undo group end  */
      undo_push_group_end (gimage);
    }

  return_args = procedural_db_return_args (&flip_proc, success);

  if (success)
    return_args[1].value.pdb_int = drawable_ID (GIMP_DRAWABLE (drawable));

  return return_args;
}

static ProcArg flip_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "flip_type",
    "Type of flip: HORIZONTAL (0), VERTICAL (1), UNKNOWN (2)"
  }
};

static ProcArg flip_outargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The flipped drawable"
  }
};

static ProcRecord flip_proc =
{
  "gimp_flip",
  "Flip the specified drawable about its center either vertically or horizontally.",
  "This tool flips the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then flipd by the specified amount. The return value is the ID of the flipped drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and flipped drawable. The flip type parameter indicates whether the flip will be applied horizontally or vertically.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  2,
  flip_inargs,
  1,
  flip_outargs,
  { { flip_invoker } }
};

static Argument *
free_select_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 num_segs;
  gdouble *segs;
  gint32 operation;
  gboolean antialias;
  gboolean feather;
  gdouble feather_radius;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  num_segs = args[1].value.pdb_int;
  if (!(num_segs < 2))
    num_segs /= 2;
  else
    success = FALSE;

  segs = (gdouble *) args[2].value.pdb_pointer;

  operation = args[3].value.pdb_int;
  if (operation < ADD || operation > INTERSECT)
    success = FALSE;

  antialias = args[4].value.pdb_int ? TRUE : FALSE;

  feather = args[5].value.pdb_int ? TRUE : FALSE;

  feather_radius = args[6].value.pdb_float;

  if (success)
    free_select (gimage, num_segs, (FreeSelectPoint *) segs, operation,
		 antialias, feather, feather_radius);

  return procedural_db_return_args (&free_select_proc, success);
}

static ProcArg free_select_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "num_segs",
    "Number of points (count 1 coordinate as two points)"
  },
  {
    PDB_FLOATARRAY,
    "segs",
    "Array of points: { p1.x, p1.y, p2.x, p2.y, ..., pn.x, pn.y}"
  },
  {
    PDB_INT32,
    "operation",
    "The selection operation: { ADD (0), SUB (1), REPLACE (2), INTERSECT (3) }"
  },
  {
    PDB_INT32,
    "antialias",
    "Antialiasing (TRUE or FALSE)"
  },
  {
    PDB_INT32,
    "feather",
    "Feather option for selections"
  },
  {
    PDB_FLOAT,
    "feather_radius",
    "Radius for feather operation"
  }
};

static ProcRecord free_select_proc =
{
  "gimp_free_select",
  "Create a polygonal selection over the specified image.",
  "This tool creates a polygonal selection over the specified image. The polygonal region can be either added to, subtracted from, or replace the contents of the previous selection mask. The polygon is specified through an array of floating point numbers and its length. The length of array must be 2n, where n is the number of points. Each point is defined by 2 floating point values which correspond to the x and y coordinates. If the final point does not connect to the starting point, a connecting segment is automatically added. If the feather option is enabled, the resulting selection is blurred before combining. The blur is a gaussian blur with the specified feather radius.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  7,
  free_select_inargs,
  0,
  NULL,
  { { free_select_invoker } }
};

static Argument *
fuzzy_select_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble x;
  gdouble y;
  gint32 threshold;
  gint32 operation;
  gboolean antialias;
  gboolean feather;
  gdouble feather_radius;
  gboolean sample_merged;
  GimpImage *gimage;
  Channel *new, *old_fuzzy_mask;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  x = args[1].value.pdb_float;

  y = args[2].value.pdb_float;

  threshold = args[3].value.pdb_int;
  if (threshold < 0 || threshold > 255)
    success = FALSE;

  operation = args[4].value.pdb_int;
  if (operation < ADD || operation > INTERSECT)
    success = FALSE;

  antialias = args[5].value.pdb_int ? TRUE : FALSE;

  feather = args[6].value.pdb_int ? TRUE : FALSE;

  feather_radius = args[7].value.pdb_float;

  sample_merged = args[8].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
    
      new = find_contiguous_region (gimage, drawable, antialias, threshold,
				    x, y, sample_merged);
      old_fuzzy_mask = fuzzy_mask;
      fuzzy_mask = new;
    
      drawable = sample_merged ? NULL : drawable;
      fuzzy_select (gimage, drawable, operation, feather, feather_radius);
    
      fuzzy_mask = old_fuzzy_mask;
    }

  return procedural_db_return_args (&fuzzy_select_proc, success);
}

static ProcArg fuzzy_select_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_FLOAT,
    "x",
    "x coordinate of initial seed fill point: (image coordinates)"
  },
  {
    PDB_FLOAT,
    "y",
    "y coordinate of initial seed fill point: (image coordinates)"
  },
  {
    PDB_INT32,
    "threshold",
    "Threshold in intensity levels 0 <= threshold <= 255"
  },
  {
    PDB_INT32,
    "operation",
    "The selection operation: { ADD (0), SUB (1), REPLACE (2), INTERSECT (3) }"
  },
  {
    PDB_INT32,
    "antialias",
    "Antialiasing (TRUE or FALSE)"
  },
  {
    PDB_INT32,
    "feather",
    "Feather option for selections"
  },
  {
    PDB_FLOAT,
    "feather_radius",
    "Radius for feather operation"
  },
  {
    PDB_INT32,
    "sample_merged",
    "Use the composite image, not the drawable"
  }
};

static ProcRecord fuzzy_select_proc =
{
  "gimp_fuzzy_select",
  "Create a fuzzy selection starting at the specified coordinates on the specified drawable.",
  "This tool creates a fuzzy selection over the specified image. A fuzzy selection is determined by a seed fill under the constraints of the specified threshold. Essentially, the color at the specified coordinates (in the drawable) is measured and the selection expands outwards from that point to any adjacent pixels which are not significantly different (as determined by the threshold value). This process continues until no more expansion is possible. The antialiasing parameter allows the final selection mask to contain intermediate values based on close misses to the threshold bar at pixels along the seed fill boundary. Feathering can be enabled optionally and is controlled with the \"feather_radius\" paramter. If the sample_merged parameter is non-zero, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of a merged sampling, the supplied drawable is ignored."
  "If the sample is merged, the specified coordinates are relative to the image origin; otherwise, they are relative to the drawable's origin.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  9,
  fuzzy_select_inargs,
  0,
  NULL,
  { { fuzzy_select_invoker } }
};

static Argument *
paintbrush_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble fade_out;
  gint32 num_strokes;
  gdouble *strokes;
  gint32 method;
  gdouble gradient_length;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  fade_out = args[1].value.pdb_float;
  if (fade_out < 0.0)
    success = FALSE;

  num_strokes = args[2].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[3].value.pdb_pointer;

  method = args[4].value.pdb_int;
  if (method < CONSTANT || method > INCREMENTAL)
    success = FALSE;

  gradient_length = args[5].value.pdb_float;
  if (gradient_length < 0.0)
    success = FALSE;

  if (success)
    success = paintbrush_non_gui (drawable, num_strokes, strokes, fade_out,
				  method, gradient_length);

  return procedural_db_return_args (&paintbrush_proc, success);
}

static ProcArg paintbrush_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_FLOAT,
    "fade_out",
    "Fade out parameter: 0 <= fade_out"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  },
  {
    PDB_INT32,
    "method",
    "CONTINUOUS (0) or INCREMENTAL (1)"
  },
  {
    PDB_FLOAT,
    "gradient_length",
    "Length of gradient to draw: 0 <= gradient_length"
  }
};

static ProcRecord paintbrush_proc =
{
  "gimp_paintbrush",
  "Paint in the current brush with optional fade out parameter and pull colors from a gradient.",
  "This tool is the standard paintbrush. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The \"fade_out\" parameter is measured in pixels and allows the brush stroke to linearly fall off. The pressure is set to the maximum at the beginning of the stroke. As the distance of the stroke nears the fade_out value, the pressure will approach zero. The gradient_length is the distance to spread the gradient over. It is measured in pixels. If the gradient_length is 0, no gradient is used.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  6,
  paintbrush_inargs,
  0,
  NULL,
  { { paintbrush_invoker } }
};

static Argument *
paintbrush_default_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = paintbrush_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&paintbrush_default_proc, success);
}

static ProcArg paintbrush_default_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord paintbrush_default_proc =
{
  "gimp_paintbrush_default",
  "Paint in the current brush. The fade out parameter and pull colors from a gradient parameter are set from the paintbrush options dialog. If this dialog has not been activated then the dialog defaults will be used.",
  "This tool is similar to the standard paintbrush. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The \"fade_out\" parameter is measured in pixels and allows the brush stroke to linearly fall off (value obtained from the option dialog). The pressure is set to the maximum at the beginning of the stroke. As the distance of the stroke nears the fade_out value, the pressure will approach zero. The gradient_length (value obtained from the option dialog) is the distance to spread the gradient over. It is measured in pixels. If the gradient_length is 0, no gradient is used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  3,
  paintbrush_default_inargs,
  0,
  NULL,
  { { paintbrush_default_invoker } }
};

static Argument *
pencil_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = pencil_non_gui (drawable, num_strokes, strokes);

  return procedural_db_return_args (&pencil_proc, success);
}

static ProcArg pencil_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord pencil_proc =
{
  "gimp_pencil",
  "Paint in the current brush without sub-pixel sampling.",
  "This tool is the standard pencil. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The brush mask is treated as though it contains only black and white values. Any value below half is treated as black; any above half, as white.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  3,
  pencil_inargs,
  0,
  NULL,
  { { pencil_invoker } }
};

static Argument *
perspective_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gboolean interpolation;
  GimpImage *gimage;
  TileManager *float_tiles, *new_tiles;
  Layer *layer;
  int new_layer;
  double cx, cy;
  double scalex, scaley;
  double trans_info[8];
  GimpMatrix m, matrix;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  interpolation = args[1].value.pdb_int ? TRUE : FALSE;

  trans_info[X0] = args[2].value.pdb_float;

  trans_info[Y0] = args[3].value.pdb_float;

  trans_info[X1] = args[4].value.pdb_float;

  trans_info[Y1] = args[5].value.pdb_float;

  trans_info[X2] = args[6].value.pdb_float;

  trans_info[Y2] = args[7].value.pdb_float;

  trans_info[X3] = args[8].value.pdb_float;

  trans_info[Y3] = args[9].value.pdb_float;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
    
      /* Start a transform undo group */
      undo_push_group_start (gimage, TRANSFORM_CORE_UNDO);
    
      /* Cut/Copy from the specified drawable */
      float_tiles = transform_core_cut (gimage, drawable, &new_layer);
    
      /* Determine the perspective transform that maps from
       * the unit cube to the trans_info coordinates
       */
      perspective_find_transform (trans_info, m);
    
      cx     = float_tiles->x;
      cy     = float_tiles->y;
      scalex = 1.0;
      scaley = 1.0;
      if (float_tiles->width)
	scalex = 1.0 / float_tiles->width;
      if (float_tiles->height)
	scaley = 1.0 / float_tiles->height;
    
      /* Assemble the transformation matrix */
      gimp_matrix_identity  (matrix);
      gimp_matrix_translate (matrix, -cx, -cy);
      gimp_matrix_scale     (matrix, scalex, scaley);
      gimp_matrix_mult      (m, matrix);
    
      /* Perspective the buffer */
      new_tiles = perspective_tool_perspective (gimage, drawable, NULL,
						float_tiles, interpolation,
						matrix);
    
      /* Free the cut/copied buffer */
      tile_manager_destroy (float_tiles);
    
      if (new_tiles)
	{
	  layer = transform_core_paste (gimage, drawable, new_tiles, new_layer);
	  success = layer != NULL;
	}
      else
	success = FALSE;
    
      /*  push the undo group end  */
      undo_push_group_end (gimage);
    }

  return_args = procedural_db_return_args (&perspective_proc, success);

  if (success)
    return_args[1].value.pdb_int = drawable_ID (GIMP_DRAWABLE (drawable));

  return return_args;
}

static ProcArg perspective_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "interpolation",
    "Whether to use interpolation"
  },
  {
    PDB_FLOAT,
    "x0",
    "The new x coordinate of upper-left corner of original bounding box"
  },
  {
    PDB_FLOAT,
    "y0",
    "The new y coordinate of upper-left corner of original bounding box"
  },
  {
    PDB_FLOAT,
    "x1",
    "The new x coordinate of upper-right corner of original bounding box"
  },
  {
    PDB_FLOAT,
    "y1",
    "The new y coordinate of upper-right corner of original bounding box"
  },
  {
    PDB_FLOAT,
    "x2",
    "The new x coordinate of lower-left corner of original bounding box"
  },
  {
    PDB_FLOAT,
    "y2",
    "The new y coordinate of lower-left corner of original bounding box"
  },
  {
    PDB_FLOAT,
    "x3",
    "The new x coordinate of lower-right corner of original bounding box"
  },
  {
    PDB_FLOAT,
    "y3",
    "The new y coordinate of lower-right corner of original bounding box"
  }
};

static ProcArg perspective_outargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The newly mapped drawable"
  }
};

static ProcRecord perspective_proc =
{
  "gimp_perspective",
  "Perform a possibly non-affine transformation on the specified drawable.",
  "This tool performs a possibly non-affine transformation on the specified drawable by allowing the corners of the original bounding box to be arbitrarily remapped to any values. The specified drawable is remapped if no selection exists. However, if a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then remapped as specified. The interpolation parameter can be set to TRUE to indicate that either linear or cubic interpolation should be used to smooth the resulting remapped drawable. The return value is the ID of the remapped drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and remapped drawable. The 4 coordinates specify the new locations of each corner of the original bounding box. By specifying these values, any affine transformation (rotation, scaling, translation) can be affected. Additionally,"
  "these values can be specified such that the resulting transformed drawable will appear to have been projected via a perspective transform.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  10,
  perspective_inargs,
  1,
  perspective_outargs,
  { { perspective_invoker } }
};

static Argument *
rect_select_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gdouble x;
  gdouble y;
  gdouble width;
  gdouble height;
  gint32 operation;
  gboolean feather;
  gdouble feather_radius;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  x = args[1].value.pdb_float;

  y = args[2].value.pdb_float;

  width = args[3].value.pdb_float;
  if (width <= 0.0)
    success = FALSE;

  height = args[4].value.pdb_float;
  if (height <= 0.0)
    success = FALSE;

  operation = args[5].value.pdb_int;
  if (operation < ADD || operation > INTERSECT)
    success = FALSE;

  feather = args[6].value.pdb_int ? TRUE : FALSE;

  feather_radius = args[7].value.pdb_float;

  if (success)
    rect_select (gimage, (int) x, (int) y, (int) width, (int) height,
		 operation, feather, feather_radius);

  return procedural_db_return_args (&rect_select_proc, success);
}

static ProcArg rect_select_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_FLOAT,
    "x",
    "x coordinate of upper-left corner of rectangle"
  },
  {
    PDB_FLOAT,
    "y",
    "y coordinate of upper-left corner of rectangle"
  },
  {
    PDB_FLOAT,
    "width",
    "The width of the rectangle: 0 < width"
  },
  {
    PDB_FLOAT,
    "height",
    "The height of the rectangle: 0 < height"
  },
  {
    PDB_INT32,
    "operation",
    "The selection operation: { ADD (0), SUB (1), REPLACE (2), INTERSECT (3) }"
  },
  {
    PDB_INT32,
    "feather",
    "Feather option for selections"
  },
  {
    PDB_FLOAT,
    "feather_radius",
    "Radius for feather operation"
  }
};

static ProcRecord rect_select_proc =
{
  "gimp_rect_select",
  "Create a rectangular selection over the specified image;",
  "This tool creates a rectangular selection over the specified image. The rectangular region can be either added to, subtracted from, or replace the contents of the previous selection mask. If the feather option is enabled, the resulting selection is blurred before combining. The blur is a gaussian blur with the specified feather radius.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  8,
  rect_select_inargs,
  0,
  NULL,
  { { rect_select_invoker } }
};

static Argument *
rotate_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gboolean interpolation;
  gdouble angle;
  GimpImage *gimage;
  TileManager *float_tiles, *new_tiles;
  Layer *layer;
  int new_layer;
  double cx, cy;
  GimpMatrix matrix;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  interpolation = args[1].value.pdb_int ? TRUE : FALSE;

  angle = args[2].value.pdb_float;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
    
      /* Start a transform undo group */
      undo_push_group_start (gimage, TRANSFORM_CORE_UNDO);
    
      /* Cut/Copy from the specified drawable */
      float_tiles = transform_core_cut (gimage, drawable, &new_layer);
    
      cx = float_tiles->x + float_tiles->width / 2.0;
      cy = float_tiles->y + float_tiles->height / 2.0;
    
      /* Assemble the transformation matrix */
      gimp_matrix_identity  (matrix);
      gimp_matrix_translate (matrix, -cx, -cy);
      gimp_matrix_rotate    (matrix, angle);
      gimp_matrix_translate (matrix, +cx, +cy);
    
      /* Rotate the buffer */
      new_tiles = rotate_tool_rotate (gimage, drawable, NULL, angle,
				      float_tiles, interpolation, matrix);
    
      /* Free the cut/copied buffer */
      tile_manager_destroy (float_tiles);
    
      if (new_tiles)
	{
	  layer = transform_core_paste (gimage, drawable, new_tiles, new_layer);
	  success = layer != NULL;
	}
      else
	success = FALSE;
    
      /* Push the undo group end */
      undo_push_group_end (gimage);
    }

  return_args = procedural_db_return_args (&rotate_proc, success);

  if (success)
    return_args[1].value.pdb_int = drawable_ID (GIMP_DRAWABLE (drawable));

  return return_args;
}

static ProcArg rotate_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "interpolation",
    "Whether to use interpolation"
  },
  {
    PDB_FLOAT,
    "angle",
    "The angle of rotation (radians)"
  }
};

static ProcArg rotate_outargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The rotated drawable"
  }
};

static ProcRecord rotate_proc =
{
  "gimp_rotate",
  "Rotate the specified drawable about its center through the specified angle.",
  "This tool rotates the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then rotated by the specified amount. The interpolation parameter can be set to TRUE to indicate that either linear or cubic interpolation should be used to smooth the resulting rotated drawable. The return value is the ID of the rotated drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and rotated drawable.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  3,
  rotate_inargs,
  1,
  rotate_outargs,
  { { rotate_invoker } }
};

static Argument *
scale_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gboolean interpolation;
  GimpImage *gimage;
  TileManager *float_tiles, *new_tiles;
  Layer *layer;
  int new_layer;
  double scalex, scaley;
  double trans_info[4];
  GimpMatrix matrix;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  interpolation = args[1].value.pdb_int ? TRUE : FALSE;

  trans_info[X0] = args[2].value.pdb_float;

  trans_info[Y0] = args[3].value.pdb_float;

  trans_info[X1] = args[4].value.pdb_float;

  trans_info[Y1] = args[5].value.pdb_float;

  if (success)
    {
      if (trans_info[X0] < trans_info[X1] &&
	  trans_info[Y0] < trans_info[X1])
	{
	  gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
    
	  /* Start a transform undo group */
	  undo_push_group_start (gimage, TRANSFORM_CORE_UNDO);
    
	  /* Cut/Copy from the specified drawable */
	  float_tiles = transform_core_cut (gimage, drawable, &new_layer);
    
	  scalex = scaley = 1.0;
	  if (float_tiles->width)
	    scalex = (trans_info[X1] - trans_info[X0]) /
		     (double) float_tiles->width;
	  if (float_tiles->height)
	    scaley = (trans_info[Y1] - trans_info[Y0]) /
		     (double) float_tiles->height;
    
	  /* Assemble the transformation matrix */
	  gimp_matrix_identity  (matrix);
	  gimp_matrix_translate (matrix, float_tiles->x, float_tiles->y);
	  gimp_matrix_scale     (matrix, scalex, scaley);
	  gimp_matrix_translate (matrix, trans_info[X0], trans_info[Y0]);
    
	  /* Scale the buffer */
	  new_tiles = scale_tool_scale (gimage, drawable, NULL, trans_info,
					float_tiles, interpolation, matrix);
    
	  /* Free the cut/copied buffer */
	  tile_manager_destroy (float_tiles);
    
	  if (new_tiles)
	    {
	      layer = transform_core_paste (gimage, drawable, new_tiles, new_layer);
	      success = layer != NULL;
	    }
	  else
	    success = FALSE;
    
	  /*  push the undo group end  */
	  undo_push_group_end (gimage);
	}
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&scale_proc, success);

  if (success)
    return_args[1].value.pdb_int = drawable_ID (GIMP_DRAWABLE (drawable));

  return return_args;
}

static ProcArg scale_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "interpolation",
    "Whether to use interpolation"
  },
  {
    PDB_FLOAT,
    "x0",
    "The new x coordinate of upper-left corner of newly scaled region"
  },
  {
    PDB_FLOAT,
    "y0",
    "The new y coordinate of upper-left corner of newly scaled region"
  },
  {
    PDB_FLOAT,
    "x1",
    "The new x coordinate of lower-right corner of newly scaled region"
  },
  {
    PDB_FLOAT,
    "y1",
    "The new y coordinate of lower-right corner of newly scaled region"
  }
};

static ProcArg scale_outargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The scaled drawable"
  }
};

static ProcRecord scale_proc =
{
  "gimp_scale",
  "Scale the specified drawable.",
  "This tool scales the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then scaled by the specified amount. The interpolation parameter can be set to TRUE to indicate that either linear or cubic interpolation should be used to smooth the resulting scaled drawable. The return value is the ID of the scaled drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and scaled drawable.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  6,
  scale_inargs,
  1,
  scale_outargs,
  { { scale_invoker } }
};

static Argument *
shear_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gboolean interpolation;
  gint32 shear_type;
  gdouble magnitude;
  GimpImage *gimage;
  TileManager *float_tiles, *new_tiles;
  Layer *layer;
  int new_layer;
  double cx, cy;
  GimpMatrix matrix;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  interpolation = args[1].value.pdb_int ? TRUE : FALSE;

  shear_type = args[2].value.pdb_int;
  if (shear_type < VERTICAL || shear_type > UNKNOWN)
    success = FALSE;

  magnitude = args[3].value.pdb_float;

  if (success)
    {
      gimage = drawable_gimage (GIMP_DRAWABLE (drawable));
    
      /* Start a transform undo group */
      undo_push_group_start (gimage, TRANSFORM_CORE_UNDO);
    
      /* Cut/Copy from the specified drawable */
      float_tiles = transform_core_cut (gimage, drawable, &new_layer);
    
      cx = float_tiles->x + float_tiles->width  / 2.0;
      cy = float_tiles->y + float_tiles->height / 2.0;
    
      gimp_matrix_identity  (matrix);
      gimp_matrix_translate (matrix, -cx, -cy);
      /* Shear matrix */
      if (shear_type == ORIENTATION_HORIZONTAL)
	gimp_matrix_xshear (matrix, magnitude / float_tiles->height);
      else if (shear_type == ORIENTATION_VERTICAL)
	gimp_matrix_yshear (matrix, magnitude / float_tiles->width);
      gimp_matrix_translate (matrix, +cx, +cy);
    
      /* Shear the buffer */
      new_tiles = shear_tool_shear (gimage, drawable, NULL, float_tiles,
				    interpolation, matrix);
    
      /* Free the cut/copied buffer */
      tile_manager_destroy (float_tiles);
    
      if (new_tiles)
	{
	  layer = transform_core_paste (gimage, drawable, new_tiles, new_layer);
	  success = layer != NULL;
	}
      else
	success = FALSE;
    
      /* Push the undo group end */
      undo_push_group_end (gimage);
    }

  return_args = procedural_db_return_args (&shear_proc, success);

  if (success)
    return_args[1].value.pdb_int = drawable_ID (GIMP_DRAWABLE (drawable));

  return return_args;
}

static ProcArg shear_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "interpolation",
    "Whether to use interpolation"
  },
  {
    PDB_INT32,
    "shear_type",
    "Type of shear: HORIZONTAL (0), VERTICAL (1), UNKNOWN (2)"
  },
  {
    PDB_FLOAT,
    "magnitude",
    "The magnitude of the shear"
  }
};

static ProcArg shear_outargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The sheared drawable"
  }
};

static ProcRecord shear_proc =
{
  "gimp_shear",
  "Shear the specified drawable about its center by the specified magnitude.",
  "This tool shears the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then sheard by the specified amount. The interpolation parameter can be set to TRUE to indicate that either linear or cubic interpolation should be used to smooth the resulting sheared drawable. The return value is the ID of the sheard drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and sheard drawable. The shear type parameter indicates whether the shear will be applied horizontally or vertically. The magnitude can be either positive or negative and indicates the extent (in pixels) to shear by.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  4,
  shear_inargs,
  1,
  shear_outargs,
  { { shear_invoker } }
};

static Argument *
smudge_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  pressure = args[1].value.pdb_float;
  if (pressure < 0.0 || pressure > 100.0)
    success = FALSE;

  num_strokes = args[2].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[3].value.pdb_pointer;

  if (success)
    success = smudge_non_gui (drawable, pressure, num_strokes, strokes);

  return procedural_db_return_args (&smudge_proc, success);
}

static ProcArg smudge_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_FLOAT,
    "pressure",
    "The pressure of the smudge strokes (0 <= pressure <= 100)"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord smudge_proc =
{
  "gimp_smudge",
  "Smudge image with varying pressure.",
  "This tool simulates a smudge using the current brush. High pressure results in a greater smudge of paint while low pressure results in a lesser smudge.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  4,
  smudge_inargs,
  0,
  NULL,
  { { smudge_invoker } }
};

static Argument *
smudge_default_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_ID (args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = smudge_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&smudge_default_proc, success);
}

static ProcArg smudge_default_inargs[] =
{
  {
    PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord smudge_default_proc =
{
  "gimp_smudge_default",
  "Smudge image with varying pressure.",
  "This tool simulates a smudge using the current brush. It behaves exactly the same as gimp_smudge except that the pressure value is taken from the smudge tool options or the options default if the tools option dialog has not been activated.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  3,
  smudge_default_inargs,
  0,
  NULL,
  { { smudge_default_invoker } }
};
