/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpselectiontools_pdb.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#ifndef __GIMP_SELECTION_TOOLS_PDB_H__
#define __GIMP_SELECTION_TOOLS_PDB_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */


gboolean gimp_by_color_select (gint32          drawable_ID,
			       GimpRGB        *color,
			       gint            threshold,
			       GimpChannelOps  operation,
			       gboolean        antialias,
			       gboolean        feather,
			       gdouble         feather_radius,
			       gboolean        sample_merged);
gboolean gimp_ellipse_select  (gint32          image_ID,
			       gdouble         x,
			       gdouble         y,
			       gdouble         width,
			       gdouble         height,
			       GimpChannelOps  operation,
			       gboolean        antialias,
			       gboolean        feather,
			       gdouble         feather_radius);
gboolean gimp_free_select     (gint32          image_ID,
			       gint            num_segs,
			       gdouble        *segs,
			       GimpChannelOps  operation,
			       gboolean        antialias,
			       gboolean        feather,
			       gdouble         feather_radius);
gboolean gimp_fuzzy_select    (gint32          drawable_ID,
			       gdouble         x,
			       gdouble         y,
			       gint            threshold,
			       GimpChannelOps  operation,
			       gboolean        antialias,
			       gboolean        feather,
			       gdouble         feather_radius,
			       gboolean        sample_merged);
gboolean gimp_rect_select     (gint32          image_ID,
			       gdouble         x,
			       gdouble         y,
			       gdouble         width,
			       gdouble         height,
			       GimpChannelOps  operation,
			       gboolean        feather,
			       gdouble         feather_radius);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIMP_SELECTION_TOOLS_PDB_H__ */
