/* The GIMP -- an image manipulation program
 * Copyright (C) 1995, 1996, 1997 Spencer Kimball and Peter Mattis
 * Copyright (C) 1997 Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <gtk/gtk.h>

#include "gui-types.h"

#include "widgets/gimpactiongroup.h"

#include "file-dialog-utils.h"


void
file_dialog_show (GtkWidget *dialog,
                  GtkWidget *parent)
{
  GList *list;

  for (list = gimp_action_groups_from_name ("file");
       list;
       list = g_list_next (list))
    {
      GimpActionGroup *group = list->data;

      gimp_action_group_set_action_sensitive (group, "file-save",        FALSE);
      gimp_action_group_set_action_sensitive (group, "file-save-as",     FALSE);
      gimp_action_group_set_action_sensitive (group, "file-save-a-copy", FALSE);
    }

  gtk_window_set_screen (GTK_WINDOW (dialog), gtk_widget_get_screen (parent));
  gtk_window_present (GTK_WINDOW (dialog));
}

void
file_dialog_hide (GtkWidget *dialog)
{
  GList *list;

  gtk_widget_hide (dialog);

  for (list = gimp_action_groups_from_name ("file");
       list;
       list = g_list_next (list))
    {
      GimpActionGroup *group = list->data;

      gimp_action_group_set_action_sensitive (group, "file-save",        TRUE);
      gimp_action_group_set_action_sensitive (group, "file-save-as",     TRUE);
      gimp_action_group_set_action_sensitive (group, "file-save-a-copy", TRUE);
    }
}
