/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * gimppreviewrendererlayer.c
 * Copyright (C) 2003 Michael Natterer <mitch@gimp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <gtk/gtk.h>

#include "libgimpwidgets/gimpwidgets.h"

#include "widgets-types.h"

#include "text/gimptextlayer.h"

#include "gimppreviewrendererlayer.h"


static void   gimp_preview_renderer_layer_class_init (GimpPreviewRendererLayerClass *klass);

static void   gimp_preview_renderer_layer_render (GimpPreviewRenderer *renderer,
                                                  GtkWidget           *widget);


static GimpPreviewRendererDrawableClass *parent_class = NULL;


GType
gimp_preview_renderer_layer_get_type (void)
{
  static GType renderer_type = 0;

  if (! renderer_type)
    {
      static const GTypeInfo renderer_info =
      {
        sizeof (GimpPreviewRendererLayerClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) gimp_preview_renderer_layer_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (GimpPreviewRendererLayer),
        0,              /* n_preallocs */
        NULL,           /* instance_init */
      };

      renderer_type = g_type_register_static (GIMP_TYPE_PREVIEW_RENDERER_DRAWABLE,
                                              "GimpPreviewRendererLayer",
                                              &renderer_info, 0);
    }

  return renderer_type;
}

static void
gimp_preview_renderer_layer_class_init (GimpPreviewRendererLayerClass *klass)
{
  GimpPreviewRendererClass *renderer_class;

  renderer_class = GIMP_PREVIEW_RENDERER_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);

  renderer_class->render = gimp_preview_renderer_layer_render;
}

static void
gimp_preview_renderer_layer_render (GimpPreviewRenderer *renderer,
                                    GtkWidget           *widget)
{
  const gchar *stock_id = NULL;

  if (gimp_layer_is_floating_sel (GIMP_LAYER (renderer->viewable)))
    {
      stock_id = GIMP_STOCK_FLOATING_SELECTION;
    }
  else if (gimp_drawable_is_text_layer (GIMP_DRAWABLE (renderer->viewable)))
    {
      stock_id = gimp_viewable_get_stock_id (renderer->viewable);
    }

  if (stock_id)
    gimp_preview_renderer_default_render_stock (renderer, widget, stock_id);
  else
    GIMP_PREVIEW_RENDERER_CLASS (parent_class)->render (renderer, widget);
}
