/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpbrush_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * gimp_brush_new:
 * @name: The requested name of the new brush.
 *
 * Creates a new brush
 *
 * This procedure creates a new, uninitialized brush
 *
 * Returns: The actual new brush name.
 *
 * Since: GIMP 2.2
 */
gchar *
gimp_brush_new (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *ret_name = NULL;

  return_vals = gimp_run_procedure ("gimp_brush_new",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_name;
}

/**
 * gimp_brush_duplicate:
 * @name: The brush name (\"\" means currently active brush).
 *
 * Duplicates a brush
 *
 * This procedure creates an identical brush by a different name
 *
 * Returns: The name of the brush's copy.
 *
 * Since: GIMP 2.2
 */
gchar *
gimp_brush_duplicate (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *ret_name = NULL;

  return_vals = gimp_run_procedure ("gimp_brush_duplicate",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_name;
}

/**
 * gimp_brush_rename:
 * @name: The brush name (\"\" means currently active brush).
 * @new_name: The new name of the brush.
 *
 * Rename a brush
 *
 * This procedure renames a brush
 *
 * Returns: The actual new name of the brush.
 *
 * Since: GIMP 2.2
 */
gchar *
gimp_brush_rename (const gchar *name,
		   const gchar *new_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *ret_name = NULL;

  return_vals = gimp_run_procedure ("gimp_brush_rename",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_STRING, new_name,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_name;
}

/**
 * gimp_brush_delete:
 * @name: The brush name (\"\" means currently active brush).
 *
 * Deletes a brush
 *
 * This procedure deletes a brush
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_brush_delete (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_brush_delete",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_brush_get_info:
 * @name: The brush name (\"\" means currently active brush).
 * @width: The brush width.
 * @height: The brush height.
 *
 * Retrieve information about the specified brush.
 *
 * This procedure retrieves information about the specified brush. This
 * includes the brush name, and the brush extents (width and height).
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_brush_get_info (const gchar *name,
		     gint        *width,
		     gint        *height)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_brush_get_info",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  *width = 0;
  *height = 0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *width = return_vals[1].data.d_int32;
      *height = return_vals[2].data.d_int32;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_brush_get_spacing:
 * @name: The brush name (\"\" means currently active brush).
 * @spacing: The brush spacing.
 *
 * Get the brush spacing.
 *
 * This procedure returns the spacing setting for the specified brush.
 * The return value is an integer between 0 and 1000 which represents
 * percentage of the maximum of the width and height of the mask.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_brush_get_spacing (const gchar *name,
			gint        *spacing)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_brush_get_spacing",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  *spacing = 0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *spacing = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_brush_set_spacing:
 * @name: The brush name (\"\" means currently active brush).
 * @spacing: The brush spacing.
 *
 * Set the brush spacing.
 *
 * This procedure modifies the spacing setting for the specified brush.
 * The value should be a integer between 0 and 1000.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_brush_set_spacing (const gchar *name,
			gint         spacing)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_brush_set_spacing",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_INT32, spacing,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
