/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpdynamics_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpdynamics
 * @title: gimpdynamics
 * @short_description: Operations related to paint dynamics.
 *
 * Operations related to paint dynamics.
 **/


/**
 * gimp_dynamics_refresh:
 *
 * Refresh current paint dynamics. This function always succeeds.
 *
 * This procedure retrieves all paint dynamics currently in the user's
 * paint dynamics path and updates the paint dynamics dialogs
 * accordingly.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_dynamics_refresh (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-dynamics-refresh",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_dynamics_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_dynamics: The number of available paint dynamics.
 *
 * Retrieve the list of loaded paint dynamics.
 *
 * This procedure returns a list of the paint dynamics that are
 * currently available.
 *
 * Returns: The list of paint dynamics names. The returned value must
 * be freed with g_strfreev().
 *
 * Since: 2.8
 **/
gchar **
gimp_dynamics_get_list (const gchar *filter,
                        gint        *num_dynamics)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **dynamics_list = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp-dynamics-get-list",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, filter,
                                    GIMP_PDB_END);

  *num_dynamics = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_dynamics = return_vals[1].data.d_int32;
      if (*num_dynamics > 0)
        {
          dynamics_list = g_new0 (gchar *, *num_dynamics + 1);
          for (i = 0; i < *num_dynamics; i++)
            dynamics_list[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
        }
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return dynamics_list;
}
