/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <glib-object.h>

#include "pdb-types.h"

#include "core/gimp.h"

#include "gimp-intl.h"

/* Forward declarations for registering PDB procs */

void register_brush_procs              (Gimp *gimp);
void register_brush_select_procs       (Gimp *gimp);
void register_brushes_procs            (Gimp *gimp);
void register_channel_procs            (Gimp *gimp);
void register_color_procs              (Gimp *gimp);
void register_context_procs            (Gimp *gimp);
void register_convert_procs            (Gimp *gimp);
void register_display_procs            (Gimp *gimp);
void register_drawable_procs           (Gimp *gimp);
void register_drawable_transform_procs (Gimp *gimp);
void register_edit_procs               (Gimp *gimp);
void register_fileops_procs            (Gimp *gimp);
void register_floating_sel_procs       (Gimp *gimp);
void register_font_select_procs        (Gimp *gimp);
void register_fonts_procs              (Gimp *gimp);
void register_gimprc_procs             (Gimp *gimp);
void register_gradient_procs           (Gimp *gimp);
void register_gradient_select_procs    (Gimp *gimp);
void register_gradients_procs          (Gimp *gimp);
void register_guides_procs             (Gimp *gimp);
void register_help_procs               (Gimp *gimp);
void register_image_procs              (Gimp *gimp);
void register_layer_procs              (Gimp *gimp);
void register_message_procs            (Gimp *gimp);
void register_misc_procs               (Gimp *gimp);
void register_paint_tools_procs        (Gimp *gimp);
void register_palette_procs            (Gimp *gimp);
void register_palette_select_procs     (Gimp *gimp);
void register_palettes_procs           (Gimp *gimp);
void register_parasite_procs           (Gimp *gimp);
void register_paths_procs              (Gimp *gimp);
void register_pattern_procs            (Gimp *gimp);
void register_pattern_select_procs     (Gimp *gimp);
void register_patterns_procs           (Gimp *gimp);
void register_plug_in_procs            (Gimp *gimp);
void register_procedural_db_procs      (Gimp *gimp);
void register_progress_procs           (Gimp *gimp);
void register_selection_procs          (Gimp *gimp);
void register_selection_tools_procs    (Gimp *gimp);
void register_text_tool_procs          (Gimp *gimp);
void register_transform_tools_procs    (Gimp *gimp);
void register_undo_procs               (Gimp *gimp);
void register_unit_procs               (Gimp *gimp);
void register_vectors_procs            (Gimp *gimp);

/* 475 procedures registered total */

void
internal_procs_init (Gimp               *gimp,
                     GimpInitStatusFunc  status_callback)
{
  g_return_if_fail (GIMP_IS_GIMP (gimp));
  g_return_if_fail (status_callback != NULL);

  (* status_callback) (_("Internal Procedures"), _("Brush"), 0.0);
  register_brush_procs (gimp);

  (* status_callback) (NULL, _("Brush UI"), 0.046);
  register_brush_select_procs (gimp);

  (* status_callback) (NULL, _("Brushes"), 0.053);
  register_brushes_procs (gimp);

  (* status_callback) (NULL, _("Channel"), 0.065);
  register_channel_procs (gimp);

  (* status_callback) (NULL, _("Color"), 0.086);
  register_color_procs (gimp);

  (* status_callback) (NULL, _("Context"), 0.12);
  register_context_procs (gimp);

  (* status_callback) (NULL, _("Convert"), 0.166);
  register_convert_procs (gimp);

  (* status_callback) (NULL, _("Display procedures"), 0.173);
  register_display_procs (gimp);

  (* status_callback) (NULL, _("Drawable procedures"), 0.183);
  register_drawable_procs (gimp);

  (* status_callback) (NULL, _("Transformation procedures"), 0.257);
  register_drawable_transform_procs (gimp);

  (* status_callback) (NULL, _("Edit procedures"), 0.291);
  register_edit_procs (gimp);

  (* status_callback) (NULL, _("File Operations"), 0.326);
  register_fileops_procs (gimp);

  (* status_callback) (NULL, _("Floating selections"), 0.347);
  register_floating_sel_procs (gimp);

  (* status_callback) (NULL, _("Font UI"), 0.36);
  register_font_select_procs (gimp);

  (* status_callback) (NULL, _("Fonts"), 0.366);
  register_fonts_procs (gimp);

  (* status_callback) (NULL, _("Gimprc procedures"), 0.371);
  register_gimprc_procs (gimp);

  (* status_callback) (NULL, _("Gradient"), 0.385);
  register_gradient_procs (gimp);

  (* status_callback) (NULL, _("Gradient UI"), 0.448);
  register_gradient_select_procs (gimp);

  (* status_callback) (NULL, _("Gradients"), 0.455);
  register_gradients_procs (gimp);

  (* status_callback) (NULL, _("Guide procedures"), 0.465);
  register_guides_procs (gimp);

  (* status_callback) (NULL, _("Help procedures"), 0.478);
  register_help_procs (gimp);

  (* status_callback) (NULL, _("Image"), 0.48);
  register_image_procs (gimp);

  (* status_callback) (NULL, _("Layer"), 0.613);
  register_layer_procs (gimp);

  (* status_callback) (NULL, _("Message procedures"), 0.669);
  register_message_procs (gimp);

  (* status_callback) (NULL, _("Miscellaneous"), 0.676);
  register_misc_procs (gimp);

  (* status_callback) (NULL, _("Paint Tool procedures"), 0.682);
  register_paint_tools_procs (gimp);

  (* status_callback) (NULL, _("Palette"), 0.714);
  register_palette_procs (gimp);

  (* status_callback) (NULL, _("Palette UI"), 0.743);
  register_palette_select_procs (gimp);

  (* status_callback) (NULL, _("Palettes"), 0.749);
  register_palettes_procs (gimp);

  (* status_callback) (NULL, _("Parasite procedures"), 0.758);
  register_parasite_procs (gimp);

  (* status_callback) (NULL, _("Paths"), 0.783);
  register_paths_procs (gimp);

  (* status_callback) (NULL, _("Pattern"), 0.817);
  register_pattern_procs (gimp);

  (* status_callback) (NULL, _("Pattern UI"), 0.821);
  register_pattern_select_procs (gimp);

  (* status_callback) (NULL, _("Patterns"), 0.827);
  register_patterns_procs (gimp);

  (* status_callback) (NULL, _("Plug-in"), 0.836);
  register_plug_in_procs (gimp);

  (* status_callback) (NULL, _("Procedural database"), 0.848);
  register_procedural_db_procs (gimp);

  (* status_callback) (NULL, _("Progress"), 0.867);
  register_progress_procs (gimp);

  (* status_callback) (NULL, _("Image mask"), 0.884);
  register_selection_procs (gimp);

  (* status_callback) (NULL, _("Selection Tool procedures"), 0.92);
  register_selection_tools_procs (gimp);

  (* status_callback) (NULL, _("Text procedures"), 0.931);
  register_text_tool_procs (gimp);

  (* status_callback) (NULL, _("Transform Tool procedures"), 0.939);
  register_transform_tools_procs (gimp);

  (* status_callback) (NULL, _("Undo"), 0.952);
  register_undo_procs (gimp);

  (* status_callback) (NULL, _("Units"), 0.966);
  register_unit_procs (gimp);

  (* status_callback) (NULL, _("Paths"), 0.992);
  register_vectors_procs (gimp);

}
