/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpmessage_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * gimp_message:
 * @message: Message to display in the dialog.
 *
 * Displays a dialog box with a message.
 *
 * Displays a dialog box with a message. Useful for status or error
 * reporting. The message must be in UTF-8 encoding.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_message (const gchar *message)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-message",
				    &nreturn_vals,
				    GIMP_PDB_STRING, message,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_message_get_handler:
 *
 * Returns the current state of where warning messages are displayed.
 *
 * This procedure returns the way g_message warnings are displayed.
 * They can be shown in a dialog box or printed on the console where
 * gimp was started.
 *
 * Returns: The current handler type.
 */
GimpMessageHandlerType
gimp_message_get_handler (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpMessageHandlerType handler = 0;

  return_vals = gimp_run_procedure ("gimp-message-get-handler",
				    &nreturn_vals,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    handler = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return handler;
}

/**
 * gimp_message_set_handler:
 * @handler: The new handler type.
 *
 * Controls where warning messages are displayed.
 *
 * This procedure controls how g_message warnings are displayed. They
 * can be shown in a dialog box or printed on the console where gimp
 * was started.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_message_set_handler (GimpMessageHandlerType handler)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-message-set-handler",
				    &nreturn_vals,
				    GIMP_PDB_INT32, handler,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
