/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "libgimpcolor/gimpcolor.h"

#include "pdb-types.h"
#include "gimppdb.h"
#include "gimpprocedure.h"
#include "core/gimpparamspecs.h"

#include "core/gimp.h"
#include "core/gimpcontainer.h"
#include "core/gimpcontext.h"
#include "core/gimpdatafactory.h"
#include "plug-in/gimpplugin-context.h"
#include "plug-in/gimpplugin.h"
#include "plug-in/gimppluginmanager.h"


static GValueArray *
context_push_invoker (GimpProcedure     *procedure,
                      Gimp              *gimp,
                      GimpContext       *context,
                      GimpProgress      *progress,
                      const GValueArray *args)
{
  gboolean success = TRUE;
  GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

  if (plug_in && plug_in->open)
    success = gimp_plug_in_context_push (plug_in);
  else
    success = FALSE;

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_pop_invoker (GimpProcedure     *procedure,
                     Gimp              *gimp,
                     GimpContext       *context,
                     GimpProgress      *progress,
                     const GValueArray *args)
{
  gboolean success = TRUE;
  GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

  if (plug_in && plug_in->open)
    success = gimp_plug_in_context_pop (plug_in);
  else
    success = FALSE;

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_paint_method_invoker (GimpProcedure     *procedure,
                                  Gimp              *gimp,
                                  GimpContext       *context,
                                  GimpProgress      *progress,
                                  const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpPaintInfo *paint_info = gimp_context_get_paint_info (context);

  if (paint_info)
    name = g_strdup (gimp_object_get_name (GIMP_OBJECT (paint_info)));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_paint_method_invoker (GimpProcedure     *procedure,
                                  Gimp              *gimp,
                                  GimpContext       *context,
                                  GimpProgress      *progress,
                                  const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPaintInfo *paint_info = (GimpPaintInfo *)
        gimp_container_get_child_by_name (gimp->paint_info_list, name);

      if (paint_info)
        gimp_context_set_paint_info (context, paint_info);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_foreground_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  GValueArray *return_vals;
  GimpRGB foreground = { 0.0, 0.0, 0.0, 1.0 };

  gimp_context_get_foreground (context, &foreground);
  gimp_rgb_set_alpha (&foreground, 1.0);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE);
  gimp_value_set_rgb (&return_vals->values[1], &foreground);

  return return_vals;
}

static GValueArray *
context_set_foreground_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  gboolean success = TRUE;
  GimpRGB foreground;

  gimp_value_get_rgb (&args->values[0], &foreground);

  if (success)
    {
      gimp_rgb_set_alpha (&foreground, 1.0);
      gimp_context_set_foreground (context, &foreground);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_background_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  GValueArray *return_vals;
  GimpRGB background = { 0.0, 0.0, 0.0, 1.0 };

  gimp_context_get_background (context, &background);
  gimp_rgb_set_alpha (&background, 1.0);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE);
  gimp_value_set_rgb (&return_vals->values[1], &background);

  return return_vals;
}

static GValueArray *
context_set_background_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  gboolean success = TRUE;
  GimpRGB background;

  gimp_value_get_rgb (&args->values[0], &background);

  if (success)
    {
      gimp_rgb_set_alpha (&background, 1.0);
      gimp_context_set_background (context, &background);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_set_default_colors_invoker (GimpProcedure     *procedure,
                                    Gimp              *gimp,
                                    GimpContext       *context,
                                    GimpProgress      *progress,
                                    const GValueArray *args)
{
  gimp_context_set_default_colors (context);
  return gimp_procedure_get_return_values (procedure, TRUE);
}

static GValueArray *
context_swap_colors_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gimp_context_swap_colors (context);
  return gimp_procedure_get_return_values (procedure, TRUE);
}

static GValueArray *
context_get_opacity_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  GValueArray *return_vals;
  gdouble opacity = 0.0;

  opacity = gimp_context_get_opacity (context) * 100.0;

  return_vals = gimp_procedure_get_return_values (procedure, TRUE);
  g_value_set_double (&return_vals->values[1], opacity);

  return return_vals;
}

static GValueArray *
context_set_opacity_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  gdouble opacity;

  opacity = g_value_get_double (&args->values[0]);

  if (success)
    {
      gimp_context_set_opacity (context, opacity / 100.0);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_paint_mode_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  GValueArray *return_vals;
  gint32 paint_mode = 0;

  paint_mode = gimp_context_get_paint_mode (context);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE);
  g_value_set_enum (&return_vals->values[1], paint_mode);

  return return_vals;
}

static GValueArray *
context_set_paint_mode_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  gboolean success = TRUE;
  gint32 paint_mode;

  paint_mode = g_value_get_enum (&args->values[0]);

  if (success)
    {
      gimp_context_set_paint_mode (context, paint_mode);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_brush_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpBrush *brush = gimp_context_get_brush (context);

  if (brush)
    name = g_strdup (gimp_object_get_name (GIMP_OBJECT (brush)));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_brush_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpBrush *brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush)
        gimp_context_set_brush (context, brush);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_pattern_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpPattern *pattern = gimp_context_get_pattern (context);

  if (pattern)
    name = g_strdup (gimp_object_get_name (GIMP_OBJECT (pattern)));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_pattern_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPattern *pattern = (GimpPattern *)
        gimp_container_get_child_by_name (gimp->pattern_factory->container, name);

      if (pattern)
        gimp_context_set_pattern (context, pattern);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_gradient_invoker (GimpProcedure     *procedure,
                              Gimp              *gimp,
                              GimpContext       *context,
                              GimpProgress      *progress,
                              const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpGradient *gradient = gimp_context_get_gradient (context);

  if (gradient)
    name = g_strdup (gimp_object_get_name (GIMP_OBJECT (gradient)));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_gradient_invoker (GimpProcedure     *procedure,
                              Gimp              *gimp,
                              GimpContext       *context,
                              GimpProgress      *progress,
                              const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpGradient *gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        gimp_context_set_gradient (context, gradient);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_palette_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpPalette *palette = gimp_context_get_palette (context);

  if (palette)
    name = g_strdup (gimp_object_get_name (GIMP_OBJECT (palette)));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_palette_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette)
        gimp_context_set_palette (context, palette);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
context_get_font_invoker (GimpProcedure     *procedure,
                          Gimp              *gimp,
                          GimpContext       *context,
                          GimpProgress      *progress,
                          const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpFont *font = gimp_context_get_font (context);

  if (font)
    name = g_strdup (gimp_object_get_name (GIMP_OBJECT (font)));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_font_invoker (GimpProcedure     *procedure,
                          Gimp              *gimp,
                          GimpContext       *context,
                          GimpProgress      *progress,
                          const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpFont *font = (GimpFont *)
        gimp_container_get_child_by_name (gimp->fonts, name);

      if (font)
        gimp_context_set_font (context, font);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

void
register_context_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-context-push
   */
  procedure = gimp_procedure_new (context_push_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-push");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-push",
                                     "Pushes a context to the top of the plug-in's context stack.",
                                     "This procedure creates a new context by copying the current context. This copy becomes the new current context for the calling plug-in until it is popped again using gimp-context-pop.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-pop
   */
  procedure = gimp_procedure_new (context_pop_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-pop");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-pop",
                                     "Pops the topmost context from the plug-in's context stack.",
                                     "This procedure removes the topmost context from the plug-in's context stack. The context that was active before the corresponding call to gimp-context-push becomes the new current context of the plug-in.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-paint-method
   */
  procedure = gimp_procedure_new (context_get_paint_method_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-paint-method");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-paint-method",
                                     "Retrieve the currently active paint method.",
                                     "This procedure returns the name of the currently active paint method.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active paint method",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-paint-method
   */
  procedure = gimp_procedure_new (context_set_paint_method_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-paint-method");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-paint-method",
                                     "Set the specified paint method as the active paint method.",
                                     "This procedure allows the active paint method to be set by specifying its name. The name is simply a string which corresponds to one of the names of the available paint methods. If there is no matching method found, this procedure will return an error. Otherwise, the specified method becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the paint method",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-foreground
   */
  procedure = gimp_procedure_new (context_get_foreground_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-foreground");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-foreground",
                                     "Get the current GIMP foreground color.",
                                     "This procedure returns the current GIMP foreground color. The foreground color is used in a variety of tools such as paint tools, blending, and bucket fill.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("foreground",
                                                        "foreground",
                                                        "The foreground color",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-foreground
   */
  procedure = gimp_procedure_new (context_set_foreground_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-foreground");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-foreground",
                                     "Set the current GIMP foreground color.",
                                     "This procedure sets the current GIMP foreground color. After this is set, operations which use foreground such as paint tools, blending, and bucket fill will use the new value.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("foreground",
                                                    "foreground",
                                                    "The foreground color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-background
   */
  procedure = gimp_procedure_new (context_get_background_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-background");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-background",
                                     "Get the current GIMP background color.",
                                     "This procedure returns the current GIMP background color. The background color is used in a variety of tools such as blending, erasing (with non-alpha images), and image filling.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("background",
                                                        "background",
                                                        "The background color",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-background
   */
  procedure = gimp_procedure_new (context_set_background_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-background");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-background",
                                     "Set the current GIMP background color.",
                                     "This procedure sets the current GIMP background color. After this is set, operations which use background such as blending, filling images, clearing, and erasing (in non-alpha images) will use the new value.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("background",
                                                    "background",
                                                    "The background color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-default-colors
   */
  procedure = gimp_procedure_new (context_set_default_colors_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-default-colors");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-default-colors",
                                     "Set the current GIMP foreground and background colors to black and white.",
                                     "This procedure sets the current GIMP foreground and background colors to their initial default values, black and white.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-swap-colors
   */
  procedure = gimp_procedure_new (context_swap_colors_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-swap-colors");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-swap-colors",
                                     "Swap the current GIMP foreground and background colors.",
                                     "This procedure swaps the current GIMP foreground and background colors, so that the new foreground color becomes the old background color and vice versa.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-opacity
   */
  procedure = gimp_procedure_new (context_get_opacity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-opacity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-opacity",
                                     "Get the opacity.",
                                     "This procedure returns the opacity setting. The return value is a floating point number between 0 and 100.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("opacity",
                                                        "opacity",
                                                        "The opacity",
                                                        0, 100, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-opacity
   */
  procedure = gimp_procedure_new (context_set_opacity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-opacity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-opacity",
                                     "Set the opacity.",
                                     "This procedure modifies the opacity setting. The value should be a floating point number between 0 and 100.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The opacity",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-paint-mode
   */
  procedure = gimp_procedure_new (context_get_paint_mode_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-paint-mode");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-paint-mode",
                                     "Get the paint mode.",
                                     "This procedure returns the paint-mode setting. The return value is an integer which corresponds to the values listed in the argument description.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("paint-mode",
                                                      "paint mode",
                                                      "The paint mode",
                                                      GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                      GIMP_NORMAL_MODE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-paint-mode
   */
  procedure = gimp_procedure_new (context_set_paint_mode_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-paint-mode");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-paint-mode",
                                     "Set the paint mode.",
                                     "This procedure modifies the paint_mode setting.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("paint-mode",
                                                  "paint mode",
                                                  "The paint mode",
                                                  GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                  GIMP_NORMAL_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush
   */
  procedure = gimp_procedure_new (context_get_brush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-brush");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush",
                                     "Retrieve the currently active brush.",
                                     "This procedure returns the name of the currently active brush. All paint operations and stroke operations use this brush to control the application of paint to the image.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active brush",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush
   */
  procedure = gimp_procedure_new (context_set_brush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-brush");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush",
                                     "Set the specified brush as the active brush.",
                                     "This procedure allows the active brush to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed brushes. If there is no matching brush found, this procedure will return an error. Otherwise, the specified brush becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the brush",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-pattern
   */
  procedure = gimp_procedure_new (context_get_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-pattern");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-pattern",
                                     "Retrieve the currently active pattern.",
                                     "This procedure returns name of the the currently active pattern. All clone and bucket-fill operations with patterns will use this pattern to control the application of paint to the image.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active pattern",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-pattern
   */
  procedure = gimp_procedure_new (context_set_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-pattern");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-pattern",
                                     "Set the specified pattern as the active pattern.",
                                     "This procedure allows the active pattern to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed patterns. If there is no matching pattern found, this procedure will return an error. Otherwise, the specified pattern becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the pattern",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-gradient
   */
  procedure = gimp_procedure_new (context_get_gradient_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-gradient");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-gradient",
                                     "Retrieve the currently active gradient.",
                                     "This procedure returns the name of the currently active gradient.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active gradient",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-gradient
   */
  procedure = gimp_procedure_new (context_set_gradient_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-gradient");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-gradient",
                                     "Sets the specified gradient as the active gradient.",
                                     "This procedure lets you set the specified gradient as the active or \"current\" one. The name is simply a string which corresponds to one of the loaded gradients. If no matching gradient is found, this procedure will return an error. Otherwise, the specified gradient will become active and will be used for subsequent custom gradient operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the gradient",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-palette
   */
  procedure = gimp_procedure_new (context_get_palette_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-palette");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-palette",
                                     "Retrieve the currently active palette.",
                                     "This procedure returns the name of the the currently active palette.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active palette",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-palette
   */
  procedure = gimp_procedure_new (context_set_palette_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-palette");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-palette",
                                     "Set the specified palette as the active palette.",
                                     "This procedure allows the active palette to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed palettes. If no matching palette is found, this procedure will return an error. Otherwise, the specified palette becomes active and will be used in all subsequent palette operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the palette",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-font
   */
  procedure = gimp_procedure_new (context_get_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-get-font");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-font",
                                     "Retrieve the currently active font.",
                                     "This procedure returns the name of the currently active font.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active font",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-font
   */
  procedure = gimp_procedure_new (context_set_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-context-set-font");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-font",
                                     "Set the specified font as the active font.",
                                     "This procedure allows the active font to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed fonts. If no matching font is found, this procedure will return an error. Otherwise, the specified font becomes active and will be used in all subsequent font operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the font",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
