/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <string.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpbrush.h"
#include "core/gimpbrushgenerated.h"
#include "core/gimpcontext.h"
#include "core/gimpdatafactory.h"
#include "core/gimpparamspecs.h"
#include "core/gimptempbuf.h"
#include "gegl/gimp-babl-compat.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GimpValueArray *
brush_new_invoker (GimpProcedure         *procedure,
                   Gimp                  *gimp,
                   GimpContext           *context,
                   GimpProgress          *progress,
                   const GimpValueArray  *args,
                   GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  GimpBrush *brush = NULL;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      brush = (GimpBrush *) gimp_data_factory_data_new (gimp->brush_factory,
                                                        context, name);

      if (! brush)
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), brush);

  return return_vals;
}

static GimpValueArray *
brush_get_by_name_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  GimpBrush *brush = NULL;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      brush = gimp_pdb_get_brush (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (! brush)
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), brush);

  return return_vals;
}

static GimpValueArray *
brush_is_generated_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gboolean generated = FALSE;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      generated = GIMP_IS_BRUSH_GENERATED (brush);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), generated);

  return return_vals;
}

static GimpValueArray *
brush_get_info_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gint width = 0;
  gint height = 0;
  gint mask_bpp = 0;
  gint color_bpp = 0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpTempBuf *mask   = gimp_brush_get_mask (brush);
      GimpTempBuf *pixmap = gimp_brush_get_pixmap (brush);
      const Babl  *format;

      format = gimp_babl_compat_u8_mask_format (
        gimp_temp_buf_get_format (mask));

      width    = gimp_brush_get_width  (brush);
      height   = gimp_brush_get_height (brush);
      mask_bpp = babl_format_get_bytes_per_pixel (format);

      if (pixmap)
        {
          format = gimp_babl_compat_u8_format (
            gimp_temp_buf_get_format (pixmap));

          color_bpp = babl_format_get_bytes_per_pixel (format);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), width);
      g_value_set_int (gimp_value_array_index (return_vals, 2), height);
      g_value_set_int (gimp_value_array_index (return_vals, 3), mask_bpp);
      g_value_set_int (gimp_value_array_index (return_vals, 4), color_bpp);
    }

  return return_vals;
}

static GimpValueArray *
brush_get_pixels_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gint width = 0;
  gint height = 0;
  gint mask_bpp = 0;
  GBytes *mask_bytes = NULL;
  gint color_bpp = 0;
  GBytes *color_bytes = NULL;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpTempBuf *mask   = gimp_brush_get_mask (brush);
      GimpTempBuf *pixmap = gimp_brush_get_pixmap (brush);
      const Babl  *format;
      gpointer     data;
      gsize        num_mask_bytes;
      gsize        num_color_bytes;

      format = gimp_babl_compat_u8_mask_format (
        gimp_temp_buf_get_format (mask));
      data   = gimp_temp_buf_lock (mask, format, GEGL_ACCESS_READ);

      width          = gimp_temp_buf_get_width  (mask);
      height         = gimp_temp_buf_get_height (mask);
      mask_bpp       = babl_format_get_bytes_per_pixel (format);
      num_mask_bytes = gimp_temp_buf_get_height (mask) *
                       gimp_temp_buf_get_width  (mask) * mask_bpp;
      mask_bytes     = g_bytes_new (data, num_mask_bytes);

      gimp_temp_buf_unlock (mask, data);

      if (pixmap)
        {
          format = gimp_babl_compat_u8_format (
            gimp_temp_buf_get_format (pixmap));
          data   = gimp_temp_buf_lock (pixmap, format, GEGL_ACCESS_READ);

          color_bpp       = babl_format_get_bytes_per_pixel (format);
          num_color_bytes = gimp_temp_buf_get_height (pixmap) *
                            gimp_temp_buf_get_width  (pixmap) *
                            color_bpp;
          color_bytes     = g_bytes_new (data, num_color_bytes);

          gimp_temp_buf_unlock (pixmap, data);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), width);
      g_value_set_int (gimp_value_array_index (return_vals, 2), height);
      g_value_set_int (gimp_value_array_index (return_vals, 3), mask_bpp);
      g_value_take_boxed (gimp_value_array_index (return_vals, 4), mask_bytes);
      g_value_set_int (gimp_value_array_index (return_vals, 5), color_bpp);
      g_value_take_boxed (gimp_value_array_index (return_vals, 6), color_bytes);
    }

  return return_vals;
}

static GimpValueArray *
brush_get_spacing_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gint spacing = 0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      spacing = gimp_brush_get_spacing (brush);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), spacing);

  return return_vals;
}

static GimpValueArray *
brush_set_spacing_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpBrush *brush;
  gint spacing;

  brush = g_value_get_object (gimp_value_array_index (args, 0));
  spacing = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      if (gimp_data_is_writable (GIMP_DATA (brush)))
        gimp_brush_set_spacing (brush, spacing);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
brush_get_shape_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gint shape = 0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush))
        shape = GIMP_BRUSH_GENERATED (brush)->shape;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), shape);

  return return_vals;
}

static GimpValueArray *
brush_set_shape_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gint shape_in;
  gint shape_out = 0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));
  shape_in = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush) &&
          gimp_data_is_writable (GIMP_DATA (brush)))
        {
          gimp_brush_generated_set_shape (GIMP_BRUSH_GENERATED (brush),
                                          shape_in);
          shape_out = GIMP_BRUSH_GENERATED (brush)->shape;
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), shape_out);

  return return_vals;
}

static GimpValueArray *
brush_get_radius_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gdouble radius = 0.0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush))
        radius = GIMP_BRUSH_GENERATED (brush)->radius;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), radius);

  return return_vals;
}

static GimpValueArray *
brush_set_radius_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gdouble radius_in;
  gdouble radius_out = 0.0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));
  radius_in = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush) &&
          gimp_data_is_writable (GIMP_DATA (brush)))
        {
          gimp_brush_generated_set_radius (GIMP_BRUSH_GENERATED (brush),
                                           radius_in);
          radius_out = GIMP_BRUSH_GENERATED (brush)->radius;
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), radius_out);

  return return_vals;
}

static GimpValueArray *
brush_get_spikes_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gint spikes = 0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush))
        spikes = GIMP_BRUSH_GENERATED (brush)->spikes;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), spikes);

  return return_vals;
}

static GimpValueArray *
brush_set_spikes_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gint spikes_in;
  gint spikes_out = 0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));
  spikes_in = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush) &&
          gimp_data_is_writable (GIMP_DATA (brush)))
        {
          gimp_brush_generated_set_spikes (GIMP_BRUSH_GENERATED (brush),
                                           spikes_in);
          spikes_out = GIMP_BRUSH_GENERATED (brush)->spikes;
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), spikes_out);

  return return_vals;
}

static GimpValueArray *
brush_get_hardness_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gdouble hardness = 0.0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush))
        hardness = GIMP_BRUSH_GENERATED (brush)->hardness;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), hardness);

  return return_vals;
}

static GimpValueArray *
brush_set_hardness_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gdouble hardness_in;
  gdouble hardness_out = 0.0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));
  hardness_in = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush) &&
          gimp_data_is_writable (GIMP_DATA (brush)))
        {
          gimp_brush_generated_set_hardness (GIMP_BRUSH_GENERATED (brush),
                                             hardness_in);
          hardness_out = GIMP_BRUSH_GENERATED (brush)->hardness;
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), hardness_out);

  return return_vals;
}

static GimpValueArray *
brush_get_aspect_ratio_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gdouble aspect_ratio = 0.0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush))
        aspect_ratio = GIMP_BRUSH_GENERATED (brush)->aspect_ratio;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), aspect_ratio);

  return return_vals;
}

static GimpValueArray *
brush_set_aspect_ratio_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gdouble aspect_ratio_in;
  gdouble aspect_ratio_out = 0.0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));
  aspect_ratio_in = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush) &&
          gimp_data_is_writable (GIMP_DATA (brush)))
        {
          gimp_brush_generated_set_aspect_ratio (GIMP_BRUSH_GENERATED (brush),
                                                 aspect_ratio_in);
          aspect_ratio_out = GIMP_BRUSH_GENERATED (brush)->aspect_ratio;
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), aspect_ratio_out);

  return return_vals;
}

static GimpValueArray *
brush_get_angle_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gdouble angle = 0.0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush))
        angle = GIMP_BRUSH_GENERATED (brush)->angle;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), angle);

  return return_vals;
}

static GimpValueArray *
brush_set_angle_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpBrush *brush;
  gdouble angle_in;
  gdouble angle_out = 0.0;

  brush = g_value_get_object (gimp_value_array_index (args, 0));
  angle_in = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      if (GIMP_IS_BRUSH_GENERATED (brush) &&
          gimp_data_is_writable (GIMP_DATA (brush)))
        {
          gimp_brush_generated_set_angle (GIMP_BRUSH_GENERATED (brush),
                                          angle_in);
          angle_out = GIMP_BRUSH_GENERATED (brush)->angle;
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), angle_out);

  return return_vals;
}

void
register_brush_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-brush-new
   */
  procedure = gimp_procedure_new (brush_new_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-new");
  gimp_procedure_set_static_help (procedure,
                                  "Create a new generated brush having default parameters.",
                                  "Creates a new, parametric brush.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The requested name of the new brush",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_brush ("brush",
                                                          "brush",
                                                          "The brush",
                                                          FALSE,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-by-name
   */
  procedure = gimp_procedure_new (brush_get_by_name_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-by-name");
  gimp_procedure_set_static_help (procedure,
                                  "Returns the brush with the given name.",
                                  "Returns the brush with the given name.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the brush",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_brush ("brush",
                                                          "brush",
                                                          "The brush",
                                                          FALSE,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-is-generated
   */
  procedure = gimp_procedure_new (brush_is_generated_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-is-generated");
  gimp_procedure_set_static_help (procedure,
                                  "Whether the brush is generated (parametric versus raster).",
                                  "Returns TRUE when brush is parametric.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("generated",
                                                         "generated",
                                                         "TRUE if the brush is generated",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-info
   */
  procedure = gimp_procedure_new (brush_get_info_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-info");
  gimp_procedure_set_static_help (procedure,
                                  "Gets information about the brush.",
                                  "Gets information about the brush: brush extents (width and height), color depth and mask depth (bpp). The color bpp is zero when the brush is parametric versus raster.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("width",
                                                     "width",
                                                     "The brush width",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("height",
                                                     "height",
                                                     "The brush height",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("mask-bpp",
                                                     "mask bpp",
                                                     "The brush mask bpp",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("color-bpp",
                                                     "color bpp",
                                                     "The brush color bpp",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-pixels
   */
  procedure = gimp_procedure_new (brush_get_pixels_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-pixels");
  gimp_procedure_set_static_help (procedure,
                                  "Gets information about the brush.",
                                  "Gets information about the brush: the brush extents (width and height) and its pixels data. The color bpp is zero and pixels empty when the brush is parametric versus raster.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("width",
                                                     "width",
                                                     "The brush width",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("height",
                                                     "height",
                                                     "The brush height",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("mask-bpp",
                                                     "mask bpp",
                                                     "The brush mask bpp",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boxed ("mask-bytes",
                                                       "mask bytes",
                                                       "The brush mask data",
                                                       G_TYPE_BYTES,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("color-bpp",
                                                     "color bpp",
                                                     "The brush color bpp",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boxed ("color-bytes",
                                                       "color bytes",
                                                       "The brush color data",
                                                       G_TYPE_BYTES,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-spacing
   */
  procedure = gimp_procedure_new (brush_get_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-spacing");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the brush spacing, the stamping frequency.",
                                  "Returns the spacing setting for the brush. Spacing is an integer between 0 and 1000 which represents a percentage of the maximum of the width and height of the mask. Both parametric and raster brushes have a spacing.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("spacing",
                                                     "spacing",
                                                     "The brush spacing",
                                                     0, 1000, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-set-spacing
   */
  procedure = gimp_procedure_new (brush_set_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-set-spacing");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the brush spacing.",
                                  "Set the spacing for the brush. The spacing must be an integer between 0 and 1000. Both parametric and raster brushes have a spacing. Returns an error when the brush is not editable. Create a new or copied brush or to get an editable brush.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("spacing",
                                                 "spacing",
                                                 "The brush spacing",
                                                 0, 1000, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-shape
   */
  procedure = gimp_procedure_new (brush_get_shape_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-shape");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the shape of a generated brush.",
                                  "Gets the shape of a generated brush. Returns an error when called for a non-parametric brush. The choices for shape are Circle (GIMP_BRUSH_GENERATED_CIRCLE), Square (GIMP_BRUSH_GENERATED_SQUARE), and Diamond (GIMP_BRUSH_GENERATED_DIAMOND). Other shapes might be added in the future.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("shape",
                                                      "shape",
                                                      "The brush shape",
                                                      GIMP_TYPE_BRUSH_GENERATED_SHAPE,
                                                      GIMP_BRUSH_GENERATED_CIRCLE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-set-shape
   */
  procedure = gimp_procedure_new (brush_set_shape_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-set-shape");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the shape of a generated brush.",
                                  "Sets the shape of a generated brush. Returns an error when brush is non-parametric or not editable. The choices for shape are Circle (GIMP_BRUSH_GENERATED_CIRCLE), Square (GIMP_BRUSH_GENERATED_SQUARE), and Diamond (GIMP_BRUSH_GENERATED_DIAMOND).",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("shape-in",
                                                  "shape in",
                                                  "The brush shape",
                                                  GIMP_TYPE_BRUSH_GENERATED_SHAPE,
                                                  GIMP_BRUSH_GENERATED_CIRCLE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("shape-out",
                                                      "shape out",
                                                      "The brush shape actually assigned",
                                                      GIMP_TYPE_BRUSH_GENERATED_SHAPE,
                                                      GIMP_BRUSH_GENERATED_CIRCLE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-radius
   */
  procedure = gimp_procedure_new (brush_get_radius_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-radius");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the radius of a generated brush.",
                                  "Gets the radius of a generated brush. Returns an error when called for a non-parametric brush.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("radius",
                                                        "radius",
                                                        "The radius of the brush in pixels",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-set-radius
   */
  procedure = gimp_procedure_new (brush_set_radius_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-set-radius");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the radius of a generated brush.",
                                  "Sets the radius for a generated brush. Clamps radius to [0.0, 32767.0]. Returns the clamped value. Returns an error when brush is non-parametric or not editable.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("radius-in",
                                                    "radius in",
                                                    "The desired brush radius in pixel",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("radius-out",
                                                        "radius out",
                                                        "The brush radius actually assigned",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-spikes
   */
  procedure = gimp_procedure_new (brush_get_spikes_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-spikes");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the number of spikes for a generated brush.",
                                  "Gets the number of spikes for a generated brush. Returns an error when called for a non-parametric brush.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("spikes",
                                                     "spikes",
                                                     "The number of spikes on the brush.",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-set-spikes
   */
  procedure = gimp_procedure_new (brush_set_spikes_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-set-spikes");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the number of spikes for a generated brush.",
                                  "Sets the number of spikes for a generated brush. Clamps spikes to [2,20]. Returns the clamped value. Returns an error when brush is non-parametric or not editable.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("spikes-in",
                                                 "spikes in",
                                                 "The desired number of spikes",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("spikes-out",
                                                     "spikes out",
                                                     "The number of spikes actually assigned",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-hardness
   */
  procedure = gimp_procedure_new (brush_get_hardness_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-hardness");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the hardness of a generated brush.",
                                  "Gets the hardness of a generated brush. The hardness of a brush is the amount its intensity fades at the outside edge, as a float between 0.0 and 1.0. Returns an error when called for a non-parametric brush.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("hardness",
                                                        "hardness",
                                                        "The hardness of the brush.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-set-hardness
   */
  procedure = gimp_procedure_new (brush_set_hardness_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-set-hardness");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the hardness of a generated brush.",
                                  "Sets the hardness for a generated brush. Clamps hardness to [0.0, 1.0]. Returns the clamped value. Returns an error when brush is non-parametric or not editable.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("hardness-in",
                                                    "hardness in",
                                                    "The desired brush hardness",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("hardness-out",
                                                        "hardness out",
                                                        "The brush hardness actually assigned",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-aspect-ratio
   */
  procedure = gimp_procedure_new (brush_get_aspect_ratio_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-aspect-ratio");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the aspect ratio of a generated brush.",
                                  "Gets the aspect ratio of a generated brush. Returns an error when called for a non-parametric brush. The aspect ratio is a float between 0.0 and 1000.0.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("aspect-ratio",
                                                        "aspect ratio",
                                                        "The aspect ratio of the brush.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-set-aspect-ratio
   */
  procedure = gimp_procedure_new (brush_set_aspect_ratio_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-set-aspect-ratio");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the aspect ratio of a generated brush.",
                                  "Sets the aspect ratio for a generated brush. Clamps aspect ratio to [0.0, 1000.0]. Returns the clamped value. Returns an error when brush is non-parametric or not editable.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("aspect-ratio-in",
                                                    "aspect ratio in",
                                                    "The desired brush aspect ratio",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("aspect-ratio-out",
                                                        "aspect ratio out",
                                                        "The brush aspect ratio actually assigned",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-get-angle
   */
  procedure = gimp_procedure_new (brush_get_angle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-get-angle");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the rotation angle of a generated brush.",
                                  "Gets the angle of rotation for a generated brush. Returns an error when called for a non-parametric brush.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("angle",
                                                        "angle",
                                                        "The rotation angle of the brush in degree.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-brush-set-angle
   */
  procedure = gimp_procedure_new (brush_set_angle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-brush-set-angle");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the rotation angle of a generated brush.",
                                  "Sets the rotation angle for a generated brush. Sets the angle modulo 180, in the range [-180.0, 180.0]. Returns the clamped value. Returns an error when brush is non-parametric or not editable.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_brush ("brush",
                                                      "brush",
                                                      "The brush",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("angle-in",
                                                    "angle in",
                                                    "The desired brush rotation angle in degrees",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("angle-out",
                                                        "angle out",
                                                        "The brush rotation angle actually assigned",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
