/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_HTREE_ITEM_H__
#define __GTK_HTREE_ITEM_H__


#include <gdk/gdk.h>

#include "gtktreeitem.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_HTREE_ITEM(obj)          GTK_CHECK_CAST (obj, gtk_htree_item_get_type (), GtkHTreeItem)
#define GTK_HTREE_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_htree_item_get_type (), GtkHTreeItemClass)
#define GTK_IS_HTREE_ITEM(obj)       GTK_CHECK_TYPE (obj, gtk_htree_item_get_type ())


typedef struct _GtkHTreeItem       GtkHTreeItem;
typedef struct _GtkHTreeItemClass  GtkHTreeItemClass;

struct _GtkHTreeItem
{
  GtkTreeItem item;
};

struct _GtkHTreeItemClass
{
  GtkTreeItemClass parent_class;
};


guint      gtk_htree_item_get_type         (void);
GtkWidget* gtk_htree_item_new              (void);
GtkWidget* gtk_htree_item_new_with_label   (const gchar         *label);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_HTREE_ITEM_H__ */
