/* gtkcombo - combo widget for gtk+
 * Copyright 1997 Paolo Molaro
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include "gtkcombo.h"

void do_exit() {
	gtk_exit(0);
}

gchar* 
get_string (GtkWidget* w) {
	GtkBox* box;
	GtkLabel* label;
	gchar* text = NULL;

	box = GTK_BOX(GTK_BIN(w)->child); 
	/* get the text of the first column */
	label = GTK_LABEL(((GtkBoxChild*)box->children->data)->widget);
	gtk_label_get(label, &text);

	return text;
}

int main(int argc, char* argv[]) {
	GtkWidget* win;
	GtkWidget* combo;
	GtkWidget* label;
	GtkWidget* vbox;
	GtkWidget* hbox;
	GtkWidget* li;
	GList* list = NULL;
	gint i;
	char * items1[]= {"mele", "pere", "bicocche", "arance", "limoni", 
		"banane", "spierciuli", "noccioline mericane", "noci carniche",
		"ciribattole", "finferli", "catachiurli", "regarnardi"};
	gint nitems1 = 13;
	char * items2[] = {"Rosencrantz", "column2", "Gildenstern", "column2", "A", "B"};
	gint nitems2 = 6;
	char * items3[] = {"A very long label to trigger horizontal scrollbar"};
	gint nitems3 = 1;

	gtk_init(&argc, &argv);
	win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	combo = gtk_combo_new();
	gtk_combo_set_use_arrows_always(GTK_COMBO(combo), TRUE);
	for (i=0; i < nitems1; ++i) {
		li = gtk_list_item_new_with_label(items1[i]);
		gtk_widget_show(li);
		list = g_list_append(list, li);
	}
	gtk_list_append_items(GTK_LIST(GTK_COMBO(combo)->list), list);
	list = NULL;
	gtk_widget_show(combo);
	vbox = gtk_vbox_new(0, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(win), vbox);
	label = gtk_label_new("Test per GtkCombo");
	gtk_widget_show(label);
	gtk_container_add(GTK_CONTAINER(vbox), label);
	gtk_container_add(GTK_CONTAINER(vbox), combo);
	label = gtk_label_new("Test per GtkCombo n2");
	gtk_widget_show(label);
	gtk_container_add(GTK_CONTAINER(vbox), label);
	combo = gtk_combo_new();
	gtk_container_border_width(GTK_CONTAINER(GTK_COMBO(combo)->popup), 10);
	gtk_combo_set_get_string_func(GTK_COMBO(combo), get_string);
	for (i=0; i+1 < nitems2; i+=2) {
		hbox = gtk_hbox_new(0, 2);
		gtk_widget_show(hbox);
		li = gtk_list_item_new();
		gtk_widget_show(li);
		gtk_container_add(GTK_CONTAINER(li), hbox);
		label = gtk_label_new(items2[i]);
		gtk_widget_show(label);
		gtk_box_pack_start(GTK_BOX(hbox), label, 0, 0, 2);
		label = gtk_label_new(items2[i+1]);
		gtk_widget_show(label);
		gtk_box_pack_end(GTK_BOX(hbox), label, 0, 0, 2);
		list = g_list_append(list, li);
	}
	gtk_list_append_items(GTK_LIST(GTK_COMBO(combo)->list), list);
	list = NULL;
	gtk_combo_set_value_in_list(GTK_COMBO(combo), TRUE, TRUE);
	gtk_combo_set_use_arrows(GTK_COMBO(combo), FALSE);
	gtk_widget_show(combo);
	gtk_container_add(GTK_CONTAINER(vbox), combo);
	combo = gtk_combo_new();
	for (i=0; i < nitems3; ++i) {
		li = gtk_list_item_new_with_label(items3[i]);
		gtk_widget_show(li);
		list = g_list_append(list, li);
	}
	gtk_list_append_items(GTK_LIST(GTK_COMBO(combo)->list), list);
	list = NULL;
	gtk_widget_show(combo);
	gtk_container_add(GTK_CONTAINER(vbox), combo);
	combo = gtk_combo_new();
	list = g_list_append(list, gtk_list_item_new_with_label("Intentionally not show:-)"));
	gtk_list_append_items(GTK_LIST(GTK_COMBO(combo)->list), list);
	gtk_widget_show(combo);
	gtk_container_add(GTK_CONTAINER(vbox), combo);

	gtk_signal_connect(GTK_OBJECT(win), "destroy", do_exit, NULL);
	gtk_signal_connect(GTK_OBJECT(win), "delete_event", do_exit, NULL);
	gtk_widget_show(win);
	gtk_main();
	return 0;

}

