/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1998-1999 Adrian E. Feiguin <adrian@ifir.ifir.edu.ar>
 *
 * GtkSheetEntry widget by Adrian E. Feiguin
 * Based on GtkEntry widget 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_SHENTRY_H__
#define __GTK_SHENTRY_H__


#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_SHENTRY(obj)          GTK_CHECK_CAST (obj, gtk_shentry_get_type (), GtkSHEntry)
#define GTK_SHENTRY_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_shentry_get_type (), GtkSHEntryClass)
#define GTK_IS_SHENTRY(obj)       GTK_CHECK_TYPE (obj, gtk_shentry_get_type ())


typedef struct _GtkSHEntry       GtkSHEntry;
typedef struct _GtkSHEntryClass  GtkSHEntryClass;

struct _GtkSHEntry
{
  GtkWidget widget;

  GdkWindow *text_area;
  GdkPixmap *backing_pixmap;
  GdkCursor *cursor;
  gchar *text;

  guint justification;

  GdkGC *fg_gc;
  GdkGC *bg_gc;

  guint16 text_size;
  guint16 text_length;
  guint16 text_max_length;
  guint16 text_max_size;
  gint16  current_pos;
  gint16  selection_start_pos;
  gint16  selection_end_pos;
  gint16  scroll_offset;
  guint   have_selection : 1;
  guint   visible : 1;
  guint   editable : 1;
  guint32 timer;
  GdkIC   ic;

  gchar *clipboard_text;
};

struct _GtkSHEntryClass
{
  GtkWidgetClass parent_class;

  void (* insert_text)  (GtkSHEntry    *shentry,
			 const gchar *text,
			 gint         length,
			 gint        *position);
  void (* delete_text)  (GtkSHEntry    *shentry,
			 gint         start_pos,
			 gint         end_pos);
  void (* changed)      (GtkSHEntry    *shentry);
  void (* set_text)     (GtkSHEntry    *shentry);
  void (* activate)     (GtkSHEntry    *shentry,
                         GdkEventKey *keyvalue);
};

guint      gtk_shentry_get_type       (void);
GtkWidget* gtk_shentry_new            (void);
GtkWidget* gtk_shentry_new_with_max_length (guint16   max);
void       gtk_shentry_set_text       (GtkSHEntry      *shentry,
				     const gchar   *text,
                                     guint          justification);
void       gtk_shentry_append_text    (GtkSHEntry      *shentry,
				     const gchar   *text);
void       gtk_shentry_prepend_text   (GtkSHEntry      *shentry,
				     const gchar   *text);
void       gtk_shentry_set_position   (GtkSHEntry      *shentry,
				     gint           position);
gchar*     gtk_shentry_get_text       (GtkSHEntry      *shentry);
void       gtk_shentry_select_region  (GtkSHEntry      *shentry,
				     gint           start,
				     gint           end);
void       gtk_shentry_set_visibility (GtkSHEntry      *shentry,
				     gboolean       visible);
void       gtk_shentry_set_editable   (GtkSHEntry      *shentry,
				     gboolean       editable);

/* If shentry->text is already > max it's up to you to change it */
void       gtk_shentry_set_max_length (GtkSHEntry      *shentry,
                                     guint16        max);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_SHENTRY_H__ */
