#include <GToolKit/GToolKit.h>
#include <Foundation/NSAutoreleasePool.h>

@interface Foo : NSObject
{
    GTKHScale *scale;
    GTKEntry *entry;
}
- (void) updateEntry:sender;
- (void) updateScale:sender;
- (void) showDialog:sender;
@end

@implementation Foo

- init
{
    GTKWindow *window;
    GTKVBox *box;
    GTKAdjustment *adjust;
    GTKButton *button;

    [super init];

    adjust = [GTKAdjustment adjustmentWithValue:50 lower:0 upper:100
	      stepIncrement:1 pageIncrement:10 pageSize:0];
    box = [GTKVBox vBoxWithHomogeneous:YES spacing:10];
    scale = [GTKHScale hScaleWithAdjustment:adjust];
    entry = [GTKEntry entry];
    button = [GTKButton buttonWithLabel:@"Colors..."];
    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];

    [box packStartDefaults:scale];
    [box packStartDefaults:entry];
    [box packStartDefaults:button];
    [window borderWidth:10];
    [window add:box];
    [window show];

    [window connectSignal:@"destroy" withTarget:GTKApp
	    sel:@selector(terminate:)];
    [adjust connectSignal:@"value_changed" withTarget:self
	    sel:@selector(updateEntry:)];
    [entry  connectSignal:@"changed" withTarget:self
	    sel:@selector(updateScale:)];
    [button connectSignal:@"clicked" withTarget:self
	    sel:@selector(showDialog:)];
    return self;
}

- (void) updateEntry:sender
{
    [entry setDoubleValue:[sender getValue]];
}

- (void) updateScale:sender
{
    [scale setDoubleValue:[sender doubleValue]];
}

- (void) showDialog:sender
{
    [[GTKColorSelectionDialog colorSelectionDialogWithTitle:@"Choose Color"]
	show];
}
@end

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];
    [[Foo new] autorelease];

    [GTKApp run];
    [pool release];
    return 0;
}
