#include <GToolKit/GToolKit.h>

@implementation GTKAcceleratorTable
+ acceleratorTable
{
    return [[(GTKAcceleratorTable *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_accelerator_table_new()];
}
+ (GTKAcceleratorTable*) find:(GTKObject	*) object signalName:(const NSString *) signal_name acceleratorKey:(guchar) accelerator_key acceleratorMods:(guint8) accelerator_mods
{
    return Gtk_to_Object(gtk_accelerator_table_find([ object  gtk],NSString_to_String( signal_name ), accelerator_key , accelerator_mods), "GTKAcceleratorTable");
}
- (GTKAcceleratorTable *) ref
{
    return Gtk_to_Object(gtk_accelerator_table_ref(gtk), "GTKAcceleratorTable");
}
- (void) unref
{
    gtk_accelerator_table_unref(gtk);
}
- (void) install:(GTKObject *) object signalName:(const NSString *) signal_name acceleratorKey:(guchar) accelerator_key acceleratorMods:(guint8) accelerator_mods
{
    gtk_accelerator_table_install(gtk,[ object  gtk],NSString_to_String( signal_name ), accelerator_key , accelerator_mods);
}
- (void) remove:(GTKObject *) object signalName:(const NSString *) signal_name
{
    gtk_accelerator_table_remove(gtk,[ object  gtk],NSString_to_String( signal_name));
}
- (gint) check:(const guchar) accelerator_key acceleratorMods:(guint8) accelerator_mods
{
    return gtk_accelerator_table_check(gtk, accelerator_key , accelerator_mods);
}
- (void) setModMask:(guint8) modifier_mask
{
    gtk_accelerator_table_set_mod_mask(gtk, modifier_mask);
}
#define gtk	((GtkAcceleratorTable *) gtk)
 - (oneway void) release
{
    unsigned ref_count = gtk->ref_count;

#ifdef DEBUG
    if (ref_count == 0) g_error("ref_count == 0 in " __FILE__ " (release)");
#endif
    [self unref];
    if (ref_count == 1) [self dealloc];
}
 - retain
{
    if (gtk) [self ref];
    return self;
}
 - (unsigned) retainCount
{
    return gtk->ref_count;
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKAdjustment
+ (GtkType) getType
{
    return gtk_adjustment_get_type();
}
+ adjustmentWithValue:(gfloat) value lower:(gfloat) lower upper:(gfloat) upper stepIncrement:(gfloat) step_increment pageIncrement:(gfloat) page_increment pageSize:(gfloat) page_size
{
    return [[(GTKAdjustment *)[self alloc] initWithValue:value lower:lower upper:upper stepIncrement:step_increment pageIncrement:page_increment pageSize:page_size] autorelease];
}
- initWithValue:(gfloat) value lower:(gfloat) lower upper:(gfloat) upper stepIncrement:(gfloat) step_increment pageIncrement:(gfloat) page_increment pageSize:(gfloat) page_size
{
    return [self initWithGtk:gtk_adjustment_new( value , lower , upper , step_increment , page_increment , page_size)];
}
- (void) setValue:(gfloat) value
{
    gtk_adjustment_set_value(gtk, value);
}
- (void) clampPage:(gfloat) lower upper:(gfloat) upper
{
    gtk_adjustment_clamp_page(gtk, lower , upper);
}
#define gtk	((GtkAdjustment *) gtk)
- (gfloat) getValue
{
    return gtk->value;
}
- (void) setLower:(gfloat) lower upper:(gfloat) upper stepIncrement:(gfloat) step_increment pageIncrement:(gfloat) page_increment pageSize:(gfloat) page_size
{
    gtk->lower = lower;
    gtk->upper = upper;
    gtk->step_increment = step_increment;
    gtk->page_increment = page_increment;
    gtk->page_size = page_size;
}
- (void) getLower:(gfloat *) lower upper:(gfloat *) upper stepIncrement:(gfloat *) step_increment pageIncrement:(gfloat *) page_increment pageSize:(gfloat *) page_size
{
    *lower = gtk->lower;
    *upper = gtk->upper;
    *step_increment = gtk->step_increment;
    *page_increment = gtk->page_increment;
    *page_size = gtk->page_size;
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKAlignment
+ (guint) getType
{
    return gtk_alignment_get_type();
}
+ alignmentWithXalign:(gfloat) xalign yalign:(gfloat) yalign xscale:(gfloat) xscale yscale:(gfloat) yscale
{
    return [[(GTKAlignment *)[self alloc] initWithXalign:xalign yalign:yalign xscale:xscale yscale:yscale] autorelease];
}
- initWithXalign:(gfloat) xalign yalign:(gfloat) yalign xscale:(gfloat) xscale yscale:(gfloat) yscale
{
    return [self initWithGtk:gtk_alignment_new( xalign , yalign , xscale , yscale)];
}
- (void) set:(gfloat) xalign yalign:(gfloat) yalign xscale:(gfloat) xscale yscale:(gfloat) yscale
{
    gtk_alignment_set(gtk, xalign , yalign , xscale , yscale);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKArrow
+ (guint) getType
{
    return gtk_arrow_get_type();
}
+ arrowWithArrowType:(GtkArrowType) arrow_type shadowType:(GtkShadowType) shadow_type
{
    return [[(GTKArrow *)[self alloc] initWithArrowType:arrow_type shadowType:shadow_type] autorelease];
}
- initWithArrowType:(GtkArrowType) arrow_type shadowType:(GtkShadowType) shadow_type
{
    return [self initWithGtk:gtk_arrow_new( arrow_type , shadow_type)];
}
- (void) set:(GtkArrowType) arrow_type shadowType:(GtkShadowType) shadow_type
{
    gtk_arrow_set(gtk, arrow_type , shadow_type);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKAspectFrame
+ (GtkType) getType
{
    return gtk_aspect_frame_get_type();
}
+ aspectFrameWithLabel:(const NSString *) label xalign:(gfloat) xalign yalign:(gfloat) yalign ratio:(gfloat) ratio obeyChild:(gint) obey_child
{
    return [[(GTKAspectFrame *)[self alloc] initWithLabel:label xalign:xalign yalign:yalign ratio:ratio obeyChild:obey_child] autorelease];
}
- initWithLabel:(const NSString *) label xalign:(gfloat) xalign yalign:(gfloat) yalign ratio:(gfloat) ratio obeyChild:(gint) obey_child
{
    return [self initWithGtk:gtk_aspect_frame_new(NSString_to_String( label ), xalign , yalign , ratio , obey_child)];
}
- (void) set:(gfloat) xalign yalign:(gfloat) yalign ratio:(gfloat) ratio obeyChild:(gint) obey_child
{
    gtk_aspect_frame_set(gtk, xalign , yalign , ratio , obey_child);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKButtonBox
+ (guint) getType
{
    return gtk_button_box_get_type();
}
+ (void) getChildSizeDefault:(gint *) min_width minHeight:(gint *) min_height
{
    gtk_button_box_get_child_size_default( min_width , min_height);
}
+ (void) getChildIpaddingDefault:(gint *) ipad_x ipadY:(gint *) ipad_y
{
    gtk_button_box_get_child_ipadding_default( ipad_x , ipad_y);
}
+ (void) setChildSizeDefault:(gint) min_width minHeight:(gint) min_height
{
    gtk_button_box_set_child_size_default( min_width , min_height);
}
+ (void) setChildIpaddingDefault:(gint) ipad_x ipadY:(gint) ipad_y
{
    gtk_button_box_set_child_ipadding_default( ipad_x , ipad_y);
}
- (gint) getSpacing
{
    return gtk_button_box_get_spacing(gtk);
}
- (GtkButtonBoxStyle) getLayout
{
    return gtk_button_box_get_layout(gtk);
}
- (void) getChildSize:(gint *) min_width minHeight:(gint *) min_height
{
    gtk_button_box_get_child_size(gtk, min_width , min_height);
}
- (void) getChildIpadding:(gint *) ipad_x ipadY:(gint *) ipad_y
{
    gtk_button_box_get_child_ipadding(gtk, ipad_x , ipad_y);
}
- (void) setSpacing:(gint) spacing
{
    gtk_button_box_set_spacing(gtk, spacing);
}
- (void) setLayout:(GtkButtonBoxStyle) layout_style
{
    gtk_button_box_set_layout(gtk, layout_style);
}
- (void) setChildSize:(gint) min_width minHeight:(gint) min_height
{
    gtk_button_box_set_child_size(gtk, min_width , min_height);
}
- (void) setChildIpadding:(gint) ipad_x ipadY:(gint) ipad_y
{
    gtk_button_box_set_child_ipadding(gtk, ipad_x , ipad_y);
}
+ (void) childRequisition:(GTKWidget *) widget nvisChildren:(int *) nvis_children width:(int *) width height:(int *) height
{
    gtk_button_box_child_requisition([ widget  gtk], nvis_children , width , height);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKBin
+ (guint) getType
{
    return gtk_bin_get_type();
}
#define gtk	((GtkBin *) gtk)
- child
{
    return Gtk_to_Object(gtk->child, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKBox
+ (guint) getType
{
    return gtk_box_get_type();
}
- (void) packStart:(GTKWidget *) child expand:(gint) expand fill:(gint) fill padding:(gint) padding
{
    gtk_box_pack_start(gtk,[ child  gtk], expand , fill , padding);
}
- (void) packEnd:(GTKWidget *) child expand:(gint) expand fill:(gint) fill padding:(gint) padding
{
    gtk_box_pack_end(gtk,[ child  gtk], expand , fill , padding);
}
- (void) packStartDefaults:(GTKWidget *) widget
{
    gtk_box_pack_start_defaults(gtk,[ widget gtk]);
}
- (void) packEndDefaults:(GTKWidget *) widget
{
    gtk_box_pack_end_defaults(gtk,[ widget gtk]);
}
- (void) setHomogeneous:(gint) homogeneous
{
    gtk_box_set_homogeneous(gtk, homogeneous);
}
- (void) setSpacing:(gint) spacing
{
    gtk_box_set_spacing(gtk, spacing);
}
- (void) reorderChild:(GTKWidget *) child pos:(guint) pos
{
    gtk_box_reorder_child(gtk,[ child  gtk], pos);
}
- (void) queryChildPacking:(GTKWidget *) child expand:(gint *) expand fill:(gint *) fill padding:(gint *) padding packType:(GtkPackType *) pack_type
{
    gtk_box_query_child_packing(gtk,[ child  gtk], expand , fill , padding , pack_type);
}
- (void) setChildPacking:(GTKWidget *) child expand:(gint) expand fill:(gint) fill padding:(gint) padding packType:(GtkPackType) pack_type
{
    gtk_box_set_child_packing(gtk,[ child  gtk], expand , fill , padding , pack_type);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKButton
+ (GtkType) getType
{
    return gtk_button_get_type();
}
+ button
{
    return [[(GTKButton *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_button_new()];
}
+ buttonWithLabel:(const NSString *) label
{
    return [[(GTKButton *)[self alloc] initWithLabel:label] autorelease];
}
- initWithLabel:(const NSString *) label
{
    return [self initWithGtk:gtk_button_new_with_label(NSString_to_String( label))];
}
- (void) pressed
{
    gtk_button_pressed(gtk);
}
- (void) released
{
    gtk_button_released(gtk);
}
- (void) clicked
{
    gtk_button_clicked(gtk);
}
- (void) enter
{
    gtk_button_enter(gtk);
}
- (void) leave
{
    gtk_button_leave(gtk);
}
#define gtk	((GtkButton *) gtk)
- child
{
    return Gtk_to_Object(gtk->child, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKCheckButton
+ (guint) getType
{
    return gtk_check_button_get_type();
}
+ checkButton
{
    return [[(GTKCheckButton *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_check_button_new()];
}
+ checkButtonWithLabel:(const NSString *) label
{
    return [[(GTKCheckButton *)[self alloc] initWithLabel:label] autorelease];
}
- initWithLabel:(const NSString *) label
{
    return [self initWithGtk:gtk_check_button_new_with_label(NSString_to_String( label))];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKCheckMenuItem
+ (GtkType) getType
{
    return gtk_check_menu_item_get_type();
}
+ checkMenuItem
{
    return [[(GTKCheckMenuItem *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_check_menu_item_new()];
}
+ checkMenuItemWithLabel:(const NSString *) label
{
    return [[(GTKCheckMenuItem *)[self alloc] initWithLabel:label] autorelease];
}
- initWithLabel:(const NSString *) label
{
    return [self initWithGtk:gtk_check_menu_item_new_with_label(NSString_to_String( label))];
}
- (void) setState:(gint) state
{
    gtk_check_menu_item_set_state(gtk, state);
}
- (void) setShowToggle:(gboolean) always
{
    gtk_check_menu_item_set_show_toggle(gtk, always);
}
- (void) toggled
{
    gtk_check_menu_item_toggled(gtk);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKCList
+ (guint) getType
{
    return gtk_clist_get_type();
}
- (void) construct:(gint) columns titles:(NSArray  *) titles
{
    gtk_clist_construct(gtk, columns ,(char **)NSArray_to_StrVec( titles));
}
+ cListWithColumns:(gint) columns
{
    return [[(GTKCList *)[self alloc] initWithColumns:columns] autorelease];
}
- initWithColumns:(gint) columns
{
    return [self initWithGtk:gtk_clist_new( columns)];
}
+ cListWithTitles:(gint) columns titles:(NSArray  *) titles
{
    return [[(GTKCList *)[self alloc] initWithTitles:columns titles:titles] autorelease];
}
- initWithTitles:(gint) columns titles:(NSArray  *) titles
{
    return [self initWithGtk:gtk_clist_new_with_titles( columns ,(char **)NSArray_to_StrVec( titles))];
}
- (void) setBorder:(GtkShadowType) border
{
    gtk_clist_set_border(gtk, border);
}
- (void) setSelectionMode:(GtkSelectionMode) mode
{
    gtk_clist_set_selection_mode(gtk, mode);
}
- (void) setPolicy:(GtkPolicyType) vscrollbar_policy hscrollbarPolicy:(GtkPolicyType) hscrollbar_policy
{
    gtk_clist_set_policy(gtk, vscrollbar_policy , hscrollbar_policy);
}
- (void) freeze
{
    gtk_clist_freeze(gtk);
}
- (void) thaw
{
    gtk_clist_thaw(gtk);
}
- (void) columnTitlesShow
{
    gtk_clist_column_titles_show(gtk);
}
- (void) columnTitlesHide
{
    gtk_clist_column_titles_hide(gtk);
}
- (void) columnTitleActive:(gint) column
{
    gtk_clist_column_title_active(gtk, column);
}
- (void) columnTitlePassive:(gint) column
{
    gtk_clist_column_title_passive(gtk, column);
}
- (void) columnTitlesActive
{
    gtk_clist_column_titles_active(gtk);
}
- (void) columnTitlesPassive
{
    gtk_clist_column_titles_passive(gtk);
}
- (void) setColumnTitle:(gint) column title:(NSString *) title
{
    gtk_clist_set_column_title(gtk, column ,NSString_to_String( title));
}
- (void) setColumnWidget:(gint) column widget:(GTKWidget *) widget
{
    gtk_clist_set_column_widget(gtk, column ,[ widget gtk]);
}
- (void) setColumnJustification:(gint) column justification:(GtkJustification) justification
{
    gtk_clist_set_column_justification(gtk, column , justification);
}
- (void) setColumnWidth:(gint) column width:(gint) width
{
    gtk_clist_set_column_width(gtk, column , width);
}
- (void) setRowHeight:(gint) height
{
    gtk_clist_set_row_height(gtk, height);
}
- (void) moveto:(gint) row column:(gint) column rowAlign:(gfloat) row_align colAlign:(gfloat) col_align
{
    gtk_clist_moveto(gtk, row , column , row_align , col_align);
}
- (GtkVisibility) rowIsVisible:(gint) row
{
    return gtk_clist_row_is_visible(gtk, row);
}
- (GtkCellType) getCellType:(gint) row column:(gint) column
{
    return gtk_clist_get_cell_type(gtk, row , column);
}
- (void) setText:(gint) row column:(gint) column text:(NSString *) text
{
    gtk_clist_set_text(gtk, row , column ,NSString_to_String( text));
}
- (gint) getText:(gint) row column:(gint) column text:(NSString **) text
{
    char *_outval_1;
    gint  _retval_1;
    _retval_1 = gtk_clist_get_text(gtk, row , column ,&_outval_1);
    * text = String_to_NSString(_outval_1);
    return _retval_1;
}
- (void) setPixmap:(gint) row column:(gint) column pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    gtk_clist_set_pixmap(gtk, row , column , pixmap , mask);
}
- (gint) getPixmap:(gint) row column:(gint) column pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask
{
    return gtk_clist_get_pixmap(gtk, row , column , pixmap , mask);
}
- (void) setPixtext:(gint) row column:(gint) column text:(NSString *) text spacing:(guint8) spacing pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    gtk_clist_set_pixtext(gtk, row , column ,NSString_to_String( text ), spacing , pixmap , mask);
}
- (gint) getPixtext:(gint) row column:(gint) column text:(NSString **) text spacing:(guint8 *) spacing pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask
{
    char *_outval_1;
    gint  _retval_1;
    _retval_1 = gtk_clist_get_pixtext(gtk, row , column ,&_outval_1, spacing , pixmap , mask);
    * text  = String_to_NSString(_outval_1);
    return _retval_1;
}
- (void) setForeground:(gint) row color:(GdkColor *) color
{
    gtk_clist_set_foreground(gtk, row , color);
}
- (void) setBackground:(gint) row color:(GdkColor *) color
{
    gtk_clist_set_background(gtk, row , color);
}
- (void) setShift:(gint) row column:(gint) column vertical:(gint) vertical horizontal:(gint) horizontal
{
    gtk_clist_set_shift(gtk, row , column , vertical , horizontal);
}
- (gint) append:(NSArray  *) text
{
    return gtk_clist_append(gtk,(char **)NSArray_to_StrVec( text));
}
- (void) insert:(gint) row text:(NSArray  *) text
{
    gtk_clist_insert(gtk, row ,(char **)NSArray_to_StrVec( text));
}
- (void) remove:(gint) row
{
    gtk_clist_remove(gtk, row);
}
- (void) setRowData:(gint) row data:(gpointer) data
{
    gtk_clist_set_row_data(gtk, row , data);
}
- (void) setRowDataFull:(gint) row data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    gtk_clist_set_row_data_full(gtk, row , data , destroy);
}
- (gpointer) getRowData:(gint) row
{
    return gtk_clist_get_row_data(gtk, row);
}
- (gint) findRowFromData:(gpointer) data
{
    return gtk_clist_find_row_from_data(gtk, data);
}
- (void) selectRow:(gint) row column:(gint) column
{
    gtk_clist_select_row(gtk, row , column);
}
- (void) unselectRow:(gint) row column:(gint) column
{
    gtk_clist_unselect_row(gtk, row , column);
}
- (void) clear
{
    gtk_clist_clear(gtk);
}
- (gint) getSelectionInfo:(gint) x y:(gint) y row:(gint *) row column:(gint *) column
{
    return gtk_clist_get_selection_info(gtk, x , y , row , column);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKColorSelection
+ (guint) getType
{
    return gtk_color_selection_get_type();
}
+ colorSelection
{
    return [[(GTKColorSelection *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_color_selection_new()];
}
- (void) setUpdatePolicy:(GtkUpdateType) policy
{
    gtk_color_selection_set_update_policy(gtk, policy);
}
- (void) setOpacity:(gint) use_opacity
{
    gtk_color_selection_set_opacity(gtk, use_opacity);
}
- (void) setColor:(gdouble *) color
{
    gtk_color_selection_set_color(gtk, color);
}
- (void) getColor:(gdouble *) color
{
    gtk_color_selection_get_color(gtk, color);
}
+ (guint) dialogGetType
{
    return gtk_color_selection_dialog_get_type();
}
+ (GTKWidget*) dialogNew:(const NSString *) title
{
    return Gtk_to_Object(gtk_color_selection_dialog_new(NSString_to_String( title)), 0);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKColorSelectionDialog
+ (guint) getType
{
    return gtk_color_selection_dialog_get_type();
}
+ colorSelectionDialogWithTitle:(const NSString *) title
{
    return [[(GTKColorSelectionDialog *)[self alloc] initWithTitle:title] autorelease];
}
- initWithTitle:(const NSString *) title
{
    return [self initWithGtk:gtk_color_selection_dialog_new(NSString_to_String( title))];
}
#define gtk	((GtkColorSelectionDialog *) gtk)
- (GTKWidget *) colorsel
{
    return Gtk_to_Object(gtk->colorsel, 0);
}
- (GTKWidget *) okButton
{
    return Gtk_to_Object(gtk->ok_button, 0);
}
- (GTKWidget *) resetButton
{
    return Gtk_to_Object(gtk->reset_button, 0);
}
- (GTKWidget *) cancelButton
{
    return Gtk_to_Object(gtk->cancel_button, 0);
}
- (GTKWidget *) helpButton
{
    return Gtk_to_Object(gtk->help_button, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKCombo
+ (guint) getType
{
    return gtk_combo_get_type();
}
+ combo
{
    return [[(GTKCombo *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_combo_new()];
}
- (void) setValueInList:(gint) val okIfEmpty:(gint) ok_if_empty
{
    gtk_combo_set_value_in_list(gtk, val , ok_if_empty);
}
- (void) setUseArrows:(gint) val
{
    gtk_combo_set_use_arrows(gtk, val);
}
- (void) setUseArrowsAlways:(gint) val
{
    gtk_combo_set_use_arrows_always(gtk, val);
}
- (void) setCaseSensitive:(gint) val
{
    gtk_combo_set_case_sensitive(gtk, val);
}
- (void) setItemString:(GTKItem*) item itemValue:(const NSString *) item_value
{
    gtk_combo_set_item_string(gtk,[ item  gtk],NSString_to_String( item_value));
}
- (void) setPopdownStrings:(NSArray *) strings
{
    gtk_combo_set_popdown_strings(gtk,NSArray_to_GList( strings));
}
- (void) disableActivate
{
    gtk_combo_disable_activate(gtk);
}
#define gtk	((GtkCombo *) gtk)
- entry
{
    return Gtk_to_Object(gtk->entry, 0);
}
- (GTKWidget *) list
{
    return Gtk_to_Object(gtk->list, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKContainer
+ (GtkType) getType
{
    return gtk_container_get_type();
}
- (void) borderWidth:(gint) border_width
{
    gtk_container_border_width(gtk, border_width);
}
- (void) add:(GTKWidget *) widget
{
    gtk_container_add(gtk,[ widget gtk]);
}
- (void) remove:(GTKWidget *) widget
{
    gtk_container_remove(gtk,[ widget gtk]);
}
- (void) disableResize
{
    gtk_container_disable_resize(gtk);
}
- (void) enableResize
{
    gtk_container_enable_resize(gtk);
}
- (void) blockResize
{
    gtk_container_block_resize(gtk);
}
- (void) unblockResize
{
    gtk_container_unblock_resize(gtk);
}
- (gint) needResize
{
    return gtk_container_need_resize(gtk);
}
- (void) foreach:(GtkCallback) callback callbackData:(gpointer) callback_data
{
    gtk_container_foreach(gtk, callback , callback_data);
}
- (void) foreachInterp:(GtkCallbackMarshal) marshal callbackData:(gpointer) callback_data notify:(GtkDestroyNotify) notify
{
    gtk_container_foreach_interp(gtk, marshal , callback_data , notify);
}
- (void) foreachFull:(GtkCallback) callback marshal:(GtkCallbackMarshal) marshal callbackData:(gpointer) callback_data notify:(GtkDestroyNotify) notify
{
    gtk_container_foreach_full(gtk, callback , marshal , callback_data , notify);
}
- (NSArray *) children
{
    return GList_to_NSArray(gtk_container_children(gtk));
}
- (void) registerToplevel
{
    gtk_container_register_toplevel(gtk);
}
- (void) unregisterToplevel
{
    gtk_container_unregister_toplevel(gtk);
}
- (gint) focus:(GtkDirectionType) direction
{
    return gtk_container_focus(gtk, direction);
}
- (void) setFocusChild:(GTKWidget *) child
{
    gtk_container_set_focus_child(gtk,[ child gtk]);
}
- (void) setFocusVadjustment:(GTKAdjustment *) adjustment
{
    gtk_container_set_focus_vadjustment(gtk,[ adjustment gtk]);
}
- (void) setFocusHadjustment:(GTKAdjustment *) adjustment
{
    gtk_container_set_focus_hadjustment(gtk,[ adjustment gtk]);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKCurve
+ (guint) getType
{
    return gtk_curve_get_type();
}
+ curve
{
    return [[(GTKCurve *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_curve_new()];
}
- (void) reset
{
    gtk_curve_reset(gtk);
}
- (void) setGamma:(gfloat) gamma
{
    gtk_curve_set_gamma(gtk, gamma);
}
- (void) setRange:(gfloat) min_x maxX:(gfloat) max_x minY:(gfloat) min_y maxY:(gfloat) max_y
{
    gtk_curve_set_range(gtk, min_x , max_x , min_y , max_y);
}
- (void) getVector:(int) veclen vector:(gfloat *) vector
{
    gtk_curve_get_vector(gtk, veclen , vector);
}
- (void) setVector:(int) veclen vector:(gfloat *) vector
{
    gtk_curve_set_vector(gtk, veclen , vector);
}
- (void) setCurveType:(GtkCurveType) type
{
    gtk_curve_set_curve_type(gtk, type);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKData
+ (GtkType) getType
{
    return gtk_data_get_type();
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKDialog
+ (guint) getType
{
    return gtk_dialog_get_type();
}
+ dialog
{
    return [[(GTKDialog *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_dialog_new()];
}
#define gtk	((GtkDialog *) gtk)
- (GTKWidget *) vbox
{
    return Gtk_to_Object(gtk->vbox, 0);
}
- (GTKWidget *) actionArea
{
    return Gtk_to_Object(gtk->action_area, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKDrawingArea
+ (guint) getType
{
    return gtk_drawing_area_get_type();
}
+ drawingArea
{
    return [[(GTKDrawingArea *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_drawing_area_new()];
}
- (void) size:(gint) width height:(gint) height
{
    gtk_drawing_area_size(gtk, width , height);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKEditable
+ (guint) getType
{
    return gtk_editable_get_type();
}
- (void) selectRegion:(gint) start end:(gint) end
{
    gtk_editable_select_region(gtk, start , end);
}
- (void) insertText:(const NSString *) new_text newTextLength:(gint) new_text_length position:(gint *) position
{
    gtk_editable_insert_text(gtk,NSString_to_String( new_text ), new_text_length , position);
}
- (void) deleteText:(gint) start_pos endPos:(gint) end_pos
{
    gtk_editable_delete_text(gtk, start_pos , end_pos);
}
- (NSString *) getChars:(gint) start_pos endPos:(gint) end_pos
{
    return String_to_NSString(gtk_editable_get_chars(gtk, start_pos , end_pos));
}
- (void) cutClipboard:(guint32) time
{
    gtk_editable_cut_clipboard(gtk, time);
}
- (void) copyClipboard:(guint32) time
{
    gtk_editable_copy_clipboard(gtk, time);
}
- (void) pasteClipboard:(guint32) time
{
    gtk_editable_paste_clipboard(gtk, time);
}
- (void) claimSelection:(gboolean) claim time:(guint32) time
{
    gtk_editable_claim_selection(gtk, claim , time);
}
- (void) deleteSelection
{
    gtk_editable_delete_selection(gtk);
}
- (void) changed
{
    gtk_editable_changed(gtk);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKEntry
+ (guint) getType
{
    return gtk_entry_get_type();
}
+ entry
{
    return [[(GTKEntry *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_entry_new()];
}
+ entryWithMaxLength:(guint16) max
{
    return [[(GTKEntry *)[self alloc] initWithMaxLength:max] autorelease];
}
- initWithMaxLength:(guint16) max
{
    return [self initWithGtk:gtk_entry_new_with_max_length( max)];
}
- (void) setText:(const NSString *) text
{
    gtk_entry_set_text(gtk,NSString_to_String( text));
}
- (void) appendText:(const NSString *) text
{
    gtk_entry_append_text(gtk,NSString_to_String( text));
}
- (void) prependText:(const NSString *) text
{
    gtk_entry_prepend_text(gtk,NSString_to_String( text));
}
- (void) setPosition:(gint) position
{
    gtk_entry_set_position(gtk, position);
}
- (NSString *) getText
{
    return String_to_NSString(gtk_entry_get_text(gtk));
}
- (void) selectRegion:(gint) start end:(gint) end
{
    gtk_entry_select_region(gtk, start , end);
}
- (void) setVisibility:(gboolean) visible
{
    gtk_entry_set_visibility(gtk, visible);
}
- (void) setEditable:(gboolean) editable
{
    gtk_entry_set_editable(gtk, editable);
}
- (void) setMaxLength:(guint16) max
{
    gtk_entry_set_max_length(gtk, max);
}
#include <stdio.h>
#include <stdlib.h>
- (void) setDoubleValue:(double) value
{
    char string[64];

    sprintf(string, "%g", value);
    gtk_entry_set_text(gtk, string);
}
- (void) setIntValue:(int) value
{
    char string[64];

    sprintf(string, "%d", value);
    gtk_entry_set_text(gtk, string);
}
- (void) setStringValue:(NSString *) value
{
    gtk_entry_set_text(gtk, NSString_to_String(value));
}
- (double) doubleValue
{
    return atof(gtk_entry_get_text(gtk));
}
- (int) intValue
{
    return atoi(gtk_entry_get_text(gtk));
}
- (NSString *) stringValue
{
    return String_to_NSString(gtk_entry_get_text(gtk));
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKEventBox
+ (guint) getType
{
    return gtk_event_box_get_type();
}
+ eventBox
{
    return [[(GTKEventBox *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_event_box_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKFileSelection
+ (guint) getType
{
    return gtk_file_selection_get_type();
}
+ fileSelectionWithTitle:(const NSString *) title
{
    return [[(GTKFileSelection *)[self alloc] initWithTitle:title] autorelease];
}
- initWithTitle:(const NSString *) title
{
    return [self initWithGtk:gtk_file_selection_new(NSString_to_String( title))];
}
- (void) setFilename:(const NSString *) filename
{
    gtk_file_selection_set_filename(gtk,NSString_to_String( filename));
}
- (NSString *) getFilename
{
    return String_to_NSString(gtk_file_selection_get_filename(gtk));
}
- (void) showFileopButtons
{
    gtk_file_selection_show_fileop_buttons(gtk);
}
- (void) hideFileopButtons
{
    gtk_file_selection_hide_fileop_buttons(gtk);
}
#define gtk	((GtkFileSelection *) gtk)
- (GTKWidget *) okButton
{
    return Gtk_to_Object(gtk->ok_button, 0);
}
- (GTKWidget *) cancelButton
{
    return Gtk_to_Object(gtk->cancel_button, 0);
}
- (GTKWidget *) helpButton
{
    return Gtk_to_Object(gtk->help_button, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKFixed
+ (guint) getType
{
    return gtk_fixed_get_type();
}
+ fixed
{
    return [[(GTKFixed *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_fixed_new()];
}
- (void) put:(GTKWidget *) widget x:(gint16) x y:(gint16) y
{
    gtk_fixed_put(gtk,[ widget  gtk], x , y);
}
- (void) move:(GTKWidget *) widget x:(gint16) x y:(gint16) y
{
    gtk_fixed_move(gtk,[ widget  gtk], x , y);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKFrame
+ (guint) getType
{
    return gtk_frame_get_type();
}
+ frameWithLabel:(const NSString *) label
{
    return [[(GTKFrame *)[self alloc] initWithLabel:label] autorelease];
}
- initWithLabel:(const NSString *) label
{
    return [self initWithGtk:gtk_frame_new(NSString_to_String( label))];
}
- (void) setLabel:(const NSString *) label
{
    gtk_frame_set_label(gtk,NSString_to_String( label));
}
- (void) setLabelAlign:(gfloat) xalign yalign:(gfloat) yalign
{
    gtk_frame_set_label_align(gtk, xalign , yalign);
}
- (void) setShadowType:(GtkShadowType) type
{
    gtk_frame_set_shadow_type(gtk, type);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKGammaCurve
+ (guint) getType
{
    return gtk_gamma_curve_get_type();
}
+ gammaCurve
{
    return [[(GTKGammaCurve *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_gamma_curve_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKHandleBox
+ (guint) getType
{
    return gtk_handle_box_get_type();
}
+ handleBox
{
    return [[(GTKHandleBox *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_handle_box_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKHButtonBox
+ (guint) getType
{
    return gtk_hbutton_box_get_type();
}
+ hButtonBox
{
    return [[(GTKHButtonBox *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_hbutton_box_new()];
}
+ (gint) getSpacingDefault
{
    return gtk_hbutton_box_get_spacing_default();
}
+ (GtkButtonBoxStyle) getLayoutDefault
{
    return gtk_hbutton_box_get_layout_default();
}
+ (void) setSpacingDefault:(gint) spacing
{
    gtk_hbutton_box_set_spacing_default( spacing);
}
+ (void) setLayoutDefault:(GtkButtonBoxStyle) layout
{
    gtk_hbutton_box_set_layout_default( layout);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKHBox
+ (guint) getType
{
    return gtk_hbox_get_type();
}
+ hBoxWithHomogeneous:(gint) homogeneous spacing:(gint) spacing
{
    return [[(GTKHBox *)[self alloc] initWithHomogeneous:homogeneous spacing:spacing] autorelease];
}
- initWithHomogeneous:(gint) homogeneous spacing:(gint) spacing
{
    return [self initWithGtk:gtk_hbox_new( homogeneous , spacing)];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKHPaned
+ (guint) getType
{
    return gtk_hpaned_get_type();
}
+ hPaned
{
    return [[(GTKHPaned *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_hpaned_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKHRuler
+ (guint) getType
{
    return gtk_hruler_get_type();
}
+ hRuler
{
    return [[(GTKHRuler *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_hruler_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKHScale
+ (guint) getType
{
    return gtk_hscale_get_type();
}
+ hScaleWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKHScale *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_hscale_new([ adjustment gtk])];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKHScrollbar
+ (guint) getType
{
    return gtk_hscrollbar_get_type();
}
+ hScrollbarWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKHScrollbar *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_hscrollbar_new([ adjustment gtk])];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKHSeparator
+ (guint) getType
{
    return gtk_hseparator_get_type();
}
+ hSeparator
{
    return [[(GTKHSeparator *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_hseparator_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKImage
+ (guint) getType
{
    return gtk_image_get_type();
}
+ imageWithVal:(GdkImage *) val mask:(GdkBitmap *) mask
{
    return [[(GTKImage *)[self alloc] initWithVal:val mask:mask] autorelease];
}
- initWithVal:(GdkImage *) val mask:(GdkBitmap *) mask
{
    return [self initWithGtk:gtk_image_new( val , mask)];
}
- (void) set:(GdkImage *) val mask:(GdkBitmap *) mask
{
    gtk_image_set(gtk, val , mask);
}
- (void) get:(GdkImage **) val mask:(GdkBitmap **) mask
{
    gtk_image_get(gtk, val , mask);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKInputDialog
+ (guint) getType
{
    return gtk_input_dialog_get_type();
}
+ inputDialog
{
    return [[(GTKInputDialog *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_input_dialog_new()];
}
#define gtk	((GtkInputDialog *) gtk)
- (GTKWidget *) closeButton
{
    return Gtk_to_Object(gtk->close_button, 0);
}
- (GTKWidget *) saveButton
{
    return Gtk_to_Object(gtk->save_button, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKItem
+ (guint) getType
{
    return gtk_item_get_type();
}
- (void) select
{
    gtk_item_select(gtk);
}
- (void) deselect
{
    gtk_item_deselect(gtk);
}
- (void) toggle
{
    gtk_item_toggle(gtk);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKLabel
+ (guint) getType
{
    return gtk_label_get_type();
}
+ labelWithStr:(const NSString *) str
{
    return [[(GTKLabel *)[self alloc] initWithStr:str] autorelease];
}
- initWithStr:(const NSString *) str
{
    return [self initWithGtk:gtk_label_new(NSString_to_String( str))];
}
- (void) set:(const NSString *) str
{
    gtk_label_set(gtk,NSString_to_String( str));
}
- (void) setJustify:(GtkJustification) jtype
{
    gtk_label_set_justify(gtk, jtype);
}
- (void) get:(NSString **) str
{
    char *_outval_1;
    gtk_label_get(gtk,&_outval_1);
    * str = String_to_NSString(_outval_1);
}
#include <stdio.h>
#include <stdlib.h>
- (void) setDoubleValue:(double) value
{
    char string[64];

    sprintf(string, "%g", value);
    gtk_label_set(gtk, string);
}
- (void) setIntValue:(int) value
{
    char string[64];

    sprintf(string, "%d", value);
    gtk_label_set(gtk, string);
}
- (void) setStringValue:(NSString *) value
{
    gtk_label_set(gtk, NSString_to_String(value));
}
- (double) doubleValue
{
    char *string;

    gtk_label_get(gtk, &string);
    return atof(string);
}
- (int) intValue
{
    char *string;

    gtk_label_get(gtk, &string);
    return atoi(string);
}
- (NSString *) stringValue
{
    char *string;

    gtk_label_get(gtk, &string);
    return String_to_NSString(string);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKList
+ (GtkType) getType
{
    return gtk_list_get_type();
}
+ list
{
    return [[(GTKList *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_list_new()];
}
- (void) insertItems:(NSArray *) items position:(gint) position
{
    gtk_list_insert_items(gtk,NSArray_to_GList( items ), position);
}
- (void) appendItems:(NSArray *) items
{
    gtk_list_append_items(gtk,NSArray_to_GList( items));
}
- (void) prependItems:(NSArray *) items
{
    gtk_list_prepend_items(gtk,NSArray_to_GList( items));
}
- (void) removeItems:(NSArray *) items
{
    gtk_list_remove_items(gtk,NSArray_to_GList( items));
}
- (void) removeItemsNoUnref:(NSArray *) items
{
    gtk_list_remove_items_no_unref(gtk,NSArray_to_GList( items));
}
- (void) clearItems:(gint) start end:(gint) end
{
    gtk_list_clear_items(gtk, start , end);
}
- (void) selectItem:(gint) item
{
    gtk_list_select_item(gtk, item);
}
- (void) unselectItem:(gint) item
{
    gtk_list_unselect_item(gtk, item);
}
- (void) selectChild:(GTKWidget *) child
{
    gtk_list_select_child(gtk,[ child gtk]);
}
- (void) unselectChild:(GTKWidget *) child
{
    gtk_list_unselect_child(gtk,[ child gtk]);
}
- (gint) childPosition:(GTKWidget *) child
{
    return gtk_list_child_position(gtk,[ child gtk]);
}
- (void) setSelectionMode:(GtkSelectionMode) mode
{
    gtk_list_set_selection_mode(gtk, mode);
}
#define gtk	((GtkList *) gtk)
- (NSArray *) selection
{
    return GList_to_NSArray(gtk->selection);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKListItem
+ (guint) getType
{
    return gtk_list_item_get_type();
}
+ listItem
{
    return [[(GTKListItem *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_list_item_new()];
}
+ listItemWithLabel:(const NSString *) label
{
    return [[(GTKListItem *)[self alloc] initWithLabel:label] autorelease];
}
- initWithLabel:(const NSString *) label
{
    return [self initWithGtk:gtk_list_item_new_with_label(NSString_to_String( label))];
}
- (void) select
{
    gtk_list_item_select(gtk);
}
- (void) deselect
{
    gtk_list_item_deselect(gtk);
}
@end
#include <gtk/gtkrc.h>
#include <GToolKit/GToolKit.h>

@implementation GTKMain
- (void) exit:(gint) error_code
{
    gtk_exit( error_code);
}
- (NSString *) setLocale
{
    return String_to_NSString(gtk_set_locale());
}
- (gint) eventsPending
{
    return gtk_events_pending();
}
- (void) main
{
    gtk_main();
}
- (guint) mainLevel
{
    return gtk_main_level();
}
- (void) mainQuit
{
    gtk_main_quit();
}
- (gint) mainIteration
{
    return gtk_main_iteration();
}
- (gint) mainIterationDo:(gboolean) blocking
{
    return gtk_main_iteration_do( blocking);
}
- (gint) true
{
    return gtk_true();
}
- (gint) false
{
    return gtk_false();
}
- (void) grabAdd:(GTKWidget *) widget
{
    gtk_grab_add([ widget gtk]);
}
- (GTKWidget*) grabGetCurrent
{
    return Gtk_to_Object(gtk_grab_get_current(), 0);
}
- (void) grabRemove:(GTKWidget *) widget
{
    gtk_grab_remove([ widget gtk]);
}
- (void) initAdd:(GtkFunction) function data:(gpointer) data
{
    gtk_init_add( function , data);
}
- (void) quitAddDestroy:(guint) main_level object:(GTKObject *) object
{
    gtk_quit_add_destroy( main_level ,[ object gtk]);
}
- (guint) quitAdd:(guint) main_level function:(GtkFunction) function data:(gpointer) data
{
    return gtk_quit_add( main_level , function , data);
}
- (guint) quitAddFull:(guint) main_level function:(GtkFunction) function marshal:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_quit_add_full( main_level , function , marshal , data , destroy);
}
- (void) quitRemove:(guint) quit_handler_id
{
    gtk_quit_remove( quit_handler_id);
}
- (void) quitRemoveByData:(gpointer) data
{
    gtk_quit_remove_by_data( data);
}
- (guint) timeoutAddFull:(guint32) interval function:(GtkFunction) function marshal:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_timeout_add_full( interval , function , marshal , data , destroy);
}
- (guint) timeoutAdd:(guint32) interval function:(GtkFunction) function data:(gpointer) data
{
    return gtk_timeout_add( interval , function , data);
}
- (guint) timeoutAddInterp:(guint32) interval function:(GtkCallbackMarshal) function data:(gpointer) data notify:(GtkDestroyNotify) notify
{
    return gtk_timeout_add_interp( interval , function , data , notify);
}
- (void) timeoutRemove:(guint) timeout_handler_id
{
    gtk_timeout_remove( timeout_handler_id);
}
- (guint) idleAdd:(GtkFunction) function data:(gpointer) data
{
    return gtk_idle_add( function , data);
}
- (guint) idleAddPriority:(gint) priority function:(GtkFunction) function data:(gpointer) data
{
    return gtk_idle_add_priority( priority , function , data);
}
- (guint) idleAddFull:(gint) priority function:(GtkFunction) function marshal:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_idle_add_full( priority , function , marshal , data , destroy);
}
- (guint) idleAddInterp:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_idle_add_interp( marshal , data , destroy);
}
- (void) idleRemove:(guint) idle_handler_id
{
    gtk_idle_remove( idle_handler_id);
}
- (void) idleRemoveByData:(gpointer) data
{
    gtk_idle_remove_by_data( data);
}
- (guint) inputAddFull:(gint) source condition:(GdkInputCondition) condition function:(GdkInputFunction) function marshal:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_input_add_full( source , condition , function , marshal , data , destroy);
}
- (void) inputRemove:(guint) input_handler_id
{
    gtk_input_remove( input_handler_id);
}
- (guint) keySnooperInstall:(GtkKeySnoopFunc) snooper funcData:(gpointer) func_data
{
    return gtk_key_snooper_install( snooper , func_data);
}
- (void) keySnooperRemove:(guint) snooper_handler_id
{
    gtk_key_snooper_remove( snooper_handler_id);
}
- (GdkEvent*) getCurrentEvent
{
    return gtk_get_current_event();
}
- (GTKWidget*) getEventWidget:(GdkEvent	*) event
{
    return Gtk_to_Object(gtk_get_event_widget( event), 0);
}
- (void) rcInit
{
    gtk_rc_init();
}
- (void) rcParse:(const NSString *) filename
{
    gtk_rc_parse(NSString_to_String( filename));
}
- (void) rcParseString:(const NSString *) rc_string
{
    gtk_rc_parse_string(NSString_to_String( rc_string));
}
- (GTKStyle*) rcGetStyle:(GTKWidget *) widget
{
    return Gtk_to_Object(gtk_rc_get_style([ widget gtk]), "GTKStyle");
}
- (void) rcAddWidgetNameStyle:(GTKStyle *) style pattern:(const NSString *) pattern
{
    gtk_rc_add_widget_name_style([ style  gtk],NSString_to_String( pattern));
}
- (void) rcAddWidgetClassStyle:(GTKStyle *) style pattern:(const NSString *) pattern
{
    gtk_rc_add_widget_class_style([ style  gtk],NSString_to_String( pattern));
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKMenu
+ (guint) getType
{
    return gtk_menu_get_type();
}
+ menu
{
    return [[(GTKMenu *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_menu_new()];
}
- (void) append:(GTKWidget *) child
{
    gtk_menu_append(gtk,[ child gtk]);
}
- (void) prepend:(GTKWidget *) child
{
    gtk_menu_prepend(gtk,[ child gtk]);
}
- (void) insert:(GTKWidget *) child position:(gint) position
{
    gtk_menu_insert(gtk,[ child  gtk], position);
}
- (void) popup:(GTKWidget *) parent_menu_shell parentMenuItem:(GTKWidget *) parent_menu_item func:(GtkMenuPositionFunc) func data:(gpointer) data button:(guint) button activateTime:(guint32) activate_time
{
    gtk_menu_popup(gtk,[ parent_menu_shell  gtk],[ parent_menu_item  gtk], func , data , button , activate_time);
}
- (void) popdown
{
    gtk_menu_popdown(gtk);
}
- (GTKWidget*) getActive
{
    return Gtk_to_Object(gtk_menu_get_active(gtk), 0);
}
- (void) setActive:(guint) index
{
    gtk_menu_set_active(gtk, index);
}
- (void) setAcceleratorTable:(GTKAcceleratorTable *) table
{
    gtk_menu_set_accelerator_table(gtk,[ table gtk]);
}
- (void) attachToWidget:(GTKWidget *) attach_widget detacher:(GtkMenuDetachFunc	) detacher
{
    gtk_menu_attach_to_widget(gtk,[ attach_widget  gtk], detacher);
}
- (GTKWidget*) getAttachWidget
{
    return Gtk_to_Object(gtk_menu_get_attach_widget(gtk), 0);
}
- (void) detach
{
    gtk_menu_detach(gtk);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKMenuBar
+ (guint) getType
{
    return gtk_menu_bar_get_type();
}
+ menuBar
{
    return [[(GTKMenuBar *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_menu_bar_new()];
}
- (void) append:(GTKWidget *) child
{
    gtk_menu_bar_append(gtk,[ child gtk]);
}
- (void) prepend:(GTKWidget *) child
{
    gtk_menu_bar_prepend(gtk,[ child gtk]);
}
- (void) insert:(GTKWidget *) child position:(gint) position
{
    gtk_menu_bar_insert(gtk,[ child  gtk], position);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKMenuFactory
+ menuFactoryWithType:(GtkMenuFactoryType) type
{
    return [[(GTKMenuFactory *)[self alloc] initWithType:type] autorelease];
}
- initWithType:(GtkMenuFactoryType) type
{
    return [self initWithGtk:gtk_menu_factory_new( type)];
}
- (void) destroy
{
    gtk_menu_factory_destroy(gtk);
}
- (void) addEntries:(GtkMenuEntry *) entries nentries:(int) nentries
{
    gtk_menu_factory_add_entries(gtk, entries , nentries);
}
- (void) addSubfactory:(GTKMenuFactory *) subfactory path:(const NSString *) path
{
    gtk_menu_factory_add_subfactory(gtk,[ subfactory  gtk],NSString_to_String( path));
}
- (void) removePaths:(NSString **) paths npaths:(int) npaths
{
    char *_outval_1;
    gtk_menu_factory_remove_paths(gtk,&_outval_1, npaths);
    * paths  = String_to_NSString(_outval_1);
}
- (void) removeEntries:(GtkMenuEntry *) entries nentries:(int) nentries
{
    gtk_menu_factory_remove_entries(gtk, entries , nentries);
}
- (void) removeSubfactory:(GTKMenuFactory *) subfactory path:(const NSString *) path
{
    gtk_menu_factory_remove_subfactory(gtk,[ subfactory  gtk],NSString_to_String( path));
}
- (GtkMenuPath*) find:(const NSString *) path
{
    return gtk_menu_factory_find(gtk,NSString_to_String( path));
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKMenuItem
+ (guint) getType
{
    return gtk_menu_item_get_type();
}
+ menuItem
{
    return [[(GTKMenuItem *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_menu_item_new()];
}
+ menuItemWithLabel:(const NSString *) label
{
    return [[(GTKMenuItem *)[self alloc] initWithLabel:label] autorelease];
}
- initWithLabel:(const NSString *) label
{
    return [self initWithGtk:gtk_menu_item_new_with_label(NSString_to_String( label))];
}
- (void) setSubmenu:(GTKWidget *) submenu
{
    gtk_menu_item_set_submenu(gtk,[ submenu gtk]);
}
- (void) removeSubmenu
{
    gtk_menu_item_remove_submenu(gtk);
}
- (void) setPlacement:(GtkSubmenuPlacement) placement
{
    gtk_menu_item_set_placement(gtk, placement);
}
- (void) acceleratorSize
{
    gtk_menu_item_accelerator_size(gtk);
}
- (void) acceleratorText:(NSString *) buffer
{
    gtk_menu_item_accelerator_text(gtk,NSString_to_String( buffer));
}
- (void) configure:(gint) show_toggle_indicator showSubmenuIndicator:(gint) show_submenu_indicator
{
    gtk_menu_item_configure(gtk, show_toggle_indicator , show_submenu_indicator);
}
- (void) select
{
    gtk_menu_item_select(gtk);
}
- (void) deselect
{
    gtk_menu_item_deselect(gtk);
}
- (void) activate
{
    gtk_menu_item_activate(gtk);
}
- (void) rightJustify
{
    gtk_menu_item_right_justify(gtk);
}
#define gtk	((GtkMenuItem *) gtk)
- (GTKWidget *) submenu
{
    return Gtk_to_Object(gtk->submenu, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKMenuShell
+ (guint) getType
{
    return gtk_menu_shell_get_type();
}
- (void) append:(GTKWidget *) child
{
    gtk_menu_shell_append(gtk,[ child gtk]);
}
- (void) prepend:(GTKWidget *) child
{
    gtk_menu_shell_prepend(gtk,[ child gtk]);
}
- (void) insert:(GTKWidget *) child position:(gint) position
{
    gtk_menu_shell_insert(gtk,[ child  gtk], position);
}
- (void) deactivate
{
    gtk_menu_shell_deactivate(gtk);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKMisc
+ (guint) getType
{
    return gtk_misc_get_type();
}
- (void) setAlignment:(gfloat) xalign yalign:(gfloat) yalign
{
    gtk_misc_set_alignment(gtk, xalign , yalign);
}
- (void) setPadding:(gint) xpad ypad:(gint) ypad
{
    gtk_misc_set_padding(gtk, xpad , ypad);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKNotebook
+ (guint) getType
{
    return gtk_notebook_get_type();
}
+ notebook
{
    return [[(GTKNotebook *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_notebook_new()];
}
- (void) appendPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label
{
    gtk_notebook_append_page(gtk,[ child  gtk],[ tab_label gtk]);
}
- (void) appendPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label
{
    gtk_notebook_append_page_menu(gtk,[ child  gtk],[ tab_label  gtk],[ menu_label gtk]);
}
- (void) prependPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label
{
    gtk_notebook_prepend_page(gtk,[ child  gtk],[ tab_label gtk]);
}
- (void) prependPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label
{
    gtk_notebook_prepend_page_menu(gtk,[ child  gtk],[ tab_label  gtk],[ menu_label gtk]);
}
- (void) insertPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label position:(gint) position
{
    gtk_notebook_insert_page(gtk,[ child  gtk],[ tab_label  gtk], position);
}
- (void) insertPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label position:(gint) position
{
    gtk_notebook_insert_page_menu(gtk,[ child  gtk],[ tab_label  gtk],[ menu_label  gtk], position);
}
- (void) removePage:(gint) page_num
{
    gtk_notebook_remove_page(gtk, page_num);
}
- (gint) currentPage
{
    return gtk_notebook_current_page(gtk);
}
- (void) setPage:(gint) page_num
{
    gtk_notebook_set_page(gtk, page_num);
}
- (void) nextPage
{
    gtk_notebook_next_page(gtk);
}
- (void) prevPage
{
    gtk_notebook_prev_page(gtk);
}
- (void) setTabPos:(GtkPositionType) pos
{
    gtk_notebook_set_tab_pos(gtk, pos);
}
- (void) setShowTabs:(gint) show_tabs
{
    gtk_notebook_set_show_tabs(gtk, show_tabs);
}
- (void) setShowBorder:(gint) show_border
{
    gtk_notebook_set_show_border(gtk, show_border);
}
- (void) setScrollable:(gint) scrollable
{
    gtk_notebook_set_scrollable(gtk, scrollable);
}
- (void) setTabBorder:(gint) border_width
{
    gtk_notebook_set_tab_border(gtk, border_width);
}
- (void) popupEnable
{
    gtk_notebook_popup_enable(gtk);
}
- (void) popupDisable
{
    gtk_notebook_popup_disable(gtk);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKObject
+ (GtkType	) getType
{
    return gtk_object_get_type();
}
+ (void	) classAddSignals:(GtkObjectClass	*) klass signals:(guint *) signals nsignals:(guint) nsignals
{
    return gtk_object_class_add_signals( klass , signals , nsignals);
}
+ objectvWithType:(GtkType	) type nargs:(guint) nargs args:(GtkArg *) args
{
    return [[(GTKObject *)[self alloc] initvWithType:type nargs:nargs args:args] autorelease];
}
- initvWithType:(GtkType	) type nargs:(guint) nargs args:(GtkArg *) args
{
    return [self initWithGtk:gtk_object_newv( type , nargs , args)];
}
- (void) sink
{
    gtk_object_sink(gtk);
}
- (void) ref
{
    gtk_object_ref(gtk);
}
- (void) unref
{
    gtk_object_unref(gtk);
}
- (void) weakref:(GtkDestroyNotify) notify data:(gpointer) data
{
    gtk_object_weakref(gtk, notify , data);
}
- (void) weakunref:(GtkDestroyNotify) notify data:(gpointer) data
{
    gtk_object_weakunref(gtk, notify , data);
}
- (void) destroy
{
    gtk_object_destroy(gtk);
}
- (void	) getv:(guint) nargs args:(GtkArg *) args
{
    return gtk_object_getv(gtk, nargs , args);
}
- (void	) setv:(guint) nargs args:(GtkArg *) args
{
    return gtk_object_setv(gtk, nargs , args);
}
+ (GtkArg*) queryArgs:(GtkType	) class_type argFlags:(guint32	**) arg_flags nargs:(guint *) nargs
{
    return gtk_object_query_args( class_type , arg_flags , nargs);
}
+ (void	) addArgType:(const NSString *) arg_name argType:(GtkType	) arg_type argFlags:(guint) arg_flags argId:(guint) arg_id
{
    return gtk_object_add_arg_type(NSString_to_String( arg_name ), arg_type , arg_flags , arg_id);
}
+ (GtkType	) getArgType:(const NSString *) arg_name
{
    return gtk_object_get_arg_type(NSString_to_String( arg_name));
}
- (void) setData:(const NSString *) key data:(gpointer) data
{
    gtk_object_set_data(gtk,NSString_to_String( key ), data);
}
- (void) setDataFull:(const NSString *) key data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    gtk_object_set_data_full(gtk,NSString_to_String( key ), data , destroy);
}
- (gpointer) getData:(const NSString *) key
{
    return gtk_object_get_data(gtk,NSString_to_String( key));
}
- (void) removeData:(const NSString *) key
{
    gtk_object_remove_data(gtk,NSString_to_String( key));
}
- (void) setDataById:(guint) data_id data:(gpointer) data
{
    gtk_object_set_data_by_id(gtk, data_id , data);
}
- (void) setDataByIdFull:(guint) data_id data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    gtk_object_set_data_by_id_full(gtk, data_id , data , destroy);
}
- (gpointer) getDataById:(guint) data_id
{
    return gtk_object_get_data_by_id(gtk, data_id);
}
- (void) removeDataById:(guint) data_id
{
    gtk_object_remove_data_by_id(gtk, data_id);
}
+ (guint) dataTryKey:(const NSString *) key
{
    return gtk_object_data_try_key(NSString_to_String( key));
}
+ (guint) dataForceId:(const NSString *) key
{
    return gtk_object_data_force_id(NSString_to_String( key));
}
- (void) setUserData:(gpointer) data
{
    gtk_object_set_user_data(gtk, data);
}
- (gpointer) getUserData
{
    return gtk_object_get_user_data(gtk);
}
- (GTKObject*) checkCast:(GtkType) cast_type
{
    return Gtk_to_Object(gtk_object_check_cast(gtk, cast_type), 0);
}
+ (GtkObjectClass*) checkClassCast:(GtkObjectClass *) klass castType:(GtkType) cast_type
{
    return gtk_object_check_class_cast( klass , cast_type);
}
#define gtk	((GtkObject *) gtk)
static void destroy_notify (GTKObject *self)
{
    [self dealloc];
}
 - initWithGtk:(gpointer) _gtk
{
    [super initWithGtk:_gtk];

    // disable floating flag, we use autorelease instead...
    GTK_OBJECT_UNSET_FLAGS(_gtk, GTK_FLOATING);
    [self weakref:(GtkDestroyNotify) destroy_notify data:self];

    if (![self isKindOfClass:[GTKWindow class]] &&
	![self isKindOfClass:[GTKMenu class]] &&
	[self respondsToSelector:@selector(show)]) [(id) self show];
    return self;
}
 - (oneway void) release
{
#ifdef DEBUG
    if (gtk->ref_count == 0)
	g_error("ref_count == 0 in " __FILE__ " (release)");
#endif
    [self unref];
}
 - retain
{
    if (gtk) [self ref];
    return self;
}
 - (unsigned) retainCount
{
    return gtk->ref_count;
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKOptionMenu
+ (guint) getType
{
    return gtk_option_menu_get_type();
}
+ optionMenu
{
    return [[(GTKOptionMenu *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_option_menu_new()];
}
- (GTKWidget*) getMenu
{
    return Gtk_to_Object(gtk_option_menu_get_menu(gtk), 0);
}
- (void) setMenu:(GTKWidget *) menu
{
    gtk_option_menu_set_menu(gtk,[ menu gtk]);
}
- (void) removeMenu
{
    gtk_option_menu_remove_menu(gtk);
}
- (void) setHistory:(guint) index
{
    gtk_option_menu_set_history(gtk, index);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKPaned
+ (guint) getType
{
    return gtk_paned_get_type();
}
- (void) add1:(GTKWidget *) child
{
    gtk_paned_add1(gtk,[ child gtk]);
}
- (void) add2:(GTKWidget *) child
{
    gtk_paned_add2(gtk,[ child gtk]);
}
- (void) handleSize:(guint16) size
{
    gtk_paned_handle_size(gtk, size);
}
- (void) gutterSize:(guint16) size
{
    gtk_paned_gutter_size(gtk, size);
}
#define gtk	((GtkPaned *) gtk)
- child1
{
    return Gtk_to_Object(gtk->child1, 0);
}
- child2
{
    return Gtk_to_Object(gtk->child2, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKPixmap
+ (guint) getType
{
    return gtk_pixmap_get_type();
}
+ pixmapWithPixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    return [[(GTKPixmap *)[self alloc] initWithPixmap:pixmap mask:mask] autorelease];
}
- initWithPixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    return [self initWithGtk:gtk_pixmap_new( pixmap , mask)];
}
- (void) set:(GdkPixmap *) val mask:(GdkBitmap *) mask
{
    gtk_pixmap_set(gtk, val , mask);
}
- (void) get:(GdkPixmap **) val mask:(GdkBitmap **) mask
{
    gtk_pixmap_get(gtk, val , mask);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKPreview
+ (guint) getType
{
    return gtk_preview_get_type();
}
+ (void) uninit
{
    gtk_preview_uninit();
}
+ previewWithType:(GtkPreviewType) type
{
    return [[(GTKPreview *)[self alloc] initWithType:type] autorelease];
}
- initWithType:(GtkPreviewType) type
{
    return [self initWithGtk:gtk_preview_new( type)];
}
- (void) size:(gint) width height:(gint) height
{
    gtk_preview_size(gtk, width , height);
}
- (void) put:(GdkWindow *) window gc:(GdkGC *) gc srcx:(gint) srcx srcy:(gint) srcy destx:(gint) destx desty:(gint) desty width:(gint) width height:(gint) height
{
    gtk_preview_put(gtk, window , gc , srcx , srcy , destx , desty , width , height);
}
- (void) putRow:(guchar *) src dest:(guchar *) dest x:(gint) x y:(gint) y w:(gint) w
{
    gtk_preview_put_row(gtk, src , dest , x , y , w);
}
- (void) drawRow:(guchar *) data x:(gint) x y:(gint) y w:(gint) w
{
    gtk_preview_draw_row(gtk, data , x , y , w);
}
- (void) setExpand:(gint) expand
{
    gtk_preview_set_expand(gtk, expand);
}
+ (void) setGamma:(double) gamma
{
    gtk_preview_set_gamma( gamma);
}
+ (void) setColorCube:(guint) nred_shades ngreenShades:(guint) ngreen_shades nblueShades:(guint) nblue_shades ngrayShades:(guint) ngray_shades
{
    gtk_preview_set_color_cube( nred_shades , ngreen_shades , nblue_shades , ngray_shades);
}
+ (void) setInstallCmap:(gint) install_cmap
{
    gtk_preview_set_install_cmap( install_cmap);
}
+ (void) setReserved:(gint) nreserved
{
    gtk_preview_set_reserved( nreserved);
}
+ (GdkVisual*) getVisual
{
    return gtk_preview_get_visual();
}
+ (GdkColormap*) getCmap
{
    return gtk_preview_get_cmap();
}
+ (GtkPreviewInfo*) getInfo
{
    return gtk_preview_get_info();
}
+ (void) reset
{
    gtk_preview_reset();
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKProgressBar
+ (guint) getType
{
    return gtk_progress_bar_get_type();
}
+ progressBar
{
    return [[(GTKProgressBar *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_progress_bar_new()];
}
- (void) update:(gfloat) percentage
{
    gtk_progress_bar_update(gtk, percentage);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKRadioButton
+ (guint) getType
{
    return gtk_radio_button_get_type();
}
+ radioButtonWithGroup:(GSList *) group
{
    return [[(GTKRadioButton *)[self alloc] initWithGroup:group] autorelease];
}
- initWithGroup:(GSList *) group
{
    return [self initWithGtk:gtk_radio_button_new( group)];
}
+ radioButtonFromWidgetWithGroup:(GTKRadioButton *) group
{
    return [[(GTKRadioButton *)[self alloc] initFromWidgetWithGroup:group] autorelease];
}
- initFromWidgetWithGroup:(GTKRadioButton *) group
{
    return [self initWithGtk:gtk_radio_button_new_from_widget([ group gtk])];
}
+ radioButtonWithLabel:(GSList *) group label:(const NSString *) label
{
    return [[(GTKRadioButton *)[self alloc] initWithLabel:group label:label] autorelease];
}
- initWithLabel:(GSList *) group label:(const NSString *) label
{
    return [self initWithGtk:gtk_radio_button_new_with_label( group ,NSString_to_String( label))];
}
+ radioButtonWithLabelFromWidget:(GTKRadioButton *) group label:(const NSString *) label
{
    return [[(GTKRadioButton *)[self alloc] initWithLabelFromWidget:group label:label] autorelease];
}
- initWithLabelFromWidget:(GTKRadioButton *) group label:(const NSString *) label
{
    return [self initWithGtk:gtk_radio_button_new_with_label_from_widget([ group  gtk],NSString_to_String( label))];
}
- (GSList*) group
{
    return gtk_radio_button_group(gtk);
}
- (void) setGroup:(GSList *) group
{
    gtk_radio_button_set_group(gtk, group);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKRadioMenuItem
+ (guint) getType
{
    return gtk_radio_menu_item_get_type();
}
+ radioMenuItemWithGroup:(GSList *) group
{
    return [[(GTKRadioMenuItem *)[self alloc] initWithGroup:group] autorelease];
}
- initWithGroup:(GSList *) group
{
    return [self initWithGtk:gtk_radio_menu_item_new( group)];
}
+ radioMenuItemWithLabel:(GSList *) group label:(const NSString *) label
{
    return [[(GTKRadioMenuItem *)[self alloc] initWithLabel:group label:label] autorelease];
}
- initWithLabel:(GSList *) group label:(const NSString *) label
{
    return [self initWithGtk:gtk_radio_menu_item_new_with_label( group ,NSString_to_String( label))];
}
- (GSList*) group
{
    return gtk_radio_menu_item_group(gtk);
}
- (void) setGroup:(GSList *) group
{
    gtk_radio_menu_item_set_group(gtk, group);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKRange
+ (guint) getType
{
    return gtk_range_get_type();
}
- (GTKAdjustment*) getAdjustment
{
    return Gtk_to_Object(gtk_range_get_adjustment(gtk), 0);
}
- (void) setUpdatePolicy:(GtkUpdateType) policy
{
    gtk_range_set_update_policy(gtk, policy);
}
- (void) setAdjustment:(GTKAdjustment *) adjustment
{
    gtk_range_set_adjustment(gtk,[ adjustment gtk]);
}
- (void) drawBackground
{
    gtk_range_draw_background(gtk);
}
- (void) drawTrough
{
    gtk_range_draw_trough(gtk);
}
- (void) drawSlider
{
    gtk_range_draw_slider(gtk);
}
- (void) drawStepForw
{
    gtk_range_draw_step_forw(gtk);
}
- (void) drawStepBack
{
    gtk_range_draw_step_back(gtk);
}
- (void) sliderUpdate
{
    gtk_range_slider_update(gtk);
}
- (gint) troughClick:(gint) x y:(gint) y jumpPerc:(gfloat *) jump_perc
{
    return gtk_range_trough_click(gtk, x , y , jump_perc);
}
- (void) defaultHsliderUpdate
{
    gtk_range_default_hslider_update(gtk);
}
- (void) defaultVsliderUpdate
{
    gtk_range_default_vslider_update(gtk);
}
- (gint) defaultHtroughClick:(gint) x y:(gint) y jumpPerc:(gfloat *) jump_perc
{
    return gtk_range_default_htrough_click(gtk, x , y , jump_perc);
}
- (gint) defaultVtroughClick:(gint) x y:(gint) y jumpPerc:(gfloat *) jump_perc
{
    return gtk_range_default_vtrough_click(gtk, x , y , jump_perc);
}
- (void) defaultHmotion:(gint) xdelta ydelta:(gint) ydelta
{
    gtk_range_default_hmotion(gtk, xdelta , ydelta);
}
- (void) defaultVmotion:(gint) xdelta ydelta:(gint) ydelta
{
    gtk_range_default_vmotion(gtk, xdelta , ydelta);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKRuler
+ (guint) getType
{
    return gtk_ruler_get_type();
}
- (void) setMetric:(GtkMetricType) metric
{
    gtk_ruler_set_metric(gtk, metric);
}
- (void) setRange:(gfloat) lower upper:(gfloat) upper position:(gfloat) position maxSize:(gfloat) max_size
{
    gtk_ruler_set_range(gtk, lower , upper , position , max_size);
}
- (void) drawTicks
{
    gtk_ruler_draw_ticks(gtk);
}
- (void) drawPos
{
    gtk_ruler_draw_pos(gtk);
}
#define gtk	((GtkRuler *) gtk)
- (void) setPosition:(gfloat) position
{
    gtk->position = position;
}
- (gfloat) position
{
    return gtk->position;
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKScale
+ (guint) getType
{
    return gtk_scale_get_type();
}
- (void) setDigits:(gint) digits
{
    gtk_scale_set_digits(gtk, digits);
}
- (void) setDrawValue:(gint) draw_value
{
    gtk_scale_set_draw_value(gtk, draw_value);
}
- (void) setValuePos:(GtkPositionType) pos
{
    gtk_scale_set_value_pos(gtk, pos);
}
- (gint) valueWidth
{
    return gtk_scale_value_width(gtk);
}
- (void) drawValue
{
    gtk_scale_draw_value(gtk);
}
- (void) setDoubleValue:(double) value
{
    GtkAdjustment *adjustment = gtk_range_get_adjustment(gtk);
    gfloat new_value = value;

    if (adjustment->value != new_value)
	gtk_adjustment_set_value(adjustment, new_value);
}
- (double) doubleValue
{
    return gtk_range_get_adjustment(gtk)->value;
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKScrollbar
+ (guint) getType
{
    return gtk_scrollbar_get_type();
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKScrolledWindow
+ (guint) getType
{
    return gtk_scrolled_window_get_type();
}
+ scrolledWindowWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [[(GTKScrolledWindow *)[self alloc] initWithHadjustment:hadjustment vadjustment:vadjustment] autorelease];
}
- initWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [self initWithGtk:gtk_scrolled_window_new([ hadjustment  gtk],[ vadjustment gtk])];
}
- (void) construct:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    gtk_scrolled_window_construct(gtk,[ hadjustment  gtk],[ vadjustment gtk]);
}
- (GTKAdjustment*) getHadjustment
{
    return Gtk_to_Object(gtk_scrolled_window_get_hadjustment(gtk), 0);
}
- (GTKAdjustment*) getVadjustment
{
    return Gtk_to_Object(gtk_scrolled_window_get_vadjustment(gtk), 0);
}
- (void) setPolicy:(GtkPolicyType) hscrollbar_policy vscrollbarPolicy:(GtkPolicyType) vscrollbar_policy
{
    gtk_scrolled_window_set_policy(gtk, hscrollbar_policy , vscrollbar_policy);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKSeparator
+ (guint) getType
{
    return gtk_separator_get_type();
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKSpinButton
+ (guint) getType
{
    return gtk_spin_button_get_type();
}
- (void) construct:(GTKAdjustment *) adjustment climbRate:(gfloat) climb_rate digits:(gint) digits
{
    gtk_spin_button_construct(gtk,[ adjustment  gtk], climb_rate , digits);
}
+ spinButtonWithAdjustment:(GTKAdjustment *) adjustment climbRate:(gfloat) climb_rate digits:(gint) digits
{
    return [[(GTKSpinButton *)[self alloc] initWithAdjustment:adjustment climbRate:climb_rate digits:digits] autorelease];
}
- initWithAdjustment:(GTKAdjustment *) adjustment climbRate:(gfloat) climb_rate digits:(gint) digits
{
    return [self initWithGtk:gtk_spin_button_new([ adjustment  gtk], climb_rate , digits)];
}
- (void) setAdjustment:(GTKAdjustment *) adjustment
{
    gtk_spin_button_set_adjustment(gtk,[ adjustment gtk]);
}
- (GTKAdjustment*	) getAdjustment
{
    return Gtk_to_Object(gtk_spin_button_get_adjustment(gtk), 0);
}
- (void) setDigits:(gint) digits
{
    gtk_spin_button_set_digits(gtk, digits);
}
- (gfloat) getValueAsFloat
{
    return gtk_spin_button_get_value_as_float(gtk);
}
- (gint) getValueAsInt
{
    return gtk_spin_button_get_value_as_int(gtk);
}
- (void) setValue:(gfloat) value
{
    gtk_spin_button_set_value(gtk, value);
}
- (void) setUpdatePolicy:(GtkSpinButtonUpdatePolicy) policy
{
    gtk_spin_button_set_update_policy(gtk, policy);
}
- (void) setNumeric:(gint) numeric
{
    gtk_spin_button_set_numeric(gtk, numeric);
}
- (void) spin:(guint) direction step:(gfloat) step
{
    gtk_spin_button_spin(gtk, direction , step);
}
- (void) setWrap:(gint) wrap
{
    gtk_spin_button_set_wrap(gtk, wrap);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKStatusbar
+ (guint) getType
{
    return gtk_statusbar_get_type();
}
+ statusbar
{
    return [[(GTKStatusbar *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_statusbar_new()];
}
- (guint) getContextId:(const NSString *) context_description
{
    return gtk_statusbar_get_context_id(gtk,NSString_to_String( context_description));
}
- (guint) push:(guint) context_id text:(const NSString *) text
{
    return gtk_statusbar_push(gtk, context_id ,NSString_to_String( text));
}
- (void) pop:(guint) context_id
{
    gtk_statusbar_pop(gtk, context_id);
}
- (void) remove:(guint) context_id messageId:(guint) message_id
{
    gtk_statusbar_remove(gtk, context_id , message_id);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKStyle
+ style
{
    return [[(GTKStyle *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_style_new()];
}
- (GTKStyle*) copy
{
    return Gtk_to_Object(gtk_style_copy(gtk), "GTKStyle");
}
- (GTKStyle*) attach:(GdkWindow *) window
{
    return Gtk_to_Object(gtk_style_attach(gtk, window), "GTKStyle");
}
- (void) detach
{
    gtk_style_detach(gtk);
}
- (GTKStyle*) ref
{
    return Gtk_to_Object(gtk_style_ref(gtk), "GTKStyle");
}
- (void) unref
{
    gtk_style_unref(gtk);
}
- (void) setBackground:(GdkWindow *) window stateType:(GtkStateType) state_type
{
    gtk_style_set_background(gtk, window , state_type);
}
#define gtk	((GtkStyle *) gtk)
 - (oneway void) release
{
    unsigned ref_count = gtk->ref_count;

#ifdef DEBUG
    if (ref_count == 0) g_error("ref_count == 0 in " __FILE__ " (release)");
#endif
    [self unref];
    if (ref_count == 1) [self dealloc];
}
 - retain
{
    if (gtk) [self ref];
    return self;
}
 - (unsigned) retainCount
{
    return gtk->ref_count;
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKTable
+ (guint) getType
{
    return gtk_table_get_type();
}
+ tableWithRows:(gint) rows columns:(gint) columns homogeneous:(gint) homogeneous
{
    return [[(GTKTable *)[self alloc] initWithRows:rows columns:columns homogeneous:homogeneous] autorelease];
}
- initWithRows:(gint) rows columns:(gint) columns homogeneous:(gint) homogeneous
{
    return [self initWithGtk:gtk_table_new( rows , columns , homogeneous)];
}
- (void) attach:(GTKWidget *) child leftAttach:(gint) left_attach rightAttach:(gint) right_attach topAttach:(gint) top_attach bottomAttach:(gint) bottom_attach xoptions:(gint) xoptions yoptions:(gint) yoptions xpadding:(gint) xpadding ypadding:(gint) ypadding
{
    gtk_table_attach(gtk,[ child  gtk], left_attach , right_attach , top_attach , bottom_attach , xoptions , yoptions , xpadding , ypadding);
}
- (void) attachDefaults:(GTKWidget *) widget leftAttach:(gint) left_attach rightAttach:(gint) right_attach topAttach:(gint) top_attach bottomAttach:(gint) bottom_attach
{
    gtk_table_attach_defaults(gtk,[ widget  gtk], left_attach , right_attach , top_attach , bottom_attach);
}
- (void) setRowSpacing:(gint) row spacing:(gint) spacing
{
    gtk_table_set_row_spacing(gtk, row , spacing);
}
- (void) setColSpacing:(gint) column spacing:(gint) spacing
{
    gtk_table_set_col_spacing(gtk, column , spacing);
}
- (void) setRowSpacings:(gint) spacing
{
    gtk_table_set_row_spacings(gtk, spacing);
}
- (void) setColSpacings:(gint) spacing
{
    gtk_table_set_col_spacings(gtk, spacing);
}
- (void) setHomogeneous:(gint) homogeneous
{
    gtk_table_set_homogeneous(gtk, homogeneous);
}
#define gtk	((GtkTable *) gtk)
- (gint) rows
{
    return gtk->nrows;
}
- (gint) columns
{
    return gtk->ncols;
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKText
+ (guint) getType
{
    return gtk_text_get_type();
}
+ textWithHadj:(GTKAdjustment *) hadj vadj:(GTKAdjustment *) vadj
{
    return [[(GTKText *)[self alloc] initWithHadj:hadj vadj:vadj] autorelease];
}
- initWithHadj:(GTKAdjustment *) hadj vadj:(GTKAdjustment *) vadj
{
    return [self initWithGtk:gtk_text_new([ hadj  gtk],[ vadj gtk])];
}
- (void) setEditable:(gint) editable
{
    gtk_text_set_editable(gtk, editable);
}
- (void) setWordWrap:(gint) word_wrap
{
    gtk_text_set_word_wrap(gtk, word_wrap);
}
- (void) setAdjustments:(GTKAdjustment *) hadj vadj:(GTKAdjustment *) vadj
{
    gtk_text_set_adjustments(gtk,[ hadj  gtk],[ vadj gtk]);
}
- (void) setPoint:(guint) index
{
    gtk_text_set_point(gtk, index);
}
- (guint) getPoint
{
    return gtk_text_get_point(gtk);
}
- (guint) getLength
{
    return gtk_text_get_length(gtk);
}
- (void) freeze
{
    gtk_text_freeze(gtk);
}
- (void) thaw
{
    gtk_text_thaw(gtk);
}
- (void) insert:(GdkFont *) font fore:(GdkColor *) fore back:(GdkColor *) back chars:(const NSString *) chars length:(gint) length
{
    gtk_text_insert(gtk, font , fore , back ,NSString_to_String( chars ), length);
}
- (gint) backwardDelete:(guint) nchars
{
    return gtk_text_backward_delete(gtk, nchars);
}
- (gint) forwardDelete:(guint) nchars
{
    return gtk_text_forward_delete(gtk, nchars);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKTipsQuery
+ (GtkType) getType
{
    return gtk_tips_query_get_type();
}
+ tipsQuery
{
    return [[(GTKTipsQuery *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_tips_query_new()];
}
- (void) startQuery
{
    gtk_tips_query_start_query(gtk);
}
- (void) stopQuery
{
    gtk_tips_query_stop_query(gtk);
}
- (void) setCaller:(GTKWidget	*) caller
{
    gtk_tips_query_set_caller(gtk,[ caller gtk]);
}
- (void) setLabels:(const NSString *) label_inactive labelNoTip:(const NSString *) label_no_tip
{
    gtk_tips_query_set_labels(gtk,NSString_to_String( label_inactive ),NSString_to_String( label_no_tip));
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKToggleButton
+ (guint) getType
{
    return gtk_toggle_button_get_type();
}
+ toggleButton
{
    return [[(GTKToggleButton *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_toggle_button_new()];
}
+ toggleButtonWithLabel:(const NSString *) label
{
    return [[(GTKToggleButton *)[self alloc] initWithLabel:label] autorelease];
}
- initWithLabel:(const NSString *) label
{
    return [self initWithGtk:gtk_toggle_button_new_with_label(NSString_to_String( label))];
}
- (void) setMode:(gint) draw_indicator
{
    gtk_toggle_button_set_mode(gtk, draw_indicator);
}
- (void) setState:(gint) state
{
    gtk_toggle_button_set_state(gtk, state);
}
- (void) toggled
{
    gtk_toggle_button_toggled(gtk);
}
#define gtk	((GtkToggleButton *) gtk)
- (gint) state
{
    return gtk->active;
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKToolbar
+ (guint) getType
{
    return gtk_toolbar_get_type();
}
+ toolbarWithOrientation:(GtkOrientation) orientation style:(GtkToolbarStyle) style
{
    return [[(GTKToolbar *)[self alloc] initWithOrientation:orientation style:style] autorelease];
}
- initWithOrientation:(GtkOrientation) orientation style:(GtkToolbarStyle) style
{
    return [self initWithGtk:gtk_toolbar_new( orientation , style)];
}
- (GTKWidget *) appendItem:(const NSString *) text tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data
{
    return Gtk_to_Object(gtk_toolbar_append_item(gtk,NSString_to_String( text ),NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text ),[ icon  gtk], callback , user_data), 0);
}
- (GTKWidget *) prependItem:(const NSString *) text tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data
{
    return Gtk_to_Object(gtk_toolbar_prepend_item(gtk,NSString_to_String( text ),NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text ),[ icon  gtk], callback , user_data), 0);
}
- (GTKWidget *) insertItem:(const NSString *) text tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data position:(gint) position
{
    return Gtk_to_Object(gtk_toolbar_insert_item(gtk,NSString_to_String( text ),NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text ),[ icon  gtk], callback , user_data , position), 0);
}
- (void) appendSpace
{
    gtk_toolbar_append_space(gtk);
}
- (void) prependSpace
{
    gtk_toolbar_prepend_space(gtk);
}
- (void) insertSpace:(gint) position
{
    gtk_toolbar_insert_space(gtk, position);
}
- (GTKWidget *) appendElement:(GtkToolbarChildType) type widget:(GTKWidget *) widget text:(const NSString *) text tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data
{
    return Gtk_to_Object(gtk_toolbar_append_element(gtk, type ,[ widget  gtk],NSString_to_String( text ),NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text ),[ icon  gtk], callback , user_data), 0);
}
- (GTKWidget *) prependElement:(GtkToolbarChildType) type widget:(GTKWidget *) widget text:(const NSString *) text tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data
{
    return Gtk_to_Object(gtk_toolbar_prepend_element(gtk, type ,[ widget  gtk],NSString_to_String( text ),NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text ),[ icon  gtk], callback , user_data), 0);
}
- (GTKWidget *) insertElement:(GtkToolbarChildType) type widget:(GTKWidget *) widget text:(const NSString *) text tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data position:(gint) position
{
    return Gtk_to_Object(gtk_toolbar_insert_element(gtk, type ,[ widget  gtk],NSString_to_String( text ),NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text ),[ icon  gtk], callback , user_data , position), 0);
}
- (void) appendWidget:(GTKWidget *) widget tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text
{
    gtk_toolbar_append_widget(gtk,[ widget  gtk],NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text));
}
- (void) prependWidget:(GTKWidget *) widget tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text
{
    gtk_toolbar_prepend_widget(gtk,[ widget  gtk],NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text));
}
- (void) insertWidget:(GTKWidget *) widget tooltipText:(const NSString *) tooltip_text tooltipPrivateText:(const NSString *) tooltip_private_text position:(gint) position
{
    gtk_toolbar_insert_widget(gtk,[ widget  gtk],NSString_to_String( tooltip_text ),NSString_to_String( tooltip_private_text ), position);
}
- (void) setOrientation:(GtkOrientation) orientation
{
    gtk_toolbar_set_orientation(gtk, orientation);
}
- (void) setStyle:(GtkToolbarStyle) style
{
    gtk_toolbar_set_style(gtk, style);
}
- (void) setSpaceSize:(gint) space_size
{
    gtk_toolbar_set_space_size(gtk, space_size);
}
- (void) setTooltips:(gint) enable
{
    gtk_toolbar_set_tooltips(gtk, enable);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKTooltips
+ (GtkType) getType
{
    return gtk_tooltips_get_type();
}
+ tooltips
{
    return [[(GTKTooltips *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_tooltips_new()];
}
- (void) enable
{
    gtk_tooltips_enable(gtk);
}
- (void) disable
{
    gtk_tooltips_disable(gtk);
}
- (void) setDelay:(guint) delay
{
    gtk_tooltips_set_delay(gtk, delay);
}
- (void) setTip:(GTKWidget *) widget tipText:(const NSString *) tip_text tipPrivate:(const NSString *) tip_private
{
    gtk_tooltips_set_tip(gtk,[ widget  gtk],NSString_to_String( tip_text ),NSString_to_String( tip_private));
}
- (void) setColors:(GdkColor *) background foreground:(GdkColor *) foreground
{
    gtk_tooltips_set_colors(gtk, background , foreground);
}
+ (GtkTooltipsData*) dataGet:(GTKWidget *) widget
{
    return gtk_tooltips_data_get([ widget gtk]);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKTree
+ (guint) getType
{
    return gtk_tree_get_type();
}
+ tree
{
    return [[(GTKTree *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_tree_new()];
}
- (void) append:(GTKWidget *) tree_item
{
    gtk_tree_append(gtk,[ tree_item gtk]);
}
- (void) prepend:(GTKWidget *) tree_item
{
    gtk_tree_prepend(gtk,[ tree_item gtk]);
}
- (void) insert:(GTKWidget *) tree_item position:(gint) position
{
    gtk_tree_insert(gtk,[ tree_item  gtk], position);
}
- (void) removeItems:(NSArray *) items
{
    gtk_tree_remove_items(gtk,NSArray_to_GList( items));
}
- (void) clearItems:(gint) start end:(gint) end
{
    gtk_tree_clear_items(gtk, start , end);
}
- (void) selectItem:(gint) item
{
    gtk_tree_select_item(gtk, item);
}
- (void) unselectItem:(gint) item
{
    gtk_tree_unselect_item(gtk, item);
}
- (void) selectChild:(GTKWidget *) tree_item
{
    gtk_tree_select_child(gtk,[ tree_item gtk]);
}
- (void) unselectChild:(GTKWidget *) tree_item
{
    gtk_tree_unselect_child(gtk,[ tree_item gtk]);
}
- (gint) childPosition:(GTKWidget *) child
{
    return gtk_tree_child_position(gtk,[ child gtk]);
}
- (void) setSelectionMode:(GtkSelectionMode) mode
{
    gtk_tree_set_selection_mode(gtk, mode);
}
- (void) setViewMode:(GtkTreeViewMode) mode
{
    gtk_tree_set_view_mode(gtk, mode);
}
- (void) setViewLines:(guint) flag
{
    gtk_tree_set_view_lines(gtk, flag);
}
- (void) removeItem:(GTKWidget *) child
{
    gtk_tree_remove_item(gtk,[ child gtk]);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKTreeItem
+ (guint) getType
{
    return gtk_tree_item_get_type();
}
+ treeItem
{
    return [[(GTKTreeItem *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_tree_item_new()];
}
+ treeItemWithLabel:(NSString *) label
{
    return [[(GTKTreeItem *)[self alloc] initWithLabel:label] autorelease];
}
- initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_tree_item_new_with_label(NSString_to_String( label))];
}
- (void) setSubtree:(GTKWidget *) subtree
{
    gtk_tree_item_set_subtree(gtk,[ subtree gtk]);
}
- (void) removeSubtree
{
    gtk_tree_item_remove_subtree(gtk);
}
- (void) select
{
    gtk_tree_item_select(gtk);
}
- (void) deselect
{
    gtk_tree_item_deselect(gtk);
}
- (void) expand
{
    gtk_tree_item_expand(gtk);
}
- (void) collapse
{
    gtk_tree_item_collapse(gtk);
}
#define gtk	((GtkTreeItem *) gtk)
- (GTKWidget *) subtree
{
    return Gtk_to_Object(gtk->subtree, 0);
}
#undef gtk
@end
#include <GToolKit/GToolKit.h>

@implementation GTKVButtonBox
+ (guint) getType
{
    return gtk_vbutton_box_get_type();
}
+ vButtonBox
{
    return [[(GTKVButtonBox *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_vbutton_box_new()];
}
+ (gint) getSpacingDefault
{
    return gtk_vbutton_box_get_spacing_default();
}
+ (void) setSpacingDefault:(gint) spacing
{
    gtk_vbutton_box_set_spacing_default( spacing);
}
+ (GtkButtonBoxStyle) getLayoutDefault
{
    return gtk_vbutton_box_get_layout_default();
}
+ (void) setLayoutDefault:(GtkButtonBoxStyle) layout
{
    gtk_vbutton_box_set_layout_default( layout);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKVBox
+ (guint) getType
{
    return gtk_vbox_get_type();
}
+ vBoxWithHomogeneous:(gint) homogeneous spacing:(gint) spacing
{
    return [[(GTKVBox *)[self alloc] initWithHomogeneous:homogeneous spacing:spacing] autorelease];
}
- initWithHomogeneous:(gint) homogeneous spacing:(gint) spacing
{
    return [self initWithGtk:gtk_vbox_new( homogeneous , spacing)];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKViewport
+ (guint) getType
{
    return gtk_viewport_get_type();
}
+ viewportWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [[(GTKViewport *)[self alloc] initWithHadjustment:hadjustment vadjustment:vadjustment] autorelease];
}
- initWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [self initWithGtk:gtk_viewport_new([ hadjustment  gtk],[ vadjustment gtk])];
}
- (GTKAdjustment*) getHadjustment
{
    return Gtk_to_Object(gtk_viewport_get_hadjustment(gtk), 0);
}
- (GTKAdjustment*) getVadjustment
{
    return Gtk_to_Object(gtk_viewport_get_vadjustment(gtk), 0);
}
- (void) setHadjustment:(GTKAdjustment *) adjustment
{
    gtk_viewport_set_hadjustment(gtk,[ adjustment gtk]);
}
- (void) setVadjustment:(GTKAdjustment *) adjustment
{
    gtk_viewport_set_vadjustment(gtk,[ adjustment gtk]);
}
- (void) setShadowType:(GtkShadowType) type
{
    gtk_viewport_set_shadow_type(gtk, type);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKVPaned
+ (guint) getType
{
    return gtk_vpaned_get_type();
}
+ vPaned
{
    return [[(GTKVPaned *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_vpaned_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKVRuler
+ (guint) getType
{
    return gtk_vruler_get_type();
}
+ vRuler
{
    return [[(GTKVRuler *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_vruler_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKVScale
+ (guint) getType
{
    return gtk_vscale_get_type();
}
+ vScaleWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKVScale *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_vscale_new([ adjustment gtk])];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKVScrollbar
+ (guint) getType
{
    return gtk_vscrollbar_get_type();
}
+ vScrollbarWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKVScrollbar *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_vscrollbar_new([ adjustment gtk])];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKVSeparator
+ (guint) getType
{
    return gtk_vseparator_get_type();
}
+ vSeparator
{
    return [[(GTKVSeparator *)[self alloc] init] autorelease];
}
- init
{
    return [self initWithGtk:gtk_vseparator_new()];
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKWidget
+ (GtkType) getType
{
    return gtk_widget_get_type();
}
+ widgetvWithType:(guint) type nargs:(guint) nargs args:(GtkArg *) args
{
    return [[(GTKWidget *)[self alloc] initvWithType:type nargs:nargs args:args] autorelease];
}
- initvWithType:(guint) type nargs:(guint) nargs args:(GtkArg *) args
{
    return [self initWithGtk:gtk_widget_newv( type , nargs , args)];
}
- (void) ref
{
    gtk_widget_ref(gtk);
}
- (void) unref
{
    gtk_widget_unref(gtk);
}
- (void) destroy
{
    gtk_widget_destroy(gtk);
}
- (void) destroyed:(GTKWidget **) widget_pointer
{
    GtkWidget * _outval_1;
    gtk_widget_destroyed(gtk,&_outval_1);
    * widget_pointer = Gtk_to_Object(_outval_1, 0);
}
- (void) get:(GtkArg *) arg
{
    gtk_widget_get(gtk, arg);
}
- (void) getv:(guint) nargs args:(GtkArg *) args
{
    gtk_widget_getv(gtk, nargs , args);
}
- (void) setv:(guint) nargs args:(GtkArg *) args
{
    gtk_widget_setv(gtk, nargs , args);
}
- (void) unparent
{
    gtk_widget_unparent(gtk);
}
- (void) show
{
    gtk_widget_show(gtk);
}
- (void) showNow
{
    gtk_widget_show_now(gtk);
}
- (void) hide
{
    gtk_widget_hide(gtk);
}
- (void) showAll
{
    gtk_widget_show_all(gtk);
}
- (void) hideAll
{
    gtk_widget_hide_all(gtk);
}
- (void) map
{
    gtk_widget_map(gtk);
}
- (void) unmap
{
    gtk_widget_unmap(gtk);
}
- (void) realize
{
    gtk_widget_realize(gtk);
}
- (void) unrealize
{
    gtk_widget_unrealize(gtk);
}
- (void) queueDraw
{
    gtk_widget_queue_draw(gtk);
}
- (void) queueResize
{
    gtk_widget_queue_resize(gtk);
}
- (void) draw:(GdkRectangle *) area
{
    gtk_widget_draw(gtk, area);
}
- (void) drawFocus
{
    gtk_widget_draw_focus(gtk);
}
- (void) drawDefault
{
    gtk_widget_draw_default(gtk);
}
- (void) drawChildren
{
    gtk_widget_draw_children(gtk);
}
- (void) sizeRequest:(GtkRequisition *) requisition
{
    gtk_widget_size_request(gtk, requisition);
}
- (void) sizeAllocate:(GtkAllocation *) allocation
{
    gtk_widget_size_allocate(gtk, allocation);
}
- (void) installAccelerator:(GTKAcceleratorTable *) table signalName:(const NSString *) signal_name key:(gchar) key modifiers:(guint8) modifiers
{
    gtk_widget_install_accelerator(gtk,[ table  gtk],NSString_to_String( signal_name ), key , modifiers);
}
- (void) removeAccelerator:(GTKAcceleratorTable *) table signalName:(const NSString *) signal_name
{
    gtk_widget_remove_accelerator(gtk,[ table  gtk],NSString_to_String( signal_name));
}
- (gint) event:(GdkEvent *) event
{
    return gtk_widget_event(gtk, event);
}
- (void) activate
{
    gtk_widget_activate(gtk);
}
- (void) reparent:(GTKWidget *) new_parent
{
    gtk_widget_reparent(gtk,[ new_parent gtk]);
}
- (void) popup:(gint) x y:(gint) y
{
    gtk_widget_popup(gtk, x , y);
}
- (gint) intersect:(GdkRectangle *) area intersection:(GdkRectangle *) intersection
{
    return gtk_widget_intersect(gtk, area , intersection);
}
- (gint) basic
{
    return gtk_widget_basic(gtk);
}
- (void) grabFocus
{
    gtk_widget_grab_focus(gtk);
}
- (void) grabDefault
{
    gtk_widget_grab_default(gtk);
}
- (void) setName:(const NSString *) name
{
    gtk_widget_set_name(gtk,NSString_to_String( name));
}
- (NSString *) getName
{
    return String_to_NSString(gtk_widget_get_name(gtk));
}
- (void) setState:(GtkStateType) state
{
    gtk_widget_set_state(gtk, state);
}
- (void) setSensitive:(gint) sensitive
{
    gtk_widget_set_sensitive(gtk, sensitive);
}
- (void) setParent:(GTKWidget *) parent
{
    gtk_widget_set_parent(gtk,[ parent gtk]);
}
- (void) setParentWindow:(GdkWindow *) parent_window
{
    gtk_widget_set_parent_window(gtk, parent_window);
}
- (GdkWindow *) getParentWindow
{
    return gtk_widget_get_parent_window(gtk);
}
- (void) setUposition:(gint) x y:(gint) y
{
    gtk_widget_set_uposition(gtk, x , y);
}
- (void) setUsize:(gint) width height:(gint) height
{
    gtk_widget_set_usize(gtk, width , height);
}
- (void) setEvents:(gint) events
{
    gtk_widget_set_events(gtk, events);
}
- (void) setExtensionEvents:(GdkExtensionMode	) mode
{
    gtk_widget_set_extension_events(gtk, mode);
}
- (GdkExtensionMode) getExtensionEvents
{
    return gtk_widget_get_extension_events(gtk);
}
- (GTKWidget*) getToplevel
{
    return Gtk_to_Object(gtk_widget_get_toplevel(gtk), 0);
}
- (GTKWidget*) getAncestor:(GtkType	) widget_type
{
    return Gtk_to_Object(gtk_widget_get_ancestor(gtk, widget_type), 0);
}
- (GdkColormap*) getColormap
{
    return gtk_widget_get_colormap(gtk);
}
- (GdkVisual*) getVisual
{
    return gtk_widget_get_visual(gtk);
}
- (gint) getEvents
{
    return gtk_widget_get_events(gtk);
}
- (void) getPointer:(gint *) x y:(gint *) y
{
    gtk_widget_get_pointer(gtk, x , y);
}
- (gint) isAncestor:(GTKWidget	*) ancestor
{
    return gtk_widget_is_ancestor(gtk,[ ancestor gtk]);
}
- (gint) isChild:(GTKWidget	*) child
{
    return gtk_widget_is_child(gtk,[ child gtk]);
}
- (gint) hideOnDelete
{
    return gtk_widget_hide_on_delete(gtk);
}
- (void) setStyle:(GTKStyle	*) style
{
    gtk_widget_set_style(gtk,[ style gtk]);
}
- (void) setRcStyle
{
    gtk_widget_set_rc_style(gtk);
}
- (void) ensureStyle
{
    gtk_widget_ensure_style(gtk);
}
- (GTKStyle*) getStyle
{
    return Gtk_to_Object(gtk_widget_get_style(gtk), "GTKStyle");
}
- (void) restoreDefaultStyle
{
    gtk_widget_restore_default_style(gtk);
}
+ (void) propagateDefaultStyle
{
    gtk_widget_propagate_default_style();
}
+ (void) pushStyle:(GTKStyle	*) style
{
    gtk_widget_push_style([ style gtk]);
}
+ (void) pushColormap:(GdkColormap	*) cmap
{
    gtk_widget_push_colormap( cmap);
}
+ (void) pushVisual:(GdkVisual	*) visual
{
    gtk_widget_push_visual( visual);
}
+ (void) popStyle
{
    gtk_widget_pop_style();
}
+ (void) popColormap
{
    gtk_widget_pop_colormap();
}
+ (void) popVisual
{
    gtk_widget_pop_visual();
}
+ (void) setDefaultStyle:(GTKStyle *) style
{
    gtk_widget_set_default_style([ style gtk]);
}
+ (void) setDefaultColormap:(GdkColormap *) colormap
{
    gtk_widget_set_default_colormap( colormap);
}
+ (void) setDefaultVisual:(GdkVisual *) visual
{
    gtk_widget_set_default_visual( visual);
}
+ (GTKStyle*) getDefaultStyle
{
    return Gtk_to_Object(gtk_widget_get_default_style(), "GTKStyle");
}
+ (GdkColormap*) getDefaultColormap
{
    return gtk_widget_get_default_colormap();
}
+ (GdkVisual*) getDefaultVisual
{
    return gtk_widget_get_default_visual();
}
- (void) shapeCombineMask:(GdkBitmap *) shape_mask offsetX:(gint) offset_x offsetY:(gint) offset_y
{
    gtk_widget_shape_combine_mask(gtk, shape_mask , offset_x , offset_y);
}
- (void) dndDragAdd
{
    gtk_widget_dnd_drag_add(gtk);
}
- (void) dndDragSet:(guint8) drag_enable typeAcceptList:(NSArray  *) type_accept_list numtypes:(guint) numtypes
{
    gtk_widget_dnd_drag_set(gtk, drag_enable ,(char **)NSArray_to_StrVec( type_accept_list ), numtypes);
}
- (void) dndDropSet:(guint8) drop_enable typeAcceptList:(NSArray  *) type_accept_list numtypes:(guint) numtypes isDestructiveOperation:(guint8) is_destructive_operation
{
    gtk_widget_dnd_drop_set(gtk, drop_enable ,(char **)NSArray_to_StrVec( type_accept_list ), numtypes , is_destructive_operation);
}
- (void) dndDataSet:(GdkEvent *) event data:(gpointer) data dataNumbytes:(gulong) data_numbytes
{
    gtk_widget_dnd_data_set(gtk, event , data , data_numbytes);
}
@end
#include <GToolKit/GToolKit.h>

@implementation GTKWindow
+ (GtkType) getType
{
    return gtk_window_get_type();
}
+ windowWithType:(GtkWindowType) type
{
    return [[(GTKWindow *)[self alloc] initWithType:type] autorelease];
}
- initWithType:(GtkWindowType) type
{
    return [self initWithGtk:gtk_window_new( type)];
}
- (void) setTitle:(const NSString *) title
{
    gtk_window_set_title(gtk,NSString_to_String( title));
}
- (void) setWmclass:(const NSString *) wmclass_name wmclassClass:(const NSString *) wmclass_class
{
    gtk_window_set_wmclass(gtk,NSString_to_String( wmclass_name ),NSString_to_String( wmclass_class));
}
- (void) setFocus:(GTKWidget *) focus
{
    gtk_window_set_focus(gtk,[ focus gtk]);
}
- (void) setDefault:(GTKWidget *) defaultw
{
    gtk_window_set_default(gtk,[ defaultw gtk]);
}
- (void) setPolicy:(gint) allow_shrink allowGrow:(gint) allow_grow autoShrink:(gint) auto_shrink
{
    gtk_window_set_policy(gtk, allow_shrink , allow_grow , auto_shrink);
}
- (void) addAcceleratorTable:(GTKAcceleratorTable *) table
{
    gtk_window_add_accelerator_table(gtk,[ table gtk]);
}
- (void) removeAcceleratorTable:(GTKAcceleratorTable *) table
{
    gtk_window_remove_accelerator_table(gtk,[ table gtk]);
}
- (void) position:(GtkWindowPosition) position
{
    gtk_window_position(gtk, position);
}
- (gint) activateFocus
{
    return gtk_window_activate_focus(gtk);
}
- (gint) activateDefault
{
    return gtk_window_activate_default(gtk);
}
#define gtk	((GtkWindow *) gtk)
 - initWithGtk:(gpointer) _gtk
{
    [super initWithGtk:_gtk];
    [self ref];		// first reference is missing (due to floating flag)
    return self;
}
- (NSString *) title
{
    return String_to_NSString(gtk->title);
}
- (GTKWidget *) focusWidget
{
    return Gtk_to_Object(gtk->focus_widget, 0);
}
- (GTKWidget *) defaultWidget
{
    return Gtk_to_Object(gtk->default_widget, 0);
}
#undef gtk
@end
