/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998  Elmar Ludwig - Universitaet Osnabrueck
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GTOOLKIT_GTKAPPLICATION_H
#define GTOOLKIT_GTKAPPLICATION_H

#include <GToolKit/GTKMain.h>
#include <Foundation/NSNotification.h>

@class NSException;

#define GTKRunStoppedResponse	0

/*
 * Display a modal message box or alert panel.
 * Return value is n-1 if button number n is clicked (e.g. 0 for button1).
 */
int GTKRunMessageBox (NSString *title, NSString *format, NSString *button1,
		      NSString *button2, NSString *button3, ...);

/*
 * The GTKApplication class controls the running application and exactly one
 * instance of this class must be created when the program starts. This
 * GTKApplication object is globally accessible through the variable GTKApp!!,
 * so there is no need to pass it as an argument to method calls.<p>
 * Most of the methods of GTKApplication are implemented in its superclass
 * @GTKMain, so look there for additional methods to control the event loop.
 */
@interface GTKApplication : GTKMain
{
    id delegate;		  // delegate of the application object
    NSNotificationCenter *center; // default notification center of this task
    NSMutableArray *windows;	  // application's window list
    GTKWindow *mainWindow;	  // application's main window
    int modalCode;		  // return code of the current event loop
}

/* initializing the application object */
+ (GTKApplication *) sharedApplication;
- initWithArgc:(int *) argc argv:(char ***) argv;
- (void) finishLaunching;
- (void) setDelegate:delegate;
- delegate;

/* controlling the event loop */
- (void) run;
- (BOOL) isRunning;
- (int) runModalForWindow:(GTKWindow *) window;
- (void) stopModal;
- (void) stopModalWithCode:(int) code;
- (void) stop:sender;
- (void) terminate:sender;
- (void) reportException:(NSException *) exception;

/* managing the windows list */
- (BOOL) isActive;
- (GTKWindow *) mainWindow;
- (NSArray *) windows;
@end

extern NSString *GTKApplicationDidBecomeActiveNotification;
extern NSString *GTKApplicationDidFinishLaunchingNotification;
extern NSString *GTKApplicationDidResignActiveNotification;
extern NSString *GTKApplicationWillFinishLaunchingNotification;
extern NSString *GTKApplicationWillTerminateNotification;

/*
 * These methods may be implemented by the delegate.
 */
@protocol GTKApplicationDelegate
- (void) applicationDidBecomeActive:(NSNotification *) event;
- (void) applicationDidFinishLaunching:(NSNotification *) event;
- (void) applicationDidResignActive:(NSNotification *) event;
- (BOOL) applicationShouldTerminate:(GTKApplication *) sender;
- (BOOL) applicationShouldTerminateAfterLastWindowClosed:(GTKApplication *) sender;
- (void) applicationWillFinishLaunching:(NSNotification *) event;
- (void) applicationWillTerminate:(NSNotification *) event;
@end

extern GTKApplication *GTKApp;		// the application object

#endif
