#include <stdio.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSAutoreleasePool.h>
#include <GToolKit/GToolKit.h>

@interface GTKCListExample : GTKCList
- (void)   select:(id) sender row:(int) row column:(int) column;
- (void) unselect:(id) sender row:(int) row column:(int) column;
@end

@implementation GTKCListExample

- (id) initWithColumns:(gint) columns
{
    return [self initWithTitles:columns titles:nil];
}

- (id) initWithTitles:(gint) columns titles:(NSArray *) titles
{
    if (titles)
	[super initWithTitles:columns titles:titles];
    else
	[super initWithColumns:columns];

    [self setSelectionMode:GTK_SELECTION_MULTIPLE];

    [self connectSignal:@"select_row" withTarget:self
	  sel:@selector(select:row:column:)];
    [self connectSignal:@"unselect_row" withTarget:self
	  sel:@selector(unselect:row:column:)];
    return self;
}

- (void) select:(id) sender row:(int) row column:(int) column
{
    fprintf(stderr, "select_row:   (%d,%d)\n", row, column);
}

- (void) unselect:(id) sender row:(int) row column:(int) column
{
    fprintf(stderr, "unselect_row: (%d,%d)\n", row, column);
}
@end

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    GTKWindow *window;
    GTKCListExample *clist;

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];

    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];

    clist = [GTKCListExample cListWithTitles:4 titles:
	[NSArray arrayWithObjects:@"One", @"Two", @"Three", @"Four", nil]];

    [clist append:
	[NSArray arrayWithObjects:@"Another", @"line", @"of", @"text", nil]];
    [clist insert:0 text:
	[NSArray arrayWithObjects:@"This", @"is a", @"line of", @"text", nil]];
    [clist append:
	[NSArray arrayWithObjects:@"This", @"is the", @"final", @"line", nil]];
    [clist insert:0 text:
	[NSArray arrayWithObjects:@"This", @"is the", @"first", @"line", nil]];

    [clist columnsAutosize];

    [window setBorderWidth:4];
    [window add:clist];
    [window show];

    [GTKApp run];
    [pool release];
    return 0;
}
