/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkaccelgroup.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKAccelGroup.h>

@implementation GTKAccelGroup
+ (id) accelGroup
{
    return [[(GTKAccelGroup *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_accel_group_new()];
}
+ (GTKAccelGroup*) getDefault
{
    return gtoolkit_object(gtk_accel_group_get_default(), "GTKAccelGroup");
}
- (GTKAccelGroup*) ref
{
    return gtoolkit_object(gtk_accel_group_ref(gtk), "GTKAccelGroup");
}
- (void) unref
{
    gtk_accel_group_unref(gtk);
}
- (void) lock
{
    gtk_accel_group_lock(gtk);
}
- (void) unlock
{
    gtk_accel_group_unlock(gtk);
}
#define gtk	((GtkAccelGroup *) gtk)
 - (oneway void) release
{
    unsigned ref_count = gtk ? gtk->ref_count : 1;

#ifdef DEBUG
    if (ref_count == 0) g_error("ref_count == 0 in " __FILE__ " (release)");
#endif
    if (gtk) [self unref];
    if (ref_count == 1) [self dealloc];
}

 - (id) retain
{
    if (gtk) [self ref];
    return self;
}

 - (unsigned) retainCount
{
    return gtk ? gtk->ref_count : 1;
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkaccellabel.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKAccelLabel.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKAccelLabel
+ (GtkType) getType
{
    return gtk_accel_label_get_type();
}
+ (id) accelLabelWithString:(NSString *) string
{
    return [[(GTKAccelLabel *)[self alloc] initWithString:string] autorelease];
}
- (id) initWithString:(NSString *) string
{
    return [self initWithGtk:gtk_accel_label_new(gtoolkit_utf8_string( string))];
}
- (guint) getAccelWidth
{
    return gtk_accel_label_get_accel_width(gtk);
}
- (void) setAccelWidget:(GTKWidget *) accel_widget
{
    gtk_accel_label_set_accel_widget(gtk, accel_widget ? accel_widget->gtk : 0);
}
- (gboolean) refetch
{
    return gtk_accel_label_refetch(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkadjustment.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKAdjustment.h>

@implementation GTKAdjustment
+ (GtkType) getType
{
    return gtk_adjustment_get_type();
}
+ (id) adjustmentWithValue:(gfloat) value lower:(gfloat) lower upper:(gfloat) upper stepIncrement:(gfloat) step_increment pageIncrement:(gfloat) page_increment pageSize:(gfloat) page_size
{
    return [[(GTKAdjustment *)[self alloc] initWithValue:value lower:lower upper:upper stepIncrement:step_increment pageIncrement:page_increment pageSize:page_size] autorelease];
}
- (id) initWithValue:(gfloat) value lower:(gfloat) lower upper:(gfloat) upper stepIncrement:(gfloat) step_increment pageIncrement:(gfloat) page_increment pageSize:(gfloat) page_size
{
    return [self initWithGtk:gtk_adjustment_new( value , lower , upper , step_increment , page_increment , page_size)];
}
- (void) changed
{
    gtk_adjustment_changed(gtk);
}
- (void) valueChanged
{
    gtk_adjustment_value_changed(gtk);
}
- (void) clampPage:(gfloat) lower upper:(gfloat) upper
{
    gtk_adjustment_clamp_page(gtk, lower , upper);
}
- (void) setValue:(gfloat) value
{
    gtk_adjustment_set_value(gtk, value);
}
#define gtk	((GtkAdjustment *) gtk)
- (gfloat) getValue
{
    return gtk->value;
}

- (void) setLower:(gfloat) lower upper:(gfloat) upper
	 stepIncrement:(gfloat) step_increment
	 pageIncrement:(gfloat) page_increment pageSize:(gfloat) page_size
{
    gtk->lower = lower;
    gtk->upper = upper;
    gtk->step_increment = step_increment;
    gtk->page_increment = page_increment;
    gtk->page_size = page_size;
}

- (void) getLower:(gfloat *) lower upper:(gfloat *) upper
	 stepIncrement:(gfloat *) step_increment
	 pageIncrement:(gfloat *) page_increment pageSize:(gfloat *) page_size
{
    *lower = gtk->lower;
    *upper = gtk->upper;
    *step_increment = gtk->step_increment;
    *page_increment = gtk->page_increment;
    *page_size = gtk->page_size;
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkalignment.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKAlignment.h>

@implementation GTKAlignment
+ (GtkType) getType
{
    return gtk_alignment_get_type();
}
+ (id) alignmentWithXalign:(gfloat) xalign yalign:(gfloat) yalign xscale:(gfloat) xscale yscale:(gfloat) yscale
{
    return [[(GTKAlignment *)[self alloc] initWithXalign:xalign yalign:yalign xscale:xscale yscale:yscale] autorelease];
}
- (id) initWithXalign:(gfloat) xalign yalign:(gfloat) yalign xscale:(gfloat) xscale yscale:(gfloat) yscale
{
    return [self initWithGtk:gtk_alignment_new( xalign , yalign , xscale , yscale)];
}
- (void) set:(gfloat) xalign yalign:(gfloat) yalign xscale:(gfloat) xscale yscale:(gfloat) yscale
{
    gtk_alignment_set(gtk, xalign , yalign , xscale , yscale);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkarrow.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKArrow.h>

@implementation GTKArrow
+ (GtkType) getType
{
    return gtk_arrow_get_type();
}
+ (id) arrowWithType:(GtkArrowType) arrow_type shadowType:(GtkShadowType) shadow_type
{
    return [[(GTKArrow *)[self alloc] initWithType:arrow_type shadowType:shadow_type] autorelease];
}
- (id) initWithType:(GtkArrowType) arrow_type shadowType:(GtkShadowType) shadow_type
{
    return [self initWithGtk:gtk_arrow_new( arrow_type , shadow_type)];
}
- (void) set:(GtkArrowType) arrow_type shadowType:(GtkShadowType) shadow_type
{
    gtk_arrow_set(gtk, arrow_type , shadow_type);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkaspectframe.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKAspectFrame.h>

@implementation GTKAspectFrame
+ (GtkType) getType
{
    return gtk_aspect_frame_get_type();
}
+ (id) aspectFrameWithLabel:(NSString *) label xalign:(gfloat) xalign yalign:(gfloat) yalign ratio:(gfloat) ratio obeyChild:(gboolean) obey_child
{
    return [[(GTKAspectFrame *)[self alloc] initWithLabel:label xalign:xalign yalign:yalign ratio:ratio obeyChild:obey_child] autorelease];
}
- (id) initWithLabel:(NSString *) label xalign:(gfloat) xalign yalign:(gfloat) yalign ratio:(gfloat) ratio obeyChild:(gboolean) obey_child
{
    return [self initWithGtk:gtk_aspect_frame_new(gtoolkit_utf8_string( label ), xalign , yalign , ratio , obey_child)];
}
- (void) set:(gfloat) xalign yalign:(gfloat) yalign ratio:(gfloat) ratio obeyChild:(gboolean) obey_child
{
    gtk_aspect_frame_set(gtk, xalign , yalign , ratio , obey_child);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkbbox.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKButtonBox.h>

@implementation GTKButtonBox
+ (GtkType) getType
{
    return gtk_button_box_get_type();
}
+ (void) getChildSizeDefault:(gint *) min_width minHeight:(gint *) min_height
{
    gtk_button_box_get_child_size_default( min_width , min_height);
}
+ (void) getChildIpaddingDefault:(gint *) ipad_x ipadY:(gint *) ipad_y
{
    gtk_button_box_get_child_ipadding_default( ipad_x , ipad_y);
}
+ (void) setChildSizeDefault:(gint) min_width minHeight:(gint) min_height
{
    gtk_button_box_set_child_size_default( min_width , min_height);
}
+ (void) setChildIpaddingDefault:(gint) ipad_x ipadY:(gint) ipad_y
{
    gtk_button_box_set_child_ipadding_default( ipad_x , ipad_y);
}
- (gint) getSpacing
{
    return gtk_button_box_get_spacing(gtk);
}
- (GtkButtonBoxStyle) getLayout
{
    return gtk_button_box_get_layout(gtk);
}
- (void) getChildSize:(gint *) min_width minHeight:(gint *) min_height
{
    gtk_button_box_get_child_size(gtk, min_width , min_height);
}
- (void) getChildIpadding:(gint *) ipad_x ipadY:(gint *) ipad_y
{
    gtk_button_box_get_child_ipadding(gtk, ipad_x , ipad_y);
}
- (void) setSpacing:(gint) spacing
{
    gtk_button_box_set_spacing(gtk, spacing);
}
- (void) setLayout:(GtkButtonBoxStyle) layout_style
{
    gtk_button_box_set_layout(gtk, layout_style);
}
- (void) setChildSize:(gint) min_width minHeight:(gint) min_height
{
    gtk_button_box_set_child_size(gtk, min_width , min_height);
}
- (void) setChildIpadding:(gint) ipad_x ipadY:(gint) ipad_y
{
    gtk_button_box_set_child_ipadding(gtk, ipad_x , ipad_y);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkbin.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKBin.h>

@implementation GTKBin
+ (GtkType) getType
{
    return gtk_bin_get_type();
}
#define gtk	((GtkBin *) gtk)
- (id) child
{
    return GTOOLKIT_OBJECT(gtk->child);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkbox.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKBox.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKBox
+ (GtkType) getType
{
    return gtk_box_get_type();
}
- (void) packStart:(GTKWidget *) child expand:(gboolean) expand fill:(gboolean) fill padding:(guint) padding
{
    gtk_box_pack_start(gtk, child  ? child ->gtk : 0, expand , fill , padding);
}
- (void) packEnd:(GTKWidget *) child expand:(gboolean) expand fill:(gboolean) fill padding:(guint) padding
{
    gtk_box_pack_end(gtk, child  ? child ->gtk : 0, expand , fill , padding);
}
- (void) packStartDefaults:(GTKWidget *) widget
{
    gtk_box_pack_start_defaults(gtk, widget ? widget->gtk : 0);
}
- (void) packEndDefaults:(GTKWidget *) widget
{
    gtk_box_pack_end_defaults(gtk, widget ? widget->gtk : 0);
}
- (void) setHomogeneous:(gboolean) homogeneous
{
    gtk_box_set_homogeneous(gtk, homogeneous);
}
- (void) setSpacing:(gint) spacing
{
    gtk_box_set_spacing(gtk, spacing);
}
- (void) reorderChild:(GTKWidget *) child position:(gint) position
{
    gtk_box_reorder_child(gtk, child  ? child ->gtk : 0, position);
}
- (void) queryChildPacking:(GTKWidget *) child expand:(gboolean *) expand fill:(gboolean *) fill padding:(guint *) padding packType:(GtkPackType *) pack_type
{
    gtk_box_query_child_packing(gtk, child  ? child ->gtk : 0, expand , fill , padding , pack_type);
}
- (void) setChildPacking:(GTKWidget *) child expand:(gboolean) expand fill:(gboolean) fill padding:(guint) padding packType:(GtkPackType) pack_type
{
    gtk_box_set_child_packing(gtk, child  ? child ->gtk : 0, expand , fill , padding , pack_type);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkbutton.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKButton.h>

@implementation GTKButton
+ (GtkType) getType
{
    return gtk_button_get_type();
}
+ (id) button
{
    return [[(GTKButton *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_button_new()];
}
+ (id) buttonWithLabel:(NSString *) label
{
    return [[(GTKButton *)[self alloc] initWithLabel:label] autorelease];
}
- (id) initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_button_new_with_label(gtoolkit_utf8_string( label))];
}
- (void) pressed
{
    gtk_button_pressed(gtk);
}
- (void) released
{
    gtk_button_released(gtk);
}
- (void) clicked
{
    gtk_button_clicked(gtk);
}
- (void) enter
{
    gtk_button_enter(gtk);
}
- (void) leave
{
    gtk_button_leave(gtk);
}
- (void) setRelief:(GtkReliefStyle) newstyle
{
    gtk_button_set_relief(gtk, newstyle);
}
- (GtkReliefStyle) getRelief
{
    return gtk_button_get_relief(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkcalendar.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKCalendar.h>

@implementation GTKCalendar
+ (GtkType) getType
{
    return gtk_calendar_get_type();
}
+ (id) calendar
{
    return [[(GTKCalendar *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_calendar_new()];
}
- (gint) selectMonth:(guint) month year:(guint) year
{
    return gtk_calendar_select_month(gtk, month , year);
}
- (void) selectDay:(guint) day
{
    gtk_calendar_select_day(gtk, day);
}
- (gint) markDay:(guint) day
{
    return gtk_calendar_mark_day(gtk, day);
}
- (gint) unmarkDay:(guint) day
{
    return gtk_calendar_unmark_day(gtk, day);
}
- (void) clearMarks
{
    gtk_calendar_clear_marks(gtk);
}
- (void) displayOptions:(GtkCalendarDisplayOptions) flags
{
    gtk_calendar_display_options(gtk, flags);
}
- (void) getDate:(guint *) year month:(guint *) month day:(guint *) day
{
    gtk_calendar_get_date(gtk, year , month , day);
}
- (void) freeze
{
    gtk_calendar_freeze(gtk);
}
- (void) thaw
{
    gtk_calendar_thaw(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkcheckbutton.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKCheckButton.h>

@implementation GTKCheckButton
+ (GtkType) getType
{
    return gtk_check_button_get_type();
}
+ (id) checkButton
{
    return [[(GTKCheckButton *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_check_button_new()];
}
+ (id) checkButtonWithLabel:(NSString *) label
{
    return [[(GTKCheckButton *)[self alloc] initWithLabel:label] autorelease];
}
- (id) initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_check_button_new_with_label(gtoolkit_utf8_string( label))];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkcheckmenuitem.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKCheckMenuItem.h>

@implementation GTKCheckMenuItem
+ (GtkType) getType
{
    return gtk_check_menu_item_get_type();
}
+ (id) checkMenuItem
{
    return [[(GTKCheckMenuItem *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_check_menu_item_new()];
}
+ (id) checkMenuItemWithLabel:(NSString *) label
{
    return [[(GTKCheckMenuItem *)[self alloc] initWithLabel:label] autorelease];
}
- (id) initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_check_menu_item_new_with_label(gtoolkit_utf8_string( label))];
}
- (void) setActive:(gboolean) is_active
{
    gtk_check_menu_item_set_active(gtk, is_active);
}
- (void) setShowToggle:(gboolean) always
{
    gtk_check_menu_item_set_show_toggle(gtk, always);
}
- (void) toggled
{
    gtk_check_menu_item_toggled(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkclist.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKCList.h>
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKAdjustment.h>
#include <GToolKit/GTKStyle.h>

@implementation GTKCList
+ (GtkType) getType
{
    return gtk_clist_get_type();
}
+ (id) cListWithColumns:(gint) columns
{
    return [[(GTKCList *)[self alloc] initWithColumns:columns] autorelease];
}
- (id) initWithColumns:(gint) columns
{
    return [self initWithGtk:gtk_clist_new( columns)];
}
+ (id) cListWithTitles:(gint) columns titles:(NSArray  *) titles
{
    return [[(GTKCList *)[self alloc] initWithTitles:columns titles:titles] autorelease];
}
- (id) initWithTitles:(gint) columns titles:(NSArray  *) titles
{
    return [self initWithGtk:gtk_clist_new_with_titles( columns ,(char **)gtoolkit_array_to_strvec( titles))];
}
- (void) setHadjustment:(GTKAdjustment *) adjustment
{
    gtk_clist_set_hadjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) setVadjustment:(GTKAdjustment *) adjustment
{
    gtk_clist_set_vadjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (GTKAdjustment*) getHadjustment
{
    return gtoolkit_object(gtk_clist_get_hadjustment(gtk), 0);
}
- (GTKAdjustment*) getVadjustment
{
    return gtoolkit_object(gtk_clist_get_vadjustment(gtk), 0);
}
- (void) setShadowType:(GtkShadowType) type
{
    gtk_clist_set_shadow_type(gtk, type);
}
- (void) setSelectionMode:(GtkSelectionMode) mode
{
    gtk_clist_set_selection_mode(gtk, mode);
}
- (void) setReorderable:(gboolean) reorderable
{
    gtk_clist_set_reorderable(gtk, reorderable);
}
- (void) setUseDragIcons:(gboolean) use_icons
{
    gtk_clist_set_use_drag_icons(gtk, use_icons);
}
- (void) setButtonActions:(guint) button buttonActions:(guint8) button_actions
{
    gtk_clist_set_button_actions(gtk, button , button_actions);
}
- (void) freeze
{
    gtk_clist_freeze(gtk);
}
- (void) thaw
{
    gtk_clist_thaw(gtk);
}
- (void) columnTitlesShow
{
    gtk_clist_column_titles_show(gtk);
}
- (void) columnTitlesHide
{
    gtk_clist_column_titles_hide(gtk);
}
- (void) columnTitleActive:(gint) column
{
    gtk_clist_column_title_active(gtk, column);
}
- (void) columnTitlePassive:(gint) column
{
    gtk_clist_column_title_passive(gtk, column);
}
- (void) columnTitlesActive
{
    gtk_clist_column_titles_active(gtk);
}
- (void) columnTitlesPassive
{
    gtk_clist_column_titles_passive(gtk);
}
- (void) setColumn:(gint) column title:(NSString *) title
{
    gtk_clist_set_column_title(gtk, column ,gtoolkit_utf8_string( title));
}
- (NSString *) getColumnTitle:(gint) column
{
    return gtoolkit_objc_string(gtk_clist_get_column_title(gtk, column));
}
- (void) setColumn:(gint) column widget:(GTKWidget *) widget
{
    gtk_clist_set_column_widget(gtk, column , widget ? widget->gtk : 0);
}
- (GTKWidget *) getColumnWidget:(gint) column
{
    return gtoolkit_object(gtk_clist_get_column_widget(gtk, column), 0);
}
- (void) setColumn:(gint) column justification:(GtkJustification) justification
{
    gtk_clist_set_column_justification(gtk, column , justification);
}
- (void) setColumnVisibility:(gint) column visible:(gboolean) visible
{
    gtk_clist_set_column_visibility(gtk, column , visible);
}
- (void) setColumn:(gint) column resizeable:(gboolean) resizeable
{
    gtk_clist_set_column_resizeable(gtk, column , resizeable);
}
- (void) setColumn:(gint) column autoResize:(gboolean) auto_resize
{
    gtk_clist_set_column_auto_resize(gtk, column , auto_resize);
}
- (gint) columnsAutosize
{
    return gtk_clist_columns_autosize(gtk);
}
- (gint) optimalColumnWidth:(gint) column
{
    return gtk_clist_optimal_column_width(gtk, column);
}
- (void) setColumn:(gint) column width:(gint) width
{
    gtk_clist_set_column_width(gtk, column , width);
}
- (void) setColumn:(gint) column minWidth:(gint) min_width
{
    gtk_clist_set_column_min_width(gtk, column , min_width);
}
- (void) setColumn:(gint) column maxWidth:(gint) max_width
{
    gtk_clist_set_column_max_width(gtk, column , max_width);
}
- (void) setRowHeight:(guint) height
{
    gtk_clist_set_row_height(gtk, height);
}
- (void) moveto:(gint) row column:(gint) column rowAlign:(gfloat) row_align colAlign:(gfloat) col_align
{
    gtk_clist_moveto(gtk, row , column , row_align , col_align);
}
- (GtkVisibility) rowIsVisible:(gint) row
{
    return gtk_clist_row_is_visible(gtk, row);
}
- (GtkCellType) getCellType:(gint) row column:(gint) column
{
    return gtk_clist_get_cell_type(gtk, row , column);
}
- (void) setText:(gint) row column:(gint) column text:(NSString *) text
{
    gtk_clist_set_text(gtk, row , column ,gtoolkit_utf8_string( text));
}
- (gint) getText:(gint) row column:(gint) column text:(NSString **) text
{
    char *_outval_1;
    gint _retval_1;
    _retval_1 = gtk_clist_get_text(gtk, row , column ,&_outval_1);
    * text = gtoolkit_objc_string(_outval_1);
    return _retval_1;
}
- (void) setPixmap:(gint) row column:(gint) column pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    gtk_clist_set_pixmap(gtk, row , column , pixmap , mask);
}
- (gint) getPixmap:(gint) row column:(gint) column pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask
{
    return gtk_clist_get_pixmap(gtk, row , column , pixmap , mask);
}
- (void) setPixtext:(gint) row column:(gint) column text:(NSString *) text spacing:(guint8) spacing pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    gtk_clist_set_pixtext(gtk, row , column ,gtoolkit_utf8_string( text ), spacing , pixmap , mask);
}
- (gint) getPixtext:(gint) row column:(gint) column text:(NSString **) text spacing:(guint8 *) spacing pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask
{
    char *_outval_1;
    gint _retval_1;
    _retval_1 = gtk_clist_get_pixtext(gtk, row , column ,&_outval_1, spacing , pixmap , mask);
    * text  = gtoolkit_objc_string(_outval_1);
    return _retval_1;
}
- (void) setForeground:(gint) row color:(GdkColor *) color
{
    gtk_clist_set_foreground(gtk, row , color);
}
- (void) setBackground:(gint) row color:(GdkColor *) color
{
    gtk_clist_set_background(gtk, row , color);
}
- (void) setCellStyle:(gint) row column:(gint) column style:(GTKStyle *) style
{
    gtk_clist_set_cell_style(gtk, row , column , style ? style->gtk : 0);
}
- (GTKStyle *) getCellStyle:(gint) row column:(gint) column
{
    return gtoolkit_object(gtk_clist_get_cell_style(gtk, row , column), "GTKStyle");
}
- (void) setRow:(gint) row style:(GTKStyle *) style
{
    gtk_clist_set_row_style(gtk, row , style ? style->gtk : 0);
}
- (GTKStyle *) getRowStyle:(gint) row
{
    return gtoolkit_object(gtk_clist_get_row_style(gtk, row), "GTKStyle");
}
- (void) setShift:(gint) row column:(gint) column vertical:(gint) vertical horizontal:(gint) horizontal
{
    gtk_clist_set_shift(gtk, row , column , vertical , horizontal);
}
- (void) setSelectable:(gint) row selectable:(gboolean) selectable
{
    gtk_clist_set_selectable(gtk, row , selectable);
}
- (gboolean) getSelectable:(gint) row
{
    return gtk_clist_get_selectable(gtk, row);
}
- (gint) prepend:(NSArray  *) text
{
    return gtk_clist_prepend(gtk,(char **)gtoolkit_array_to_strvec( text));
}
- (gint) append:(NSArray  *) text
{
    return gtk_clist_append(gtk,(char **)gtoolkit_array_to_strvec( text));
}
- (gint) insert:(gint) row text:(NSArray  *) text
{
    return gtk_clist_insert(gtk, row ,(char **)gtoolkit_array_to_strvec( text));
}
- (void) remove:(gint) row
{
    gtk_clist_remove(gtk, row);
}
- (void) setRow:(gint) row data:(gpointer) data
{
    gtk_clist_set_row_data(gtk, row , data);
}
- (void) setRowDataFull:(gint) row data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    gtk_clist_set_row_data_full(gtk, row , data , destroy);
}
- (gpointer) getRowData:(gint) row
{
    return gtk_clist_get_row_data(gtk, row);
}
- (gint) findRowFromData:(gpointer) data
{
    return gtk_clist_find_row_from_data(gtk, data);
}
- (void) selectRow:(gint) row column:(gint) column
{
    gtk_clist_select_row(gtk, row , column);
}
- (void) unselectRow:(gint) row column:(gint) column
{
    gtk_clist_unselect_row(gtk, row , column);
}
- (void) undoSelection
{
    gtk_clist_undo_selection(gtk);
}
- (void) clear
{
    gtk_clist_clear(gtk);
}
- (gint) getSelectionInfo:(gint) x y:(gint) y row:(gint *) row column:(gint *) column
{
    return gtk_clist_get_selection_info(gtk, x , y , row , column);
}
- (void) selectAll
{
    gtk_clist_select_all(gtk);
}
- (void) unselectAll
{
    gtk_clist_unselect_all(gtk);
}
- (void) swapRows:(gint) row1 row2:(gint) row2
{
    gtk_clist_swap_rows(gtk, row1 , row2);
}
- (void) rowMove:(gint) source_row destRow:(gint) dest_row
{
    gtk_clist_row_move(gtk, source_row , dest_row);
}
- (void) setCompareFunc:(GtkCListCompareFunc) cmp_func
{
    gtk_clist_set_compare_func(gtk, cmp_func);
}
- (void) setSortColumn:(gint) column
{
    gtk_clist_set_sort_column(gtk, column);
}
- (void) setSortType:(GtkSortType) sort_type
{
    gtk_clist_set_sort_type(gtk, sort_type);
}
- (void) sort
{
    gtk_clist_sort(gtk);
}
- (void) setAutoSort:(gboolean) auto_sort
{
    gtk_clist_set_auto_sort(gtk, auto_sort);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkcolorsel.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKColorSelection.h>

@implementation GTKColorSelection
+ (GtkType) getType
{
    return gtk_color_selection_get_type();
}
+ (id) colorSelection
{
    return [[(GTKColorSelection *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_color_selection_new()];
}
- (void) setUpdatePolicy:(GtkUpdateType) policy
{
    gtk_color_selection_set_update_policy(gtk, policy);
}
- (void) setOpacity:(gint) use_opacity
{
    gtk_color_selection_set_opacity(gtk, use_opacity);
}
- (void) setColor:(gdouble *) color
{
    gtk_color_selection_set_color(gtk, color);
}
- (void) getColor:(gdouble *) color
{
    gtk_color_selection_get_color(gtk, color);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkcolorsel.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKColorSelectionDialog.h>

@implementation GTKColorSelectionDialog
+ (GtkType) getType
{
    return gtk_color_selection_dialog_get_type();
}
+ (id) colorSelectionDialogWithTitle:(NSString *) title
{
    return [[(GTKColorSelectionDialog *)[self alloc] initWithTitle:title] autorelease];
}
- (id) initWithTitle:(NSString *) title
{
    return [self initWithGtk:gtk_color_selection_dialog_new(gtoolkit_utf8_string( title))];
}
#define gtk	((GtkColorSelectionDialog *) gtk)
- (GTKColorSelection *) colorSelection
{
    return GTOOLKIT_OBJECT(gtk->colorsel);
}
- (GTKWidget *) okButton
{
    return GTOOLKIT_OBJECT(gtk->ok_button);
}
- (GTKWidget *) resetButton
{
    return GTOOLKIT_OBJECT(gtk->reset_button);
}
- (GTKWidget *) cancelButton
{
    return GTOOLKIT_OBJECT(gtk->cancel_button);
}
- (GTKWidget *) helpButton
{
    return GTOOLKIT_OBJECT(gtk->help_button);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkcombo.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKCombo.h>
#include <GToolKit/GTKItem.h>

@implementation GTKCombo
+ (GtkType) getType
{
    return gtk_combo_get_type();
}
+ (id) combo
{
    return [[(GTKCombo *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_combo_new()];
}
- (void) setValueInList:(gint) val okIfEmpty:(gint) ok_if_empty
{
    gtk_combo_set_value_in_list(gtk, val , ok_if_empty);
}
- (void) setUseArrows:(gint) val
{
    gtk_combo_set_use_arrows(gtk, val);
}
- (void) setUseArrowsAlways:(gint) val
{
    gtk_combo_set_use_arrows_always(gtk, val);
}
- (void) setCaseSensitive:(gint) val
{
    gtk_combo_set_case_sensitive(gtk, val);
}
- (void) setItemString:(GTKItem*) item itemValue:(NSString *) item_value
{
    gtk_combo_set_item_string(gtk, item  ? item ->gtk : 0,gtoolkit_utf8_string( item_value));
}
- (void) setPopdownStrings:(NSArray *) strings
{
    gtk_combo_set_popdown_strings(gtk,gtoolkit_array_to_list( strings));
}
- (void) disableActivate
{
    gtk_combo_disable_activate(gtk);
}
#define gtk	((GtkCombo *) gtk)
- (id) entry
{
    return GTOOLKIT_OBJECT(gtk->entry);
}
- (GTKWidget *) list
{
    return GTOOLKIT_OBJECT(gtk->list);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkcontainer.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKContainer.h>
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKContainer
+ (GtkType) getType
{
    return gtk_container_get_type();
}
- (void) setBorderWidth:(guint) border_width
{
    gtk_container_set_border_width(gtk, border_width);
}
- (void) add:(GTKWidget *) widget
{
    gtk_container_add(gtk, widget ? widget->gtk : 0);
}
- (void) remove:(GTKWidget *) widget
{
    gtk_container_remove(gtk, widget ? widget->gtk : 0);
}
- (void) setResizeMode:(GtkResizeMode) resize_mode
{
    gtk_container_set_resize_mode(gtk, resize_mode);
}
- (void) checkResize
{
    gtk_container_check_resize(gtk);
}
- (void) foreach:(GtkCallback) callback callbackData:(gpointer) callback_data
{
    gtk_container_foreach(gtk, callback , callback_data);
}
- (void) foreachFull:(GtkCallback) callback marshal:(GtkCallbackMarshal) marshal callbackData:(gpointer) callback_data notify:(GtkDestroyNotify) notify
{
    gtk_container_foreach_full(gtk, callback , marshal , callback_data , notify);
}
- (NSArray *) children
{
    return gtoolkit_list_to_array(gtk_container_children(gtk));
}
- (gint) focus:(GtkDirectionType) direction
{
    return gtk_container_focus(gtk, direction);
}
- (void) setReallocateRedraws:(gboolean) needs_redraws
{
    gtk_container_set_reallocate_redraws(gtk, needs_redraws);
}
- (void) setFocusChild:(GTKWidget *) child
{
    gtk_container_set_focus_child(gtk, child ? child->gtk : 0);
}
- (void) setFocusVadjustment:(GTKAdjustment *) adjustment
{
    gtk_container_set_focus_vadjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) setFocusHadjustment:(GTKAdjustment *) adjustment
{
    gtk_container_set_focus_hadjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) registerToplevel
{
    gtk_container_register_toplevel(gtk);
}
- (void) unregisterToplevel
{
    gtk_container_unregister_toplevel(gtk);
}
+ (NSArray *) getToplevels
{
    return gtoolkit_list_to_array(gtk_container_get_toplevels());
}
- (void) resizeChildren
{
    gtk_container_resize_children(gtk);
}
- (GtkType) childType
{
    return gtk_container_child_type(gtk);
}
+ (void) addChildArgType:(NSString *) arg_name argType:(GtkType) arg_type argFlags:(guint) arg_flags argId:(guint) arg_id
{
    gtk_container_add_child_arg_type(gtoolkit_utf8_string( arg_name ), arg_type , arg_flags , arg_id);
}
+ (GtkArg*) queryChildArgs:(GtkType) class_type argFlags:(guint32 **) arg_flags nArgs:(guint *) nargs
{
    return gtk_container_query_child_args( class_type , arg_flags , nargs);
}
- (void) childGetv:(GTKWidget *) child nArgs:(guint) n_args args:(GtkArg *) args
{
    gtk_container_child_getv(gtk, child  ? child ->gtk : 0, n_args , args);
}
- (void) childSetv:(GTKWidget *) child nArgs:(guint) n_args args:(GtkArg *) args
{
    gtk_container_child_setv(gtk, child  ? child ->gtk : 0, n_args , args);
}
- (void) addv:(GTKWidget *) widget nArgs:(guint) n_args args:(GtkArg *) args
{
    gtk_container_addv(gtk, widget  ? widget ->gtk : 0, n_args , args);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkctree.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKCTree.h>
#include <GToolKit/GTKStyle.h>

@implementation GTKCTree
+ (GtkType) getType
{
    return gtk_ctree_get_type();
}
+ (id) cTreeWithTitles:(gint) columns treeColumn:(gint) tree_column titles:(NSArray  *) titles
{
    return [[(GTKCTree *)[self alloc] initWithTitles:columns treeColumn:tree_column titles:titles] autorelease];
}
- (id) initWithTitles:(gint) columns treeColumn:(gint) tree_column titles:(NSArray  *) titles
{
    return [self initWithGtk:gtk_ctree_new_with_titles( columns , tree_column ,(char **)gtoolkit_array_to_strvec( titles))];
}
+ (id) cTreeWithColumns:(gint) columns treeColumn:(gint) tree_column
{
    return [[(GTKCTree *)[self alloc] initWithColumns:columns treeColumn:tree_column] autorelease];
}
- (id) initWithColumns:(gint) columns treeColumn:(gint) tree_column
{
    return [self initWithGtk:gtk_ctree_new( columns , tree_column)];
}
- (GtkCTreeNode *) insertNode:(GtkCTreeNode *) parent sibling:(GtkCTreeNode *) sibling text:(NSArray  *) text spacing:(guint8) spacing pixmapClosed:(GdkPixmap *) pixmap_closed maskClosed:(GdkBitmap *) mask_closed pixmapOpened:(GdkPixmap *) pixmap_opened maskOpened:(GdkBitmap *) mask_opened isLeaf:(gboolean) is_leaf expanded:(gboolean) expanded
{
    return gtk_ctree_insert_node(gtk, parent , sibling ,(char **)gtoolkit_array_to_strvec( text ), spacing , pixmap_closed , mask_closed , pixmap_opened , mask_opened , is_leaf , expanded);
}
- (void) removeNode:(GtkCTreeNode *) node
{
    gtk_ctree_remove_node(gtk, node);
}
- (GtkCTreeNode *) insertGnode:(GtkCTreeNode *) parent sibling:(GtkCTreeNode *) sibling gnode:(GNode *) gnode func:(GtkCTreeGNodeFunc) func data:(gpointer) data
{
    return gtk_ctree_insert_gnode(gtk, parent , sibling , gnode , func , data);
}
- (GNode *) exportToGnode:(GNode *) parent sibling:(GNode *) sibling node:(GtkCTreeNode *) node func:(GtkCTreeGNodeFunc) func data:(gpointer) data
{
    return gtk_ctree_export_to_gnode(gtk, parent , sibling , node , func , data);
}
- (void) postRecursive:(GtkCTreeNode *) node func:(GtkCTreeFunc) func data:(gpointer) data
{
    gtk_ctree_post_recursive(gtk, node , func , data);
}
- (void) postRecursive:(GtkCTreeNode *) node toDepth:(gint) depth func:(GtkCTreeFunc) func data:(gpointer) data
{
    gtk_ctree_post_recursive_to_depth(gtk, node , depth , func , data);
}
- (void) preRecursive:(GtkCTreeNode *) node func:(GtkCTreeFunc) func data:(gpointer) data
{
    gtk_ctree_pre_recursive(gtk, node , func , data);
}
- (void) preRecursive:(GtkCTreeNode *) node toDepth:(gint) depth func:(GtkCTreeFunc) func data:(gpointer) data
{
    gtk_ctree_pre_recursive_to_depth(gtk, node , depth , func , data);
}
- (gboolean) isViewable:(GtkCTreeNode *) node
{
    return gtk_ctree_is_viewable(gtk, node);
}
- (GtkCTreeNode *) last:(GtkCTreeNode *) node
{
    return gtk_ctree_last(gtk, node);
}
- (GtkCTreeNode *) findNodePtr:(GtkCTreeRow *) ctree_row
{
    return gtk_ctree_find_node_ptr(gtk, ctree_row);
}
- (GtkCTreeNode *) nodeNth:(guint) row
{
    return gtk_ctree_node_nth(gtk, row);
}
- (gboolean) find:(GtkCTreeNode *) node child:(GtkCTreeNode *) child
{
    return gtk_ctree_find(gtk, node , child);
}
- (gboolean) isAncestor:(GtkCTreeNode *) node child:(GtkCTreeNode *) child
{
    return gtk_ctree_is_ancestor(gtk, node , child);
}
- (GtkCTreeNode *) findByRow:(GtkCTreeNode *) node data:(gpointer) data
{
    return gtk_ctree_find_by_row_data(gtk, node , data);
}
- (GList *) findAllByRow:(GtkCTreeNode *) node data:(gpointer) data
{
    return gtk_ctree_find_all_by_row_data(gtk, node , data);
}
- (GtkCTreeNode *) findByRowDataCustom:(GtkCTreeNode *) node data:(gpointer) data func:(GCompareFunc) func
{
    return gtk_ctree_find_by_row_data_custom(gtk, node , data , func);
}
- (GList *) findAllByRowDataCustom:(GtkCTreeNode *) node data:(gpointer) data func:(GCompareFunc) func
{
    return gtk_ctree_find_all_by_row_data_custom(gtk, node , data , func);
}
- (gboolean) isHotSpot:(gint) x y:(gint) y
{
    return gtk_ctree_is_hot_spot(gtk, x , y);
}
- (void) move:(GtkCTreeNode *) node newParent:(GtkCTreeNode *) new_parent newSibling:(GtkCTreeNode *) new_sibling
{
    gtk_ctree_move(gtk, node , new_parent , new_sibling);
}
- (void) expand:(GtkCTreeNode *) node
{
    gtk_ctree_expand(gtk, node);
}
- (void) expandRecursive:(GtkCTreeNode *) node
{
    gtk_ctree_expand_recursive(gtk, node);
}
- (void) expand:(GtkCTreeNode *) node toDepth:(gint) depth
{
    gtk_ctree_expand_to_depth(gtk, node , depth);
}
- (void) collapse:(GtkCTreeNode *) node
{
    gtk_ctree_collapse(gtk, node);
}
- (void) collapseRecursive:(GtkCTreeNode *) node
{
    gtk_ctree_collapse_recursive(gtk, node);
}
- (void) collapse:(GtkCTreeNode *) node toDepth:(gint) depth
{
    gtk_ctree_collapse_to_depth(gtk, node , depth);
}
- (void) toggleExpansion:(GtkCTreeNode *) node
{
    gtk_ctree_toggle_expansion(gtk, node);
}
- (void) toggleExpansionRecursive:(GtkCTreeNode *) node
{
    gtk_ctree_toggle_expansion_recursive(gtk, node);
}
- (void) select:(GtkCTreeNode *) node
{
    gtk_ctree_select(gtk, node);
}
- (void) selectRecursive:(GtkCTreeNode *) node
{
    gtk_ctree_select_recursive(gtk, node);
}
- (void) unselect:(GtkCTreeNode *) node
{
    gtk_ctree_unselect(gtk, node);
}
- (void) unselectRecursive:(GtkCTreeNode *) node
{
    gtk_ctree_unselect_recursive(gtk, node);
}
- (void) realSelectRecursive:(GtkCTreeNode *) node state:(gint) state
{
    gtk_ctree_real_select_recursive(gtk, node , state);
}
- (void) nodeSetText:(GtkCTreeNode *) node column:(gint) column text:(NSString *) text
{
    gtk_ctree_node_set_text(gtk, node , column ,gtoolkit_utf8_string( text));
}
- (void) nodeSetPixmap:(GtkCTreeNode *) node column:(gint) column pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    gtk_ctree_node_set_pixmap(gtk, node , column , pixmap , mask);
}
- (void) nodeSetPixtext:(GtkCTreeNode *) node column:(gint) column text:(NSString *) text spacing:(guint8) spacing pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    gtk_ctree_node_set_pixtext(gtk, node , column ,gtoolkit_utf8_string( text ), spacing , pixmap , mask);
}
- (void) setNodeInfo:(GtkCTreeNode *) node text:(NSString *) text spacing:(guint8) spacing pixmapClosed:(GdkPixmap *) pixmap_closed maskClosed:(GdkBitmap *) mask_closed pixmapOpened:(GdkPixmap *) pixmap_opened maskOpened:(GdkBitmap *) mask_opened isLeaf:(gboolean) is_leaf expanded:(gboolean) expanded
{
    gtk_ctree_set_node_info(gtk, node ,gtoolkit_utf8_string( text ), spacing , pixmap_closed , mask_closed , pixmap_opened , mask_opened , is_leaf , expanded);
}
- (void) nodeSetShift:(GtkCTreeNode *) node column:(gint) column vertical:(gint) vertical horizontal:(gint) horizontal
{
    gtk_ctree_node_set_shift(gtk, node , column , vertical , horizontal);
}
- (void) nodeSet:(GtkCTreeNode *) node selectable:(gboolean) selectable
{
    gtk_ctree_node_set_selectable(gtk, node , selectable);
}
- (gboolean) nodeGetSelectable:(GtkCTreeNode *) node
{
    return gtk_ctree_node_get_selectable(gtk, node);
}
- (GtkCellType) nodeGetCellType:(GtkCTreeNode *) node column:(gint) column
{
    return gtk_ctree_node_get_cell_type(gtk, node , column);
}
- (gint) nodeGetText:(GtkCTreeNode *) node column:(gint) column text:(NSString **) text
{
    char *_outval_1;
    gint _retval_1;
    _retval_1 = gtk_ctree_node_get_text(gtk, node , column ,&_outval_1);
    * text = gtoolkit_objc_string(_outval_1);
    return _retval_1;
}
- (gint) nodeGetPixmap:(GtkCTreeNode *) node column:(gint) column pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask
{
    return gtk_ctree_node_get_pixmap(gtk, node , column , pixmap , mask);
}
- (gint) nodeGetPixtext:(GtkCTreeNode *) node column:(gint) column text:(NSString **) text spacing:(guint8 *) spacing pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask
{
    char *_outval_1;
    gint _retval_1;
    _retval_1 = gtk_ctree_node_get_pixtext(gtk, node , column ,&_outval_1, spacing , pixmap , mask);
    * text  = gtoolkit_objc_string(_outval_1);
    return _retval_1;
}
- (gint) getNodeInfo:(GtkCTreeNode *) node text:(NSString **) text spacing:(guint8 *) spacing pixmapClosed:(GdkPixmap **) pixmap_closed maskClosed:(GdkBitmap **) mask_closed pixmapOpened:(GdkPixmap **) pixmap_opened maskOpened:(GdkBitmap **) mask_opened isLeaf:(gboolean *) is_leaf expanded:(gboolean *) expanded
{
    char *_outval_1;
    gint _retval_1;
    _retval_1 = gtk_ctree_get_node_info(gtk, node ,&_outval_1, spacing , pixmap_closed , mask_closed , pixmap_opened , mask_opened , is_leaf , expanded);
    * text  = gtoolkit_objc_string(_outval_1);
    return _retval_1;
}
- (void) nodeSetRow:(GtkCTreeNode *) node style:(GTKStyle *) style
{
    gtk_ctree_node_set_row_style(gtk, node , style ? style->gtk : 0);
}
- (GTKStyle *) nodeGetRowStyle:(GtkCTreeNode *) node
{
    return gtoolkit_object(gtk_ctree_node_get_row_style(gtk, node), "GTKStyle");
}
- (void) nodeSetCellStyle:(GtkCTreeNode *) node column:(gint) column style:(GTKStyle *) style
{
    gtk_ctree_node_set_cell_style(gtk, node , column , style ? style->gtk : 0);
}
- (GTKStyle *) nodeGetCellStyle:(GtkCTreeNode *) node column:(gint) column
{
    return gtoolkit_object(gtk_ctree_node_get_cell_style(gtk, node , column), "GTKStyle");
}
- (void) nodeSetForeground:(GtkCTreeNode *) node color:(GdkColor *) color
{
    gtk_ctree_node_set_foreground(gtk, node , color);
}
- (void) nodeSetBackground:(GtkCTreeNode *) node color:(GdkColor *) color
{
    gtk_ctree_node_set_background(gtk, node , color);
}
- (void) nodeSetRow:(GtkCTreeNode *) node data:(gpointer) data
{
    gtk_ctree_node_set_row_data(gtk, node , data);
}
- (void) nodeSetRowDataFull:(GtkCTreeNode *) node data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    gtk_ctree_node_set_row_data_full(gtk, node , data , destroy);
}
- (gpointer) nodeGetRowData:(GtkCTreeNode *) node
{
    return gtk_ctree_node_get_row_data(gtk, node);
}
- (void) nodeMoveto:(GtkCTreeNode *) node column:(gint) column rowAlign:(gfloat) row_align colAlign:(gfloat) col_align
{
    gtk_ctree_node_moveto(gtk, node , column , row_align , col_align);
}
- (GtkVisibility) nodeIsVisible:(GtkCTreeNode *) node
{
    return gtk_ctree_node_is_visible(gtk, node);
}
- (void) setIndent:(gint) indent
{
    gtk_ctree_set_indent(gtk, indent);
}
- (void) setSpacing:(gint) spacing
{
    gtk_ctree_set_spacing(gtk, spacing);
}
- (void) setShowStub:(gboolean) show_stub
{
    gtk_ctree_set_show_stub(gtk, show_stub);
}
- (void) setLineStyle:(GtkCTreeLineStyle) line_style
{
    gtk_ctree_set_line_style(gtk, line_style);
}
- (void) setExpanderStyle:(GtkCTreeExpanderStyle) expander_style
{
    gtk_ctree_set_expander_style(gtk, expander_style);
}
- (void) setDragCompareFunc:(GtkCTreeCompareDragFunc) cmp_func
{
    gtk_ctree_set_drag_compare_func(gtk, cmp_func);
}
- (void) sortNode:(GtkCTreeNode *) node
{
    gtk_ctree_sort_node(gtk, node);
}
- (void) sortRecursive:(GtkCTreeNode *) node
{
    gtk_ctree_sort_recursive(gtk, node);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkcurve.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKCurve.h>

@implementation GTKCurve
+ (GtkType) getType
{
    return gtk_curve_get_type();
}
+ (id) curve
{
    return [[(GTKCurve *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_curve_new()];
}
- (void) reset
{
    gtk_curve_reset(gtk);
}
- (void) setGamma:(gfloat) gamma
{
    gtk_curve_set_gamma(gtk, gamma);
}
- (void) setRange:(gfloat) min_x maxX:(gfloat) max_x minY:(gfloat) min_y maxY:(gfloat) max_y
{
    gtk_curve_set_range(gtk, min_x , max_x , min_y , max_y);
}
- (void) getVector:(int) veclen vector:(gfloat *) vector
{
    gtk_curve_get_vector(gtk, veclen , vector);
}
- (void) setVector:(int) veclen vector:(gfloat *) vector
{
    gtk_curve_set_vector(gtk, veclen , vector);
}
- (void) setCurveType:(GtkCurveType) type
{
    gtk_curve_set_curve_type(gtk, type);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkdata.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKData.h>

@implementation GTKData
+ (GtkType) getType
{
    return gtk_data_get_type();
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkdialog.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKDialog.h>

@implementation GTKDialog
+ (GtkType) getType
{
    return gtk_dialog_get_type();
}
+ (id) dialog
{
    return [[(GTKDialog *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_dialog_new()];
}
#define gtk	((GtkDialog *) gtk)
- (GTKWidget *) vbox
{
    return GTOOLKIT_OBJECT(gtk->vbox);
}
- (GTKWidget *) actionArea
{
    return GTOOLKIT_OBJECT(gtk->action_area);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkdrawingarea.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKDrawingArea.h>

@implementation GTKDrawingArea
+ (GtkType) getType
{
    return gtk_drawing_area_get_type();
}
+ (id) drawingArea
{
    return [[(GTKDrawingArea *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_drawing_area_new()];
}
- (void) size:(gint) width height:(gint) height
{
    gtk_drawing_area_size(gtk, width , height);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkeditable.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKEditable.h>

@implementation GTKEditable
+ (GtkType) getType
{
    return gtk_editable_get_type();
}
- (void) selectRegion:(gint) start end:(gint) end
{
    gtk_editable_select_region(gtk, start , end);
}
- (void) insertText:(NSString *) new_text newTextLength:(gint) new_text_length position:(gint *) position
{
    gtk_editable_insert_text(gtk,gtoolkit_utf8_string( new_text ), new_text_length , position);
}
- (void) deleteText:(gint) start_pos endPos:(gint) end_pos
{
    gtk_editable_delete_text(gtk, start_pos , end_pos);
}
- (NSString *) getChars:(gint) start_pos endPos:(gint) end_pos
{
    return gtoolkit_objc_string(gtk_editable_get_chars(gtk, start_pos , end_pos));
}
- (void) cutClipboard
{
    gtk_editable_cut_clipboard(gtk);
}
- (void) copyClipboard
{
    gtk_editable_copy_clipboard(gtk);
}
- (void) pasteClipboard
{
    gtk_editable_paste_clipboard(gtk);
}
- (void) claimSelection:(gboolean) claim time:(guint32) time
{
    gtk_editable_claim_selection(gtk, claim , time);
}
- (void) deleteSelection
{
    gtk_editable_delete_selection(gtk);
}
- (void) changed
{
    gtk_editable_changed(gtk);
}
- (void) setPosition:(gint) position
{
    gtk_editable_set_position(gtk, position);
}
- (gint) getPosition
{
    return gtk_editable_get_position(gtk);
}
- (void) setEditable:(gboolean) is_editable
{
    gtk_editable_set_editable(gtk, is_editable);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkentry.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKEntry.h>

@implementation GTKEntry
+ (GtkType) getType
{
    return gtk_entry_get_type();
}
+ (id) entry
{
    return [[(GTKEntry *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_entry_new()];
}
+ (id) entryWithMaxLength:(guint16) max
{
    return [[(GTKEntry *)[self alloc] initWithMaxLength:max] autorelease];
}
- (id) initWithMaxLength:(guint16) max
{
    return [self initWithGtk:gtk_entry_new_with_max_length( max)];
}
- (void) setText:(NSString *) text
{
    gtk_entry_set_text(gtk,gtoolkit_utf8_string( text));
}
- (void) appendText:(NSString *) text
{
    gtk_entry_append_text(gtk,gtoolkit_utf8_string( text));
}
- (void) prependText:(NSString *) text
{
    gtk_entry_prepend_text(gtk,gtoolkit_utf8_string( text));
}
- (void) setPosition:(gint) position
{
    gtk_entry_set_position(gtk, position);
}
- (NSString *) getText
{
    return gtoolkit_objc_string(gtk_entry_get_text(gtk));
}
- (void) selectRegion:(gint) start end:(gint) end
{
    gtk_entry_select_region(gtk, start , end);
}
- (void) setVisibility:(gboolean) visible
{
    gtk_entry_set_visibility(gtk, visible);
}
- (void) setEditable:(gboolean) editable
{
    gtk_entry_set_editable(gtk, editable);
}
- (void) setMaxLength:(guint16) max
{
    gtk_entry_set_max_length(gtk, max);
}
#include <stdio.h>
#include <stdlib.h>

- (void) setDoubleValue:(double) value
{
    char string[64];

    sprintf(string, "%g", value);
    gtk_entry_set_text(gtk, string);
}

- (void) setIntValue:(int) value
{
    char string[64];

    sprintf(string, "%d", value);
    gtk_entry_set_text(gtk, string);
}

- (void) setStringValue:(NSString *) value
{
    gtk_entry_set_text(gtk, gtoolkit_utf8_string(value));
}

- (double) doubleValue
{
    return atof(gtk_entry_get_text(gtk));
}

- (int) intValue
{
    return atoi(gtk_entry_get_text(gtk));
}

- (NSString *) stringValue
{
    return gtoolkit_objc_string(gtk_entry_get_text(gtk));
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkeventbox.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKEventBox.h>

@implementation GTKEventBox
+ (GtkType) getType
{
    return gtk_event_box_get_type();
}
+ (id) eventBox
{
    return [[(GTKEventBox *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_event_box_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkfilesel.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKFileSelection.h>

@implementation GTKFileSelection
+ (GtkType) getType
{
    return gtk_file_selection_get_type();
}
+ (id) fileSelectionWithTitle:(NSString *) title
{
    return [[(GTKFileSelection *)[self alloc] initWithTitle:title] autorelease];
}
- (id) initWithTitle:(NSString *) title
{
    return [self initWithGtk:gtk_file_selection_new(gtoolkit_utf8_string( title))];
}
- (void) setFilename:(NSString *) filename
{
    gtk_file_selection_set_filename(gtk,gtoolkit_utf8_string( filename));
}
- (NSString *) getFilename
{
    return gtoolkit_objc_string(gtk_file_selection_get_filename(gtk));
}
- (void) complete:(NSString *) pattern
{
    gtk_file_selection_complete(gtk,gtoolkit_utf8_string( pattern));
}
- (void) showFileopButtons
{
    gtk_file_selection_show_fileop_buttons(gtk);
}
- (void) hideFileopButtons
{
    gtk_file_selection_hide_fileop_buttons(gtk);
}
#define gtk	((GtkFileSelection *) gtk)
- (GTKWidget *) okButton
{
    return GTOOLKIT_OBJECT(gtk->ok_button);
}
- (GTKWidget *) cancelButton
{
    return GTOOLKIT_OBJECT(gtk->cancel_button);
}
- (GTKWidget *) helpButton
{
    return GTOOLKIT_OBJECT(gtk->help_button);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkfixed.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKFixed.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKFixed
+ (GtkType) getType
{
    return gtk_fixed_get_type();
}
+ (id) fixed
{
    return [[(GTKFixed *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_fixed_new()];
}
- (void) put:(GTKWidget *) widget x:(gint16) x y:(gint16) y
{
    gtk_fixed_put(gtk, widget  ? widget ->gtk : 0, x , y);
}
- (void) move:(GTKWidget *) widget x:(gint16) x y:(gint16) y
{
    gtk_fixed_move(gtk, widget  ? widget ->gtk : 0, x , y);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkfontsel.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKFontSelection.h>

@implementation GTKFontSelection
+ (GtkType) getType
{
    return gtk_font_selection_get_type();
}
+ (id) fontSelection
{
    return [[(GTKFontSelection *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_font_selection_new()];
}
- (NSString *) getFontName
{
    return gtoolkit_objc_string(gtk_font_selection_get_font_name(gtk));
}
- (GdkFont*) getFont
{
    return gtk_font_selection_get_font(gtk);
}
- (gboolean) setFontName:(NSString *) fontname
{
    return gtk_font_selection_set_font_name(gtk,gtoolkit_utf8_string( fontname));
}
- (void) setFilter:(GtkFontFilterType) filter_type fontType:(GtkFontType) font_type foundries:(NSArray  *) foundries weights:(NSArray  *) weights slants:(NSArray  *) slants setwidths:(NSArray  *) setwidths spacings:(NSArray  *) spacings charsets:(NSArray  *) charsets
{
    gtk_font_selection_set_filter(gtk, filter_type , font_type ,(char **)gtoolkit_array_to_strvec( foundries ),(char **)gtoolkit_array_to_strvec( weights ),(char **)gtoolkit_array_to_strvec( slants ),(char **)gtoolkit_array_to_strvec( setwidths ),(char **)gtoolkit_array_to_strvec( spacings ),(char **)gtoolkit_array_to_strvec( charsets));
}
- (NSString *) getPreviewText
{
    return gtoolkit_objc_string(gtk_font_selection_get_preview_text(gtk));
}
- (void) setPreviewText:(NSString *) text
{
    gtk_font_selection_set_preview_text(gtk,gtoolkit_utf8_string( text));
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkfontsel.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKFontSelectionDialog.h>

@implementation GTKFontSelectionDialog
+ (GtkType) getType
{
    return gtk_font_selection_dialog_get_type();
}
+ (id) fontSelectionDialogWithTitle:(NSString *) title
{
    return [[(GTKFontSelectionDialog *)[self alloc] initWithTitle:title] autorelease];
}
- (id) initWithTitle:(NSString *) title
{
    return [self initWithGtk:gtk_font_selection_dialog_new(gtoolkit_utf8_string( title))];
}
- (NSString *) getFontName
{
    return gtoolkit_objc_string(gtk_font_selection_dialog_get_font_name(gtk));
}
- (GdkFont*) getFont
{
    return gtk_font_selection_dialog_get_font(gtk);
}
- (gboolean) setFontName:(NSString *) fontname
{
    return gtk_font_selection_dialog_set_font_name(gtk,gtoolkit_utf8_string( fontname));
}
- (void) setFilter:(GtkFontFilterType) filter_type fontType:(GtkFontType) font_type foundries:(NSArray  *) foundries weights:(NSArray  *) weights slants:(NSArray  *) slants setwidths:(NSArray  *) setwidths spacings:(NSArray  *) spacings charsets:(NSArray  *) charsets
{
    gtk_font_selection_dialog_set_filter(gtk, filter_type , font_type ,(char **)gtoolkit_array_to_strvec( foundries ),(char **)gtoolkit_array_to_strvec( weights ),(char **)gtoolkit_array_to_strvec( slants ),(char **)gtoolkit_array_to_strvec( setwidths ),(char **)gtoolkit_array_to_strvec( spacings ),(char **)gtoolkit_array_to_strvec( charsets));
}
- (NSString *) getPreviewText
{
    return gtoolkit_objc_string(gtk_font_selection_dialog_get_preview_text(gtk));
}
- (void) setPreviewText:(NSString *) text
{
    gtk_font_selection_dialog_set_preview_text(gtk,gtoolkit_utf8_string( text));
}
#define gtk	((GtkFontSelectionDialog *) gtk)
- (GTKFontSelection *) fontSelection
{
    return GTOOLKIT_OBJECT(gtk->fontsel);
}
- (GTKWidget *) okButton
{
    return GTOOLKIT_OBJECT(gtk->ok_button);
}
- (GTKWidget *) applyButton
{
    return GTOOLKIT_OBJECT(gtk->apply_button);
}
- (GTKWidget *) cancelButton
{
    return GTOOLKIT_OBJECT(gtk->cancel_button);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkframe.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKFrame.h>

@implementation GTKFrame
+ (GtkType) getType
{
    return gtk_frame_get_type();
}
+ (id) frameWithLabel:(NSString *) label
{
    return [[(GTKFrame *)[self alloc] initWithLabel:label] autorelease];
}
- (id) initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_frame_new(gtoolkit_utf8_string( label))];
}
- (void) setLabel:(NSString *) label
{
    gtk_frame_set_label(gtk,gtoolkit_utf8_string( label));
}
- (void) setLabelAlign:(gfloat) xalign yalign:(gfloat) yalign
{
    gtk_frame_set_label_align(gtk, xalign , yalign);
}
- (void) setShadowType:(GtkShadowType) type
{
    gtk_frame_set_shadow_type(gtk, type);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkgamma.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKGammaCurve.h>

@implementation GTKGammaCurve
+ (GtkType) getType
{
    return gtk_gamma_curve_get_type();
}
+ (id) gammaCurve
{
    return [[(GTKGammaCurve *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_gamma_curve_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkhandlebox.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKHandleBox.h>

@implementation GTKHandleBox
+ (GtkType) getType
{
    return gtk_handle_box_get_type();
}
+ (id) handleBox
{
    return [[(GTKHandleBox *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_handle_box_new()];
}
- (void) setShadowType:(GtkShadowType) type
{
    gtk_handle_box_set_shadow_type(gtk, type);
}
- (void) setHandlePosition:(GtkPositionType) position
{
    gtk_handle_box_set_handle_position(gtk, position);
}
- (void) setSnapEdge:(GtkPositionType) edge
{
    gtk_handle_box_set_snap_edge(gtk, edge);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkhbbox.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKHButtonBox.h>

@implementation GTKHButtonBox
+ (GtkType) getType
{
    return gtk_hbutton_box_get_type();
}
+ (id) hButtonBox
{
    return [[(GTKHButtonBox *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_hbutton_box_new()];
}
+ (gint) getSpacingDefault
{
    return gtk_hbutton_box_get_spacing_default();
}
+ (GtkButtonBoxStyle) getLayoutDefault
{
    return gtk_hbutton_box_get_layout_default();
}
+ (void) setSpacingDefault:(gint) spacing
{
    gtk_hbutton_box_set_spacing_default( spacing);
}
+ (void) setLayoutDefault:(GtkButtonBoxStyle) layout
{
    gtk_hbutton_box_set_layout_default( layout);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkhbox.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKHBox.h>

@implementation GTKHBox
+ (GtkType) getType
{
    return gtk_hbox_get_type();
}
+ (id) hBoxWithHomogeneous:(gboolean) homogeneous spacing:(gint) spacing
{
    return [[(GTKHBox *)[self alloc] initWithHomogeneous:homogeneous spacing:spacing] autorelease];
}
- (id) initWithHomogeneous:(gboolean) homogeneous spacing:(gint) spacing
{
    return [self initWithGtk:gtk_hbox_new( homogeneous , spacing)];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkhpaned.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKHPaned.h>

@implementation GTKHPaned
+ (GtkType) getType
{
    return gtk_hpaned_get_type();
}
+ (id) hPaned
{
    return [[(GTKHPaned *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_hpaned_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkhruler.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKHRuler.h>

@implementation GTKHRuler
+ (GtkType) getType
{
    return gtk_hruler_get_type();
}
+ (id) hRuler
{
    return [[(GTKHRuler *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_hruler_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkhscale.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKHScale.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKHScale
+ (GtkType) getType
{
    return gtk_hscale_get_type();
}
+ (id) hScaleWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKHScale *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- (id) initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_hscale_new( adjustment ? adjustment->gtk : 0)];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkhscrollbar.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKHScrollbar.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKHScrollbar
+ (GtkType) getType
{
    return gtk_hscrollbar_get_type();
}
+ (id) hScrollbarWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKHScrollbar *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- (id) initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_hscrollbar_new( adjustment ? adjustment->gtk : 0)];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkhseparator.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKHSeparator.h>

@implementation GTKHSeparator
+ (GtkType) getType
{
    return gtk_hseparator_get_type();
}
+ (id) hSeparator
{
    return [[(GTKHSeparator *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_hseparator_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkimage.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKImage.h>

@implementation GTKImage
+ (GtkType) getType
{
    return gtk_image_get_type();
}
+ (id) imageWithVal:(GdkImage *) val mask:(GdkBitmap *) mask
{
    return [[(GTKImage *)[self alloc] initWithVal:val mask:mask] autorelease];
}
- (id) initWithVal:(GdkImage *) val mask:(GdkBitmap *) mask
{
    return [self initWithGtk:gtk_image_new( val , mask)];
}
- (void) set:(GdkImage *) val mask:(GdkBitmap *) mask
{
    gtk_image_set(gtk, val , mask);
}
- (void) get:(GdkImage **) val mask:(GdkBitmap **) mask
{
    gtk_image_get(gtk, val , mask);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkinputdialog.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKInputDialog.h>

@implementation GTKInputDialog
+ (GtkType) getType
{
    return gtk_input_dialog_get_type();
}
+ (id) inputDialog
{
    return [[(GTKInputDialog *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_input_dialog_new()];
}
#define gtk	((GtkInputDialog *) gtk)
- (GTKWidget *) closeButton
{
    return GTOOLKIT_OBJECT(gtk->close_button);
}
- (GTKWidget *) saveButton
{
    return GTOOLKIT_OBJECT(gtk->save_button);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkinvisible.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKInvisible.h>

@implementation GTKInvisible
+ (GtkType) getType
{
    return gtk_invisible_get_type();
}
+ (id) invisible
{
    return [[(GTKInvisible *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_invisible_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkitem.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKItem.h>

@implementation GTKItem
+ (GtkType) getType
{
    return gtk_item_get_type();
}
- (void) select
{
    gtk_item_select(gtk);
}
- (void) deselect
{
    gtk_item_deselect(gtk);
}
- (void) toggle
{
    gtk_item_toggle(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkitemfactory.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKItemFactory.h>
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKAccelGroup.h>

@implementation GTKItemFactory
+ (GtkType) getType
{
    return gtk_item_factory_get_type();
}
+ (id) itemFactoryWithContainerType:(GtkType) container_type path:(NSString *) path accelGroup:(GTKAccelGroup *) accel_group
{
    return [[(GTKItemFactory *)[self alloc] initWithContainerType:container_type path:path accelGroup:accel_group] autorelease];
}
- (id) initWithContainerType:(GtkType) container_type path:(NSString *) path accelGroup:(GTKAccelGroup *) accel_group
{
    return [self initWithGtk:gtk_item_factory_new( container_type ,gtoolkit_utf8_string( path ), accel_group ? accel_group->gtk : 0)];
}
+ (void) parseRc:(NSString *) file_name
{
    gtk_item_factory_parse_rc(gtoolkit_utf8_string( file_name));
}
+ (void) parseRcString:(NSString *) rc_string
{
    gtk_item_factory_parse_rc_string(gtoolkit_utf8_string( rc_string));
}
+ (void) parseRcScanner:(GScanner *) scanner
{
    gtk_item_factory_parse_rc_scanner( scanner);
}
+ (void) addForeign:(GTKWidget *) accel_widget fullPath:(NSString *) full_path accelGroup:(GTKAccelGroup *) accel_group keyval:(guint) keyval modifiers:(GdkModifierType) modifiers
{
    gtk_item_factory_add_foreign( accel_widget  ? accel_widget ->gtk : 0,gtoolkit_utf8_string( full_path ), accel_group  ? accel_group ->gtk : 0, keyval , modifiers);
}
+ (GTKItemFactory*) fromWidget:(GTKWidget *) widget
{
    return gtoolkit_object(gtk_item_factory_from_widget( widget ? widget->gtk : 0), 0);
}
+ (NSString *) pathFromWidget:(GTKWidget *) widget
{
    return gtoolkit_objc_string(gtk_item_factory_path_from_widget( widget ? widget->gtk : 0));
}
- (GTKWidget*) getItem:(NSString *) path
{
    return gtoolkit_object(gtk_item_factory_get_item(gtk,gtoolkit_utf8_string( path)), 0);
}
- (GTKWidget*) getWidget:(NSString *) path
{
    return gtoolkit_object(gtk_item_factory_get_widget(gtk,gtoolkit_utf8_string( path)), 0);
}
- (GTKWidget*) getWidgetByAction:(guint) action
{
    return gtoolkit_object(gtk_item_factory_get_widget_by_action(gtk, action), 0);
}
- (GTKWidget*) getItemByAction:(guint) action
{
    return gtoolkit_object(gtk_item_factory_get_item_by_action(gtk, action), 0);
}
+ (void) dumpItems:(GtkPatternSpec *) path_pspec modifiedOnly:(gboolean) modified_only printFunc:(GtkPrintFunc) print_func funcData:(gpointer) func_data
{
    gtk_item_factory_dump_items( path_pspec , modified_only , print_func , func_data);
}
+ (void) dumpRc:(NSString *) file_name pathPspec:(GtkPatternSpec *) path_pspec modifiedOnly:(gboolean) modified_only
{
    gtk_item_factory_dump_rc(gtoolkit_utf8_string( file_name ), path_pspec , modified_only);
}
- (void) createItem:(GtkItemFactoryEntry *) entry callbackData:(gpointer) callback_data callbackType:(guint) callback_type
{
    gtk_item_factory_create_item(gtk, entry , callback_data , callback_type);
}
- (void) createItems:(guint) n_entries entries:(GtkItemFactoryEntry *) entries callbackData:(gpointer) callback_data
{
    gtk_item_factory_create_items(gtk, n_entries , entries , callback_data);
}
- (void) deleteItem:(NSString *) path
{
    gtk_item_factory_delete_item(gtk,gtoolkit_utf8_string( path));
}
- (void) deleteEntry:(GtkItemFactoryEntry *) entry
{
    gtk_item_factory_delete_entry(gtk, entry);
}
- (void) deleteEntries:(guint) n_entries entries:(GtkItemFactoryEntry *) entries
{
    gtk_item_factory_delete_entries(gtk, n_entries , entries);
}
- (void) popup:(guint) x y:(guint) y mouseButton:(guint) mouse_button time:(guint32) time
{
    gtk_item_factory_popup(gtk, x , y , mouse_button , time);
}
- (void) popupWithData:(gpointer) popup_data destroy:(GtkDestroyNotify) destroy x:(guint) x y:(guint) y mouseButton:(guint) mouse_button time:(guint32) time
{
    gtk_item_factory_popup_with_data(gtk, popup_data , destroy , x , y , mouse_button , time);
}
- (gpointer) popupData
{
    return gtk_item_factory_popup_data(gtk);
}
+ (gpointer) popupDataFromWidget:(GTKWidget *) widget
{
    return gtk_item_factory_popup_data_from_widget( widget ? widget->gtk : 0);
}
- (void) setTranslateFunc:(GtkTranslateFunc) func data:(gpointer) data notify:(GtkDestroyNotify) notify
{
    gtk_item_factory_set_translate_func(gtk, func , data , notify);
}
#include <stdio.h>
#include <string.h>
#include <Foundation/NSAutoreleasePool.h>


static void item_forward_signal (gpointer data, guint action, GtkWidget *widget)
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    id target = gtk_object_get_data((GtkObject *) widget, "_menu_target");

#ifdef DEBUG
    fprintf(stderr, "(item_forward_signal init) gtk = %p, action [%p %s]\n",
	    widget, target, sel_get_name(data));
#endif
    [target performSelector:data withObject:GTOOLKIT_OBJECT(widget)];
    [pool release];
#ifdef DEBUG
    fprintf(stderr, "(item_forward_signal exit) gtk = %p\n", widget);
#endif
}

 /* This must be kept in sync with gtk_item_factory_parse_path()! */
static void item_parse_path (char *path, const char *str)
{
    while (*str == '_' ? *str++ : (*path++ = *str++));
}

 - (id) initWithGtk:(gpointer) _gtk
{
    [super initWithGtk:_gtk];
    gtk_widget_show(gtk_item_factory_get_widget(_gtk, ""));
    return  self;	// avoid bug in objcdoc
}

/*
 * This is the preferred method to create item factoy entries. Note that
 * it expects a vector of type GTKItemFactoryEntry (defined in
 * GToolKit/GTKItemFactory.h) instead of the original GtkItemFactoryEntry.
 * @see -deleteEntries:count:
 */
- (void) createItems:(GTKItemFactoryEntry *) entries count:(guint) count
	 forTarget:(id) target
{
    for (; count--; ++entries)
    {
	char *path = g_new(char, strlen(entries->item.path) + 1);
	GtkWidget *item_widget;

	if (entries->item.callback == NULL && entries->selector)
	    entries->item.callback =
		(GtkItemFactoryCallback) item_forward_signal;

	gtk_item_factory_create_item(gtk, &entries->item,
				     (gpointer) entries->selector, 1);

	item_parse_path(path, entries->item.path);
	item_widget = gtk_item_factory_get_widget(gtk, path);
	gtk_object_set_data((GtkObject *) item_widget, "_menu_target", target);
	g_free(path);
    }
}

/*
 * This is the preferred method to delete item factoy entries. Note that it
 * expects a vector of type GTKItemFactoryEntry (defined in
 * GToolKit/GTKItemFactory.h) instead of the original GtkItemFactoryEntry.
 * @see -createItems:count:forTarget:
 */
- (void) deleteEntries:(GTKItemFactoryEntry *) entries count:(guint) count
{
    for (; count--; ++entries)
	gtk_item_factory_delete_entry(gtk, &entries->item);
}

#define gtk	((GtkItemFactory *) gtk)
- (GTKAccelGroup *) accelGroup
{
    return gtoolkit_object(gtk->accel_group, "GTKAccelGroup");
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtklabel.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKLabel.h>

@implementation GTKLabel
+ (GtkType) getType
{
    return gtk_label_get_type();
}
+ (id) labelWithStr:(NSString *) str
{
    return [[(GTKLabel *)[self alloc] initWithStr:str] autorelease];
}
- (id) initWithStr:(NSString *) str
{
    return [self initWithGtk:gtk_label_new(gtoolkit_utf8_string( str))];
}
- (void) setText:(NSString *) str
{
    gtk_label_set_text(gtk,gtoolkit_utf8_string( str));
}
- (void) setJustify:(GtkJustification) jtype
{
    gtk_label_set_justify(gtk, jtype);
}
- (void) setPattern:(NSString *) pattern
{
    gtk_label_set_pattern(gtk,gtoolkit_utf8_string( pattern));
}
- (void) setLineWrap:(gboolean) wrap
{
    gtk_label_set_line_wrap(gtk, wrap);
}
- (void) get:(NSString **) str
{
    char *_outval_1;
    gtk_label_get(gtk,&_outval_1);
    * str = gtoolkit_objc_string(_outval_1);
}
- (guint) parseUline:(NSString *) string
{
    return gtk_label_parse_uline(gtk,gtoolkit_utf8_string( string));
}
#include <stdio.h>
#include <stdlib.h>

- (void) setDoubleValue:(double) value
{
    char string[64];

    sprintf(string, "%g", value);
    gtk_label_set_text(gtk, string);
}

- (void) setIntValue:(int) value
{
    char string[64];

    sprintf(string, "%d", value);
    gtk_label_set_text(gtk, string);
}

- (void) setStringValue:(NSString *) value
{
    gtk_label_set_text(gtk, gtoolkit_utf8_string(value));
}

- (double) doubleValue
{
    char *string;

    gtk_label_get(gtk, &string);
    return atof(string);
}

- (int) intValue
{
    char *string;

    gtk_label_get(gtk, &string);
    return atoi(string);
}

- (NSString *) stringValue
{
    char *string;

    gtk_label_get(gtk, &string);
    return gtoolkit_objc_string(string);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtklayout.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKLayout.h>
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKLayout
+ (GtkType) getType
{
    return gtk_layout_get_type();
}
+ (id) layoutWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [[(GTKLayout *)[self alloc] initWithHadjustment:hadjustment vadjustment:vadjustment] autorelease];
}
- (id) initWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [self initWithGtk:gtk_layout_new( hadjustment  ? hadjustment ->gtk : 0, vadjustment ? vadjustment->gtk : 0)];
}
- (void) put:(GTKWidget *) widget x:(gint) x y:(gint) y
{
    gtk_layout_put(gtk, widget  ? widget ->gtk : 0, x , y);
}
- (void) move:(GTKWidget *) widget x:(gint) x y:(gint) y
{
    gtk_layout_move(gtk, widget  ? widget ->gtk : 0, x , y);
}
- (void) setSize:(guint) width height:(guint) height
{
    gtk_layout_set_size(gtk, width , height);
}
- (GTKAdjustment*) getHadjustment
{
    return gtoolkit_object(gtk_layout_get_hadjustment(gtk), 0);
}
- (GTKAdjustment*) getVadjustment
{
    return gtoolkit_object(gtk_layout_get_vadjustment(gtk), 0);
}
- (void) setHadjustment:(GTKAdjustment *) adjustment
{
    gtk_layout_set_hadjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) setVadjustment:(GTKAdjustment *) adjustment
{
    gtk_layout_set_vadjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) freeze
{
    gtk_layout_freeze(gtk);
}
- (void) thaw
{
    gtk_layout_thaw(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtklist.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKList.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKList
+ (GtkType) getType
{
    return gtk_list_get_type();
}
+ (id) list
{
    return [[(GTKList *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_list_new()];
}
- (void) insertItems:(NSArray *) items position:(gint) position
{
    gtk_list_insert_items(gtk,gtoolkit_array_to_list( items ), position);
}
- (void) appendItems:(NSArray *) items
{
    gtk_list_append_items(gtk,gtoolkit_array_to_list( items));
}
- (void) prependItems:(NSArray *) items
{
    gtk_list_prepend_items(gtk,gtoolkit_array_to_list( items));
}
- (void) removeItems:(NSArray *) items
{
    gtk_list_remove_items(gtk,gtoolkit_array_to_list( items));
}
- (void) removeItemsNoUnref:(NSArray *) items
{
    gtk_list_remove_items_no_unref(gtk,gtoolkit_array_to_list( items));
}
- (void) clearItems:(gint) start end:(gint) end
{
    gtk_list_clear_items(gtk, start , end);
}
- (void) selectItem:(gint) item
{
    gtk_list_select_item(gtk, item);
}
- (void) unselectItem:(gint) item
{
    gtk_list_unselect_item(gtk, item);
}
- (void) selectChild:(GTKWidget *) child
{
    gtk_list_select_child(gtk, child ? child->gtk : 0);
}
- (void) unselectChild:(GTKWidget *) child
{
    gtk_list_unselect_child(gtk, child ? child->gtk : 0);
}
- (gint) childPosition:(GTKWidget *) child
{
    return gtk_list_child_position(gtk, child ? child->gtk : 0);
}
- (void) setSelectionMode:(GtkSelectionMode) mode
{
    gtk_list_set_selection_mode(gtk, mode);
}
- (void) extendSelection:(GtkScrollType) scroll_type position:(gfloat) position autoStartSelection:(gboolean) auto_start_selection
{
    gtk_list_extend_selection(gtk, scroll_type , position , auto_start_selection);
}
- (void) startSelection
{
    gtk_list_start_selection(gtk);
}
- (void) endSelection
{
    gtk_list_end_selection(gtk);
}
- (void) selectAll
{
    gtk_list_select_all(gtk);
}
- (void) unselectAll
{
    gtk_list_unselect_all(gtk);
}
- (void) scrollHorizontal:(GtkScrollType) scroll_type position:(gfloat) position
{
    gtk_list_scroll_horizontal(gtk, scroll_type , position);
}
- (void) scrollVertical:(GtkScrollType) scroll_type position:(gfloat) position
{
    gtk_list_scroll_vertical(gtk, scroll_type , position);
}
- (void) toggleAddMode
{
    gtk_list_toggle_add_mode(gtk);
}
- (void) toggleFocusRow
{
    gtk_list_toggle_focus_row(gtk);
}
- (void) toggleRow:(GTKWidget *) item
{
    gtk_list_toggle_row(gtk, item ? item->gtk : 0);
}
- (void) undoSelection
{
    gtk_list_undo_selection(gtk);
}
- (void) endDragSelection
{
    gtk_list_end_drag_selection(gtk);
}
#define gtk	((GtkList *) gtk)
- (NSArray *) selection
{
    return gtoolkit_list_to_array(gtk->selection);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtklistitem.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKListItem.h>

@implementation GTKListItem
+ (GtkType) getType
{
    return gtk_list_item_get_type();
}
+ (id) listItem
{
    return [[(GTKListItem *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_list_item_new()];
}
+ (id) listItemWithLabel:(NSString *) label
{
    return [[(GTKListItem *)[self alloc] initWithLabel:label] autorelease];
}
- (id) initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_list_item_new_with_label(gtoolkit_utf8_string( label))];
}
- (void) select
{
    gtk_list_item_select(gtk);
}
- (void) deselect
{
    gtk_list_item_deselect(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkmain.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKMain.h>
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKObject.h>
#include <GToolKit/GTKStyle.h>

@implementation GTKMain
- (NSString *) checkVersion:(guint) required_major requiredMinor:(guint) required_minor requiredMicro:(guint) required_micro
{
    return gtoolkit_objc_string(gtk_check_version( required_major , required_minor , required_micro));
}
- (void) exit:(gint) error_code
{
    gtk_exit( error_code);
}
- (NSString *) setLocale
{
    return gtoolkit_objc_string(gtk_set_locale());
}
- (gint) eventsPending
{
    return gtk_events_pending();
}
- (void) mainDoEvent:(GdkEvent *) event
{
    gtk_main_do_event( event);
}
- (void) main
{
    gtk_main();
}
- (guint) mainLevel
{
    return gtk_main_level();
}
- (void) mainQuit
{
    gtk_main_quit();
}
- (gint) mainIteration
{
    return gtk_main_iteration();
}
- (gint) mainIterationDo:(gboolean) blocking
{
    return gtk_main_iteration_do( blocking);
}
- (gint) true
{
    return gtk_true();
}
- (gint) false
{
    return gtk_false();
}
- (void) grabAdd:(GTKWidget *) widget
{
    gtk_grab_add( widget ? widget->gtk : 0);
}
- (GTKWidget*) grabGetCurrent
{
    return gtoolkit_object(gtk_grab_get_current(), 0);
}
- (void) grabRemove:(GTKWidget *) widget
{
    gtk_grab_remove( widget ? widget->gtk : 0);
}
- (void) initAdd:(GtkFunction) function data:(gpointer) data
{
    gtk_init_add( function , data);
}
- (void) quitAddDestroy:(guint) main_level object:(GTKObject *) object
{
    gtk_quit_add_destroy( main_level , object ? object->gtk : 0);
}
- (guint) quitAdd:(guint) main_level function:(GtkFunction) function data:(gpointer) data
{
    return gtk_quit_add( main_level , function , data);
}
- (guint) quitAddFull:(guint) main_level function:(GtkFunction) function marshal:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_quit_add_full( main_level , function , marshal , data , destroy);
}
- (void) quitRemove:(guint) quit_handler_id
{
    gtk_quit_remove( quit_handler_id);
}
- (void) quitRemoveByData:(gpointer) data
{
    gtk_quit_remove_by_data( data);
}
- (guint) timeoutAdd:(guint32) interval function:(GtkFunction) function data:(gpointer) data
{
    return gtk_timeout_add( interval , function , data);
}
- (guint) timeoutAddFull:(guint32) interval function:(GtkFunction) function marshal:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_timeout_add_full( interval , function , marshal , data , destroy);
}
- (void) timeoutRemove:(guint) timeout_handler_id
{
    gtk_timeout_remove( timeout_handler_id);
}
- (guint) idleAdd:(GtkFunction) function data:(gpointer) data
{
    return gtk_idle_add( function , data);
}
- (guint) idleAddPriority:(gint) priority function:(GtkFunction) function data:(gpointer) data
{
    return gtk_idle_add_priority( priority , function , data);
}
- (guint) idleAddFull:(gint) priority function:(GtkFunction) function marshal:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_idle_add_full( priority , function , marshal , data , destroy);
}
- (void) idleRemove:(guint) idle_handler_id
{
    gtk_idle_remove( idle_handler_id);
}
- (void) idleRemoveByData:(gpointer) data
{
    gtk_idle_remove_by_data( data);
}
- (guint) inputAddFull:(gint) source condition:(GdkInputCondition) condition function:(GdkInputFunction) function marshal:(GtkCallbackMarshal) marshal data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    return gtk_input_add_full( source , condition , function , marshal , data , destroy);
}
- (void) inputRemove:(guint) input_handler_id
{
    gtk_input_remove( input_handler_id);
}
- (guint) keySnooperInstall:(GtkKeySnoopFunc) snooper funcData:(gpointer) func_data
{
    return gtk_key_snooper_install( snooper , func_data);
}
- (void) keySnooperRemove:(guint) snooper_handler_id
{
    gtk_key_snooper_remove( snooper_handler_id);
}
- (GdkEvent*) getCurrentEvent
{
    return gtk_get_current_event();
}
- (GTKWidget*) getEventWidget:(GdkEvent *) event
{
    return gtoolkit_object(gtk_get_event_widget( event), 0);
}
- (void) rcInit
{
    gtk_rc_init();
}
- (void) rcAddDefaultFile:(NSString *) filename
{
    gtk_rc_add_default_file(gtoolkit_utf8_string( filename));
}
- (void) rcSetDefaultFiles:(NSArray  *) filenames
{
    gtk_rc_set_default_files((char **)gtoolkit_array_to_strvec( filenames));
}
- (NSArray  *) rcGetDefaultFiles
{
    return gtoolkit_strvec_to_array((const char **)gtk_rc_get_default_files());
}
- (void) rcParse:(NSString *) filename
{
    gtk_rc_parse(gtoolkit_utf8_string( filename));
}
- (void) rcParseString:(NSString *) rc_string
{
    gtk_rc_parse_string(gtoolkit_utf8_string( rc_string));
}
- (gboolean) rcReparseAll
{
    return gtk_rc_reparse_all();
}
- (GTKStyle*) rcGetStyle:(GTKWidget *) widget
{
    return gtoolkit_object(gtk_rc_get_style( widget ? widget->gtk : 0), "GTKStyle");
}
- (void) rcAddWidgetNameStyle:(GtkRcStyle *) rc_style pattern:(NSString *) pattern
{
    gtk_rc_add_widget_name_style( rc_style ,gtoolkit_utf8_string( pattern));
}
- (void) rcAddWidgetClassStyle:(GtkRcStyle *) rc_style pattern:(NSString *) pattern
{
    gtk_rc_add_widget_class_style( rc_style ,gtoolkit_utf8_string( pattern));
}
- (void) rcAddClassStyle:(GtkRcStyle *) rc_style pattern:(NSString *) pattern
{
    gtk_rc_add_class_style( rc_style ,gtoolkit_utf8_string( pattern));
}
- (GtkRcStyle*) rcStyleNew
{
    return gtk_rc_style_new();
}
- (void) rcStyleRef:(GtkRcStyle *) rc_style
{
    gtk_rc_style_ref( rc_style);
}
- (void) rcStyleUnref:(GtkRcStyle *) rc_style
{
    gtk_rc_style_unref( rc_style);
}
- (void) rcSetImageLoader:(GtkImageLoader) loader
{
    gtk_rc_set_image_loader( loader);
}
- (GdkPixmap*) rcLoadImage:(GdkColormap *) colormap transparentColor:(GdkColor *) transparent_color filename:(NSString *) filename
{
    return gtk_rc_load_image( colormap , transparent_color ,gtoolkit_utf8_string( filename));
}
- (NSString *) rcFindPixmapInPath:(GScanner *) scanner pixmapFile:(NSString *) pixmap_file
{
    return gtoolkit_objc_string(gtk_rc_find_pixmap_in_path( scanner ,gtoolkit_utf8_string( pixmap_file)));
}
- (NSString *) rcFindModuleInPath:(NSString *) module_file
{
    return gtoolkit_objc_string(gtk_rc_find_module_in_path(gtoolkit_utf8_string( module_file)));
}
- (NSString *) rcGetThemeDir
{
    return gtoolkit_objc_string(gtk_rc_get_theme_dir());
}
- (NSString *) rcGetModuleDir
{
    return gtoolkit_objc_string(gtk_rc_get_module_dir());
}
- (guint) rcParse:(GScanner *) scanner color:(GdkColor *) color
{
    return gtk_rc_parse_color( scanner , color);
}
- (guint) rcParse:(GScanner *) scanner state:(GtkStateType *) state
{
    return gtk_rc_parse_state( scanner , state);
}
- (guint) rcParse:(GScanner *) scanner priority:(GtkPathPriorityType *) priority
{
    return gtk_rc_parse_priority( scanner , priority);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkmenu.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKMenu.h>
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKAccelGroup.h>

@implementation GTKMenu
+ (GtkType) getType
{
    return gtk_menu_get_type();
}
+ (id) menu
{
    return [[(GTKMenu *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_menu_new()];
}
- (void) append:(GTKWidget *) child
{
    gtk_menu_append(gtk, child ? child->gtk : 0);
}
- (void) prepend:(GTKWidget *) child
{
    gtk_menu_prepend(gtk, child ? child->gtk : 0);
}
- (void) insert:(GTKWidget *) child position:(gint) position
{
    gtk_menu_insert(gtk, child  ? child ->gtk : 0, position);
}
- (void) popup:(GTKWidget *) parent_menu_shell parentMenuItem:(GTKWidget *) parent_menu_item func:(GtkMenuPositionFunc) func data:(gpointer) data button:(guint) button activateTime:(guint32) activate_time
{
    gtk_menu_popup(gtk, parent_menu_shell  ? parent_menu_shell ->gtk : 0, parent_menu_item  ? parent_menu_item ->gtk : 0, func , data , button , activate_time);
}
- (void) reposition
{
    gtk_menu_reposition(gtk);
}
- (void) popdown
{
    gtk_menu_popdown(gtk);
}
- (GTKWidget*) getActive
{
    return gtoolkit_object(gtk_menu_get_active(gtk), 0);
}
- (void) setActive:(guint) index
{
    gtk_menu_set_active(gtk, index);
}
- (void) setAccelGroup:(GTKAccelGroup *) accel_group
{
    gtk_menu_set_accel_group(gtk, accel_group ? accel_group->gtk : 0);
}
- (GTKAccelGroup*) getAccelGroup
{
    return gtoolkit_object(gtk_menu_get_accel_group(gtk), "GTKAccelGroup");
}
- (void) attachToWidget:(GTKWidget *) attach_widget detacher:(GtkMenuDetachFunc) detacher
{
    gtk_menu_attach_to_widget(gtk, attach_widget  ? attach_widget ->gtk : 0, detacher);
}
- (void) detach
{
    gtk_menu_detach(gtk);
}
- (GTKWidget*) getAttachWidget
{
    return gtoolkit_object(gtk_menu_get_attach_widget(gtk), 0);
}
- (void) setTearoffState:(gboolean) torn_off
{
    gtk_menu_set_tearoff_state(gtk, torn_off);
}
- (void) setTitle:(NSString *) title
{
    gtk_menu_set_title(gtk,gtoolkit_utf8_string( title));
}
- (void) reorderChild:(GTKWidget *) child position:(gint) position
{
    gtk_menu_reorder_child(gtk, child  ? child ->gtk : 0, position);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkmenubar.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKMenuBar.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKMenuBar
+ (GtkType) getType
{
    return gtk_menu_bar_get_type();
}
+ (id) menuBar
{
    return [[(GTKMenuBar *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_menu_bar_new()];
}
- (void) append:(GTKWidget *) child
{
    gtk_menu_bar_append(gtk, child ? child->gtk : 0);
}
- (void) prepend:(GTKWidget *) child
{
    gtk_menu_bar_prepend(gtk, child ? child->gtk : 0);
}
- (void) insert:(GTKWidget *) child position:(gint) position
{
    gtk_menu_bar_insert(gtk, child  ? child ->gtk : 0, position);
}
- (void) setShadowType:(GtkShadowType) type
{
    gtk_menu_bar_set_shadow_type(gtk, type);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkmenufactory.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKMenuFactory.h>

@implementation GTKMenuFactory
+ (id) menuFactoryWithType:(GtkMenuFactoryType) type
{
    return [[(GTKMenuFactory *)[self alloc] initWithType:type] autorelease];
}
- (id) initWithType:(GtkMenuFactoryType) type
{
    return [self initWithGtk:gtk_menu_factory_new( type)];
}
- (void) destroy
{
    gtk_menu_factory_destroy(gtk);
}
- (void) addEntries:(GtkMenuEntry *) entries nentries:(int) nentries
{
    gtk_menu_factory_add_entries(gtk, entries , nentries);
}
- (void) addSubfactory:(GTKMenuFactory *) subfactory path:(NSString *) path
{
    gtk_menu_factory_add_subfactory(gtk, subfactory  ? subfactory ->gtk : 0,gtoolkit_utf8_string( path));
}
- (void) removePaths:(NSArray  *) paths npaths:(int) npaths
{
    gtk_menu_factory_remove_paths(gtk,(char **)gtoolkit_array_to_strvec( paths ), npaths);
}
- (void) removeEntries:(GtkMenuEntry *) entries nentries:(int) nentries
{
    gtk_menu_factory_remove_entries(gtk, entries , nentries);
}
- (void) removeSubfactory:(GTKMenuFactory *) subfactory path:(NSString *) path
{
    gtk_menu_factory_remove_subfactory(gtk, subfactory  ? subfactory ->gtk : 0,gtoolkit_utf8_string( path));
}
- (GtkMenuPath*) find:(NSString *) path
{
    return gtk_menu_factory_find(gtk,gtoolkit_utf8_string( path));
}
#include <stdio.h>
#include <Foundation/NSAutoreleasePool.h>


static void menu_forward_signal (GtkWidget *widget, gpointer user_data)
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    id target = gtk_object_get_data((GtkObject *) widget, "_menu_target");

#ifdef DEBUG
    fprintf(stderr, "(menu_forward_signal init) gtk = %p, action [%p %s]\n",
	    widget, target, sel_get_name(user_data));
#endif
    [target performSelector:user_data withObject:GTOOLKIT_OBJECT(widget)];
    [pool release];
#ifdef DEBUG
    fprintf(stderr, "(menu_forward_signal exit) gtk = %p\n", widget);
#endif
}

- (void) addEntries:(GtkMenuEntry *) entries forTarget:(id) target
{
    GtkMenuEntry *base = entries;
    int index, count = 0;

    while (entries->path) ++entries, ++count;
    for (index = 0; index != count; ++index)
	base[index].callback = menu_forward_signal;

    gtk_menu_factory_add_entries(gtk, base, count);

    for (index = 0; index != count; ++index)
	if (base[index].widget)
	    gtk_object_set_data((GtkObject *) base[index].widget,
				"_menu_target", target);
}

#define gtk	((GtkMenuFactory *) gtk)
- (GTKAccelGroup *) accelGroup
{
    return gtoolkit_object(gtk->accel_group, "GTKAccelGroup");
}
- (GTKWidget *) widget
{
    return GTOOLKIT_OBJECT(gtk->widget);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkmenuitem.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKMenuItem.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKMenuItem
+ (GtkType) getType
{
    return gtk_menu_item_get_type();
}
+ (id) menuItem
{
    return [[(GTKMenuItem *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_menu_item_new()];
}
+ (id) menuItemWithLabel:(NSString *) label
{
    return [[(GTKMenuItem *)[self alloc] initWithLabel:label] autorelease];
}
- (id) initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_menu_item_new_with_label(gtoolkit_utf8_string( label))];
}
- (void) setSubmenu:(GTKWidget *) submenu
{
    gtk_menu_item_set_submenu(gtk, submenu ? submenu->gtk : 0);
}
- (void) removeSubmenu
{
    gtk_menu_item_remove_submenu(gtk);
}
- (void) setPlacement:(GtkSubmenuPlacement) placement
{
    gtk_menu_item_set_placement(gtk, placement);
}
- (void) configure:(gint) show_toggle_indicator showSubmenuIndicator:(gint) show_submenu_indicator
{
    gtk_menu_item_configure(gtk, show_toggle_indicator , show_submenu_indicator);
}
- (void) select
{
    gtk_menu_item_select(gtk);
}
- (void) deselect
{
    gtk_menu_item_deselect(gtk);
}
- (void) activate
{
    gtk_menu_item_activate(gtk);
}
- (void) rightJustify
{
    gtk_menu_item_right_justify(gtk);
}
#define gtk	((GtkMenuItem *) gtk)
- (GTKWidget *) submenu
{
    return GTOOLKIT_OBJECT(gtk->submenu);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkmenushell.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKMenuShell.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKMenuShell
+ (GtkType) getType
{
    return gtk_menu_shell_get_type();
}
- (void) append:(GTKWidget *) child
{
    gtk_menu_shell_append(gtk, child ? child->gtk : 0);
}
- (void) prepend:(GTKWidget *) child
{
    gtk_menu_shell_prepend(gtk, child ? child->gtk : 0);
}
- (void) insert:(GTKWidget *) child position:(gint) position
{
    gtk_menu_shell_insert(gtk, child  ? child ->gtk : 0, position);
}
- (void) deactivate
{
    gtk_menu_shell_deactivate(gtk);
}
- (void) selectItem:(GTKWidget *) menu_item
{
    gtk_menu_shell_select_item(gtk, menu_item ? menu_item->gtk : 0);
}
- (void) deselect
{
    gtk_menu_shell_deselect(gtk);
}
- (void) activateItem:(GTKWidget *) menu_item forceDeactivate:(gboolean) force_deactivate
{
    gtk_menu_shell_activate_item(gtk, menu_item  ? menu_item ->gtk : 0, force_deactivate);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkmisc.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKMisc.h>

@implementation GTKMisc
+ (GtkType) getType
{
    return gtk_misc_get_type();
}
- (void) setAlignment:(gfloat) xalign yalign:(gfloat) yalign
{
    gtk_misc_set_alignment(gtk, xalign , yalign);
}
- (void) setPadding:(gint) xpad ypad:(gint) ypad
{
    gtk_misc_set_padding(gtk, xpad , ypad);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtknotebook.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKNotebook.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKNotebook
+ (GtkType) getType
{
    return gtk_notebook_get_type();
}
+ (id) notebook
{
    return [[(GTKNotebook *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_notebook_new()];
}
- (void) appendPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label
{
    gtk_notebook_append_page(gtk, child  ? child ->gtk : 0, tab_label ? tab_label->gtk : 0);
}
- (void) appendPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label
{
    gtk_notebook_append_page_menu(gtk, child  ? child ->gtk : 0, tab_label  ? tab_label ->gtk : 0, menu_label ? menu_label->gtk : 0);
}
- (void) prependPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label
{
    gtk_notebook_prepend_page(gtk, child  ? child ->gtk : 0, tab_label ? tab_label->gtk : 0);
}
- (void) prependPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label
{
    gtk_notebook_prepend_page_menu(gtk, child  ? child ->gtk : 0, tab_label  ? tab_label ->gtk : 0, menu_label ? menu_label->gtk : 0);
}
- (void) insertPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label position:(gint) position
{
    gtk_notebook_insert_page(gtk, child  ? child ->gtk : 0, tab_label  ? tab_label ->gtk : 0, position);
}
- (void) insertPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label position:(gint) position
{
    gtk_notebook_insert_page_menu(gtk, child  ? child ->gtk : 0, tab_label  ? tab_label ->gtk : 0, menu_label  ? menu_label ->gtk : 0, position);
}
- (void) removePage:(gint) page_num
{
    gtk_notebook_remove_page(gtk, page_num);
}
- (gint) getCurrentPage
{
    return gtk_notebook_get_current_page(gtk);
}
- (GTKWidget*) getNthPage:(gint) page_num
{
    return gtoolkit_object(gtk_notebook_get_nth_page(gtk, page_num), 0);
}
- (gint) pageNum:(GTKWidget *) child
{
    return gtk_notebook_page_num(gtk, child ? child->gtk : 0);
}
- (void) setPage:(gint) page_num
{
    gtk_notebook_set_page(gtk, page_num);
}
- (void) nextPage
{
    gtk_notebook_next_page(gtk);
}
- (void) prevPage
{
    gtk_notebook_prev_page(gtk);
}
- (void) setShowBorder:(gboolean) show_border
{
    gtk_notebook_set_show_border(gtk, show_border);
}
- (void) setShowTabs:(gboolean) show_tabs
{
    gtk_notebook_set_show_tabs(gtk, show_tabs);
}
- (void) setTabPos:(GtkPositionType) pos
{
    gtk_notebook_set_tab_pos(gtk, pos);
}
- (void) setHomogeneousTabs:(gboolean) homogeneous
{
    gtk_notebook_set_homogeneous_tabs(gtk, homogeneous);
}
- (void) setTabBorder:(guint) border_width
{
    gtk_notebook_set_tab_border(gtk, border_width);
}
- (void) setTabHborder:(guint) tab_hborder
{
    gtk_notebook_set_tab_hborder(gtk, tab_hborder);
}
- (void) setTabVborder:(guint) tab_vborder
{
    gtk_notebook_set_tab_vborder(gtk, tab_vborder);
}
- (void) setScrollable:(gboolean) scrollable
{
    gtk_notebook_set_scrollable(gtk, scrollable);
}
- (void) popupEnable
{
    gtk_notebook_popup_enable(gtk);
}
- (void) popupDisable
{
    gtk_notebook_popup_disable(gtk);
}
- (GTKWidget *) getTabLabel:(GTKWidget *) child
{
    return gtoolkit_object(gtk_notebook_get_tab_label(gtk, child ? child->gtk : 0), 0);
}
- (void) setTabLabel:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label
{
    gtk_notebook_set_tab_label(gtk, child  ? child ->gtk : 0, tab_label ? tab_label->gtk : 0);
}
- (void) setTabLabelText:(GTKWidget *) child tabText:(NSString *) tab_text
{
    gtk_notebook_set_tab_label_text(gtk, child  ? child ->gtk : 0,gtoolkit_utf8_string( tab_text));
}
- (GTKWidget *) getMenuLabel:(GTKWidget *) child
{
    return gtoolkit_object(gtk_notebook_get_menu_label(gtk, child ? child->gtk : 0), 0);
}
- (void) setMenuLabel:(GTKWidget *) child menuLabel:(GTKWidget *) menu_label
{
    gtk_notebook_set_menu_label(gtk, child  ? child ->gtk : 0, menu_label ? menu_label->gtk : 0);
}
- (void) setMenuLabelText:(GTKWidget *) child menuText:(NSString *) menu_text
{
    gtk_notebook_set_menu_label_text(gtk, child  ? child ->gtk : 0,gtoolkit_utf8_string( menu_text));
}
- (void) queryTabLabelPacking:(GTKWidget *) child expand:(gboolean *) expand fill:(gboolean *) fill packType:(GtkPackType *) pack_type
{
    gtk_notebook_query_tab_label_packing(gtk, child  ? child ->gtk : 0, expand , fill , pack_type);
}
- (void) setTabLabelPacking:(GTKWidget *) child expand:(gboolean) expand fill:(gboolean) fill packType:(GtkPackType) pack_type
{
    gtk_notebook_set_tab_label_packing(gtk, child  ? child ->gtk : 0, expand , fill , pack_type);
}
- (void) reorderChild:(GTKWidget *) child position:(gint) position
{
    gtk_notebook_reorder_child(gtk, child  ? child ->gtk : 0, position);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkobject.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKObject.h>

@implementation GTKObject
+ (GtkType) getType
{
    return gtk_object_get_type();
}
+ (guint) classUserSignalNewv:(GtkObjectClass *) klass name:(NSString *) name signalFlags:(GtkSignalRunType) signal_flags marshaller:(GtkSignalMarshaller) marshaller returnVal:(GtkType) return_val nparams:(guint) nparams params:(GtkType *) params
{
    return gtk_object_class_user_signal_newv( klass ,gtoolkit_utf8_string( name ), signal_flags , marshaller , return_val , nparams , params);
}
+ (id) objectvWithType:(GtkType) object_type nArgs:(guint) n_args args:(GtkArg *) args
{
    return [[(GTKObject *)[self alloc] initvWithType:object_type nArgs:n_args args:args] autorelease];
}
- (id) initvWithType:(GtkType) object_type nArgs:(guint) n_args args:(GtkArg *) args
{
    return [self initWithGtk:gtk_object_newv( object_type , n_args , args)];
}
- (void) defaultConstruct
{
    gtk_object_default_construct(gtk);
}
- (void) sink
{
    gtk_object_sink(gtk);
}
- (void) ref
{
    gtk_object_ref(gtk);
}
- (void) unref
{
    gtk_object_unref(gtk);
}
- (void) weakref:(GtkDestroyNotify) notify data:(gpointer) data
{
    gtk_object_weakref(gtk, notify , data);
}
- (void) weakunref:(GtkDestroyNotify) notify data:(gpointer) data
{
    gtk_object_weakunref(gtk, notify , data);
}
- (void) destroy
{
    gtk_object_destroy(gtk);
}
- (void) getv:(guint) n_args args:(GtkArg *) args
{
    gtk_object_getv(gtk, n_args , args);
}
- (void) setv:(guint) n_args args:(GtkArg *) args
{
    gtk_object_setv(gtk, n_args , args);
}
+ (GtkArg*) queryArgs:(GtkType) class_type argFlags:(guint32 **) arg_flags nArgs:(guint *) n_args
{
    return gtk_object_query_args( class_type , arg_flags , n_args);
}
- (void) setData:(NSString *) key data:(gpointer) data
{
    gtk_object_set_data(gtk,gtoolkit_utf8_string( key ), data);
}
- (void) setDataFull:(NSString *) key data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    gtk_object_set_data_full(gtk,gtoolkit_utf8_string( key ), data , destroy);
}
- (void) removeData:(NSString *) key
{
    gtk_object_remove_data(gtk,gtoolkit_utf8_string( key));
}
- (gpointer) getData:(NSString *) key
{
    return gtk_object_get_data(gtk,gtoolkit_utf8_string( key));
}
- (void) removeNoNotify:(NSString *) key
{
    gtk_object_remove_no_notify(gtk,gtoolkit_utf8_string( key));
}
- (void) setUserData:(gpointer) data
{
    gtk_object_set_user_data(gtk, data);
}
- (gpointer) getUserData
{
    return gtk_object_get_user_data(gtk);
}
+ (void) classAddSignals:(GtkObjectClass *) klass signals:(guint *) signals nsignals:(guint) nsignals
{
    gtk_object_class_add_signals( klass , signals , nsignals);
}
+ (void) addArgType:(NSString *) arg_name argType:(GtkType) arg_type argFlags:(guint) arg_flags argId:(guint) arg_id
{
    gtk_object_add_arg_type(gtoolkit_utf8_string( arg_name ), arg_type , arg_flags , arg_id);
}
- (void) setDataById:(GQuark) data_id data:(gpointer) data
{
    gtk_object_set_data_by_id(gtk, data_id , data);
}
- (void) setDataByIdFull:(GQuark) data_id data:(gpointer) data destroy:(GtkDestroyNotify) destroy
{
    gtk_object_set_data_by_id_full(gtk, data_id , data , destroy);
}
- (gpointer) getDataById:(GQuark) data_id
{
    return gtk_object_get_data_by_id(gtk, data_id);
}
- (void) removeDataById:(GQuark) data_id
{
    gtk_object_remove_data_by_id(gtk, data_id);
}
- (void) removeNoNotifyById:(GQuark) key_id
{
    gtk_object_remove_no_notify_by_id(gtk, key_id);
}
static void destroy_notify (GTKObject *self)
{
    [self dealloc];
}

 - (id) initWithGtk:(gpointer) _gtk
{
    [super initWithGtk:_gtk];

    // disable floating flag, we use autorelease instead...
    GTK_OBJECT_UNSET_FLAGS(_gtk, GTK_FLOATING);
    [self weakref:(GtkDestroyNotify) destroy_notify data:self];

    if (tag) tag = 0;		// tag value -1 indicates "do not show"
    // show all widgets (except windows and menus) by default
    else if ([self respondsToSelector:@selector(show)] &&
	     ![self isKindOfClass:[GTKMenu class]] &&
	     ![self isKindOfClass:[GTKWindow class]]) [(id) self show];
    return self;
}

#define gtk	((GtkObject *) gtk)
 - (oneway void) release
{
#ifdef DEBUG
    if (gtk && gtk->ref_count == 0)
	g_error("ref_count == 0 in " __FILE__ " (release)");
#endif
    if (gtk) [self unref];
    else [self dealloc];
}

 - (id) retain
{
    if (gtk) [self ref];
    return self;
}

 - (unsigned) retainCount
{
    return gtk ? gtk->ref_count : 1;
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkoptionmenu.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKOptionMenu.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKOptionMenu
+ (GtkType) getType
{
    return gtk_option_menu_get_type();
}
+ (id) optionMenu
{
    return [[(GTKOptionMenu *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_option_menu_new()];
}
- (GTKWidget*) getMenu
{
    return gtoolkit_object(gtk_option_menu_get_menu(gtk), 0);
}
- (void) setMenu:(GTKWidget *) menu
{
    gtk_option_menu_set_menu(gtk, menu ? menu->gtk : 0);
}
- (void) removeMenu
{
    gtk_option_menu_remove_menu(gtk);
}
- (void) setHistory:(guint) index
{
    gtk_option_menu_set_history(gtk, index);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkpacker.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKPacker.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKPacker
+ (GtkType) getType
{
    return gtk_packer_get_type();
}
+ (id) packer
{
    return [[(GTKPacker *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_packer_new()];
}
- (void) addDefaults:(GTKWidget *) child side:(GtkSideType) side anchor:(GtkAnchorType) anchor options:(GtkPackerOptions) options
{
    gtk_packer_add_defaults(gtk, child  ? child ->gtk : 0, side , anchor , options);
}
- (void) add:(GTKWidget *) child side:(GtkSideType) side anchor:(GtkAnchorType) anchor options:(GtkPackerOptions) options borderWidth:(guint) border_width padX:(guint) pad_x padY:(guint) pad_y iPadX:(guint) i_pad_x iPadY:(guint) i_pad_y
{
    gtk_packer_add(gtk, child  ? child ->gtk : 0, side , anchor , options , border_width , pad_x , pad_y , i_pad_x , i_pad_y);
}
- (void) setChildPacking:(GTKWidget *) child side:(GtkSideType) side anchor:(GtkAnchorType) anchor options:(GtkPackerOptions) options borderWidth:(guint) border_width padX:(guint) pad_x padY:(guint) pad_y iPadX:(guint) i_pad_x iPadY:(guint) i_pad_y
{
    gtk_packer_set_child_packing(gtk, child  ? child ->gtk : 0, side , anchor , options , border_width , pad_x , pad_y , i_pad_x , i_pad_y);
}
- (void) reorderChild:(GTKWidget *) child position:(gint) position
{
    gtk_packer_reorder_child(gtk, child  ? child ->gtk : 0, position);
}
- (void) setSpacing:(guint) spacing
{
    gtk_packer_set_spacing(gtk, spacing);
}
- (void) setDefaultBorderWidth:(guint) border
{
    gtk_packer_set_default_border_width(gtk, border);
}
- (void) setDefaultPad:(guint) pad_x padY:(guint) pad_y
{
    gtk_packer_set_default_pad(gtk, pad_x , pad_y);
}
- (void) setDefaultIpad:(guint) i_pad_x iPadY:(guint) i_pad_y
{
    gtk_packer_set_default_ipad(gtk, i_pad_x , i_pad_y);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkpaned.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKPaned.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKPaned
+ (GtkType) getType
{
    return gtk_paned_get_type();
}
- (void) add1:(GTKWidget *) child
{
    gtk_paned_add1(gtk, child ? child->gtk : 0);
}
- (void) add2:(GTKWidget *) child
{
    gtk_paned_add2(gtk, child ? child->gtk : 0);
}
- (void) pack1:(GTKWidget *) child resize:(gboolean) resize shrink:(gboolean) shrink
{
    gtk_paned_pack1(gtk, child  ? child ->gtk : 0, resize , shrink);
}
- (void) pack2:(GTKWidget *) child resize:(gboolean) resize shrink:(gboolean) shrink
{
    gtk_paned_pack2(gtk, child  ? child ->gtk : 0, resize , shrink);
}
- (void) setPosition:(gint) position
{
    gtk_paned_set_position(gtk, position);
}
- (void) setHandleSize:(guint16) size
{
    gtk_paned_set_handle_size(gtk, size);
}
- (void) setGutterSize:(guint16) size
{
    gtk_paned_set_gutter_size(gtk, size);
}
#define gtk	((GtkPaned *) gtk)
- (id) child1
{
    return GTOOLKIT_OBJECT(gtk->child1);
}
- (id) child2
{
    return GTOOLKIT_OBJECT(gtk->child2);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkpixmap.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKPixmap.h>

@implementation GTKPixmap
+ (GtkType) getType
{
    return gtk_pixmap_get_type();
}
+ (id) pixmapWithPixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    return [[(GTKPixmap *)[self alloc] initWithPixmap:pixmap mask:mask] autorelease];
}
- (id) initWithPixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask
{
    return [self initWithGtk:gtk_pixmap_new( pixmap , mask)];
}
- (void) set:(GdkPixmap *) val mask:(GdkBitmap *) mask
{
    gtk_pixmap_set(gtk, val , mask);
}
- (void) get:(GdkPixmap **) val mask:(GdkBitmap **) mask
{
    gtk_pixmap_get(gtk, val , mask);
}
- (void) setBuildInsensitive:(guint) build
{
    gtk_pixmap_set_build_insensitive(gtk, build);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkplug.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKPlug.h>

@implementation GTKPlug
+ (GtkType) getType
{
    return gtk_plug_get_type();
}
+ (id) plugWithSocketId:(guint32) socket_id
{
    return [[(GTKPlug *)[self alloc] initWithSocketId:socket_id] autorelease];
}
- (id) initWithSocketId:(guint32) socket_id
{
    return [self initWithGtk:gtk_plug_new( socket_id)];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkpreview.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKPreview.h>

@implementation GTKPreview
+ (GtkType) getType
{
    return gtk_preview_get_type();
}
+ (void) uninit
{
    gtk_preview_uninit();
}
+ (id) previewWithType:(GtkPreviewType) type
{
    return [[(GTKPreview *)[self alloc] initWithType:type] autorelease];
}
- (id) initWithType:(GtkPreviewType) type
{
    return [self initWithGtk:gtk_preview_new( type)];
}
- (void) size:(gint) width height:(gint) height
{
    gtk_preview_size(gtk, width , height);
}
- (void) put:(GdkWindow *) window gc:(GdkGC *) gc srcx:(gint) srcx srcy:(gint) srcy destx:(gint) destx desty:(gint) desty width:(gint) width height:(gint) height
{
    gtk_preview_put(gtk, window , gc , srcx , srcy , destx , desty , width , height);
}
- (void) drawRow:(guchar *) data x:(gint) x y:(gint) y w:(gint) w
{
    gtk_preview_draw_row(gtk, data , x , y , w);
}
- (void) setExpand:(gboolean) expand
{
    gtk_preview_set_expand(gtk, expand);
}
+ (void) setGamma:(double) gamma
{
    gtk_preview_set_gamma( gamma);
}
+ (void) setColorCube:(guint) nred_shades ngreenShades:(guint) ngreen_shades nblueShades:(guint) nblue_shades ngrayShades:(guint) ngray_shades
{
    gtk_preview_set_color_cube( nred_shades , ngreen_shades , nblue_shades , ngray_shades);
}
+ (void) setInstallCmap:(gint) install_cmap
{
    gtk_preview_set_install_cmap( install_cmap);
}
+ (void) setReserved:(gint) nreserved
{
    gtk_preview_set_reserved( nreserved);
}
- (void) setDither:(GdkRgbDither) dither
{
    gtk_preview_set_dither(gtk, dither);
}
+ (GdkVisual*) getVisual
{
    return gtk_preview_get_visual();
}
+ (GdkColormap*) getCmap
{
    return gtk_preview_get_cmap();
}
+ (GtkPreviewInfo*) getInfo
{
    return gtk_preview_get_info();
}
+ (void) reset
{
    gtk_preview_reset();
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkprogress.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKProgress.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKProgress
+ (GtkType) getType
{
    return gtk_progress_get_type();
}
- (void) setShowText:(gint) show_text
{
    gtk_progress_set_show_text(gtk, show_text);
}
- (void) setTextAlignment:(gfloat) x_align yAlign:(gfloat) y_align
{
    gtk_progress_set_text_alignment(gtk, x_align , y_align);
}
- (void) setFormatString:(NSString *) format
{
    gtk_progress_set_format_string(gtk,gtoolkit_utf8_string( format));
}
- (void) setAdjustment:(GTKAdjustment *) adjustment
{
    gtk_progress_set_adjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) configure:(gfloat) value min:(gfloat) min max:(gfloat) max
{
    gtk_progress_configure(gtk, value , min , max);
}
- (void) setPercentage:(gfloat) percentage
{
    gtk_progress_set_percentage(gtk, percentage);
}
- (void) setValue:(gfloat) value
{
    gtk_progress_set_value(gtk, value);
}
- (gfloat) getValue
{
    return gtk_progress_get_value(gtk);
}
- (void) setActivityMode:(guint) activity_mode
{
    gtk_progress_set_activity_mode(gtk, activity_mode);
}
- (NSString *) getCurrentText
{
    return gtoolkit_objc_string(gtk_progress_get_current_text(gtk));
}
- (NSString *) getTextFromValue:(gfloat) value
{
    return gtoolkit_objc_string(gtk_progress_get_text_from_value(gtk, value));
}
- (gfloat) getCurrentPercentage
{
    return gtk_progress_get_current_percentage(gtk);
}
- (gfloat) getPercentageFromValue:(gfloat) value
{
    return gtk_progress_get_percentage_from_value(gtk, value);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkprogressbar.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKProgressBar.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKProgressBar
+ (GtkType) getType
{
    return gtk_progress_bar_get_type();
}
+ (id) progressBar
{
    return [[(GTKProgressBar *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_progress_bar_new()];
}
+ (id) progressBarWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKProgressBar *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- (id) initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_progress_bar_new_with_adjustment( adjustment ? adjustment->gtk : 0)];
}
- (void) setBarStyle:(GtkProgressBarStyle) style
{
    gtk_progress_bar_set_bar_style(gtk, style);
}
- (void) setDiscreteBlocks:(guint) blocks
{
    gtk_progress_bar_set_discrete_blocks(gtk, blocks);
}
- (void) setActivityStep:(guint) step
{
    gtk_progress_bar_set_activity_step(gtk, step);
}
- (void) setActivityBlocks:(guint) blocks
{
    gtk_progress_bar_set_activity_blocks(gtk, blocks);
}
- (void) setOrientation:(GtkProgressBarOrientation) orientation
{
    gtk_progress_bar_set_orientation(gtk, orientation);
}
- (void) update:(gfloat) percentage
{
    gtk_progress_bar_update(gtk, percentage);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkradiobutton.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKRadioButton.h>

@implementation GTKRadioButton
+ (GtkType) getType
{
    return gtk_radio_button_get_type();
}
+ (id) radioButtonWithGroup:(GSList *) group
{
    return [[(GTKRadioButton *)[self alloc] initWithGroup:group] autorelease];
}
- (id) initWithGroup:(GSList *) group
{
    return [self initWithGtk:gtk_radio_button_new( group)];
}
+ (id) radioButtonFromWidgetWithGroup:(GTKRadioButton *) group
{
    return [[(GTKRadioButton *)[self alloc] initFromWidgetWithGroup:group] autorelease];
}
- (id) initFromWidgetWithGroup:(GTKRadioButton *) group
{
    return [self initWithGtk:gtk_radio_button_new_from_widget( group ? group->gtk : 0)];
}
+ (id) radioButtonWithLabel:(GSList *) group label:(NSString *) label
{
    return [[(GTKRadioButton *)[self alloc] initWithLabel:group label:label] autorelease];
}
- (id) initWithLabel:(GSList *) group label:(NSString *) label
{
    return [self initWithGtk:gtk_radio_button_new_with_label( group ,gtoolkit_utf8_string( label))];
}
+ (id) radioButtonWithLabelFromWidget:(GTKRadioButton *) group label:(NSString *) label
{
    return [[(GTKRadioButton *)[self alloc] initWithLabelFromWidget:group label:label] autorelease];
}
- (id) initWithLabelFromWidget:(GTKRadioButton *) group label:(NSString *) label
{
    return [self initWithGtk:gtk_radio_button_new_with_label_from_widget( group  ? group ->gtk : 0,gtoolkit_utf8_string( label))];
}
- (GSList*) group
{
    return gtk_radio_button_group(gtk);
}
- (void) setGroup:(GSList *) group
{
    gtk_radio_button_set_group(gtk, group);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkradiomenuitem.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKRadioMenuItem.h>

@implementation GTKRadioMenuItem
+ (GtkType) getType
{
    return gtk_radio_menu_item_get_type();
}
+ (id) radioMenuItemWithGroup:(GSList *) group
{
    return [[(GTKRadioMenuItem *)[self alloc] initWithGroup:group] autorelease];
}
- (id) initWithGroup:(GSList *) group
{
    return [self initWithGtk:gtk_radio_menu_item_new( group)];
}
+ (id) radioMenuItemWithLabel:(GSList *) group label:(NSString *) label
{
    return [[(GTKRadioMenuItem *)[self alloc] initWithLabel:group label:label] autorelease];
}
- (id) initWithLabel:(GSList *) group label:(NSString *) label
{
    return [self initWithGtk:gtk_radio_menu_item_new_with_label( group ,gtoolkit_utf8_string( label))];
}
- (GSList*) group
{
    return gtk_radio_menu_item_group(gtk);
}
- (void) setGroup:(GSList *) group
{
    gtk_radio_menu_item_set_group(gtk, group);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkrange.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKRange.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKRange
+ (GtkType) getType
{
    return gtk_range_get_type();
}
- (GTKAdjustment*) getAdjustment
{
    return gtoolkit_object(gtk_range_get_adjustment(gtk), 0);
}
- (void) setUpdatePolicy:(GtkUpdateType) policy
{
    gtk_range_set_update_policy(gtk, policy);
}
- (void) setAdjustment:(GTKAdjustment *) adjustment
{
    gtk_range_set_adjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) drawBackground
{
    gtk_range_draw_background(gtk);
}
- (void) clearBackground
{
    gtk_range_clear_background(gtk);
}
- (void) drawTrough
{
    gtk_range_draw_trough(gtk);
}
- (void) drawSlider
{
    gtk_range_draw_slider(gtk);
}
- (void) drawStepForw
{
    gtk_range_draw_step_forw(gtk);
}
- (void) drawStepBack
{
    gtk_range_draw_step_back(gtk);
}
- (void) sliderUpdate
{
    gtk_range_slider_update(gtk);
}
- (gint) troughClick:(gint) x y:(gint) y jumpPerc:(gfloat *) jump_perc
{
    return gtk_range_trough_click(gtk, x , y , jump_perc);
}
- (void) defaultHsliderUpdate
{
    gtk_range_default_hslider_update(gtk);
}
- (void) defaultVsliderUpdate
{
    gtk_range_default_vslider_update(gtk);
}
- (gint) defaultHtroughClick:(gint) x y:(gint) y jumpPerc:(gfloat *) jump_perc
{
    return gtk_range_default_htrough_click(gtk, x , y , jump_perc);
}
- (gint) defaultVtroughClick:(gint) x y:(gint) y jumpPerc:(gfloat *) jump_perc
{
    return gtk_range_default_vtrough_click(gtk, x , y , jump_perc);
}
- (void) defaultHmotion:(gint) xdelta ydelta:(gint) ydelta
{
    gtk_range_default_hmotion(gtk, xdelta , ydelta);
}
- (void) defaultVmotion:(gint) xdelta ydelta:(gint) ydelta
{
    gtk_range_default_vmotion(gtk, xdelta , ydelta);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkruler.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKRuler.h>

@implementation GTKRuler
+ (GtkType) getType
{
    return gtk_ruler_get_type();
}
- (void) setMetric:(GtkMetricType) metric
{
    gtk_ruler_set_metric(gtk, metric);
}
- (void) setRange:(gfloat) lower upper:(gfloat) upper position:(gfloat) position maxSize:(gfloat) max_size
{
    gtk_ruler_set_range(gtk, lower , upper , position , max_size);
}
- (void) drawTicks
{
    gtk_ruler_draw_ticks(gtk);
}
- (void) drawPos
{
    gtk_ruler_draw_pos(gtk);
}
#define gtk	((GtkRuler *) gtk)
- (void) setPosition:(gfloat) position
{
    gtk->position = position;
}
- (gfloat) position
{
    return gtk->position;
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkscale.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKScale.h>

@implementation GTKScale
+ (GtkType) getType
{
    return gtk_scale_get_type();
}
- (void) setDigits:(gint) digits
{
    gtk_scale_set_digits(gtk, digits);
}
- (void) setDrawValue:(gboolean) draw_value
{
    gtk_scale_set_draw_value(gtk, draw_value);
}
- (void) setValuePos:(GtkPositionType) pos
{
    gtk_scale_set_value_pos(gtk, pos);
}
- (gint) getValueWidth
{
    return gtk_scale_get_value_width(gtk);
}
- (void) drawValue
{
    gtk_scale_draw_value(gtk);
}
- (void) setDoubleValue:(double) value
{
    GtkAdjustment *adjustment = gtk_range_get_adjustment(gtk);
    gfloat new_value = value;

    if (adjustment->value != new_value)
	gtk_adjustment_set_value(adjustment, new_value);
}

- (double) doubleValue
{
    return gtk_range_get_adjustment(gtk)->value;
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkscrollbar.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKScrollbar.h>

@implementation GTKScrollbar
+ (GtkType) getType
{
    return gtk_scrollbar_get_type();
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkscrolledwindow.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKScrolledWindow.h>
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKScrolledWindow
+ (GtkType) getType
{
    return gtk_scrolled_window_get_type();
}
+ (id) scrolledWindowWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [[(GTKScrolledWindow *)[self alloc] initWithHadjustment:hadjustment vadjustment:vadjustment] autorelease];
}
- (id) initWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [self initWithGtk:gtk_scrolled_window_new( hadjustment  ? hadjustment ->gtk : 0, vadjustment ? vadjustment->gtk : 0)];
}
- (void) setHadjustment:(GTKAdjustment *) hadjustment
{
    gtk_scrolled_window_set_hadjustment(gtk, hadjustment ? hadjustment->gtk : 0);
}
- (void) setVadjustment:(GTKAdjustment *) hadjustment
{
    gtk_scrolled_window_set_vadjustment(gtk, hadjustment ? hadjustment->gtk : 0);
}
- (GTKAdjustment*) getHadjustment
{
    return gtoolkit_object(gtk_scrolled_window_get_hadjustment(gtk), 0);
}
- (GTKAdjustment*) getVadjustment
{
    return gtoolkit_object(gtk_scrolled_window_get_vadjustment(gtk), 0);
}
- (void) setPolicy:(GtkPolicyType) hscrollbar_policy vscrollbarPolicy:(GtkPolicyType) vscrollbar_policy
{
    gtk_scrolled_window_set_policy(gtk, hscrollbar_policy , vscrollbar_policy);
}
- (void) setPlacement:(GtkCornerType) window_placement
{
    gtk_scrolled_window_set_placement(gtk, window_placement);
}
- (void) addWithViewport:(GTKWidget *) child
{
    gtk_scrolled_window_add_with_viewport(gtk, child ? child->gtk : 0);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkseparator.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKSeparator.h>

@implementation GTKSeparator
+ (GtkType) getType
{
    return gtk_separator_get_type();
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtksocket.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKSocket.h>

@implementation GTKSocket
+ (id) socket
{
    return [[(GTKSocket *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_socket_new()];
}
+ (GtkType) getType
{
    return gtk_socket_get_type();
}
- (void) steal:(guint32) wid
{
    gtk_socket_steal(gtk, wid);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkspinbutton.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKSpinButton.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKSpinButton
+ (GtkType) getType
{
    return gtk_spin_button_get_type();
}
- (void) configure:(GTKAdjustment *) adjustment climbRate:(gfloat) climb_rate digits:(guint) digits
{
    gtk_spin_button_configure(gtk, adjustment  ? adjustment ->gtk : 0, climb_rate , digits);
}
+ (id) spinButtonWithAdjustment:(GTKAdjustment *) adjustment climbRate:(gfloat) climb_rate digits:(guint) digits
{
    return [[(GTKSpinButton *)[self alloc] initWithAdjustment:adjustment climbRate:climb_rate digits:digits] autorelease];
}
- (id) initWithAdjustment:(GTKAdjustment *) adjustment climbRate:(gfloat) climb_rate digits:(guint) digits
{
    return [self initWithGtk:gtk_spin_button_new( adjustment  ? adjustment ->gtk : 0, climb_rate , digits)];
}
- (void) setAdjustment:(GTKAdjustment *) adjustment
{
    gtk_spin_button_set_adjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (GTKAdjustment*) getAdjustment
{
    return gtoolkit_object(gtk_spin_button_get_adjustment(gtk), 0);
}
- (void) setDigits:(guint) digits
{
    gtk_spin_button_set_digits(gtk, digits);
}
- (gfloat) getValueAsFloat
{
    return gtk_spin_button_get_value_as_float(gtk);
}
- (gint) getValueAsInt
{
    return gtk_spin_button_get_value_as_int(gtk);
}
- (void) setValue:(gfloat) value
{
    gtk_spin_button_set_value(gtk, value);
}
- (void) setUpdatePolicy:(GtkSpinButtonUpdatePolicy) policy
{
    gtk_spin_button_set_update_policy(gtk, policy);
}
- (void) setNumeric:(gboolean) numeric
{
    gtk_spin_button_set_numeric(gtk, numeric);
}
- (void) spin:(GtkSpinType) direction increment:(gfloat) increment
{
    gtk_spin_button_spin(gtk, direction , increment);
}
- (void) setWrap:(gboolean) wrap
{
    gtk_spin_button_set_wrap(gtk, wrap);
}
- (void) setShadowType:(GtkShadowType) shadow_type
{
    gtk_spin_button_set_shadow_type(gtk, shadow_type);
}
- (void) setSnapToTicks:(gboolean) snap_to_ticks
{
    gtk_spin_button_set_snap_to_ticks(gtk, snap_to_ticks);
}
- (void) update
{
    gtk_spin_button_update(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkstatusbar.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKStatusbar.h>

@implementation GTKStatusbar
+ (GtkType) getType
{
    return gtk_statusbar_get_type();
}
+ (id) statusbar
{
    return [[(GTKStatusbar *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_statusbar_new()];
}
- (guint) getContextId:(NSString *) context_description
{
    return gtk_statusbar_get_context_id(gtk,gtoolkit_utf8_string( context_description));
}
- (guint) push:(guint) context_id text:(NSString *) text
{
    return gtk_statusbar_push(gtk, context_id ,gtoolkit_utf8_string( text));
}
- (void) pop:(guint) context_id
{
    gtk_statusbar_pop(gtk, context_id);
}
- (void) remove:(guint) context_id messageId:(guint) message_id
{
    gtk_statusbar_remove(gtk, context_id , message_id);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkstyle.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKStyle.h>

@implementation GTKStyle
+ (id) style
{
    return [[(GTKStyle *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_style_new()];
}
- (GTKStyle*) copy
{
    return gtoolkit_object(gtk_style_copy(gtk), "GTKStyle");
}
- (GTKStyle*) attach:(GdkWindow *) window
{
    return gtoolkit_object(gtk_style_attach(gtk, window), "GTKStyle");
}
- (void) detach
{
    gtk_style_detach(gtk);
}
- (GTKStyle*) ref
{
    return gtoolkit_object(gtk_style_ref(gtk), "GTKStyle");
}
- (void) unref
{
    gtk_style_unref(gtk);
}
- (void) setBackground:(GdkWindow *) window stateType:(GtkStateType) state_type
{
    gtk_style_set_background(gtk, window , state_type);
}
- (void) applyDefaultBackground:(GdkWindow *) window setBg:(gboolean) set_bg stateType:(GtkStateType) state_type area:(GdkRectangle *) area x:(gint) x y:(gint) y width:(gint) width height:(gint) height
{
    gtk_style_apply_default_background(gtk, window , set_bg , state_type , area , x , y , width , height);
}
#define gtk	((GtkStyle *) gtk)
 - (oneway void) release
{
    unsigned ref_count = gtk ? gtk->ref_count : 1;

#ifdef DEBUG
    if (ref_count == 0) g_error("ref_count == 0 in " __FILE__ " (release)");
#endif
    if (gtk) [self unref];
    if (ref_count == 1) [self dealloc];
}

 - (id) retain
{
    if (gtk) [self ref];
    return self;
}

 - (unsigned) retainCount
{
    return gtk ? gtk->ref_count : 1;
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktable.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKTable.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKTable
+ (GtkType) getType
{
    return gtk_table_get_type();
}
+ (id) tableWithRows:(guint) rows columns:(guint) columns homogeneous:(gboolean) homogeneous
{
    return [[(GTKTable *)[self alloc] initWithRows:rows columns:columns homogeneous:homogeneous] autorelease];
}
- (id) initWithRows:(guint) rows columns:(guint) columns homogeneous:(gboolean) homogeneous
{
    return [self initWithGtk:gtk_table_new( rows , columns , homogeneous)];
}
- (void) resize:(guint) rows columns:(guint) columns
{
    gtk_table_resize(gtk, rows , columns);
}
- (void) attach:(GTKWidget *) child leftAttach:(guint) left_attach rightAttach:(guint) right_attach topAttach:(guint) top_attach bottomAttach:(guint) bottom_attach xoptions:(GtkAttachOptions) xoptions yoptions:(GtkAttachOptions) yoptions xpadding:(guint) xpadding ypadding:(guint) ypadding
{
    gtk_table_attach(gtk, child  ? child ->gtk : 0, left_attach , right_attach , top_attach , bottom_attach , xoptions , yoptions , xpadding , ypadding);
}
- (void) attachDefaults:(GTKWidget *) widget leftAttach:(guint) left_attach rightAttach:(guint) right_attach topAttach:(guint) top_attach bottomAttach:(guint) bottom_attach
{
    gtk_table_attach_defaults(gtk, widget  ? widget ->gtk : 0, left_attach , right_attach , top_attach , bottom_attach);
}
- (void) setRow:(guint) row spacing:(guint) spacing
{
    gtk_table_set_row_spacing(gtk, row , spacing);
}
- (void) setCol:(guint) column spacing:(guint) spacing
{
    gtk_table_set_col_spacing(gtk, column , spacing);
}
- (void) setRowSpacings:(guint) spacing
{
    gtk_table_set_row_spacings(gtk, spacing);
}
- (void) setColSpacings:(guint) spacing
{
    gtk_table_set_col_spacings(gtk, spacing);
}
- (void) setHomogeneous:(gboolean) homogeneous
{
    gtk_table_set_homogeneous(gtk, homogeneous);
}
#define gtk	((GtkTable *) gtk)
- (gint) rows
{
    return gtk->nrows;
}
- (gint) columns
{
    return gtk->ncols;
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktearoffmenuitem.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKTearoffMenuItem.h>

@implementation GTKTearoffMenuItem
+ (GtkType) getType
{
    return gtk_tearoff_menu_item_get_type();
}
+ (id) tearoffMenuItem
{
    return [[(GTKTearoffMenuItem *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_tearoff_menu_item_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktext.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKText.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKText
+ (GtkType) getType
{
    return gtk_text_get_type();
}
+ (id) textWithHadj:(GTKAdjustment *) hadj vadj:(GTKAdjustment *) vadj
{
    return [[(GTKText *)[self alloc] initWithHadj:hadj vadj:vadj] autorelease];
}
- (id) initWithHadj:(GTKAdjustment *) hadj vadj:(GTKAdjustment *) vadj
{
    return [self initWithGtk:gtk_text_new( hadj  ? hadj ->gtk : 0, vadj ? vadj->gtk : 0)];
}
- (void) setEditable:(gboolean) editable
{
    gtk_text_set_editable(gtk, editable);
}
- (void) setWordWrap:(gint) word_wrap
{
    gtk_text_set_word_wrap(gtk, word_wrap);
}
- (void) setLineWrap:(gint) line_wrap
{
    gtk_text_set_line_wrap(gtk, line_wrap);
}
- (void) setAdjustments:(GTKAdjustment *) hadj vadj:(GTKAdjustment *) vadj
{
    gtk_text_set_adjustments(gtk, hadj  ? hadj ->gtk : 0, vadj ? vadj->gtk : 0);
}
- (void) setPoint:(guint) index
{
    gtk_text_set_point(gtk, index);
}
- (guint) getPoint
{
    return gtk_text_get_point(gtk);
}
- (guint) getLength
{
    return gtk_text_get_length(gtk);
}
- (void) freeze
{
    gtk_text_freeze(gtk);
}
- (void) thaw
{
    gtk_text_thaw(gtk);
}
- (void) insert:(GdkFont *) font fore:(GdkColor *) fore back:(GdkColor *) back chars:(NSString *) chars length:(gint) length
{
    gtk_text_insert(gtk, font , fore , back ,gtoolkit_utf8_string( chars ), length);
}
- (gint) backwardDelete:(guint) nchars
{
    return gtk_text_backward_delete(gtk, nchars);
}
- (gint) forwardDelete:(guint) nchars
{
    return gtk_text_forward_delete(gtk, nchars);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktipsquery.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKTipsQuery.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKTipsQuery
+ (GtkType) getType
{
    return gtk_tips_query_get_type();
}
+ (id) tipsQuery
{
    return [[(GTKTipsQuery *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_tips_query_new()];
}
- (void) startQuery
{
    gtk_tips_query_start_query(gtk);
}
- (void) stopQuery
{
    gtk_tips_query_stop_query(gtk);
}
- (void) setCaller:(GTKWidget *) caller
{
    gtk_tips_query_set_caller(gtk, caller ? caller->gtk : 0);
}
- (void) setLabels:(NSString *) label_inactive labelNoTip:(NSString *) label_no_tip
{
    gtk_tips_query_set_labels(gtk,gtoolkit_utf8_string( label_inactive ),gtoolkit_utf8_string( label_no_tip));
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktogglebutton.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKToggleButton.h>

@implementation GTKToggleButton
+ (GtkType) getType
{
    return gtk_toggle_button_get_type();
}
+ (id) toggleButton
{
    return [[(GTKToggleButton *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_toggle_button_new()];
}
+ (id) toggleButtonWithLabel:(NSString *) label
{
    return [[(GTKToggleButton *)[self alloc] initWithLabel:label] autorelease];
}
- (id) initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_toggle_button_new_with_label(gtoolkit_utf8_string( label))];
}
- (void) setMode:(gboolean) draw_indicator
{
    gtk_toggle_button_set_mode(gtk, draw_indicator);
}
- (void) setActive:(gboolean) is_active
{
    gtk_toggle_button_set_active(gtk, is_active);
}
- (gboolean) getActive
{
    return gtk_toggle_button_get_active(gtk);
}
- (void) toggled
{
    gtk_toggle_button_toggled(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktoolbar.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKToolbar.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKToolbar
+ (GtkType) getType
{
    return gtk_toolbar_get_type();
}
+ (id) toolbarWithOrientation:(GtkOrientation) orientation style:(GtkToolbarStyle) style
{
    return [[(GTKToolbar *)[self alloc] initWithOrientation:orientation style:style] autorelease];
}
- (id) initWithOrientation:(GtkOrientation) orientation style:(GtkToolbarStyle) style
{
    return [self initWithGtk:gtk_toolbar_new( orientation , style)];
}
- (GTKWidget*) appendItem:(NSString *) text tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data
{
    return gtoolkit_object(gtk_toolbar_append_item(gtk,gtoolkit_utf8_string( text ),gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text ), icon  ? icon ->gtk : 0, callback , user_data), 0);
}
- (GTKWidget*) prependItem:(NSString *) text tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data
{
    return gtoolkit_object(gtk_toolbar_prepend_item(gtk,gtoolkit_utf8_string( text ),gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text ), icon  ? icon ->gtk : 0, callback , user_data), 0);
}
- (GTKWidget*) insertItem:(NSString *) text tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data position:(gint) position
{
    return gtoolkit_object(gtk_toolbar_insert_item(gtk,gtoolkit_utf8_string( text ),gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text ), icon  ? icon ->gtk : 0, callback , user_data , position), 0);
}
- (void) appendSpace
{
    gtk_toolbar_append_space(gtk);
}
- (void) prependSpace
{
    gtk_toolbar_prepend_space(gtk);
}
- (void) insertSpace:(gint) position
{
    gtk_toolbar_insert_space(gtk, position);
}
- (GTKWidget*) appendElement:(GtkToolbarChildType) type widget:(GTKWidget *) widget text:(NSString *) text tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data
{
    return gtoolkit_object(gtk_toolbar_append_element(gtk, type , widget  ? widget ->gtk : 0,gtoolkit_utf8_string( text ),gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text ), icon  ? icon ->gtk : 0, callback , user_data), 0);
}
- (GTKWidget*) prependElement:(GtkToolbarChildType) type widget:(GTKWidget *) widget text:(NSString *) text tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data
{
    return gtoolkit_object(gtk_toolbar_prepend_element(gtk, type , widget  ? widget ->gtk : 0,gtoolkit_utf8_string( text ),gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text ), icon  ? icon ->gtk : 0, callback , user_data), 0);
}
- (GTKWidget*) insertElement:(GtkToolbarChildType) type widget:(GTKWidget *) widget text:(NSString *) text tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text icon:(GTKWidget *) icon callback:(GtkSignalFunc) callback userData:(gpointer) user_data position:(gint) position
{
    return gtoolkit_object(gtk_toolbar_insert_element(gtk, type , widget  ? widget ->gtk : 0,gtoolkit_utf8_string( text ),gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text ), icon  ? icon ->gtk : 0, callback , user_data , position), 0);
}
- (void) appendWidget:(GTKWidget *) widget tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text
{
    gtk_toolbar_append_widget(gtk, widget  ? widget ->gtk : 0,gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text));
}
- (void) prependWidget:(GTKWidget *) widget tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text
{
    gtk_toolbar_prepend_widget(gtk, widget  ? widget ->gtk : 0,gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text));
}
- (void) insertWidget:(GTKWidget *) widget tooltipText:(NSString *) tooltip_text tooltipPrivateText:(NSString *) tooltip_private_text position:(gint) position
{
    gtk_toolbar_insert_widget(gtk, widget  ? widget ->gtk : 0,gtoolkit_utf8_string( tooltip_text ),gtoolkit_utf8_string( tooltip_private_text ), position);
}
- (void) setOrientation:(GtkOrientation) orientation
{
    gtk_toolbar_set_orientation(gtk, orientation);
}
- (void) setStyle:(GtkToolbarStyle) style
{
    gtk_toolbar_set_style(gtk, style);
}
- (void) setSpaceSize:(gint) space_size
{
    gtk_toolbar_set_space_size(gtk, space_size);
}
- (void) setSpaceStyle:(GtkToolbarSpaceStyle) space_style
{
    gtk_toolbar_set_space_style(gtk, space_style);
}
- (void) setTooltips:(gint) enable
{
    gtk_toolbar_set_tooltips(gtk, enable);
}
- (void) setButtonRelief:(GtkReliefStyle) relief
{
    gtk_toolbar_set_button_relief(gtk, relief);
}
- (GtkReliefStyle) getButtonRelief
{
    return gtk_toolbar_get_button_relief(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktooltips.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKTooltips.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKTooltips
+ (GtkType) getType
{
    return gtk_tooltips_get_type();
}
+ (id) tooltips
{
    return [[(GTKTooltips *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_tooltips_new()];
}
- (void) enable
{
    gtk_tooltips_enable(gtk);
}
- (void) disable
{
    gtk_tooltips_disable(gtk);
}
- (void) setDelay:(guint) delay
{
    gtk_tooltips_set_delay(gtk, delay);
}
- (void) setTip:(GTKWidget *) widget tipText:(NSString *) tip_text tipPrivate:(NSString *) tip_private
{
    gtk_tooltips_set_tip(gtk, widget  ? widget ->gtk : 0,gtoolkit_utf8_string( tip_text ),gtoolkit_utf8_string( tip_private));
}
- (void) setColors:(GdkColor *) background foreground:(GdkColor *) foreground
{
    gtk_tooltips_set_colors(gtk, background , foreground);
}
+ (GtkTooltipsData*) dataGet:(GTKWidget *) widget
{
    return gtk_tooltips_data_get( widget ? widget->gtk : 0);
}
- (void) forceWindow
{
    gtk_tooltips_force_window(gtk);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktree.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKTree.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKTree
+ (GtkType) getType
{
    return gtk_tree_get_type();
}
+ (id) tree
{
    return [[(GTKTree *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_tree_new()];
}
- (void) append:(GTKWidget *) tree_item
{
    gtk_tree_append(gtk, tree_item ? tree_item->gtk : 0);
}
- (void) prepend:(GTKWidget *) tree_item
{
    gtk_tree_prepend(gtk, tree_item ? tree_item->gtk : 0);
}
- (void) insert:(GTKWidget *) tree_item position:(gint) position
{
    gtk_tree_insert(gtk, tree_item  ? tree_item ->gtk : 0, position);
}
- (void) removeItems:(NSArray *) items
{
    gtk_tree_remove_items(gtk,gtoolkit_array_to_list( items));
}
- (void) clearItems:(gint) start end:(gint) end
{
    gtk_tree_clear_items(gtk, start , end);
}
- (void) selectItem:(gint) item
{
    gtk_tree_select_item(gtk, item);
}
- (void) unselectItem:(gint) item
{
    gtk_tree_unselect_item(gtk, item);
}
- (void) selectChild:(GTKWidget *) tree_item
{
    gtk_tree_select_child(gtk, tree_item ? tree_item->gtk : 0);
}
- (void) unselectChild:(GTKWidget *) tree_item
{
    gtk_tree_unselect_child(gtk, tree_item ? tree_item->gtk : 0);
}
- (gint) childPosition:(GTKWidget *) child
{
    return gtk_tree_child_position(gtk, child ? child->gtk : 0);
}
- (void) setSelectionMode:(GtkSelectionMode) mode
{
    gtk_tree_set_selection_mode(gtk, mode);
}
- (void) setViewMode:(GtkTreeViewMode) mode
{
    gtk_tree_set_view_mode(gtk, mode);
}
- (void) setViewLines:(guint) flag
{
    gtk_tree_set_view_lines(gtk, flag);
}
#define gtk	((GtkTree *) gtk)
- (NSArray *) selection
{
    return gtoolkit_list_to_array(gtk->selection);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtktreeitem.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKTreeItem.h>
#include <GToolKit/GTKWidget.h>

@implementation GTKTreeItem
+ (GtkType) getType
{
    return gtk_tree_item_get_type();
}
+ (id) treeItem
{
    return [[(GTKTreeItem *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_tree_item_new()];
}
+ (id) treeItemWithLabel:(NSString *) label
{
    return [[(GTKTreeItem *)[self alloc] initWithLabel:label] autorelease];
}
- (id) initWithLabel:(NSString *) label
{
    return [self initWithGtk:gtk_tree_item_new_with_label(gtoolkit_utf8_string( label))];
}
- (void) setSubtree:(GTKWidget *) subtree
{
    gtk_tree_item_set_subtree(gtk, subtree ? subtree->gtk : 0);
}
- (void) removeSubtree
{
    gtk_tree_item_remove_subtree(gtk);
}
- (void) select
{
    gtk_tree_item_select(gtk);
}
- (void) deselect
{
    gtk_tree_item_deselect(gtk);
}
- (void) expand
{
    gtk_tree_item_expand(gtk);
}
- (void) collapse
{
    gtk_tree_item_collapse(gtk);
}
#define gtk	((GtkTreeItem *) gtk)
- (GTKWidget *) subtree
{
    return GTOOLKIT_OBJECT(gtk->subtree);
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkvbbox.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKVButtonBox.h>

@implementation GTKVButtonBox
+ (GtkType) getType
{
    return gtk_vbutton_box_get_type();
}
+ (id) vButtonBox
{
    return [[(GTKVButtonBox *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_vbutton_box_new()];
}
+ (gint) getSpacingDefault
{
    return gtk_vbutton_box_get_spacing_default();
}
+ (void) setSpacingDefault:(gint) spacing
{
    gtk_vbutton_box_set_spacing_default( spacing);
}
+ (GtkButtonBoxStyle) getLayoutDefault
{
    return gtk_vbutton_box_get_layout_default();
}
+ (void) setLayoutDefault:(GtkButtonBoxStyle) layout
{
    gtk_vbutton_box_set_layout_default( layout);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkvbox.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKVBox.h>

@implementation GTKVBox
+ (GtkType) getType
{
    return gtk_vbox_get_type();
}
+ (id) vBoxWithHomogeneous:(gboolean) homogeneous spacing:(gint) spacing
{
    return [[(GTKVBox *)[self alloc] initWithHomogeneous:homogeneous spacing:spacing] autorelease];
}
- (id) initWithHomogeneous:(gboolean) homogeneous spacing:(gint) spacing
{
    return [self initWithGtk:gtk_vbox_new( homogeneous , spacing)];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkviewport.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKViewport.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKViewport
+ (GtkType) getType
{
    return gtk_viewport_get_type();
}
+ (id) viewportWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [[(GTKViewport *)[self alloc] initWithHadjustment:hadjustment vadjustment:vadjustment] autorelease];
}
- (id) initWithHadjustment:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return [self initWithGtk:gtk_viewport_new( hadjustment  ? hadjustment ->gtk : 0, vadjustment ? vadjustment->gtk : 0)];
}
- (GTKAdjustment*) getHadjustment
{
    return gtoolkit_object(gtk_viewport_get_hadjustment(gtk), 0);
}
- (GTKAdjustment*) getVadjustment
{
    return gtoolkit_object(gtk_viewport_get_vadjustment(gtk), 0);
}
- (void) setHadjustment:(GTKAdjustment *) adjustment
{
    gtk_viewport_set_hadjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) setVadjustment:(GTKAdjustment *) adjustment
{
    gtk_viewport_set_vadjustment(gtk, adjustment ? adjustment->gtk : 0);
}
- (void) setShadowType:(GtkShadowType) type
{
    gtk_viewport_set_shadow_type(gtk, type);
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkvpaned.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKVPaned.h>

@implementation GTKVPaned
+ (GtkType) getType
{
    return gtk_vpaned_get_type();
}
+ (id) vPaned
{
    return [[(GTKVPaned *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_vpaned_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkvruler.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKVRuler.h>

@implementation GTKVRuler
+ (GtkType) getType
{
    return gtk_vruler_get_type();
}
+ (id) vRuler
{
    return [[(GTKVRuler *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_vruler_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkvscale.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKVScale.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKVScale
+ (GtkType) getType
{
    return gtk_vscale_get_type();
}
+ (id) vScaleWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKVScale *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- (id) initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_vscale_new( adjustment ? adjustment->gtk : 0)];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkvscrollbar.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKVScrollbar.h>
#include <GToolKit/GTKAdjustment.h>

@implementation GTKVScrollbar
+ (GtkType) getType
{
    return gtk_vscrollbar_get_type();
}
+ (id) vScrollbarWithAdjustment:(GTKAdjustment *) adjustment
{
    return [[(GTKVScrollbar *)[self alloc] initWithAdjustment:adjustment] autorelease];
}
- (id) initWithAdjustment:(GTKAdjustment *) adjustment
{
    return [self initWithGtk:gtk_vscrollbar_new( adjustment ? adjustment->gtk : 0)];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkvseparator.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKVSeparator.h>

@implementation GTKVSeparator
+ (GtkType) getType
{
    return gtk_vseparator_get_type();
}
+ (id) vSeparator
{
    return [[(GTKVSeparator *)[self alloc] init] autorelease];
}
- (id) init
{
    return [self initWithGtk:gtk_vseparator_new()];
}
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkwidget.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKAccelGroup.h>
#include <GToolKit/GTKAdjustment.h>
#include <GToolKit/GTKStyle.h>

@implementation GTKWidget
+ (GtkType) getType
{
    return gtk_widget_get_type();
}
+ (id) widgetvWithType:(GtkType) type nArgs:(guint) nargs args:(GtkArg *) args
{
    return [[(GTKWidget *)[self alloc] initvWithType:type nArgs:nargs args:args] autorelease];
}
- (id) initvWithType:(GtkType) type nArgs:(guint) nargs args:(GtkArg *) args
{
    return [self initWithGtk:gtk_widget_newv( type , nargs , args)];
}
- (void) ref
{
    gtk_widget_ref(gtk);
}
- (void) unref
{
    gtk_widget_unref(gtk);
}
- (void) destroy
{
    gtk_widget_destroy(gtk);
}
- (void) destroyed:(GTKWidget **) widget_pointer
{
    GtkWidget *_outval_1;
    gtk_widget_destroyed(gtk,&_outval_1);
    * widget_pointer = gtoolkit_object(_outval_1, 0);
}
- (void) get:(GtkArg *) arg
{
    gtk_widget_get(gtk, arg);
}
- (void) getv:(guint) nargs args:(GtkArg *) args
{
    gtk_widget_getv(gtk, nargs , args);
}
- (void) setv:(guint) nargs args:(GtkArg *) args
{
    gtk_widget_setv(gtk, nargs , args);
}
- (void) unparent
{
    gtk_widget_unparent(gtk);
}
- (void) show
{
    gtk_widget_show(gtk);
}
- (void) showNow
{
    gtk_widget_show_now(gtk);
}
- (void) hide
{
    gtk_widget_hide(gtk);
}
- (void) showAll
{
    gtk_widget_show_all(gtk);
}
- (void) hideAll
{
    gtk_widget_hide_all(gtk);
}
- (void) map
{
    gtk_widget_map(gtk);
}
- (void) unmap
{
    gtk_widget_unmap(gtk);
}
- (void) realize
{
    gtk_widget_realize(gtk);
}
- (void) unrealize
{
    gtk_widget_unrealize(gtk);
}
- (void) queueDraw
{
    gtk_widget_queue_draw(gtk);
}
- (void) queueDrawArea:(gint) x y:(gint) y width:(gint) width height:(gint) height
{
    gtk_widget_queue_draw_area(gtk, x , y , width , height);
}
- (void) queueClear
{
    gtk_widget_queue_clear(gtk);
}
- (void) queueClearArea:(gint) x y:(gint) y width:(gint) width height:(gint) height
{
    gtk_widget_queue_clear_area(gtk, x , y , width , height);
}
- (void) queueResize
{
    gtk_widget_queue_resize(gtk);
}
- (void) draw:(GdkRectangle *) area
{
    gtk_widget_draw(gtk, area);
}
- (void) drawFocus
{
    gtk_widget_draw_focus(gtk);
}
- (void) drawDefault
{
    gtk_widget_draw_default(gtk);
}
- (void) sizeRequest:(GtkRequisition *) requisition
{
    gtk_widget_size_request(gtk, requisition);
}
- (void) sizeAllocate:(GtkAllocation *) allocation
{
    gtk_widget_size_allocate(gtk, allocation);
}
- (void) getChildRequisition:(GtkRequisition *) requisition
{
    gtk_widget_get_child_requisition(gtk, requisition);
}
- (void) addAccelerator:(NSString *) accel_signal accelGroup:(GTKAccelGroup *) accel_group accelKey:(guint) accel_key accelMods:(guint) accel_mods accelFlags:(GtkAccelFlags) accel_flags
{
    gtk_widget_add_accelerator(gtk,gtoolkit_utf8_string( accel_signal ), accel_group  ? accel_group ->gtk : 0, accel_key , accel_mods , accel_flags);
}
- (void) removeAccelerator:(GTKAccelGroup *) accel_group accelKey:(guint) accel_key accelMods:(guint) accel_mods
{
    gtk_widget_remove_accelerator(gtk, accel_group  ? accel_group ->gtk : 0, accel_key , accel_mods);
}
- (void) removeAccelerators:(NSString *) accel_signal visibleOnly:(gboolean) visible_only
{
    gtk_widget_remove_accelerators(gtk,gtoolkit_utf8_string( accel_signal ), visible_only);
}
- (guint) acceleratorSignal:(GTKAccelGroup *) accel_group accelKey:(guint) accel_key accelMods:(guint) accel_mods
{
    return gtk_widget_accelerator_signal(gtk, accel_group  ? accel_group ->gtk : 0, accel_key , accel_mods);
}
- (void) lockAccelerators
{
    gtk_widget_lock_accelerators(gtk);
}
- (void) unlockAccelerators
{
    gtk_widget_unlock_accelerators(gtk);
}
- (gboolean) acceleratorsLocked
{
    return gtk_widget_accelerators_locked(gtk);
}
- (gint) event:(GdkEvent *) event
{
    return gtk_widget_event(gtk, event);
}
- (gboolean) activate
{
    return gtk_widget_activate(gtk);
}
- (gboolean) setScrollAdjustments:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment
{
    return gtk_widget_set_scroll_adjustments(gtk, hadjustment  ? hadjustment ->gtk : 0, vadjustment ? vadjustment->gtk : 0);
}
- (void) reparent:(GTKWidget *) new_parent
{
    gtk_widget_reparent(gtk, new_parent ? new_parent->gtk : 0);
}
- (void) popup:(gint) x y:(gint) y
{
    gtk_widget_popup(gtk, x , y);
}
- (gint) intersect:(GdkRectangle *) area intersection:(GdkRectangle *) intersection
{
    return gtk_widget_intersect(gtk, area , intersection);
}
- (void) grabFocus
{
    gtk_widget_grab_focus(gtk);
}
- (void) grabDefault
{
    gtk_widget_grab_default(gtk);
}
- (void) setName:(NSString *) name
{
    gtk_widget_set_name(gtk,gtoolkit_utf8_string( name));
}
- (NSString *) getName
{
    return gtoolkit_objc_string(gtk_widget_get_name(gtk));
}
- (void) setState:(GtkStateType) state
{
    gtk_widget_set_state(gtk, state);
}
- (void) setSensitive:(gboolean) sensitive
{
    gtk_widget_set_sensitive(gtk, sensitive);
}
- (void) setAppPaintable:(gboolean) app_paintable
{
    gtk_widget_set_app_paintable(gtk, app_paintable);
}
- (void) setParent:(GTKWidget *) parent
{
    gtk_widget_set_parent(gtk, parent ? parent->gtk : 0);
}
- (void) setParentWindow:(GdkWindow *) parent_window
{
    gtk_widget_set_parent_window(gtk, parent_window);
}
- (GdkWindow *) getParentWindow
{
    return gtk_widget_get_parent_window(gtk);
}
- (void) setUposition:(gint) x y:(gint) y
{
    gtk_widget_set_uposition(gtk, x , y);
}
- (void) setUsize:(gint) width height:(gint) height
{
    gtk_widget_set_usize(gtk, width , height);
}
- (void) setEvents:(gint) events
{
    gtk_widget_set_events(gtk, events);
}
- (void) addEvents:(gint) events
{
    gtk_widget_add_events(gtk, events);
}
- (void) setExtensionEvents:(GdkExtensionMode) mode
{
    gtk_widget_set_extension_events(gtk, mode);
}
- (GdkExtensionMode) getExtensionEvents
{
    return gtk_widget_get_extension_events(gtk);
}
- (GTKWidget*) getToplevel
{
    return gtoolkit_object(gtk_widget_get_toplevel(gtk), 0);
}
- (GTKWidget*) getAncestor:(GtkType) widget_type
{
    return gtoolkit_object(gtk_widget_get_ancestor(gtk, widget_type), 0);
}
- (GdkColormap*) getColormap
{
    return gtk_widget_get_colormap(gtk);
}
- (GdkVisual*) getVisual
{
    return gtk_widget_get_visual(gtk);
}
- (void) setColormap:(GdkColormap *) colormap
{
    gtk_widget_set_colormap(gtk, colormap);
}
- (void) setVisual:(GdkVisual *) visual
{
    gtk_widget_set_visual(gtk, visual);
}
- (gint) getEvents
{
    return gtk_widget_get_events(gtk);
}
- (void) getPointer:(gint *) x y:(gint *) y
{
    gtk_widget_get_pointer(gtk, x , y);
}
- (gint) isAncestor:(GTKWidget *) ancestor
{
    return gtk_widget_is_ancestor(gtk, ancestor ? ancestor->gtk : 0);
}
- (gint) hideOnDelete
{
    return gtk_widget_hide_on_delete(gtk);
}
- (void) setStyle:(GTKStyle *) style
{
    gtk_widget_set_style(gtk, style ? style->gtk : 0);
}
- (void) setRcStyle
{
    gtk_widget_set_rc_style(gtk);
}
- (void) ensureStyle
{
    gtk_widget_ensure_style(gtk);
}
- (GTKStyle*) getStyle
{
    return gtoolkit_object(gtk_widget_get_style(gtk), "GTKStyle");
}
- (void) restoreDefaultStyle
{
    gtk_widget_restore_default_style(gtk);
}
- (void) modifyStyle:(GtkRcStyle *) style
{
    gtk_widget_modify_style(gtk, style);
}
- (void) setCompositeName:(NSString *) name
{
    gtk_widget_set_composite_name(gtk,gtoolkit_utf8_string( name));
}
- (NSString *) getCompositeName
{
    return gtoolkit_objc_string(gtk_widget_get_composite_name(gtk));
}
- (void) resetRcStyles
{
    gtk_widget_reset_rc_styles(gtk);
}
+ (void) pushStyle:(GTKStyle *) style
{
    gtk_widget_push_style( style ? style->gtk : 0);
}
+ (void) pushColormap:(GdkColormap *) cmap
{
    gtk_widget_push_colormap( cmap);
}
+ (void) pushVisual:(GdkVisual *) visual
{
    gtk_widget_push_visual( visual);
}
+ (void) pushCompositeChild
{
    gtk_widget_push_composite_child();
}
+ (void) popCompositeChild
{
    gtk_widget_pop_composite_child();
}
+ (void) popStyle
{
    gtk_widget_pop_style();
}
+ (void) popColormap
{
    gtk_widget_pop_colormap();
}
+ (void) popVisual
{
    gtk_widget_pop_visual();
}
+ (void) setDefaultStyle:(GTKStyle *) style
{
    gtk_widget_set_default_style( style ? style->gtk : 0);
}
+ (void) setDefaultColormap:(GdkColormap *) colormap
{
    gtk_widget_set_default_colormap( colormap);
}
+ (void) setDefaultVisual:(GdkVisual *) visual
{
    gtk_widget_set_default_visual( visual);
}
+ (GTKStyle*) getDefaultStyle
{
    return gtoolkit_object(gtk_widget_get_default_style(), "GTKStyle");
}
+ (GdkColormap*) getDefaultColormap
{
    return gtk_widget_get_default_colormap();
}
+ (GdkVisual*) getDefaultVisual
{
    return gtk_widget_get_default_visual();
}
- (void) shapeCombineMask:(GdkBitmap *) shape_mask offsetX:(gint) offset_x offsetY:(gint) offset_y
{
    gtk_widget_shape_combine_mask(gtk, shape_mask , offset_x , offset_y);
}
- (void) path:(guint *) path_length path:(NSString **) path pathReversed:(NSString **) path_reversed
{
    char *_outval_2;
    char *_outval_1;
    gtk_widget_path(gtk, path_length ,&_outval_1,&_outval_2);
    * path  = gtoolkit_objc_string(_outval_1);
    * path_reversed = gtoolkit_objc_string(_outval_2);
}
- (void) classPath:(guint *) path_length path:(NSString **) path pathReversed:(NSString **) path_reversed
{
    char *_outval_2;
    char *_outval_1;
    gtk_widget_class_path(gtk, path_length ,&_outval_1,&_outval_2);
    * path  = gtoolkit_objc_string(_outval_1);
    * path_reversed = gtoolkit_objc_string(_outval_2);
}
#define gtk	((GtkWidget *) gtk)
- (GTKWidget *) getParent
{
    return GTOOLKIT_OBJECT(gtk->parent);
}
- (GdkWindow *) getWindow
{
    return gtk->window;
}
#undef gtk
@end
/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkwindow.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#include <GToolKit/GTKWindow.h>
#include <GToolKit/GTKWidget.h>
#include <GToolKit/GTKAccelGroup.h>

@implementation GTKWindow
+ (GtkType) getType
{
    return gtk_window_get_type();
}
+ (id) windowWithType:(GtkWindowType) type
{
    return [[(GTKWindow *)[self alloc] initWithType:type] autorelease];
}
- (id) initWithType:(GtkWindowType) type
{
    return [self initWithGtk:gtk_window_new( type)];
}
- (void) setTitle:(NSString *) title
{
    gtk_window_set_title(gtk,gtoolkit_utf8_string( title));
}
- (void) setWmclass:(NSString *) wmclass_name wmclassClass:(NSString *) wmclass_class
{
    gtk_window_set_wmclass(gtk,gtoolkit_utf8_string( wmclass_name ),gtoolkit_utf8_string( wmclass_class));
}
- (void) setPolicy:(gint) allow_shrink allowGrow:(gint) allow_grow autoShrink:(gint) auto_shrink
{
    gtk_window_set_policy(gtk, allow_shrink , allow_grow , auto_shrink);
}
- (void) addAccelGroup:(GTKAccelGroup *) accel_group
{
    gtk_window_add_accel_group(gtk, accel_group ? accel_group->gtk : 0);
}
- (void) removeAccelGroup:(GTKAccelGroup *) accel_group
{
    gtk_window_remove_accel_group(gtk, accel_group ? accel_group->gtk : 0);
}
- (void) setPosition:(GtkWindowPosition) position
{
    gtk_window_set_position(gtk, position);
}
- (gint) activateFocus
{
    return gtk_window_activate_focus(gtk);
}
- (gint) activateDefault
{
    return gtk_window_activate_default(gtk);
}
- (void) setTransientFor:(GTKWindow *) parent
{
    gtk_window_set_transient_for(gtk, parent ? parent->gtk : 0);
}
- (void) setGeometryHints:(GTKWidget *) geometry_widget geometry:(GdkGeometry *) geometry geomMask:(GdkWindowHints) geom_mask
{
    gtk_window_set_geometry_hints(gtk, geometry_widget  ? geometry_widget ->gtk : 0, geometry , geom_mask);
}
- (void) setDefaultSize:(gint) width height:(gint) height
{
    gtk_window_set_default_size(gtk, width , height);
}
- (void) setModal:(gboolean) modal
{
    gtk_window_set_modal(gtk, modal);
}
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSNotification.h>


NSString *GTKWindowDidBecomeMainNotification = @"GTKWindowDidBecomeMain";
NSString *GTKWindowDidResignMainNotification = @"GTKWindowDidResignMain";
NSString *GTKWindowWillCloseNotification = @"GTKWindowWillClose";
NSString *GTKWindowWillOpenNotification = @"GTKWindowWillOpen";

static gint focus_in_window (GtkWidget *win, GdkEvent *event, GTKWindow *self)
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];

    [[NSNotificationCenter defaultCenter] postNotificationName:
	GTKWindowDidBecomeMainNotification object:self];
    [pool release];
    return NO;
}

static gint focus_out_window (GtkWidget *win, GdkEvent *event, GTKWindow *self)
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];

    [[NSNotificationCenter defaultCenter] postNotificationName:
	GTKWindowDidResignMainNotification object:self];
    [pool release];
    return NO;
}

static gint delete_window (GtkWidget *win, GdkEvent *event, GTKWindow *self)
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    id delegate = [self delegate];
    gint result = NO;

    if ([delegate respondsToSelector:@selector(windowShouldClose:)] &&
	[delegate windowShouldClose:self] == NO) result = YES;
    [pool release];
    return result;
}

static void destroy_window (GtkWidget *win, GTKWindow *self)
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];

    [[NSNotificationCenter defaultCenter] postNotificationName:
	GTKWindowWillCloseNotification object:self];
    [pool release];
}

 - (id) initWithGtk:(gpointer) _gtk
{
    [super initWithGtk:_gtk];

    gtk_signal_connect(_gtk, "focus_in_event",
			(GtkSignalFunc) focus_in_window, self);
    gtk_signal_connect(_gtk, "focus_out_event",
			(GtkSignalFunc) focus_out_window, self);
    gtk_signal_connect(_gtk, "destroy", (GtkSignalFunc) destroy_window, self);

    [[NSNotificationCenter defaultCenter] postNotificationName:
	GTKWindowWillOpenNotification object:self];

    [self ref];		// first reference is missing (due to floating flag)
    return  self;	// avoid bug in objcdoc
}

/*
 * Set the delegate object of this window or unset it (if /delegate/
 * is |nil|). If the delegate implements some of the methods described
 * in the protocol @proto(GTKWindowDelegate), it will be notified by
 * the window on the corresponding events.
 */
- (void) setDelegate:(id) object
{
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];

    if (delegate) [center removeObserver:delegate name:nil object:self];
    delegate = object;

    if ([object respondsToSelector:@selector(windowDidBecomeMain:)])
	[center addObserver:object selector:@selector(windowDidBecomeMain:)
		name:GTKWindowDidBecomeMainNotification object:self];
    if ([object respondsToSelector:@selector(windowDidResignMain:)])
	[center addObserver:object selector:@selector(windowDidResignMain:)
		name:GTKWindowDidResignMainNotification object:self];
    if ([object respondsToSelector:@selector(windowWillClose:)])
	[center addObserver:object selector:@selector(windowWillClose:)
		name:GTKWindowWillCloseNotification object:self];

    if (handler_id == 0 &&
	[object respondsToSelector:@selector(windowShouldClose:)])
	handler_id = gtk_signal_connect(gtk, "delete_event",
					(GtkSignalFunc) delete_window, self);
}

/*
 * Return this window's delegate object.
 */
- (id) delegate
{
    return delegate;
}

/*
 * Send a /delete_event/ signal to this window, i.e. act as if the user
 * had closed the receiver via the window manager. The /sender/ parameter
 * is ignored.<p>
 * If the delegate implements the method:
 * <pre>
 * - (BOOL) windowShouldClose:(GTKWindow *) sender</pre>
 *
 * this message is sent to the delegate to determine whether the window
 * should actually be closed. If it returns |YES|, this method will post
 * the GTKWindowWillCloseNotification to the default notification center
 * and close the window.
 * @see -destroy
 */
- (void) performClose:(id) sender
{
    GdkEvent event = { GDK_DELETE };
    gint result;

    event.any.window = ((GtkWidget *) gtk)->window;
    gtk_signal_emit_by_name(gtk, "delete_event", &event, &result);
}

#define gtk	((GtkWindow *) gtk)
- (NSString *) title
{
    return gtoolkit_objc_string(gtk->title);
}
- (GTKWidget *) focusWidget
{
    return GTOOLKIT_OBJECT(gtk->focus_widget);
}
- (GTKWidget *) defaultWidget
{
    return GTOOLKIT_OBJECT(gtk->default_widget);
}
#undef gtk
@end
