
/*
   Support for X resource database management.

   fotang@yahoo.com, 15Apr99.
 */

#include <ctype.h>              /* isspace, toupper */
#include <string.h>             /* memcpy */
#include <sys/param.h>          /* MAXPATHLEN */
#include <sys/types.h>          /* size_t */
#include <stdio.h>              /* sprintf, fprintf */
#include <stdlib.h>             /* getenv */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/X.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#include "gtkxrm.h"

/* defined by gtk/gdk */
extern Display *gdk_display;
extern char *g_get_prgname();

/*
   App_class_name2:
   This is the application class name as used in system X resource files.
   It is usually the application name with the first character capitalized.
   We are given the name in the call to gtk_initialize.
   App_class_name2 is set to NULL if it happens to be the same as the
   program name.
 */
static char *App_class_name2;
static XrmDatabase app_res_db;

int gtk_initialize(int *argc,
                   char **argv,
                   const char *app_class_name,
                   GTK_CMD_OPT * cmd_opt,
                   size_t cmd_opt_count)
{
/*
   Construct database and parse command line options
 */
  XrmDatabase res_db = (XrmDatabase) 0;
  char bar[MAXPATHLEN];
  char *str;
  Atom atom;
  char found = 0;
  char *cl_name;

  XrmInitialize();
  app_res_db = (XrmDatabase) 0;

  cl_name = g_strdup(app_class_name);
  if (*cl_name)
  {
    char *p = cl_name;

    while (isspace(*p))         /* remove leading blanks */
      p++;
    if (p != cl_name)
    {                           /* overwrite leading blanks */
      memmove(cl_name, p, strlen(p) + 1);
      p = cl_name;
    }
    while (*p && !isspace(*p))  /* remove terminating blanks */
      p++;
    *p = 0;
  }
  if (*cl_name == 0)
  {
    g_free(cl_name);
    cl_name = g_strdup(g_get_prgname());
    if (*cl_name == 'x')        /* xdemo --> Xdemo */
      *cl_name = 'X';
    /* Xdemo --> XDemo
       demo  --> Demo
     */
    if (*cl_name == 'X')
    {
      if (*(cl_name + 1))
        *(cl_name + 1) = toupper(*(cl_name + 1));
    }
    else
      *cl_name = toupper(*cl_name);
  }
  if (!strcmp(g_get_prgname(), cl_name))
    App_class_name2 = NULL;
  else
    App_class_name2 = g_strdup(cl_name);
  sprintf(bar, "/usr/X11/lib/X11/app-defaults/%s", cl_name);
#if DEBUG_XRM
  fprintf(stderr, "Trying system default '%s'", bar);
#endif
  app_res_db = XrmGetFileDatabase(bar);
#if DEBUG_XRM
  fprintf(stderr, ". %s\n", app_res_db ? "ok" : "failed");
  fprintf(stderr, "Trying $XAPPLRESDIR");
#endif
  str = getenv("XAPPLRESDIR");
  if (str)
  {
    sprintf(bar, "%s/%s", str, cl_name);
    res_db = XrmGetFileDatabase(bar);
#if DEBUG_XRM
    fprintf(stderr, " '%s'. %s\n", bar, res_db ? "ok" : "failed");
#endif
    if (res_db)
      XrmMergeDatabases(res_db, &app_res_db);
  }
#if DEBUG_XRM
  else
    fprintf(stderr, "\n");
  fprintf(stderr, "Trying RESOURCE_MANAGER");
#endif
  atom = XInternAtom(gdk_display, "RESOURCE_MANAGER", True);
  if (atom != None)
  {                             /* what about BadAlloc and BadValue ? */
    unsigned char *buf = 0;
    Atom actual_type = None;
    int actual_fmt;
    unsigned long nitems_returned,
         nbytes_left;
    Status result;

    result = XGetWindowProperty(gdk_display,
                                RootWindow(gdk_display, 0),
                                atom,
                                0L, 1L,	   /* 32-bit segments */
                                False, XA_STRING,
                                &actual_type,
                                &actual_fmt,
                                &nitems_returned,	   /* 8-bit items */
                                &nbytes_left,	   /* byte count */
                                &buf);
    if (result == Success && actual_type == XA_STRING && actual_fmt == 8)
    {
      if (buf)
        XFree(buf);
      result = XGetWindowProperty(gdk_display,
                                  RootWindow(gdk_display, 0),
                                  atom, 0L,
                               (long) ((nitems_returned + nbytes_left) / 4),
                                  False, XA_STRING,
                                  &actual_type, &actual_fmt,
                                  &nitems_returned,
                                  &nbytes_left, &buf);
      if (result == Success && actual_type == XA_STRING &&
          actual_fmt == 8 && buf)
      {
        res_db = XrmGetStringDatabase((char *) buf);
        XFree(buf);
        if (res_db)
        {
          XrmMergeDatabases(res_db, &app_res_db);
#if DEBUG_XRM
          fprintf(stderr, ". ok\n");
#endif
          found = 1;
        }
      }
      else if (nitems_returned > 0 && buf)
        XFree(buf);
    }
  }
  if (!found)                   /* try ~/.Xdefaults */
  {
    str = getenv("HOME");
    if (!str)
      str = ".";
    sprintf(bar, "%s/.Xdefaults", str);
#if DEBUG_XRM
    fprintf(stderr, " failed.\n Trying ~/.Xdefaults '%s'\n", bar);
#endif
    res_db = XrmGetFileDatabase(bar);
#if DEBUG_XRM
    fprintf(stderr, ". %s\n", res_db ? "ok" : "failed");
#endif
    if (res_db)
      XrmMergeDatabases(res_db, &app_res_db);
  }
  found = 0;
#if DEBUG_XRM
  fprintf(stderr, "Trying to merge $XENVIRONMENT\n");
#endif
  str = getenv("XENVIRONMENT");
  if (str)
  {
    res_db = XrmGetFileDatabase(str);
#if DEBUG_XRM
    fprintf(stderr, " %s: %s\n", str, res_db ? "ok" : "failed");
#endif
    if (res_db)
    {
      XrmMergeDatabases(res_db, &app_res_db);
      found = 1;
    }
  }
  if (!found)                   /* try ~/.Xdefaults-hostname */
  {
    char *host;

#if DEBUG_XRM
    fprintf(stderr, "Trying ~/.Xdefaults-<hostname>\n");
#endif
    host = getenv("HOSTNAME");
    if (host)
    {
      str = getenv("HOME");
      if (!str)
        str = ".";
      sprintf(bar, "%s/.Xdefaults-%s", str, host);
#if DEBUG_XRM
      fprintf(stderr, "Trying to merge '%s'", bar);
#endif
      res_db = XrmGetFileDatabase(bar);
#if DEBUG_XRM
      fprintf(stderr, ". %s\n", res_db ? "ok" : "failed");
#endif
      if (res_db)
        XrmMergeDatabases(res_db, &app_res_db);
    }
  }

  res_db = (XrmDatabase) 0;

  XrmParseCommand(&res_db,
                  cmd_opt, cmd_opt_count, cl_name, argc, argv);
  if (res_db)
    XrmMergeDatabases(res_db, &app_res_db);
  g_free(cl_name);
  if (app_res_db)
    XrmSetDatabase(gdk_display, app_res_db);

  return 1;
}

static void *get_resource(const char *str_name,
                          const char *str_class,
                          const char *defval)
{

  char *ret_type;
  XrmValue ret;
  char *name;
  Status result;

  name = (char *) g_malloc0(sizeof(char) * (strlen(str_name) + FILENAME_MAX + 2));	/* hmmmm... */

  if (App_class_name2)
    sprintf(name, "%s.%s", App_class_name2, str_name);
  else
    sprintf(name, "%s.%s", g_get_prgname(), str_name);
#if DEBUG_XRM
  fprintf(stderr, "Reading %s (%s)\n", name, str_class);
#endif
  result = XrmGetResource(app_res_db, name,
                          str_class, &ret_type,
                          &ret);
  if (result == False && App_class_name2)
  {
    sprintf(name, "%s.%s", g_get_prgname(), str_name);
#if DEBUG_XRM
    fprintf(stderr, "  Trying %s (%s)\n", name, str_class);
#endif
    result = XrmGetResource(app_res_db, name,
                            str_class, &ret_type,
                            &ret);
  }
  if (result == False)
  {
#if DEBUG_XRM
    fprintf(stderr, "\t%s (%s) not found\n", str_name, str_class);
#endif
    ret.addr = (XPointer) defval;
  }
  g_free(name);
  return (void *) ret.addr;
}

char *gtk_get_app_resource(const char *str_name,
                           const char *str_class,
                           GTK_RESOURCE_TYPE type,
                           const char *defval,
                           void *buf,
                           size_t bufsize)
{
  void *val;

  val = get_resource(str_name, str_class, defval);
  switch (type)
   {
     case GTK_SHORT:
       sscanf((char *) val, "%hd", (short *) buf);
       break;
     case GTK_BOOL:
       {
         char *str = g_strdup((char *) val);
         char *s = str;

         while ((*s = tolower(*s)))
           s++;
         *((int *) buf) = (int) (
                                  (*str == '1' && *(str + 1) == 0) ||
                    (*str == 'o' && *(str + 1) == 'n' && *(str + 2) == 0) ||
                                  (*str == 'y' && *(str + 1) == 'e' && *(str + 2) == 's' && *(str + 3) == 0) ||
                                  (*str == 't' && *(str + 1) == 'r' && *(str + 2) == 'u' && *(str + 3) == 'e' &&
                                   *(str + 4) == 0));
         g_free(str);
         break;
       }
     case GTK_INT:
       sscanf((char *) val, "%d", (int *) buf);
       break;
     case GTK_LONG:
       sscanf((char *) val, "%ld", (long *) buf);
       break;
     case GTK_STRING:
       memcpy(buf, val, bufsize);
       *((char *) buf + bufsize) = 0;
       break;
     case GTK_FLOAT:
       sscanf((char *) val, "%f", (float *) buf);
       break;
     case GTK_DOUBLE:
       sscanf((char *) val, "%lf", (double *) buf);
       break;
     default:
       break;
   }
  return (char *) val;
}

void gtk_get_app_resources(GTK_resource * res,
                           size_t count)
{
  GTK_resource *p = res,
      *end = (res + count);

  for (; p != end; p++)
    (void) gtk_get_app_resource(p->str_name, p->str_class, p->type,
                                p->defval, p->buf, p->size);
}
