/* GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * BeOS Port
 * Copyright (C) 1999 EventLoop, Inc.
 *   Shawn T. Amundson <amundson@gtk.org>
 *   James Mitchell <mitchell@eventloop.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */


#include "gdk_bwindow.h"
#include <glib.h>
#include <stdio.h>
#include <sys/time.h>
#include "gdk/gdkkeysyms.h"
#include "gdk/gdk.h"
#include "gdkprivate.h"

/* We're using the microsecond clock */

#define DOUBLE_CLICK_TIME      250000
#define TRIPLE_CLICK_TIME      400000 

extern GdkWindow *p_grab_window;
extern gboolean p_grab_automatic;
extern gboolean  *p_grab_owner_events;
extern GdkEventMask p_grab_event_mask;

extern guint32 button_click_time[2];
extern GdkWindow *button_window[2];
extern guint button_number[2];
extern void gdk_synthesize_click (GdkEvent *event, gint nclicks);

extern gboolean do_motion_hints;

GdkBWindowPrivate::GdkBWindowPrivate(BRect frame, const char *title, 
                                     window_type type, uint32 flags)
  : BWindow(frame, title, type, flags)
{
}

void
GdkBWindowPrivate::DispatchMessage(BMessage *msg, BHandler *target)
{
  BView *view;
  GdkEvent event;
  GdkWindow *window;
  GdkWindowPrivate *window_private;
  static guint last_button_down = 0;

  window = gdk_window_lookup(target);
  window_private = (GdkWindowPrivate*) window;

  g_return_if_fail(window != NULL);

  switch (msg->what)
    {
    case B_MODIFIERS_CHANGED:
      break;
    case B_UNMAPPED_KEY_UP:
    case B_KEY_UP:
      {
        event.key.type = GDK_KEY_RELEASE;
       
keyup_or_down: 
        int32 keypressed;
	int64 keytime;	
	int32 keymods;

        /*if (k_grab_window)
	  event.key.window = (GdkWindow *) k_grab_window;*/
	event.key.window = window;

        msg->FindInt32("raw_char", &keypressed);
	msg->FindInt64("when", &keytime);
	msg->FindInt32("modifiers", &keymods);

	event.key.state = 0;
	if (keymods & B_SHIFT_KEY)
	  event.key.state |= GDK_SHIFT_MASK;
	if (keymods & B_CAPS_LOCK)
	  event.key.state |= GDK_LOCK_MASK;
	if (keymods & B_CONTROL_KEY)
	  event.key.state |= GDK_CONTROL_MASK;

	event.key.time = keytime;
	event.key.string = NULL;
	event.key.length = 0;

        switch (keypressed)
          {
          case B_BACKSPACE:
	    event.key.keyval = GDK_BackSpace; break;
          case B_ENTER:
   	    event.key.keyval = GDK_Return; break;
          case B_TAB:
	    event.key.keyval = GDK_Tab; break;
          case B_ESCAPE:
	    event.key.keyval = GDK_Escape; break;
          case B_LEFT_ARROW:
	    event.key.keyval = GDK_Left; break;
          case B_RIGHT_ARROW:
	    event.key.keyval = GDK_Right; break;
          case B_UP_ARROW:
	    event.key.keyval = GDK_Up; break;
          case B_DOWN_ARROW:
	    event.key.keyval = GDK_Down; break;
          /* DO FKEY NESTED SHIT HERE */
          case B_INSERT:
	    event.key.keyval = GDK_Insert; break;
          case B_DELETE:
	    event.key.keyval = GDK_Delete; break;
          case B_HOME:
	    event.key.keyval = GDK_Home; break;
          case B_END:
	    event.key.keyval = GDK_End; break;
          /* case B_PAGE_UP:
          case B_PAGE_DOWN:*/
          default:
	    char buf[1];

	    buf[0] = keypressed;
	    buf[1] = '\0';

            event.key.keyval = (guint)keypressed;	
	    event.key.string = g_strdup(buf);
	    event.key.length = 1;
          }
        
        GDK_NOTE (EVENTS, g_print ("Event: KeyPress/Release:  keypressed %d, keyval %d, string %s, state %d\n", keypressed, event.key.keyval, event.key.string, event.key.state));
        gdk_event_put_safe(&event);
      }
      break;
    case B_UNMAPPED_KEY_DOWN:
    case B_KEY_DOWN:
      {
        event.key.type = GDK_KEY_PRESS;
	goto keyup_or_down;
      }   
      break;
    case B_MOUSE_DOWN:
      {
        BPoint cursor;
        uint32 buttons;
        GdkEventMask mask; 

        event.button.type = GDK_BUTTON_PRESS;
        event.button.window = window;
        mask = (GdkEventMask) window_private->event_mask;

        if (p_grab_window != NULL
            && !p_grab_owner_events)
          {
            /* Pointer is grabbed with owner_events FALSE */
            GDK_NOTE (EVENTS, g_print ("Event: MouseDown: ...grabbed, owner_events FALSE\n"));
            mask = p_grab_event_mask;
            if (!(mask & GDK_BUTTON_PRESS_MASK))
              /* Grabber doesn't want it */
              break;
            else
              event.button.window = p_grab_window;
            GDK_NOTE (EVENTS, g_print ("Event: MouseDown: ...sending to %#x\n",
                                       p_grab_window));
          }
        else if (window_private
                 && !(mask & GDK_BUTTON_PRESS_MASK))
          {
            /* Owner window doesn't want it */
            if (p_grab_window != NULL
                && p_grab_owner_events)
              {
                /* Pointer is grabbed with owner_events TRUE */
                GDK_NOTE (EVENTS, g_print ("Event: MouseDown: ...grabbed, owner_events TRUE, doesn't want it\n"));
                mask = p_grab_event_mask;
                if (!(mask & GDK_BUTTON_PRESS_MASK))
                  /* Grabber doesn't want it either */
                  break;
                else
                  event.button.window = p_grab_window;
                GDK_NOTE (EVENTS, g_print ("Event: MouseDown: ...sending to %#x\n",
                                           p_grab_window));
              }
            else
              {
                /* Owner doesn't want it, neither is it grabbed, so
                 * propagate to parent.
                 */
                GDK_NOTE (EVENTS, g_print ("Event: MouseDown: no one wants it, should propogate (unimplemented)\n"));
              }
           }  

        /* Emulate X's automatic grab */
        if (!p_grab_window)
          {
            gdk_pointer_grab(window, TRUE, 
			     (GdkEventMask) window_private->event_mask,
                             NULL, NULL, 0);
            p_grab_automatic = TRUE;
          }

#if 0
        if (p_grab_window)
          event.button.window = p_grab_window;
        else
          event.button.window = window;
#endif

        view = (BView*) ((GdkWindowPrivate*) event.button.window)->xwindow;

        if (view->Window()->Lock())
          {
            view->GetMouse(&cursor, &buttons);
            view->Window()->Unlock();
          }

        timeval now;
 
        gettimeofday(&now, NULL);

	event.button.time = now.tv_sec * 1000000 + now.tv_usec; 
        event.button.x = (gdouble) cursor.x; 
        event.button.y = (gdouble) cursor.y; 
        event.button.x_root = (gdouble) cursor.x;
        event.button.y_root = (gdouble) cursor.y;
        event.button.pressure = 0.5;
        event.button.xtilt = 0;
        event.button.ytilt = 0;
        event.button.state = 0;

        if (buttons & B_PRIMARY_MOUSE_BUTTON)
          event.button.state |= GDK_BUTTON1_MASK;
        else if (buttons & B_SECONDARY_MOUSE_BUTTON)
          event.button.state |= GDK_BUTTON3_MASK;
        else if (buttons & B_TERTIARY_MOUSE_BUTTON)
          event.button.state |= GDK_BUTTON2_MASK;

        if (buttons & B_PRIMARY_MOUSE_BUTTON)
          event.button.button = 1;
        else if (buttons & B_SECONDARY_MOUSE_BUTTON)
          event.button.button = 3;
        else if (buttons & B_TERTIARY_MOUSE_BUTTON)
          event.button.button = 2;

        event.button.source = GDK_SOURCE_MOUSE;
        event.button.deviceid = GDK_CORE_POINTER;

        if ((event.button.time < (button_click_time[1] + TRIPLE_CLICK_TIME)) &&
          (event.button.window == button_window[1]) &&
          (event.button.button == button_number[1]))
        {        
	  gdk_synthesize_click (&event, 3);

          button_click_time[1] = 0;
          button_click_time[0] = 0;
          button_window[1] = NULL;
          button_window[0] = 0;
          button_number[1] = -1;
          button_number[0] = -1;
        }
      else if ((event.button.time < (button_click_time[0] + DOUBLE_CLICK_TIME)) &&
               (event.button.window == button_window[0]) &&
               (event.button.button == button_number[0]))
        {
          gdk_synthesize_click (&event, 2);
 
          button_click_time[1] = button_click_time[0];
          button_click_time[0] = event.button.time;
          button_window[1] = button_window[0];
          button_window[0] = event.button.window;
          button_number[1] = button_number[0];
          button_number[0] = event.button.button;
        }          
      else
        {
          button_click_time[1] = 0;
          button_click_time[0] = event.button.time;
          button_window[1] = NULL;
          button_window[0] = event.button.window;
          button_number[1] = -1;
          button_number[0] = event.button.button;
        }    

        last_button_down = event.button.button;

        GDK_NOTE (EVENTS,
                 g_print("Event: ButtonPress: window %p  x,y %dx%d  button %d  state: %s %s %s\n",
                         event.button.window,
                         (gint) event.button.x,
                         (gint) event.button.y,
                         event.button.button,
                         (event.button.state & GDK_BUTTON1_MASK ? "1" : "."),
                         (event.button.state & GDK_BUTTON2_MASK ? "2" : "."),
                         (event.button.state & GDK_BUTTON3_MASK ? "3" : ".")));
 

        gdk_event_put_safe(&event);

        do_motion_hints = 1;
      }
      break;
    case B_MOUSE_UP:
      {
        BPoint cursor;
        int32 buttons;
        uint32 buttons_uint;
        GdkEventMask mask;

        event.button.type = GDK_BUTTON_RELEASE;
        event.button.window = window;
        mask = (GdkEventMask) window_private->event_mask;

        if (p_grab_window != NULL
            && !p_grab_owner_events)
          {
             GDK_NOTE (EVENTS, g_print ("Event: MouseUp: ...grabbed, owner_events FALSE\n"));
             mask = p_grab_event_mask;
             if (!(mask & GDK_BUTTON_RELEASE_MASK))
               /* Grabber doesn't want it */
               break;
             else
               event.button.window = p_grab_window; 
          }
        else if (window_private
                 && !(mask & GDK_BUTTON_RELEASE_MASK))
          {
            /* Owner window doesn't want it */
            if (p_grab_window != NULL
                && p_grab_owner_events)
              {
                GDK_NOTE (EVENTS, g_print ("Event: MouseUp: ...grabbed, owner_events TRUE\n"));
                mask = p_grab_event_mask;
                if (!(mask & GDK_BUTTON_RELEASE_MASK))
                  /* Grabber doesn't want it */
                  break;
                else
                  event.button.window = p_grab_window;
              }
            else
              {
                GDK_NOTE (EVENTS, g_print ("Event: MouseUp: no one wants it, should propogate (unimplemented)\n"));
                return;
              }
          }

        view = (BView*) ((GdkWindowPrivate*) event.button.window)->xwindow;

        if (view->Window()->Lock())
          {
            view->GetMouse(&cursor, &buttons_uint);
            view->Window()->Unlock();
          }

        timeval now;

        gettimeofday(&now, NULL);
                                           

	event.button.time = now.tv_sec * 1000000 + now.tv_usec; 
        event.button.x = (gdouble) cursor.x; 
        event.button.y = (gdouble) cursor.y; 
        event.button.x_root = (gdouble) cursor.x;  /* FIXME */
        event.button.y_root = (gdouble) cursor.y;  /* FIXME */
        event.button.pressure = 0.5;
        event.button.xtilt = 0;
        event.button.ytilt = 0;
        event.button.state = 0; 
        if (buttons & B_PRIMARY_MOUSE_BUTTON)
          event.button.state |= GDK_BUTTON1_MASK;
        else if (buttons & B_SECONDARY_MOUSE_BUTTON)
          event.button.state |= GDK_BUTTON2_MASK;
        else if (buttons & B_TERTIARY_MOUSE_BUTTON)
          event.button.state |= GDK_BUTTON2_MASK;
        
        event.button.button = last_button_down;

        event.button.source = GDK_SOURCE_MOUSE;
        event.button.deviceid = GDK_CORE_POINTER;

        if (p_grab_window != NULL && p_grab_automatic
            && (event.button.state & (GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GDK_BUTTON3_MASK)) == 0)
          gdk_pointer_ungrab (0);

        GDK_NOTE (EVENTS,
                 g_print("Event: ButtonRelease: window %p  x,y %dx%d  button %d  state: %s %s %s\n",
                         event.button.window,
                         (gint) event.button.x,
                         (gint) event.button.y,
                         event.button.button,
                         (event.button.state & GDK_BUTTON1_MASK ? "1" : "."),
                         (event.button.state & GDK_BUTTON2_MASK ? "2" : "."),
                         (event.button.state & GDK_BUTTON3_MASK ? "3" : ".")));
 
        gdk_event_put_safe(&event);

        do_motion_hints = 1;
      }
      break;
    case B_WINDOW_RESIZED:
      {
        int32 width;
        int32 height;
        BView *view;

        msg->FindInt32("width", &width);
        msg->FindInt32("height", &height);
 
        view = (BView*) ((GdkWindowPrivate*) window)->xwindow;
        if (view->Window()->Lock())
          {
            view->ResizeTo((float)width, (float)height);       
            view->Window()->Unlock();
          }

        event.configure.type = GDK_CONFIGURE;
        event.configure.window = window;
        event.configure.width = (gint16) width; 
        event.configure.height = (gint16) height;

        GDK_NOTE (EVENTS,
                  g_print("Event: ConfigureNotify: window %p  w x h %dx%d\n",
                          event.configure.window,
                          event.configure.width,
                          event.configure.height));

        gdk_event_put_safe(&event);
      }
      break;
    case B_MOUSE_MOVED:
    case B_VIEW_MOVED:
    case B_WINDOW_ACTIVATED:
    case B_WORKSPACES_CHANGED:
    case B_QUIT_REQUESTED:
    case B_VIEW_RESIZED:
    case B_WINDOW_MOVED:
    case _UPDATE_:
    case _EVENTS_PENDING_:
      BWindow::DispatchMessage(msg, target);
      break;
    default:
      printf("Warning: Unknown Message: %c%c%c%c for target %#x\n",
             ((char*)(&(msg->what)))[3],
             ((char*)(&(msg->what)))[2],
             ((char*)(&(msg->what)))[1],
             ((char*)(&(msg->what)))[0],
             target);
      BWindow::DispatchMessage(msg, target);
    }
}
