# Make script for freetype 2.2.1

MOD=freetype
VER=2.2.1
THIS=$MOD-$VER
DEPS=''

# Don't let libtool do its relinking dance. Don't know how relevant
# this is, but it doesn't hurt anyway.
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <builds/unix/ltmain.sh >builds/unix/ltmain.temp && mv builds/unix/ltmain.temp builds/unix/ltmain.sh

# Use a randomish DLL image base address.
sed -e 's/--image-base=0x10000000/--enable-auto-image-base/' <builds/unix/configure >builds/unix/configure.temp && mv builds/unix/configure.temp builds/unix/configure

# Do use the -export-symbols and -no-undefined libtool options.
# For backward compatibility with the gnuwin32 build of freetype 2.1.10, 
# generate a DLL called freetype6.dll. To get that, we need to use
# the -avoid-version -module libtool options.
sed -e 's/# -export/-avoid-version -module -export/' -e 's/:= lib\$(PROJECT)/:=$(PROJECT)6/' <builds/unix/unix-cc.in >builds/unix/unix-cc.in.temp && mv builds/unix/unix-cc.in.temp builds/unix/unix-cc.in

# Enable the bytecode interpreter.
sed -e 's!^/\* \(#define TT_CONFIG_OPTION_BYTECODE_INTERPRETER\) \*/!\1!' <include/freetype/config/ftoption.h >include/freetype/config/ftoption.h.temp && mv include/freetype/config/ftoption.h.temp include/freetype/config/ftoption.h

# Hide ftmac.h so that apinames won't generate export symbols for the
# functions in it, which are compiled on Macs only.
mv include/freetype/ftmac.h include/freetype/ftmac.h.bak
touch include/freetype/ftmac.h

# Don't use absolute paths in freetype-config.
sed -e 's!prefix=@prefix@!prefix=`dirname $0`/..!' <builds/unix/freetype-config.in >builds/unix/freetype-config.in.temp && mv builds/unix/freetype-config.in.temp builds/unix/freetype-config.in

# Add many "internal" functions to the exported symbols list
# because they used to be exported, and some software like fontconfig
# used them.
sed -e '/	  @echo TT_RunIns >> \$(EXPORTS_LIST)/ a\
	@echo FT_Alloc >> $(EXPORTS_LIST)\
	@echo FT_QAlloc >> $(EXPORTS_LIST)\
	@echo FT_Realloc >> $(EXPORTS_LIST)\
	@echo FT_QRealloc >> $(EXPORTS_LIST)\
	@echo FT_Free >> $(EXPORTS_LIST)\
	@echo FT_Stream_New >> $(EXPORTS_LIST)\
	@echo FT_Stream_Free >> $(EXPORTS_LIST)\
	@echo FT_Stream_OpenMemory >> $(EXPORTS_LIST)\
	@echo FT_Stream_Close >> $(EXPORTS_LIST)\
	@echo FT_Stream_Seek >> $(EXPORTS_LIST)\
	@echo FT_Stream_Skip >> $(EXPORTS_LIST)\
	@echo FT_Stream_Pos >> $(EXPORTS_LIST)\
	@echo FT_Stream_Read >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadAt >> $(EXPORTS_LIST)\
	@echo FT_Stream_TryRead >> $(EXPORTS_LIST)\
	@echo FT_Stream_EnterFrame >> $(EXPORTS_LIST)\
	@echo FT_Stream_ExitFrame >> $(EXPORTS_LIST)\
	@echo FT_Stream_ExtractFrame >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReleaseFrame >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetChar >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetShort >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetOffset >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetLong >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetShortLE >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetLongLE >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadChar >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadOffset >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadLong >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadShortLE >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadLongLE >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadFields >> $(EXPORTS_LIST)\
' <builds/exports.mk >builds/exports.mk.temp && mv builds/exports.mk.temp builds/exports.mk

usestable
usemsvs6

CC='gcc -mtune=pentium3 -mthreads' LDFLAGS='-Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --prefix=c:/devel/target/$THIS --disable-static
PATH=/devel/target/$THIS/bin:.libs:$PATH make &&

# Restore ftmac.h.
mv include/freetype/ftmac.h.bak include/freetype/ftmac.h &&
make install &&

# With -module, libtool installs the dll in "lib", so move it to "bin".
mv /devel/target/$THIS/lib/freetype6.dll /devel/target/$THIS/bin &&

# Use normal name for import library.
mv /devel/target/$THIS/lib/freetype6.dll.a /devel/target/$THIS/lib/libfreetype.dll.a &&

# Strip the dll.
(cd /devel/target/$THIS/bin && strip --strip-unneeded *.dll) &&

# Generate zip archive distribution

rm -f /tmp/$MOD-$VER.zip /tmp/$MOD-dev-$VER.zip &&
(cd /devel/target/$THIS && zip /tmp/$MOD-$VER.zip bin/freetype6.dll) &&
(cd /devel/target/$THIS && zip /tmp/$MOD-dev-$VER.zip bin/freetype-config) &&
(cd /devel/target/$THIS && zip /tmp/$MOD-dev-$VER.zip lib/libfreetype.dll.a) &&
(cd /devel/target/$THIS && zip /tmp/$MOD-dev-$VER.zip lib/pkgconfig/freetype2.pc) &&
(cd /devel/target/$THIS && zip -r /tmp/$MOD-dev-$VER.zip include) &&
(cd /devel/target/$THIS && zip -r /tmp/$MOD-dev-$VER.zip share) &&
# Include *this* file in the developer zipfile for reference
(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.make)
