/* Levels 1.3 -- Image filter plug-in for the GIMP image manipulation program
 * Copyright (C) 1996  Ed Connell and Kris Wehner  
 *
 * You can contact me at ed@lucas.further.com
 * You can contact the original The GIMP authors at gimp@xcf.berkeley.edu
 *
 * Just for the record some of this code was "borrowed" from Ian Tester's   
 * threshold.c and Spencer Kimball's and Peter Mattis' bleed.c GIMP
 * plug-ins. But please don't bug them if this program doesn't work.
 * Contact me instead.  Levels has been severely reorganized, there
 * is probably little unoriginal code left.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * @(GIMP)         = <plug-in levels "Effects/Levels">
 * @(GIMP_DEP)     = <levels.c>
 * @(GIMP_OBJ)     = <levels.o>
 * @(GIMP_LIB)     = <c libgimp.a>
 * 
 * @(GIMP_AUTHOR)  = <Ed Connell>
 * @(GIMP_EMAIL)   = <ed@lucas.further.com>
 * @(GIMP_DESC)    = <Turns dark grays to black and light grays to white>
 * @(GIMP_VERSION) = <1.3>
 * @(GIMP_URL)     = <http://www.further.com/projects/levels.html>
 */

/*
 * Version 1.3 - Conforms to Ingo's script.  Cancel on first dialog works.
 * Version 1.2c - More code clean-up.  Code doesn't make me want to puke too much anymore.
 * Version 1.2b - Code clean-up 
 * Version 1.2 - Added dialog to ask if result should be placed in a new window.
 * Version 1.1 - Added independant controls for red/green/blue.  RGB Lock keeps colors the same.
 * Version 1.0 - First try at Levels plug-in.  Does grayscale and RGB.
 *
 * Levels turns dark grays to black and light grays to white according to user specified values.
 */

/* TODO  
 *
 * Get indexed color to work
 *
 * Modularize better. One problem I can't is getting the filter guts out of level_gray.
 * A semi-good c programmer could probably figure what I'm doing wrong with it in 5 minutes.
 * If anyone does please let me know.  It's just a basic pointer problem.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "gimp.h"

/* UTILITY FUNCTIONS */
static void save_original_image(void);
static void freshen_to_original(void);
static void get_output_image(int type);
static void display_main_dialog(void);
static void initialize(int argc, char *argv[]);
static void shutdown(char *);

/*Commented out to get rid of compiler warning */
/*static void gray_guts(unsigned char **src, unsigned char **dest);*/ 

/* LEVEL FUNCTIONS */
static void level (Image, Image);
static void level_gray (Image, Image);
static void level_indexed (Image, Image);  /* DOESN'T WORK YET */
static void level_rgb(Image, Image);

/* DIALOG FORMATION */
static void form_and_display_opening_dialog(void);
static void form_RGB_dialog(void);
static void form_gray_dialog(void);

/* SCALE CALLBACKS */
static void b_scale_callback (int, void *, void *);
static void w_scale_callback (int, void *, void *);
static void R_high_scale_callback(int, void *, void *);
static void R_low_scale_callback(int, void *, void *);
static void B_high_scale_callback(int, void *, void *);
static void B_low_scale_callback(int, void *, void *);
static void G_high_scale_callback(int, void *, void *);
static void G_low_scale_callback(int, void *, void *);

/* CALLBACKS */
static void ok_callback (int, void *, void *);
static void cancel_callback(int, void *, void *);
static void open_ok_callback (int, void *, void *);
static void open_cancel_callback(int, void *, void *);
static void rgb_lock_callback (int, void *, void *);
static void open_new_callback (int, void *, void *);
static void aapply_callback (int, void *, void *);

/* ID's */
static int aapply_ID;
static int rgb_lock_ID;
static int open_new_ID;
static int dialog_ID;
static int opening_dialog_ID;
static int opening_group_ID;
static int main_group_ID;
static int black_scale_ID;
static int white_scale_ID;
static int R_low_scale_ID, R_high_scale_ID;
static int B_low_scale_ID, B_high_scale_ID;
static int G_low_scale_ID, G_high_scale_ID;

/* GLOBAL VARIABLES */
static long aapply;
static long rgb_lock;
static long open_new;
static int black_threshold = 0;
static int white_threshold = 256;
static int R_low_threshold = 0;
static int R_high_threshold = 256;
static int G_low_threshold = 0;
static int G_high_threshold = 256;
static int B_low_threshold = 0;
static int B_high_threshold = 256;

static Image input, output;
static unsigned char *original_image;

int main (int argc, char **argv)
{
  int type;

  initialize(argc,argv);
  form_and_display_opening_dialog();

  type=gimp_image_type(input);
  switch (type)
    {
    case INDEXED_IMAGE:
      gimp_message("levels: sorry, I seg fault on indexed images");
      break;

    case RGB_IMAGE:
    case GRAY_IMAGE:
      save_original_image();
      get_output_image(type);      

      if (type == RGB_IMAGE)
	form_RGB_dialog();
      else
	form_gray_dialog();      

      display_main_dialog();      
      free(original_image);    
      break;

    default:
      gimp_message ("levels: cannot operate on unkown image types");
      break;
    }

  shutdown(NULL);
  return 0;
}

/************************************************************************************
 *
 *    UTILITY FUNCTIONS
 *
 ***********************************************************************************/
static void get_output_image(int type)
{
  if (open_new)
    {
      output = gimp_new_image(0,gimp_image_width(input),gimp_image_height(input),type);
      gimp_display_image (output);
      freshen_to_original();
      gimp_update_image (output);
    }
  else
    output = gimp_get_output_image(0);
  
  if (!output)
    shutdown("levels:  couldn't get output image!");
}

static void display_main_dialog(void)
{
  if (!gimp_show_dialog(dialog_ID))
    {                                /* Cancel was clicked */          
      if (aapply)
	{
	  freshen_to_original();    
	  gimp_update_image(output);
	}
    }
  else                               /* OK was clicked */
    if (!aapply)
	{
	  level(input,output);
	  gimp_update_image(output);
	}
}

static void initialize(int argc, char *argv[])
{
  if (!gimp_init (argc, argv))
    {
      fprintf(stderr,"levels: gimp_init failed!");
      exit(1);
    }
    
  input = 0;
  output = 0;
  
  input = gimp_get_input_image (0);
  if (!input)
    shutdown("levels:  gimp_get_input_image failed!");
}

static void shutdown(char *message)
{
  if (input)  
    gimp_free_image (input);
  if (output)
    gimp_free_image (output);

  if(message != NULL)
    {
      gimp_message(message);
      gimp_quit();  
      exit(1);
    }
  else
    gimp_quit();
}

static void save_original_image(void)
{
  original_image = (unsigned char *) malloc
           (gimp_image_width(input) * gimp_image_height(input) * gimp_image_channels(input));

  memcpy(original_image, gimp_image_data(input), 
            gimp_image_width(input) * gimp_image_height(input) * gimp_image_channels(input)); 
}

static void freshen_to_original(void)
{
  memcpy(gimp_image_data(output), original_image, 
	    gimp_image_width(input) * gimp_image_height(input) * gimp_image_channels(input));
}

/******* Doesn't work yet.  Commented to get rid of compiler warning. 
  static void gray_guts(unsigned char **src, unsigned char **dest)
  {
  long val;
  
  val = (long) **src;
  if (val < black_threshold)
  *dest++ = 0;              
  else 
  if (val > white_threshold)
  **dest++ = 255;          
  else
  **dest++ = val;          
  printf("%c 2\n",**src);
  *src++;    
  printf("%c 3\n",**src);
  } 
  *********/

/*****************************************************************************************
 *
 *    LEVEL FUNCTIONS
 *
 ****************************************************************************************/

static void level (Image input, Image output)
{
  switch(gimp_image_type(input))
    {
    case INDEXED_IMAGE:
      level_indexed(input,output);
      break;
    case RGB_IMAGE:
      level_rgb(input,output);
      break;
    case GRAY_IMAGE:
      level_gray(input,output);
      break;
    default :
      break;
    }
}

static void level_rgb(Image input, Image output)
{
  long width, height;
  long channels, rowstride;
  long val;
  unsigned char *src_row, *dest_row;
  unsigned char *src,*dest;
  short row, col;
  int x1, y1, x2, y2;

  gimp_image_area (input, &x1, &y1, &x2, &y2);

  width = gimp_image_width (input);
  height = gimp_image_height (input);
  channels = gimp_image_channels (input);
  rowstride = width * channels;

  src_row = original_image;
  dest_row = gimp_image_data (output);

  src_row += rowstride * y1 + (x1 * channels);
  dest_row += rowstride * y1 + (x1 * channels);

  for (row = y1; row < y2; row++)
    {
      src = src_row;
      dest = dest_row;
      for (col = x1; col < x2; col++)
	{
	  val = (long) *src;
	  if (val < R_low_threshold)
	    *dest++ = 0;               /* Make it black */
	  else 
	    if (val > R_high_threshold)
	      *dest++ = 255;           /* Make it white */
	    else
	      *dest++ = val;           /* Keep it grey */
	  src++;
	  
	  val = (long) *src;
	  if (val < G_low_threshold)
	    *dest++ = 0;               /* Make it black */
	  else 
	    if (val > G_high_threshold)
	      *dest++ = 255;           /* Make it white */
	    else
	      *dest++ = val;           /* Keep it grey */
	  src++;

	  val = (long) *src;
	  if (val < B_low_threshold)
	    *dest++ = 0;               /* Make it black */
	  else 
	    if (val > B_high_threshold)
	      *dest++ = 255;           /* Make it white */
	    else
	      *dest++ = val;           /* Keep it grey */
	  src++;
	}
      src_row += rowstride; 
      dest_row += rowstride;
    }
}


static void level_gray (Image input, Image output)
{
  long width, height;
  long channels, rowstride;
  long val; 
  unsigned char *src_row, *dest_row;
  unsigned char *src,*dest;
  short row, col;
  int x1, y1, x2, y2;

  gimp_image_area (input, &x1, &y1, &x2, &y2);

  width = gimp_image_width (input);
  height = gimp_image_height (input);
  channels = gimp_image_channels (input);
  rowstride = width * channels;

  src_row=original_image;
  dest_row = gimp_image_data (output);

  src_row += rowstride * y1 + (x1 * channels);
  dest_row += rowstride * y1 + (x1 * channels);
  
  for (row = y1; row < y2; row++)
    {
      src = src_row;
      dest = dest_row;
      for (col = x1; col < x2; col++)
	{
	  /* printf("%c 1\n",*src);*/    /*  I can't get gray_guts to work.  I'm pretty */
	  /* gray_guts(&src,&dest);*/    /*  sure I'm not doing the pointers right.  */
	  /* printf("%c 4\n",*src);*/    /*  Especially src doesn't work right */
	  val = (long) *src; 
 	  if (val < black_threshold) 
 	    *dest++ = 0;                /* Make it black */ 
 	  else  
 	    if (val > white_threshold) 
 	      *dest++ = 255;           /* Make it white */ 
 	    else 
 	      *dest++ = val;           /* Keep it grey */ 
 	  src++; 
	}
      src_row += rowstride; 
      dest_row += rowstride;
    }
}


static void level_indexed(Image input, Image output)
{
 unsigned char *icmap, *ocmap, *in, *out;
 int num, c, val;

/* first copy the image data over */

 memcpy(gimp_image_data(output), gimp_image_data(input), \
        gimp_image_width(input) * gimp_image_height(input));

 num = gimp_image_colors(input) * 3;

 icmap = gimp_image_cmap(input);

 ocmap = (unsigned char *)malloc(768);

 in = icmap;
 out = ocmap;

 for (c = 0; c < num; c++)
 {
  val = (int)*in++;

  if (val < black_threshold)
    *out++ = 0;               /* Make it black */
  else 
    if (val > white_threshold)
      *out++ = 255;           /* Make it white */
    else
      *out++ = val;           /* Keep it grey */
 }

 gimp_set_image_colors(input,icmap,num);
 gimp_set_image_colors(output,ocmap,num);
}

/****************************************************************************************
 *
 *   DIALOG FORMATION
 *
 ***************************************************************************************/

static void form_and_display_opening_dialog(void)
{
  opening_dialog_ID=gimp_new_dialog("Levels opening dialog");
  opening_group_ID=gimp_new_row_group(opening_dialog_ID,DEFAULT,NORMAL,"");  
  open_new_ID=gimp_new_check_button(opening_dialog_ID,opening_group_ID,"Open new window");
  open_new=1;

  gimp_change_item(opening_dialog_ID,open_new_ID,sizeof(open_new),&open_new);
  gimp_add_callback(opening_dialog_ID,open_new_ID,open_new_callback,&open_new);
  gimp_add_callback(opening_dialog_ID,gimp_ok_item_id (opening_dialog_ID) , open_ok_callback, 0);
  gimp_add_callback(opening_dialog_ID,gimp_cancel_item_id (opening_dialog_ID),open_cancel_callback, 0);

  if (!gimp_show_dialog(opening_dialog_ID))
    {
      shutdown(NULL);
      exit(0);
    }
}

static void form_RGB_dialog(void)
{
  dialog_ID= gimp_new_dialog ("Levels");
  main_group_ID = gimp_new_row_group (dialog_ID,DEFAULT,NORMAL,"");
  
  aapply_ID = gimp_new_check_button(dialog_ID,main_group_ID,"Auto Apply");
  aapply = 1;
  gimp_change_item(dialog_ID,aapply_ID,sizeof(aapply),&aapply);
  
  rgb_lock_ID = gimp_new_check_button(dialog_ID,main_group_ID,"RGB Lock");
  rgb_lock = 1;
  gimp_change_item(dialog_ID,rgb_lock_ID,sizeof(rgb_lock),&rgb_lock);
  
  /* Red */
  R_low_scale_ID = gimp_new_scale (dialog_ID,main_group_ID, -1, 256, R_low_threshold, 0);
  R_high_scale_ID = gimp_new_scale (dialog_ID,main_group_ID, -1, 256,  R_high_threshold, 0);
  gimp_new_label(dialog_ID,R_low_scale_ID,"Red Low Threshold");
  gimp_new_label(dialog_ID,R_high_scale_ID,"Red High Threshold");
  gimp_add_callback(dialog_ID,R_low_scale_ID,R_low_scale_callback, &R_low_threshold);
  gimp_add_callback(dialog_ID,R_high_scale_ID,R_high_scale_callback, &R_high_threshold);
  
  /* Green */
  G_low_scale_ID = gimp_new_scale (dialog_ID,main_group_ID, -1, 256, G_low_threshold, 0);
  G_high_scale_ID = gimp_new_scale (dialog_ID,main_group_ID, -1, 256, G_high_threshold, 0);
  gimp_new_label(dialog_ID,G_low_scale_ID,"Green Low Threshold");
  gimp_new_label(dialog_ID,G_high_scale_ID,"Green High Threshold");
  gimp_add_callback(dialog_ID,G_low_scale_ID,G_low_scale_callback, &G_low_threshold);
  gimp_add_callback(dialog_ID,G_high_scale_ID,G_high_scale_callback, &G_high_threshold);
  
  /* Blue */
  B_low_scale_ID = gimp_new_scale (dialog_ID,main_group_ID, -1, 256, B_low_threshold, 0);
  B_high_scale_ID = gimp_new_scale (dialog_ID,main_group_ID, -1, 256, B_high_threshold, 0);
  gimp_new_label(dialog_ID,B_low_scale_ID,"Blue Low Threshold");
  gimp_new_label(dialog_ID,B_high_scale_ID,"Blue High Threshold");
  gimp_add_callback(dialog_ID,B_low_scale_ID,B_low_scale_callback, &B_low_threshold);
  gimp_add_callback(dialog_ID,B_high_scale_ID,B_high_scale_callback, &B_high_threshold);
  
  /* Auto-apply, RGB lock, ok, cancel */
  gimp_add_callback(dialog_ID,aapply_ID,aapply_callback,&aapply);
  gimp_add_callback(dialog_ID,rgb_lock_ID,rgb_lock_callback,&rgb_lock);
  gimp_add_callback(dialog_ID,gimp_ok_item_id (dialog_ID) , ok_callback, 0);
  gimp_add_callback(dialog_ID,gimp_cancel_item_id (dialog_ID) , cancel_callback, 0);
}

static void form_gray_dialog(void)
{
  dialog_ID= gimp_new_dialog ("Levels");
  main_group_ID = gimp_new_row_group (dialog_ID,DEFAULT,NORMAL,"");
  
  aapply_ID = gimp_new_check_button(dialog_ID,main_group_ID,"Auto Apply");
  aapply = 1;
  gimp_change_item(dialog_ID,aapply_ID,sizeof(aapply),&aapply);
  
  black_scale_ID = gimp_new_scale (dialog_ID,main_group_ID, -1, 256, black_threshold, 0);
  white_scale_ID = gimp_new_scale (dialog_ID,main_group_ID, -1, 256, white_threshold, 0);
  
  gimp_new_label(dialog_ID,black_scale_ID,"Black Threshold");
  gimp_new_label(dialog_ID,white_scale_ID,"White Threshold");
  gimp_add_callback(dialog_ID,black_scale_ID,b_scale_callback, &black_threshold);
  gimp_add_callback(dialog_ID,white_scale_ID,w_scale_callback, &white_threshold);
  
  gimp_add_callback(dialog_ID,aapply_ID,aapply_callback,&aapply);
  gimp_add_callback(dialog_ID,gimp_ok_item_id (dialog_ID) , ok_callback, 0);
  gimp_add_callback(dialog_ID,gimp_cancel_item_id (dialog_ID) , cancel_callback, 0); 
}

/**************************************************************************************
 *
 *   SCALE CALLBACKS
 *
 *************************************************************************************/

/* Grayscale */
static void b_scale_callback (int item_ID, void *client_data, void *call_data)
{ 
 if (aapply && (*((long *) client_data) != *((long *) call_data)))
   {
     *((long *) client_data) = *((long *) call_data);
     if (black_threshold > white_threshold)
       {
	 white_threshold=black_threshold;
	 gimp_change_item(dialog_ID,white_scale_ID,sizeof(white_threshold),&white_threshold);
       }
 
     level(input,output);
     gimp_update_image(output);
   }
 else
   *((long *) client_data) = *((long *) call_data);
}

static void w_scale_callback (int item_ID, void *client_data, void *call_data)
{
 if (aapply && (*((long *) client_data) != *((long *) call_data)))
   {
     *((long *) client_data) = *((long *) call_data);
     if (black_threshold > white_threshold)
       {
	 black_threshold=white_threshold;
	 gimp_change_item(dialog_ID,black_scale_ID,sizeof(black_threshold),&black_threshold);
       }
 
     level(input,output);
     gimp_update_image(output);
   }
 else
   *((long *) client_data) = *((long *) call_data);
}

/* Red */
static void R_low_scale_callback (int item_ID, void *client_data, void *call_data)
{ 
 if (aapply && (*((long *) client_data) != *((long *) call_data)))
   {
     *((long *) client_data) = *((long *) call_data);
     if (R_low_threshold > R_high_threshold)
       {
	 R_high_threshold=R_low_threshold;
	 gimp_change_item(dialog_ID,R_high_scale_ID,sizeof(R_high_threshold),&R_high_threshold);
       }
     if (rgb_lock)
       {
	 G_low_threshold=R_low_threshold;
	 gimp_change_item(dialog_ID,G_low_scale_ID,sizeof(G_low_threshold),&G_low_threshold);
	 G_high_threshold=R_high_threshold;
	 gimp_change_item(dialog_ID,G_high_scale_ID,sizeof(G_high_threshold),&G_high_threshold);
	 B_low_threshold=R_low_threshold;
	 gimp_change_item(dialog_ID,B_low_scale_ID,sizeof(B_low_threshold),&B_low_threshold);
	 B_high_threshold=R_high_threshold;
	 gimp_change_item(dialog_ID,B_high_scale_ID,sizeof(B_high_threshold),&B_high_threshold);
       }     
     level_rgb(input,output);
     gimp_update_image(output);
   }
 else
   *((long *) client_data) = *((long *) call_data);
}

static void R_high_scale_callback (int item_ID, void *client_data, void *call_data)
{  
 if (aapply && (*((long *) client_data) != *((long *) call_data)))
   {
     *((long *) client_data) = *((long *) call_data);
     if (R_high_threshold < R_low_threshold)
       {
	 R_low_threshold=R_high_threshold;
	 gimp_change_item(dialog_ID,R_low_scale_ID,sizeof(R_low_threshold),&R_low_threshold);
       }
     if (rgb_lock)
       {
	 G_low_threshold=R_low_threshold;
	 gimp_change_item(dialog_ID,G_low_scale_ID,sizeof(G_low_threshold),&G_low_threshold);
	 G_high_threshold=R_high_threshold;
	 gimp_change_item(dialog_ID,G_high_scale_ID,sizeof(G_high_threshold),&G_high_threshold);
	 B_low_threshold=R_low_threshold;
	 gimp_change_item(dialog_ID,B_low_scale_ID,sizeof(B_low_threshold),&B_low_threshold);
	 B_high_threshold=R_high_threshold;
	 gimp_change_item(dialog_ID,B_high_scale_ID,sizeof(B_high_threshold),&B_high_threshold);
       }
     level_rgb(input,output);
     gimp_update_image(output);
   }
 else
   *((long *) client_data) = *((long *) call_data);
}

/* Green */
static void G_low_scale_callback (int item_ID, void *client_data, void *call_data)
{
 if (aapply && (*((long *) client_data) != *((long *) call_data)))
   {
     *((long *) client_data) = *((long *) call_data);
     if (G_low_threshold > G_high_threshold)
       {
	 G_high_threshold=G_low_threshold;
	 gimp_change_item(dialog_ID,G_high_scale_ID,sizeof(G_high_threshold),&G_high_threshold);
       }
     if (rgb_lock)
       {
	 R_low_threshold=G_low_threshold;
	 gimp_change_item(dialog_ID,R_low_scale_ID,sizeof(R_low_threshold),&R_low_threshold);
	 R_high_threshold=G_high_threshold;
	 gimp_change_item(dialog_ID,R_high_scale_ID,sizeof(R_high_threshold),&R_high_threshold);
	 B_low_threshold=G_low_threshold;
	 gimp_change_item(dialog_ID,B_low_scale_ID,sizeof(B_low_threshold),&B_low_threshold);
	 B_high_threshold=G_high_threshold;
	 gimp_change_item(dialog_ID,B_high_scale_ID,sizeof(B_high_threshold),&B_high_threshold);
       }
     level_rgb(input,output);
     gimp_update_image(output);
   }
 else
   *((long *) client_data) = *((long *) call_data);
}

static void G_high_scale_callback (int item_ID, void *client_data, void *call_data)
{
 if (aapply && (*((long *) client_data) != *((long *) call_data)))
   {
     *((long *) client_data) = *((long *) call_data);
     if (G_high_threshold < G_low_threshold)
       {
	 G_low_threshold=G_high_threshold;
	 gimp_change_item(dialog_ID,G_low_scale_ID,sizeof(G_low_threshold),&G_low_threshold);
       }
     if (rgb_lock)
       {
	 R_low_threshold=G_low_threshold;
	 gimp_change_item(dialog_ID,R_low_scale_ID,sizeof(R_low_threshold),&R_low_threshold);
	 R_high_threshold=G_high_threshold;
	 gimp_change_item(dialog_ID,R_high_scale_ID,sizeof(R_high_threshold),&R_high_threshold);
	 B_low_threshold=G_low_threshold;
	 gimp_change_item(dialog_ID,B_low_scale_ID,sizeof(B_low_threshold),&B_low_threshold);
	 B_high_threshold=G_high_threshold;
	 gimp_change_item(dialog_ID,B_high_scale_ID,sizeof(B_high_threshold),&B_high_threshold);
       }
     level_rgb(input,output);
     gimp_update_image(output);
   }
 else
   *((long *) client_data) = *((long *) call_data);
}

/* Blue */
static void B_low_scale_callback (int item_ID, void *client_data, void *call_data)
{
  if (aapply && (*((long *) client_data) != *((long *) call_data)))
    {
     *((long *) client_data) = *((long *) call_data);
     if (B_low_threshold > B_high_threshold)
       {
	 B_high_threshold=B_low_threshold;
	 gimp_change_item(dialog_ID,B_high_scale_ID,sizeof(B_high_threshold),&B_high_threshold);
       }
     if (rgb_lock)
       {
	 R_low_threshold=B_low_threshold;
	 gimp_change_item(dialog_ID,R_low_scale_ID,sizeof(R_low_threshold),&R_low_threshold);
	 R_high_threshold=B_high_threshold;
	 gimp_change_item(dialog_ID,R_high_scale_ID,sizeof(R_high_threshold),&R_high_threshold);
	 G_low_threshold=B_low_threshold;
	 gimp_change_item(dialog_ID,G_low_scale_ID,sizeof(G_low_threshold),&G_low_threshold);
	 G_high_threshold=B_high_threshold;
	 gimp_change_item(dialog_ID,G_high_scale_ID,sizeof(G_high_threshold),&G_high_threshold);
       }
     level_rgb(input,output);
     gimp_update_image(output);
    }
 else
   *((long *) client_data) = *((long *) call_data);
}

static void B_high_scale_callback (int item_ID, void *client_data, void *call_data)
{
 if (aapply && (*((long *) client_data) != *((long *) call_data)))
   {
     *((long *) client_data) = *((long *) call_data);
     if (B_high_threshold < B_low_threshold)
       {
	 B_low_threshold=B_high_threshold;
	 gimp_change_item(dialog_ID,B_low_scale_ID,sizeof(B_low_threshold),&B_low_threshold);
       }
     if (rgb_lock)
       {
	 R_low_threshold=B_low_threshold;
	 gimp_change_item(dialog_ID,R_low_scale_ID,sizeof(R_low_threshold),&R_low_threshold);
	 R_high_threshold=B_high_threshold;
	 gimp_change_item(dialog_ID,R_high_scale_ID,sizeof(R_high_threshold),&R_high_threshold);
	 G_low_threshold=B_low_threshold;
	 gimp_change_item(dialog_ID,G_low_scale_ID,sizeof(G_low_threshold),&G_low_threshold);
	 G_high_threshold=B_high_threshold;
	 gimp_change_item(dialog_ID,G_high_scale_ID,sizeof(G_high_threshold),&G_high_threshold);
       }
     
     level_rgb(input,output);
     gimp_update_image(output);
   }
 else
   *((long *) client_data) = *((long *) call_data);
}

/******************************************************************************************
 *
 *    CALLBACKS
 *
 *****************************************************************************************/

static void ok_callback (int item_ID, void *client_date, void *call_data)
{
  gimp_close_dialog(dialog_ID,1);
}

static void cancel_callback (int item_ID, void *client_date, void *call_data)
{
  gimp_close_dialog(dialog_ID,0);
}
static void open_ok_callback (int item_ID, void *client_date, void *call_data)
{
  gimp_close_dialog(opening_dialog_ID,1);
}

static void open_cancel_callback (int item_ID, void *client_date, void *call_data)
{
  gimp_close_dialog(opening_dialog_ID,0);
}

static void rgb_lock_callback (int item_ID, void *client_data, void *call_data)
{
  *((long *) client_data) = *((long *) call_data);

 if (rgb_lock)
   {
     G_low_threshold=R_low_threshold;
     gimp_change_item(dialog_ID,G_low_scale_ID,sizeof(G_low_threshold),&G_low_threshold);
     G_high_threshold=R_high_threshold;
     gimp_change_item(dialog_ID,G_high_scale_ID,sizeof(G_high_threshold),&G_high_threshold);
     B_low_threshold=R_low_threshold;
     gimp_change_item(dialog_ID,B_low_scale_ID,sizeof(B_low_threshold),&B_low_threshold);
     B_high_threshold=R_high_threshold;
     gimp_change_item(dialog_ID,B_high_scale_ID,sizeof(B_high_threshold),&B_high_threshold);
     level(input,output);
     gimp_update_image(output);
   }
}

static void open_new_callback (int item_ID, void *client_data, void *call_data)
{
  *((long *) client_data) = *((long *) call_data);
}

static void aapply_callback (int item_ID, void *client_data, void *call_data)
{
  *((long *) client_data) = *((long *) call_data);

  if (aapply)
    {
      level(input,output);
      gimp_update_image(output);
    }
  else
    {
      freshen_to_original();
      gimp_update_image(output);
    }
}















