#include <gtk/gtk.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "region.h"
#include "at_type.h"
#include "at_track.h"
#include "at_view.h"
#include "libatech.h"

/* I don't like this.. it needs to be in the clip structure and the clip
   needs to be obtained elsewhere... */
static gchar *record_track = NULL;

static void at_track_mute_cmd_callback(GtkWidget *widget, gpointer *data);

/* imported from at_interface.c. */
extern GtkWidget *scrolled_window_vbox;

/* imported from at_clip.c */
extern int global_clip_ID;


GSList *track_list = NULL;

Track *
at_track_new (gint clip_ID,
	      size_t offset,
	      size_t length, 	      
	      gint type,
	      gchar *name, 
	      gfloat volume,
	      gint mode)
{
  Track *new_track;
  
  new_track = g_malloc0 (sizeof (Track));
    
  new_track->name = g_strdup (name);
  new_track->mute = FALSE;

  /* the track adjustments */
  new_track->adjustments = NULL;

  new_track->length = length;
  new_track->type = type;
  new_track->start_offset = offset;

  new_track->bytes = at_type_bytes (type);
  new_track->volume = volume;
  new_track->mode = mode;
  
  new_track->ID = global_clip_ID++;  
  new_track->clip_ID = clip_ID;

  new_track->data = region_new (length, new_track->bytes);

  /* preview stuff for wave widget */
  new_track->preview[0] = NULL;
  new_track->preview[1] = NULL;
  new_track->preview_len = 0;
  new_track->preview_compression = 800;

  track_list = g_slist_append (track_list, new_track);

  return new_track;
}  

void
at_track_delete (Track *track)
{
  g_free (track->name);
  
  region_delete (track->data);
  /*
  while (track->adjuments)
    {
      adjustment_delete (track->adjustment);
    }
    */

  track_list = g_slist_remove (track_list, track);
  g_free (track);
}


Track *
at_track_get_ID (gint ID)
{
  GSList *tmp = track_list;
  Track *track;

  while (tmp) 
    {
      track = (Track *) tmp->data;
      if (track->ID == ID)
	return track;

      tmp = tmp->next;
    }

  return NULL;
}

void
at_track_translate (Track *track, size_t new_offset)
{
  track->start_offset += new_offset;
  
  at_track_dirty (track);
  at_track_invalidate_thumbnail (track->ID);

}

void
at_track_invalidate_thumbnail (int track_ID)
{
  /* FIXME: should really do something here :) */
}

gint 
at_track_has_alpha (Track *track)
{
  if (track->type == AT_RLA || 
      track->type == AT_MONOA || 
      track->type == AT_RLFRA)
    return TRUE;
  else
    return FALSE;
}

void
at_track_dirty (Track *track)
{
  track->dirty++;
}


void
at_track_build_preview (Track *track)
{
  gint i;
  gint preview_len;
  atdata *track_data;
  gint num_channels;
  TmpRegion *region;

  /* this isn't working - segv *shrug* */
  /* track_data = at_track_get_track_data (track); */

  region = tmp_region_new (track->data, 0, track->data->length);

  track_data = region->data;

  if (track->preview[0])
    g_free(track->preview[0]);
  
  if (track->preview[1])
    g_free(track->preview[1]);
  
  track->preview[0] = NULL;
  track->preview[1] = NULL;
  track->preview_len = 0;

  if (track_data == NULL) 
    return;

  preview_len = track->length / track->preview_compression;


  num_channels = at_type_channels (track->type);
  g_print ("preview_len is %d, compression is %d, track len is %d, num_channels is %d\n", 
	   preview_len, track->preview_compression, track->length, num_channels);

  track->preview_len = preview_len;


  if (num_channels == 2) {

    track->preview[0] = g_malloc (preview_len * sizeof (gfloat)); 
    track->preview[1] = g_malloc (preview_len * sizeof (gfloat)); 
    
    for (i=0; i < preview_len; i++) {
      track->preview[0][i] = track_data[i * track->preview_compression];
      track->preview[1][i] = track_data[i * track->preview_compression + sizeof (gfloat)];
    }
  } else {
    
    track->preview[0] = g_malloc (preview_len * sizeof (gfloat)); 

    for (i=0; i < preview_len; i++) {
      track->preview[0][i] = track_data[i * track->preview_compression];
    }
  }

  tmp_region_destroy (region);

  /* left and right previews */
  if (track->preview[0])
    gtk_wave_set_data (GTK_WAVE (track->wave_widget), 0, 
		       track->preview[0], track->preview_len);  
  if (track->preview[1])
    gtk_wave_set_data (GTK_WAVE (track->wave_widget), 1, 
		       track->preview[1], track->preview_len);  

  g_print ("done creating track preview\n");
}


void
at_track_new_cmd_callback (GtkWidget *widget, gpointer data)
{
  View  *view;
  Track *track;

  /* FIXME this is ugly, but it's relatively sane from the moment I think
     god I am writting some ugly code right now... --Larry */
  if (data != NULL)
    view = (View *)data;
  else
    view = at_view_active ();

  /* FIXME: need to make sure we handle the pathological cases... */
  /* FIXME: we need to build a new_track dialog here... :) */
  track = at_track_new (view->clip->ID, 0, 200, AT_RL, "New Track", 1.0, 0);
  
  at_clip_add_track (view->clip, track, 
		     at_clip_get_track_index (view->clip,
					      view->clip->active_track));
  at_views_update (view->clip->ID);
}

void
at_track_delete_cmd_callback (GtkWidget *widget, gpointer data)
{
  View *view;
  Track *track = NULL;

  /* FIXME this is ugly, but it's relatively sane from the moment I think
     god I am writting some ugly code right now... --Larry */
  if (data != NULL)
    view = (View *)data;
  else
    view = at_view_active ();

  if ((track = at_track_get_ID (view->clip->active_track)))
    {
      at_clip_remove_track (view->clip, view->clip->active_track);
      at_track_delete (track);
    }

  /* set dirty flag for clip so it will be remixed */
  view->clip->dirty = TRUE;
  at_views_update (view->clip->ID);
}


void 
at_track_raise_cmd_callback (GtkWidget *widget, gpointer data)
{
  View  *view;

  if (data != NULL)
    view = data;
  else
    view = at_view_active ();
  
  at_clip_raise_track (view->clip, view->clip->active_track);
  at_views_update (view->clip->ID);
}
  
void
at_track_lower_cmd_callback (GtkWidget *widget, gpointer data)
{
  View *view;
  
  if (data != NULL)
    view = data;
  else
    view = at_view_active ();
  
  at_clip_lower_track (view->clip, view->clip->active_track);
  at_views_update (view->clip->ID);
}


gchar *
at_track_get_record_track(void)
{
  /* FIXME I don't like the record_track temp storage... grrr... */
  /* 
   * eventually the record stuff should probably go into a floating selection 
   */
  if (record_track)
    {
      g_free (record_track);
      record_track = NULL;
    }

  return (record_track = tempnam ("./", "atrec"));
}

void
at_track_record_done (Clip *clip)
{
  Track *track;

  /* ignore most of the crap in here, it's just test stuff */
  track = at_track_get_ID (clip->active_track);

  /* need remixing.. */
  clip->dirty = TRUE;
  
  if (track)
    {
      AudioRegion *old;
      Clip *clip;

      old = track->data;
      track->data = region_new_from_file (record_track,
					  at_type_bytes (track->type));
      if (!track->data)
	{
	  track->data = old;
	  g_warning ("why no file????");
	}
      else
	{
	  track->length = track->data->length;
	  g_print ("new length = %d, old->length = %d track_ID %d\n", track->length, 
		   old->length, track->ID);
	  region_delete (old);
	}

      clip = at_clip_get_ID (track->clip_ID);

      if (track->length > clip->length) 
	at_clip_resize (clip, track->length, 0);
      
    }
  else 
    {
      g_warning ("screwed up record track");
    }

  at_track_build_preview (track);
}


/* GUI section - from here on, it's all callbacks and GUI code. */
static void 
at_track_mute_cmd_callback (GtkWidget *widget, gpointer *data)
{
    gint track_ID = (gint) data;
    Track *track;
    Clip *clip;

    /* FIXME the suspend flag is because of the set state in the creation
       routine it's not well implemented, but I don't care right now :) */
    
    track = at_track_get_ID (track_ID);
    
    if (GTK_TOGGLE_BUTTON (widget)->active) {
      g_print ("muting track %d\n", track_ID);
      track->mute = TRUE;
    } else {
      g_print ("un-muting track %d\n", track_ID);
      track->mute = FALSE;
    }
    
    /* this one is muted now, we have to remix. */
    clip = at_clip_get_ID (track->clip_ID);
    clip->dirty = TRUE;
    at_clip_update(clip);
}

static void 
at_track_wave_compression_cmd_callback (GtkWidget *widget, gpointer *data)
{
    gint track_ID = (gint) data;
    gint range;
    Track *track;
    GtkWidget *spinner;
    
    track = at_track_get_ID (track_ID);
    
    spinner = track->spinner;
    
    range = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spinner));

    if (range == track->preview_compression)
      return;

    track->preview_compression = range * 10;

    at_track_build_preview (track);

    /* left and right previews */
    if (track->preview[0])
      gtk_wave_set_data (GTK_WAVE (track->wave_widget), 0, 
			 track->preview[0], track->preview_len);  
    if (track->preview[1])
      gtk_wave_set_data (GTK_WAVE (track->wave_widget), 1, 
			 track->preview[1], track->preview_len);  

}

GtkWidget *at_track_gui_new (View *view, gint id)
{
    GtkWidget *main_hbox;
    GtkWidget *button;
    GtkWidget *frame;
    GtkWidget *hbox;
    GtkWidget *vbox;
    GtkWidget *spinner;
    GtkAdjustment *adj;
    gchar buf[128];
    Track *track;

    track = at_track_get_ID (id);
    /* first, the top hbox */
    main_hbox = gtk_hbox_new (FALSE, 5);
    gtk_container_border_width (GTK_CONTAINER (main_hbox), 5);
    
    /* frame for the whole track. */
    sprintf(buf,"%s (%d)", track->name, track->ID);
    frame = gtk_frame_new (buf);
    gtk_box_pack_start (GTK_BOX (main_hbox), frame, TRUE, TRUE, 0);

    
    hbox = gtk_hbox_new (FALSE, 5);
    gtk_container_border_width (GTK_CONTAINER (hbox), 5);
    gtk_container_add (GTK_CONTAINER (frame), hbox);

    vbox = gtk_vbox_new (FALSE, 5);
    gtk_container_border_width (GTK_CONTAINER (vbox), 5);
    gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 2);

    /* the mute button */
    button = gtk_toggle_button_new_with_label ("Mute");
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (at_track_mute_cmd_callback),
			(gpointer) id);
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button),
				 track->mute ? TRUE: FALSE);
    gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 2);
    
    /* spin button for wave range */
    adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) track->preview_compression / 10, 
						10.0, 200.0, 10.0,
						5.0, 0.0);
    spinner = track->spinner = gtk_spin_button_new (adj, 0, 0);
    gtk_box_pack_start (GTK_BOX (vbox), spinner, FALSE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			GTK_SIGNAL_FUNC (at_track_wave_compression_cmd_callback),
			(gpointer) id);

    /* wave widget */
    track->wave_widget = gtk_wave_new ();
    gtk_widget_set_usize (GTK_WIDGET(track->wave_widget), -1, 100);
    gtk_wave_set_vertical_range (GTK_WAVE (track->wave_widget), 2);
    gtk_box_pack_start (GTK_BOX (hbox), track->wave_widget, TRUE, TRUE, 2);

    if (track->preview[0])
      gtk_wave_set_data (GTK_WAVE (track->wave_widget), 0, 
			 track->preview[0], track->preview_len);  
    if (track->preview[1])
      gtk_wave_set_data (GTK_WAVE (track->wave_widget), 1, 
			 track->preview[1], track->preview_len);  

    gtk_object_set_user_data (GTK_OBJECT (main_hbox), (gpointer) id);

    gtk_widget_show_all (main_hbox);
    return (main_hbox);
}














