/*
 * Program:	DCE server login
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	1 August 1988
 * Last Edited:	13 March 1997
 *
 * Copyright 1997 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made available
 * "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/* Server log in
 * Accepts: user name string
 *	    password string
 *	    argument count
 *	    argument vector
 * Returns: T if password validated, NIL otherwise
 */

#include <dce/rpc.h>
#include <dce/sec_login.h>

long server_login (char *user,char *pass,int argc,char *argv[])
{
  sec_passwd_rec_t pwr;
  sec_login_handle_t lhdl;
  boolean32 rstpwd;
  sec_login_auth_src_t asrc;
  error_status_t status;
  FILE *fd;
  char *tmp = NIL;
  long ret = NIL;
  struct passwd *pw = getpwnam (user);
				/* allow case-independent match */
  if (!pw) pw = getpwnam (lcase (tmp = cpystr (user)));
  if (pw && pw->pw_uid &&	/* validate user and password */
      !strcmp (pw->pw_passwd,(char *) crypt (pass,pw->pw_passwd))) ret = T;
				/* try DCE password cache file */
  else if (fd = fopen (PASSWD_OVERRIDE, "r")) {
    while ((pw = fgetpwent (fd)) && strcmp (user,pw->pw_name));
    if (pw && pw->pw_uid &&	/* validate user and password */
	!strcmp (pw->pw_passwd,(char *) crypt (pass,pw->pw_passwd))) ret = T;
    fclose (fd);		/* finished with cache file */
  }
  if (!ret) {			/* try DCE (slow...) */
    sec_login_setup_identity ((unsigned_char_p_t) user,sec_login_no_flags,
			      &lhdl,&status);
    if (status == error_status_ok) {
      pwr.key.tagged_union.plain = (idl_char *) pass;
      pwr.key.key_type = sec_passwd_plain;
      pwr.pepper = NIL;
      pwr.version_number = sec_passwd_c_version_none;
				/* validate password with login context */
      sec_login_validate_identity (lhdl,&pwr,&rstpwd,&asrc,&status);
      if (status == error_status_ok) {
	sec_login_purge_context (&lhdl,&status);
	if (status == error_status_ok) ret = T;
      }
    }
  }
  if (ret) {
    setgid (pw->pw_gid);	/* all OK, login in as that user */
				/* initialize groups */
    initgroups (pw->pw_name,pw->pw_gid);
    setuid (pw->pw_uid);	/* become the guy */
    chdir (pw->pw_dir);		/* set home directory as default */
    env_init (pw->pw_name,pw->pw_dir);
  }
  if (tmp) fs_give ((void **) &tmp);
  return ret;
}
