/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __AREAS_H__
#define __AREAS_H__

#include "glib.h"


typedef struct _GimpPoint GimpPoint;
typedef struct _GimpArea GimpArea;

struct _GimpPoint {
  gint x;
  gint y;
};

struct _GimpArea {
  GimpPoint a;
  GimpPoint b;
};



#define ga_width(ga)  ((ga)->b.x - (ga)->a.x)
#define ga_height(ga) ((ga)->b.y - (ga)->a.y)



/* check validity of tile coords */
#define ga_tile_ok(buffer,area) \
  (((area)->a.x <  0 || \
    (area)->a.x >= (area)->b.x || \
    (area)->a.y <  0 || \
    (area)->a.y >= (area)->b.y || \
    (area)->b.x >  gimp_buffer_xtiles (buffer) || \
    (area)->b.y >  gimp_buffer_ytiles (buffer)) \
   ? 0 \
   : 1)

#define gp_tile_ok(buffer,point) \
  (((point)->x <  0 || \
    (point)->y <  0 || \
    (point)->x >= gimp_buffer_xtiles (buffer) || \
    (point)->y >= gimp_buffer_ytiles (buffer)) \
   ? 0 \
   : 1)


/* check validity of buffer relative coords */
#define ga_buffer_ok(buffer,area) \
  (((area)->a.x <  0 || \
    (area)->a.x >= (area)->b.x || \
    (area)->a.y <  0 || \
    (area)->a.y >= (area)->b.y || \
    (area)->b.x >  (gimp_buffer_tilewidth (buffer) * \
                    gimp_buffer_xtiles (buffer)) || \
    (area)->b.y >  (gimp_buffer_tileheight (buffer) * \
                    gimp_buffer_ytiles (buffer))) \
   ? 0 \
   : 1)

#define gp_buffer_ok(buffer,point) \
  (((point)->a.x <  0 || \
    (point)->a.y <  0 || \
    (point)->a.x >= (gimp_buffer_tilewidth (buffer) * \
                     gimp_buffer_xtiles (buffer)) || \
    (point)->a.y >= (gimp_buffer_tileheight (buffer) * \
                     gimp_buffer_ytiles (buffer))) \
   ? 0 \
   : 1)


/* check validity of image relative coords */
#define ga_image_ok(buffer,area) \
  (((area)->a.x <  0 || \
    (area)->a.x >= (area)->b.x || \
    (area)->a.y <  0 || \
    (area)->a.y >= (area)->b.y || \
    (area)->b.x >  gimp_buffer_width (buffer) || \
    (area)->b.y >  gimp_buffer_height (buffer)) \
   ? 0 \
   : 1)

#define gp_image_ok(buffer,point) \
  (((point)->a.x <  0 || \
    (point)->a.y <  0 || \
    (point)->a.x >= gimp_buffer_width (buffer) || \
    (point)->a.y >= gimp_buffer_height (buffer)) \
   ? 0 \
   : 1)




   
/* convert between coord systems, tile <-> buffer <-> image */

#define ga_tile_to_buffer(buffer,area) \
  ((area)->a.x *= gimp_buffer_tilewidth (buffer), \
   (area)->a.y *= gimp_buffer_tileheight (buffer), \
   (area)->b.x *= gimp_buffer_tilewidth (buffer), \
   (area)->b.y *= gimp_buffer_tileheight (buffer))

#define gp_tile_to_buffer(buffer,point) \
  ((point)->x *= gimp_buffer_tilewidth (buffer), \
   (point)->y *= gimp_buffer_tileheight (buffer))



#define ga_buffer_to_tile(buffer,area) \
  ((area)->a.x /= gimp_buffer_tilewidth (buffer), \
   (area)->a.y /= gimp_buffer_tileheight (buffer), \
   (area)->b.x /= gimp_buffer_tilewidth (buffer), \
   (area)->b.y /= gimp_buffer_tileheight (buffer))

#define gp_buffer_to_tile(buffer,point) \
  ((point)->x /= gimp_buffer_tilewidth (buffer), \
   (point)->y /= gimp_buffer_tileheight (buffer))



#define ga_buffer_to_image(buffer,area) \
  ((area)->a.x -= gimp_buffer_xoff (buffer), \
   (area)->a.y -= gimp_buffer_yoff (buffer), \
   (area)->b.x -= gimp_buffer_xoff (buffer), \
   (area)->b.y -= gimp_buffer_yoff (buffer))

#define gp_buffer_to_image(buffer,area) \
  ((point)->x -= gimp_buffer_xoff (buffer), \
   (point)->y -= gimp_buffer_yoff (buffer))



#define ga_image_to_buffer(buffer,area) \
  ((area)->a.x += gimp_buffer_xoff (buffer), \
   (area)->a.y += gimp_buffer_yoff (buffer), \
   (area)->b.x += gimp_buffer_xoff (buffer), \
   (area)->b.y += gimp_buffer_yoff (buffer))

#define gp_image_to_buffer(buffer,area) \
  ((point)->x += gimp_buffer_xoff (buffer), \
   (point)->y += gimp_buffer_yoff (buffer))






/* decrease val to tile boundary */
#define GET_MIN(val,period) ((val) - ((val) % (period)))


/* increase val to tile boundary */
#define GET_MAX(val,period) ((val) % (period) \
                             ? (val) + (period) - ((val) % (period)) \
                             : (val))



#if 0

  /* trim to whole tiles */
  p = &portion->min;
  p->a.x = GET_MAX (roi->a.x, buffer->_x.period);
  p->a.y = GET_MAX (roi->a.y, buffer->_y.period);
  p->b.x = GET_MIN (roi->b.x, buffer->_x.period);
  p->b.y = GET_MIN (roi->b.y, buffer->_y.period);
  if (p->b.x < p->a.x) p->b.x = p->a.x;
  if (p->b.y < p->a.y) p->b.y = p->a.y;
  
  /* expand to whole tiles */
  p = &portion->max;
  p->a.x = GET_MIN (roi->a.x, buffer->_x.period);
  p->a.y = GET_MIN (roi->a.y, buffer->_y.period);
  p->b.x = GET_MAX (roi->b.x, buffer->_x.period);
  p->b.y = GET_MAX (roi->b.y, buffer->_y.period);
  
  /* expand to single tile */
  p = &portion->bounds;
  p->a.x = GET_MIN (roi->a.x, buffer->_x.period);
  p->a.y = GET_MIN (roi->a.y, buffer->_y.period);
  p->b.x = GET_MAX (roi->a.x, buffer->_x.period);
  p->b.y = GET_MAX (roi->a.y, buffer->_y.period);
  if (p->b.x == p->a.x) p->b.x = p->a.x + buffer->_x.period;
  if (p->b.y == p->a.y) p->b.y = p->a.y + buffer->_y.period;

  /* trim to single tile */
  p = &portion->focus;
  p->a.x = roi->a.x;
  p->a.y = roi->a.y;
  p->b.x = MIN (roi->b.x, portion->bounds.b.x);
  p->b.y = MIN (roi->b.y, portion->bounds.b.y);

#endif

#endif



