/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include "buffer.h"
#include "areas.h"

#define K GIMP_BUFFER_CLASS(buffer->klass)


void
gimp_buffer_delete (GimpBuffer *buffer)
{
  g_return_if_fail (buffer != NULL);
  g_return_if_fail (buffer->klass != NULL);
  g_return_if_fail (K->delete != NULL);

  K->delete (buffer);
}


gboolean
gimp_buffer_alloc (GimpBuffer        *buffer,
                   GimpArea          *area,
                   Alloc              how)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (K->alloc != NULL, FALSE);
  g_return_val_if_fail (area != NULL, FALSE);
  
  if (! ga_tile_ok (buffer, area)) return FALSE;

  return K->alloc (buffer, area, how);
}


gboolean
gimp_buffer_map (GimpBuffer    *buffer,
                 GimpArea      *darea,
                 GimpBuffer    *src,
                 GimpArea      *sarea)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);  
  g_return_val_if_fail (K->map != NULL, FALSE);
  g_return_val_if_fail (darea != NULL, FALSE);
  g_return_val_if_fail (src != NULL, FALSE);
  g_return_val_if_fail (sarea != NULL, FALSE);

  g_return_val_if_fail (K->type == GIMP_BUFFER_CLASS(src->klass)->type, FALSE);
  g_return_val_if_fail (buffer->_x.tile.size == src->_x.tile.size, FALSE);
  g_return_val_if_fail (buffer->_y.tile.size == src->_y.tile.size, FALSE);

  if (! ga_tile_ok (buffer, darea)) return FALSE;
  if (! ga_tile_ok (src, sarea)) return FALSE;

  return K->map (buffer, darea, src, sarea);
}


gboolean
gimp_buffer_validate (GimpBuffer        *buffer,
                      GimpArea          *area,
                      Validate           how)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (K->validate != NULL, FALSE);
  g_return_val_if_fail (area != NULL, FALSE);
  
  if (! ga_tile_ok (buffer, area)) return FALSE;

  return K->validate (buffer, area, how);
}


GimpMemPtr *
gimp_buffer_use (GimpBuffer        *buffer,
                 GimpPoint         *tile,
                 Use                how)
{
  GimpPoint p = {0,0};

  g_return_val_if_fail (buffer != NULL, NULL);
  g_return_val_if_fail (buffer->klass != NULL, NULL);
  g_return_val_if_fail (K->use != NULL, NULL);

  if (tile == NULL)
    tile = &p;
  
  if (! gp_tile_ok (buffer, tile)) return NULL;

  return K->use (buffer, tile, how);
}


gboolean
gimp_buffer_valid (GimpBuffer    *buffer,
                   GimpPoint     *tile)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (K->valid != NULL, FALSE);
  g_return_val_if_fail (tile != NULL, FALSE);

  if (! gp_tile_ok (buffer, tile)) return FALSE;
  
  return K->valid (buffer, tile);
}

