/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "gameover.h"
#include "mainmenu.h"

GameOver
  GameOver::m_instance;

void
GameOver::setLevelsetFilename (string levelsetFilename)
{
  this->levelsetFilename = levelsetFilename;
}

void
GameOver::init ()
{
  string location = LEVELPATH + "/" + levelsetFilename + "/ball.png";
  SDL_Surface *temp = IMG_Load (location.c_str ());
  if (temp != NULL)
    imgBall = SDL_DisplayFormat (temp);
  SDL_FreeSurface (temp);
  SDL_SetColorKey (imgBall, SDL_SRCCOLORKEY | SDL_RLEACCEL, 0x00ff00ff);
  start ();
}

void
GameOver::setBallCount (int ball_count)
{
  m_balls_left = m_ball_count = ball_count;
  time = 3000 + ball_count * 500;
}

void
GameOver::cleanup ()
{
  SDL_FreeSurface (imgBall);
}

void
GameOver::pause ()
{
}

void
GameOver::resume ()
{
}

void
GameOver::start ()
{
  currentTime = 0;
}

void
GameOver::handleEvents (GameStateManager * gameStateManager)
{
  SDL_Event event;

  if (SDL_PollEvent (&event))
    {
      switch (event.type)
	{
	case SDL_QUIT:
	  gameStateManager->quit ();
	  break;
	case SDL_KEYDOWN:
	  break;
	}
    }
}

void
GameOver::draw (GameStateManager * gameStateManager)
{
  SDL_FillRect (gameStateManager->screen, NULL,
		SDL_MapRGB (gameStateManager->screen->format, 224, 224, 224));
  for (int i = 0; i < m_balls_left; i++)
    {
      SDL_Rect s = { 0, 0, 10, 10 };
      SDL_Rect d = { 160 + 10 * i, 100, 0, 0 };
      SDL_BlitSurface (imgBall, &s, gameStateManager->screen, &d);
    }
  stringstream ssScore (stringstream::in | stringstream::out);
  ssScore << gameStateManager->getScore ();
  string strScore;
  int scoreBuffer = 5 - ssScore.str ().length ();
  if (scoreBuffer < 0)
    scoreBuffer = 0;
  for (int i = 0; i < scoreBuffer; i++)
    strScore += ' ';
  strScore += ssScore.str ();
  gameStateManager->drawString (FONT_INACTIVE, strScore.c_str (), 400, 300);
}

void
GameOver::update (GameStateManager * gameStateManager)
{
  currentTime += gameStateManager->getTime ();
  int prev_balls_left = m_balls_left;
  m_balls_left = m_ball_count - currentTime / 500;
  if (m_balls_left < 0)
    m_balls_left = 0;
  if (m_balls_left != prev_balls_left)
    {
      gameStateManager->setScore (gameStateManager->getScore () + 500);
      gameStateManager->playSound ("bonustick");
    }
  if (currentTime >= time)
    gameStateManager->popState ();
}
