/* LocaleInformation_km.java --
   Copyright (C) 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_km extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "KHR";

  private static final String currenciesDisplayNameValues = "Riel";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "KHR";

  private static final String currenciesSymbolValues = "\u17db";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u17e1",
    "\u17e2",
    "\u17e3",
    "\u17e4",
    "\u17e5",
    "\u17e6",
    "\u17e7",
    "\u17e8",
    "\u17e9",
    "\u17e1\u17e0",
    "\u17e1\u17e1",
    "\u17e1\u17e2",
    null,
  };

  private static final String[] months = {
    "\u1798\u1780\u179a\u17b6",
    "\u1780\u17bb\u1798\u17d2\u1797\u17c8",
    "\u1798\u17b7\u1793\u17b6",
    "\u1798\u17c1\u179f\u17b6",
    "\u17a7\u179f\u1797\u17b6",
    "\u1798\u17b7\u1790\u17bb\u1793\u17b6",
    "\u1780\u1780\u17d2\u1780\u178a\u17b6",
    "\u179f\u17b8\u17a0\u17b6",
    "\u1780\u1789\u17d2\u1789\u17b6",
    "\u178f\u17bb\u179b\u17b6",
    "\u179c\u17b7\u1785\u17d2\u1786\u17b7\u1780\u17b6",
    "\u1792\u17d2\u1793\u17bc",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u17a2\u17b6",
    "\u1785",
    "\u17a2",
    "\u1796\u17bb",
    "\u1796\u17d2\u179a",
    "\u179f\u17bb",
    "\u179f",
  };

  private static final String[] weekdays = {
    null,
    "\u1790\u17d2\u1784\u17c3\u200b\u17a2\u17b6\u1791\u17b7\u178f\u17d2\u1799",
    "\u1790\u17d2\u1784\u17c3\u200b\u1785\u17d0\u1793\u17d2\u1791",
    "\u1790\u17d2\u1784\u17c3\u200b\u17a2\u1784\u17d2\u1782\u17b6\u179a",
    "\u1790\u17d2\u1784\u17c3\u200b\u1796\u17bb\u1792",
    "\u1790\u17d2\u1784\u17c3\u200b\u1796\u17d2\u179a\u17a0\u179f\u17d2\u1794\u178f\u17b7\u17cd",
    "\u1790\u17d2\u1784\u17c3\u200b\u179f\u17bb\u1780\u17d2\u179a",
    "\u1790\u17d2\u1784\u17c3\u200b\u179f\u17c5\u179a\u17cd",
  };

  private static final String[] ampms = {
    "\u1796\u17d2\u179a\u17b9\u1780",
    "\u179b\u17d2\u1784\u17b6\u1785",
  };

  private static final String territoriesKeys = "TL\u00A6TJ\u00A6TH\u00A6TG\u00A6GY\u00A6TD\u00A6GW\u00A6GT\u00A6GR\u00A6GQ\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6SV\u00A6GH\u00A6SR\u00A6GE\u00A6SO\u00A6SN\u00A6SL\u00A6GA\u00A6SK\u00A6SI\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SA\u00A6FR\u00A6FM\u00A6RW\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6DO\u00A6PY\u00A6DM\u00A6DK\u00A6DJ\u00A6PT\u00A6PS\u00A6PR\u00A6DE\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6CZ\u00A6PE\u00A6CY\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BT\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BJ\u00A6BI\u00A6BH\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6AZ\u00A6NE\u00A6ZM\u00A6AU\u00A6NA\u00A6AT\u00A6AR\u00A6MZ\u00A6AO\u00A6MY\u00A6MX\u00A6AM\u00A6AL\u00A6ZA\u00A6MU\u00A6MT\u00A6MR\u00A6AF\u00A6AE\u00A6AD\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6YU\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LB\u00A6LA\u00A6KZ\u00A6KW\u00A6KR\u00A6KP\u00A6KM\u00A6KI\u00A6WS\u00A6KH\u00A6KG\u00A6KE\u00A6JP\u00A6JO\u00A6JM\u00A6VN\u00A6VE\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6TW\u00A6HK\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "\u1791\u17b8\u1798\u17d0\u179a\u1781\u17b6\u1784\u1780\u17be\u178f\u00A6\u178f\u17b6\u178a\u17a0\u17d2\u179f\u17c9\u17b8\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb\u00A6\u1790\u17c3\u00A6\u178f\u17bc\u17a0\u17d2\u1782\u17bc\u00A6\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u178e\u17b6\u00A6\u1786\u17b6\u178a\u00A6\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u1794\u17ca\u17b8\u179f\u17bc\u00A6\u17a0\u17d2\u1782\u17b6\u178f\u17c1\u1798\u17c9\u17b6\u17a1\u17b6\u00A6\u1780\u17d2\u179a\u17b7\u1785\u00A6\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a\u00A6\u179f\u17bc\u17a0\u17d2\u179f\u17c9\u17b8\u17a1\u1784\u17cb\u00A6\u179f\u17ca\u17b8\u179a\u17b8\u00A6\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u00A6\u17a0\u17d2\u1782\u17b6\u17c6\u1794\u17ca\u17b8\u00A6\u17a2\u17c2\u179b\u179f\u17b6\u179b\u17cb\u179c\u17c9\u17b6\u178c\u17d0\u179a\u00A6\u17a0\u17d2\u1780\u17b6\u178e\u17b6\u00A6\u179f\u17bc\u179a\u17b8\u178e\u17b6\u1798\u00A6\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17c9\u17b8\u00A6\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8\u00A6\u179f\u17c1\u1793\u17c1\u17a0\u17d2\u1780\u17b6\u179b\u17cb\u00A6\u179f\u17c1\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793\u00A6\u17a0\u17d2\u1782\u17b6\u1794\u17bb\u1784\u00A6\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8\u00A6\u179f\u17d2\u179b\u17bc\u179c\u17c1\u1793\u17b8\u00A6\u179f\u17b7\u1784\u17d2\u17a0\u1794\u17bb\u179a\u17b8\u00A6\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178a\u00A6\u179f\u17ca\u17bc\u178a\u1784\u17cb\u00A6\u179f\u17b8\u179f\u17c2\u179b\u00A6\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u179f\u17b6\u17a2\u17ca\u17bc\u178c\u17b8\u178f\u00A6\u1794\u17b6\u179a\u17b6\u17c6\u1784\u00A6\u1798\u17b7\u1780\u17d2\u179a\u17bc\u1793\u17c1\u179f\u17ca\u17b8\u00A6\u179a\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6\u00A6\u179a\u17bc\u179f\u17d2\u179f\u17ca\u17b8\u00A6\u17a0\u17d2\u179c\u17c9\u17b8\u17a0\u17d2\u179f\u17c9\u17b8\u00A6\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb\u00A6\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8\u00A6\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8\u00A6\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789\u00A6\u17a2\u17c1\u179a\u17b8\u1791\u17d2\u179a\u17b6\u00A6\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u1781\u17b6\u1784\u179b\u17b7\u1785\u00A6\u17a2\u17c1\u17a0\u17d2\u179f\u17c9\u17b8\u1794\u00A6\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8\u00A6\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u178c\u17d0\u179a\u00A6\u17a2\u17b6\u179b\u17cb\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u00A6\u1780\u17b6\u178f\u17b6\u179a\u00A6\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780\u17c2\u1793\u00A6\u1794\u17c9\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799\u00A6\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780\u17b6\u00A6\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780\u00A6\u17a0\u17d2\u179f\u17c9\u17b8\u1794\u17bc\u1791\u17b8\u00A6\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb\u00A6\u1794\u17c9\u17b6\u179b\u17c1\u179f\u17d2\u1791\u17b8\u1793\u00A6\u1796\u17d0\u179a\u178f\u17bc\u179a\u17b8\u1780\u17bc\u00A6\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb\u00A6\u1794\u17c9\u17bc\u179b\u17bc\u1789\u00A6\u1794\u17c9\u17b6\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793\u00A6\u17a0\u17d2\u179c\u17c9\u17b8\u179b\u17b8\u1796\u17b8\u1793\u00A6\u1794\u17c9\u17b6\u1796\u17bc\u17a2\u17b6\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u00A6\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1786\u17c1\u1780\u00A6\u1794\u17c9\u17c1\u179a\u17bc\u00A6\u179f\u17c9\u17b8\u1796\u179a\u17cd\u00A6\u1780\u17b6\u1794\u179c\u17c2\u179a\u00A6\u1794\u17c9\u17b6\u178e\u17b6\u1798\u17c9\u17b6\u00A6\u1782\u17bb\u1799\u1794\u17b6\u00A6\u1780\u17bc\u179f\u17d2\u178f\u17b6\u179a\u17b8\u1780\u17b6\u00A6\u1780\u17bc\u17a1\u17bb\u17c6\u1794\u17ca\u17b8\u00A6\u1785\u17b7\u1793\u00A6\u1780\u17b6\u1798\u17c1\u179a\u17bc\u1793\u00A6\u1788\u17b8\u179b\u17b8\u00A6\u1780\u17bc\u178a\u178c\u17b8\u179c\u17d0\u179a\u00A6\u179f\u17d2\u179c\u17b8\u179f\u00A6\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u00A6\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1780\u178e\u17d2\u178a\u17b6\u179b\u00A6\u17a2\u17bc\u1798\u17c9\u1784\u17cb\u00A6\u1780\u17b6\u178e\u17b6\u178a\u17b6\u00A6\u1794\u17c1\u179b\u17b8\u17a0\u17d2\u179f\u00A6\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f\u17d2\u179f\u00A6\u1794\u17bb\u178f\u179f\u17d2\u179c\u17b6\u178e\u17b6\u00A6\u1794\u17ca\u17bc\u178f\u17b6\u1793\u00A6\u1794\u17b6\u17a0\u17b6\u1798\u17c9\u17b6\u00A6\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b\u00A6\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u179f\u17c1\u17a1\u1784\u17cb\u00A6\u1794\u17bc\u179b\u17b8\u179c\u17b8\u00A6\u1794\u17ca\u17d2\u179a\u17bb\u1799\u178e\u17c1\u00A6\u1794\u17c1\u178e\u17b6\u17c6\u1784\u00A6\u1794\u17ca\u17bc\u179a\u17bb\u1793\u178c\u17b8\u00A6\u1794\u17b6\u179a\u17c9\u17c2\u1793\u00A6\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1782\u17b6\u179a\u17b8\u00A6\u1794\u17ca\u17bc\u179a\u1782\u17b8\u178e\u17b6\u17a0\u17d2\u179c\u17b6\u179f\u17bc\u00A6\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb\u00A6\u1794\u17c2\u179b\u17a0\u17d2\u179f\u17c9\u17b7\u1780\u00A6\u1793\u17d0\u179a\u179c\u17c2\u179f\u00A6\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c1\u179f\u17d2\u17a0\u00A6\u1794\u17b6\u179a\u1794\u17b6\u178a\u17bc\u179f\u00A6\u17a0\u17d2\u179f\u17ca\u17b8\u1798\u1794\u17b6\u1794\u179c\u17c9\u17c1\u00A6\u17a0\u17bc\u179b\u17d2\u179b\u1784\u17cb\u00A6\u1794\u17bc\u179f\u17d2\u1793\u17c9\u17b8\u00A6\u1793\u17b8\u1780\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17d0\u179a\u00A6\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6\u00A6\u17a2\u17b6\u17a0\u17ca\u17d2\u179f\u17c2\u179a\u1794\u17c2\u17a0\u17d2\u179f\u1784\u17cb\u00A6\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u00A6\u17a0\u17d2\u179f\u17b6\u17c6\u1794\u17ca\u17b8\u00A6\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u179b\u17b8\u00A6\u178e\u17b6\u1798\u17b8\u1794\u17ca\u17b8\u00A6\u17a2\u17bc\u1791\u17d2\u179a\u17b8\u179f\u00A6\u17a2\u17b6\u17a0\u17d2\u179f\u1784\u17cb\u1791\u17b8\u1793\u00A6\u1798\u17c9\u17bc\u17a0\u17d2\u179f\u17b6\u17c6\u1794\u17ca\u17b7\u1780\u00A6\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17c4\u17a1\u17b6\u00A6\u1798\u17c9\u17b6\u179b\u17c1\u179f\u17c9\u17b8\u00A6\u1798\u17c9\u17b7\u1785\u179f\u17b7\u1780\u00A6\u17a2\u17b6\u179a\u1798\u17c1\u1793\u17b8\u00A6\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8\u00A6\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784\u00A6\u1798\u17c9\u17bc\u179a\u17b8\u1791\u17bb\u179f\u00A6\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6\u00A6\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8\u00A6\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1782\u17b6\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793\u00A6\u17a2\u17c1\u1798\u17b8\u179a\u17c9\u17c2\u1791\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u179a\u17bd\u1798\u00A6\u17a2\u17b6\u1793\u178a\u17bc\u179a\u17c9\u17b6\u00A6\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8\u00A6\u1798\u17b8\u1799\u17c9\u17b6\u1793\u17cb\u1798\u17c9\u17b6\u00A6\u1798\u17c9\u17b6\u179b\u17b8\u00A6\u1798\u17c9\u17b6\u179f\u17c1\u178a\u1793\u00A6\u1799\u17bc\u17a0\u17d2\u1782\u17c4\u179f\u17d2\u179b\u17b6\u179c\u17b8\u00A6\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1780\u17b6\u179f\u17d2\u1780\u17b6\u179a\u00A6\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8\u00A6\u1798\u17c9\u17bc\u178e\u17b6\u1780\u17bc\u00A6\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780\u00A6\u1799\u17c1\u1798\u17c2\u1793\u00A6\u179b\u17b8\u1794\u17ca\u17b8\u00A6\u17a1\u17b6\u178f\u179c\u17b8\u1799\u17c9\u17b6\u00A6\u179b\u17bb\u1785\u17a0\u17d2\u179f\u17c6\u1794\u17bd\u179a\u00A6\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8\u00A6\u179b\u17be\u179f\u17bc\u178f\u17bc\u00A6\u179b\u17b8\u1794\u17c1\u179a\u17b8\u1799\u17c9\u17b6\u00A6\u179f\u17d2\u179a\u17b8\u179b\u1784\u17d2\u1780\u17b6\u00A6\u179b\u17b7\u1785\u1791\u17c1\u1793\u179f\u17d2\u178f\u17c2\u1793\u00A6\u179b\u17b8\u1794\u1784\u17cb\u00A6\u17a1\u17b6\u179c\u00A6\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u178f\u17b6\u1784\u17cb\u17cb\u00A6\u1782\u17bb\u1799\u179c\u17c9\u17c2\u178f\u00A6\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1780\u17bc\u179a\u17c9\u17c1\u00A6\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1794\u17d2\u179a\u1787\u17b6\u1792\u17b7\u1794\u178f\u17c1\u1799\u17d2\u1799\u1794\u17d2\u179a\u1787\u17b6\u1798\u17b6\u1793\u17b7\u178f\u1780\u17bc\u179a\u17c9\u17c1\u00A6\u1780\u17bb\u17c6\u1798\u17c9\u17bc\u179a\u17c9\u17bc\u179f\u00A6\u1782\u17b7\u179a\u17b7\u1794\u17b6\u1791\u17b8\u00A6\u179f\u17b6\u1798\u17bc\u17a2\u17b6\u00A6\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6\u00A6\u1782\u17c0\u179a\u17a0\u17d2\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb\u00A6\u1780\u17c1\u1793\u1799\u17c9\u17b6\u00A6\u1787\u1794\u17c9\u17bb\u1793\u00A6\u17a0\u17ca\u17d2\u179f\u1780\u178a\u17b6\u1793\u17b8\u00A6\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6\u17a2\u17c9\u17b7\u1782\u00A6\u179c\u17c0\u178f\u178e\u17b6\u1798\u00A6\u179c\u17c1\u1793\u17c1\u17a0\u17d2\u179f\u17ca\u17bb\u1799\u17a1\u17b6\u00A6\u179c\u17c9\u17b6\u1791\u17b8\u1780\u1784\u17cb\u00A6\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8\u00A6\u17a2\u17c9\u17b8\u179f\u17d2\u179b\u1784\u17cb\u00A6\u17a2\u17ca\u17b8\u179a\u17c9\u1784\u17cb\u00A6\u17a2\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17cb\u00A6\u17a2\u17ca\u17bc\u17a0\u17d2\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb\u00A6\u17a2\u17ca\u17bb\u1799\u179a\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u1799\u00A6\u17a5\u178e\u17d2\u178c\u17b6\u00A6\u17a2\u17ca\u17b8\u179f\u17d2\u179a\u17b6\u17a2\u17c2\u179b\u00A6\u179f\u17a0\u179a\u178a\u17d2\u178b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u00A6\u17a2\u17c0\u179a\u17a1\u1784\u17cb\u00A6\u17a5\u178e\u17d2\u178c\u17bc\u1793\u17c1\u179f\u17ca\u17b8\u00A6\u17a2\u17ca\u17bc\u17a0\u17d2\u1780\u1784\u17cb\u178a\u17b6\u00A6\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793\u00A6\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8\u00A6\u17a0\u17c3\u1791\u17b8\u00A6\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u179f\u17ca\u17b8\u00A6\u178f\u1784\u17cb\u17a0\u17d2\u179f\u17b6\u1793\u17b8\u00A6\u17a0\u17bb\u1784\u178c\u17bd\u179a\u17c9\u17b6\u179f\u17cb\u00A6\u178f\u17c3\u179c\u17c9\u17b6\u1793\u17cb\u00A6\u17a0\u17bb\u1784\u1780\u17bb\u1784\u00A6\u1791\u17d2\u179a\u17b8\u1793\u17b8\u178a\u17b6\u178a\u1793\u17b9\u1784\u178f\u17bc\u1794\u17b6\u17a0\u17d2\u1782\u17c4\u00A6\u1791\u17bd\u179a\u1782\u17b8\u00A6\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6\u00A6\u1791\u17bb\u1799\u1793\u17c1\u179f\u17ca\u17b8\u00A6\u1791\u17bd\u1782\u1798\u17c1\u1793\u17b8\u179f\u17d2\u178f\u1784\u17cb";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es\u00A6ku\u00A6eo\u00A6en\u00A6el\u00A6qu\u00A6ko\u00A6kn\u00A6km\u00A6kk\u00A6ka\u00A6dz\u00A6jv\u00A6pt\u00A6de\u00A6pl\u00A6da\u00A6ja\u00A6vi\u00A6pa\u00A6cs\u00A6it\u00A6is\u00A6uz\u00A6or\u00A6ur\u00A6ca\u00A6id\u00A6uk\u00A6hy\u00A6hu\u00A6bo\u00A6bn\u00A6bm\u00A6bh\u00A6bg\u00A6tt\u00A6no\u00A6be\u00A6hi\u00A6tr\u00A6nl\u00A6zu\u00A6to\u00A6he\u00A6tk\u00A6ne\u00A6az\u00A6ay\u00A6th\u00A6tg\u00A6te\u00A6zh\u00A6ar\u00A6ta\u00A6gu\u00A6an\u00A6za\u00A6mt\u00A6ms\u00A6gn\u00A6sw\u00A6mr\u00A6sv\u00A6gl\u00A6su\u00A6af\u00A6mo\u00A6ae\u00A6mn\u00A6sq\u00A6ml\u00A6mk\u00A6aa\u00A6so\u00A6mi\u00A6gd\u00A6sm\u00A6sl\u00A6mg\u00A6sk\u00A6ga\u00A6yo\u00A6yi\u00A6sd\u00A6sa\u00A6fr\u00A6lv\u00A6lt\u00A6ru\u00A6lo\u00A6fj\u00A6fi\u00A6ro\u00A6rn\u00A6la\u00A6xh\u00A6eu\u00A6ky\u00A6et";

  private static final String languagesValues = "\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789\u00A6\u1797\u17b6\u179f\u17b6\u1783\u17ba\u178a\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u1796\u17c1\u179a\u17c9\u17b6\u1793\u17d2\u1791\u17c4\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f\u00A6\u1797\u17b6\u179f\u17b6\u1780\u17d2\u179a\u17b7\u1785\u00A6\u1797\u17b6\u179f\u17b6\u1780\u17c1\u1791\u17d2\u1787\u17bc\u17a2\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u1780\u17bc\u179a\u17c9\u17c1\u00A6\u1797\u17b6\u179f\u17b6\u1780\u17b7\u178e\u17b6\u178a\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a\u00A6\u1797\u17b6\u179f\u17b6\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u178f\u1784\u17cb\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17c9\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17ca\u17bc\u178f\u17b6\u1793\u00A6\u1797\u17b6\u179f\u17b6\u1799\u17c9\u17b6\u179c\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17c9\u17bc\u17a1\u17bc\u1789\u00A6\u1797\u17b6\u179f\u17b6\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780\u00A6\u1797\u17b6\u179f\u17b6\u1787\u1794\u17c9\u17bb\u1793\u00A6\u1797\u17b6\u179f\u17b6\u179c\u17c0\u178f\u178e\u17b6\u1798\u00A6\u1797\u17b6\u179f\u17b6\u1796\u17bc\u1793\u1799\u17c9\u17b6\u1794\u17ca\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1786\u17c1\u1780\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17c9\u17b8\u179f\u17d2\u179b\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bc\u17a0\u17d2\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17bc\u179a\u17b8\u1799\u17c9\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bc\u179a\u17d2\u178c\u17bc\u00A6\u1797\u17b6\u179f\u17b6\u1780\u17b6\u178f\u17b6\u17a1\u17b6\u1793\u00A6\u1797\u17b6\u179f\u17b6\u17a5\u178e\u17d2\u178c\u17bc\u1793\u17c1\u179f\u17ca\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u1798\u17c1\u1793\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1791\u17b8\u1794\u17c1\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17c1\u1793\u17d2\u1780\u17b6\u179b\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17b6\u1798\u17d2\u1794\u17b6\u179a\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17b7\u17a0\u17b6\u179a\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1780\u17b6\u179a\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u178f\u17b6\u178f\u17b6\u179a\u00A6\u1797\u17b6\u179f\u17b6\u1793\u17d0\u179a\u179c\u17c2\u179f\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f\u17d2\u179f\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17c9\u17b7\u1793\u178c\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1791\u17bd\u179a\u1782\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17bb\u179b\u17d2\u179b\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179f\u17c9\u17bc\u179b\u17bc\u00A6\u1797\u17b6\u179f\u17b6\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17c1\u1794\u17d2\u179a\u17b7\u00A6\u1797\u17b6\u179f\u17b6\u1791\u17bd\u1782\u1798\u17c1\u1793\u17b8\u179f\u17d2\u178f\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17ca\u17d2\u179f\u17c2\u179a\u1794\u17c2\u17a0\u17d2\u179f\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b8\u1798\u17c9\u17b6\u179a\u17c9\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u1790\u17c3\u00A6\u1797\u17b6\u179f\u17b6\u178f\u17b6\u178a\u17a0\u17d2\u179f\u17c9\u17b8\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u178f\u17c1\u179b\u17bc\u17a0\u17d2\u1782\u17bc\u00A6\u1797\u17b6\u179f\u17b6\u1785\u17b7\u1793\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u178f\u17b6\u1798\u17b8\u179b\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17bb\u1799\u17c9\u17b6\u179a\u17b6\u1791\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17c4\u1793\u00A6\u1797\u17b6\u179f\u17b6\u1785\u17bd\u1784\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179b\u17c1\u179f\u17c9\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17bd\u179a\u17c9\u17b6\u1793\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179c\u17b6\u17a0\u17c9\u17b8\u179b\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179a\u17b6\u1792\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178a\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17b6\u179b\u17b8\u179f\u17c9\u17b8\u00A6\u1797\u17b6\u17c6\u179f\u17b6\u179f\u17ca\u17bc\u178a\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b8\u1780\u17b6\u17a2\u17b6\u1793\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179c\u17c2\u179f\u17d2\u178f\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u17a1\u17b6\u17a1\u17b6\u1799\u17c9\u17b6\u1793\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17bc\u1793\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17b6\u179a\u00A6\u1797\u17b6\u179f\u17b6\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17c4\u179a\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782\u00A6\u1797\u17b6\u179f\u17b6\u179f\u17b6\u1798\u17bc\u17a2\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1793\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1780\u17b6\u179f\u1780\u17b6\u179a\u00A6\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782\u00A6\u1797\u17b6\u179f\u17b6\u1799\u179a\u17bc\u1794\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u1799\u17b8\u178c\u17b8\u17a0\u17d2\u179f\u00A6\u1797\u17b6\u179f\u17b6\u179f\u17c9\u17b8\u1793\u17d2\u178a\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u179f\u17c6\u179f\u17d2\u1780\u17d2\u179a\u17b9\u178f\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17b6\u179a\u17b6\u17c6\u1784\u00A6\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u178f\u179c\u17b8\u1799\u17c9\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u0e23\u0e31\u179a\u17bc\u179f\u17d2\u179f\u17c9\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u179c\u00A6\u17a0\u17d2\u179c\u17c9\u17b8\u17a0\u17d2\u179f\u17c9\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u179a\u17bc\u1793\u17d2\u178c\u17b8\u00A6\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u178f\u17c6\u17b6\u1784\u00A6\u1797\u17b6\u179f\u17b6\u1783\u179f\u17b6\u00A6\u1797\u17b6\u179f\u17b6\u1794\u17b6\u179f\u17d2\u1780\u17c1\u00A6\u1797\u17b6\u179f\u17b6\u1782\u17c0\u179a\u17a0\u17d2\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb\u00A6\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GyMdkHmsSEDFwWahKzYeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "ampms", ampms },
    { "shortDateFormat", "d/M/yyyy" },
    { "mediumDateFormat", "d MMMM yyyy" },
    { "longDateFormat", "EEEE' \u1790\u17d2\u1784\u17c3 'd' \u1781\u17c2 'MMMM' \u1786\u17d2\u1793\u17b6\u17c6 ' yyyy" },
    { "fullDateFormat", "EEEE' \u1790\u17d2\u1784\u17c3 'd' \u1781\u17c2 'MMMM' \u1786\u17d2\u1793\u17b6\u17c6 ' yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H' \u1798\u17c9\u17c4\u1784 'm' \u1793\u17b6\u1791\u17b8 'ss' \u179c\u17b7\u1793\u17b6\u1791\u17b8\u200b'" },
    { "fullTimeFormat", "H' \u1798\u17c9\u17c4\u1784 'm' \u1793\u17b6\u1791\u17b8 'ss' \u179c\u17b7\u1793\u17b6\u1791\u17b8\u200b' z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
