/*
  Graphical IDF Wizard
  Copyright (C) 1998,1999,2002,2005,2010,2013 David Martnez Oliveira

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
 */
/* Revisions:
 * November, 17th, 2001
 * Compile warnning removal and code cleanup
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
//#include <gnome.h>
#include <gtk/gtk.h>
#include <edma.h>

#include "metform.h"

void 
met_click( GtkWidget *clist, gint row, gint column,
	   GdkEventButton *event, gpointer data)
{
  ESint32       i, j;
  gchar         text[80];
  gchar         *aux;
  EChar         name[80], type[40], access[20], array[20];
  gchar         *prop_data[] = {name, type, access, array};
  MethodWidgets *gw;

  gw = (MethodWidgets*) data;
  gw->actual = row;
  printf ("\nselected %d superclass to add", row);
  
  /* Update widgets contents */
  gtk_clist_get_text (GTK_CLIST(clist), row, 0, &aux);
  i = atoi (aux);

  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(gw->Virtual), i);

  gtk_clist_get_text (GTK_CLIST(clist), row, 1, &aux);
  i = atoi(aux);

  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(gw->Abstract), i);

  gtk_clist_get_text (GTK_CLIST(clist), row, 2, &aux);
  i = atoi (aux);

  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(gw->Static), i);

  gtk_clist_get_text (GTK_CLIST(clist), row, 3, &aux);
  gtk_entry_set_text (GTK_ENTRY(gw->Name), aux);
  gtk_clist_get_text (GTK_CLIST(clist), row, 4, &aux);
  gtk_entry_set_text (GTK_ENTRY(gw->Signature), aux);

}

void 
Met_add_click( GtkWidget *bot, gpointer data)
{
  EPChar        text;
  EUint32       n, i;
  MethodWidgets *gw;
  EChar         name[80], type[80], vir[20], abs[20], sta[20];
  const gchar         *aux;
  gchar         *met_data[] = {vir, abs, sta, name, type, 0};


  gw = (MethodWidgets*) data;
  aux = gtk_entry_get_text (GTK_ENTRY(gw->Name));
  strcpy (gw->met[gw->n].Name, aux);
  strcpy (name, aux);

  aux = gtk_entry_get_text (GTK_ENTRY(gw->Signature));
  strcpy (type, aux);
  strcpy (gw->met[gw->n].Sig, aux);

  i = GTK_TOGGLE_BUTTON (gw->Virtual)->active;
  gw->met[gw->n].Virtual = i;
  sprintf (vir, "%d", i);

  i = GTK_TOGGLE_BUTTON (gw->Abstract)->active;
  gw->met[gw->n].Abstract = i;
  sprintf (abs, "%d", i);
  i = GTK_TOGGLE_BUTTON (gw->Static)->active;
  gw->met[gw->n].Static = i;
  sprintf (sta," %d", i);
  gw->n++;

  gtk_clist_append (GTK_CLIST(gw->the_list), met_data);
}

void 
Met_addcons_click( GtkWidget *bot, gpointer data)
{
  EPChar         text;
  EUint32        n, i;
  MethodWidgets  *gw;
  EChar          *aux,name[80], type[80], vir[20], abs[20], sta[20];
  gchar          *met_data[] = {vir, abs, sta, name, type, 0};

  gw = (MethodWidgets*)data;

  strcpy (name, "born");
  strcpy (type, "\0");
  strcpy (gw->met[gw->n].Name, name);
  strcpy (gw->met[gw->n].Sig, "\0");

  i = GTK_TOGGLE_BUTTON (gw->Virtual)->active;
  sprintf (vir, "%d", i);
  gw->met[gw->n].Virtual = i;
  i = 0;
  sprintf (abs, "%d", i);
  sprintf (sta, "%d", i);
  gw->met[gw->n].Abstract = 0;
  gw->met[gw->n].Static = 0;

  gw->n++;
  gtk_clist_append (GTK_CLIST(gw->the_list), met_data);
}


void 
Met_adddes_click( GtkWidget *bot, gpointer data)
{
  EPChar        text;
  EUint32       n, i;
  MethodWidgets *gw;
  EChar         *aux, name[80], type[80], vir[20], abs[20], sta[20];
  gchar         *met_data[] = {vir, abs, sta, name, type, 0};

  gw = (MethodWidgets*) data;
  strcpy (name, "rip");
  strcpy (type, "\0");
  strcpy (gw->met[gw->n].Name, name);
  strcpy (gw->met[gw->n].Sig, "\0");

  i = GTK_TOGGLE_BUTTON (gw->Virtual)->active;
  sprintf (vir, "%d", i);
  gw->met[gw->n].Virtual = i;
  i = 0;
  sprintf (abs, "%d", i);
  sprintf (sta, "%d", i);
  gw->met[gw->n].Abstract = 0;
  gw->met[gw->n].Static = 0;


  gw->n++;
  gtk_clist_append (GTK_CLIST(gw->the_list), met_data);
}

void 
Met_set_click( GtkWidget *bot, gpointer data)
{
  EPChar        text;
  EUint32       n, i;
  MethodWidgets *gw;
  EChar         name[80], type[80], vir[20], abs[20], sta[20];
  const gchar   *aux;
  gchar         *met_data[] = {vir, abs, sta, name, type, 0};


  gw = (MethodWidgets*) data;
  aux = gtk_entry_get_text (GTK_ENTRY(gw->Name));
  strcpy (gw->met[gw->actual].Name, aux);
  strcpy (name, aux);

  aux = gtk_entry_get_text (GTK_ENTRY(gw->Signature));
  strcpy (type, aux);
  strcpy (gw->met[gw->actual].Sig, aux);

  i = GTK_TOGGLE_BUTTON (gw->Virtual)->active;
  gw->met[gw->actual].Virtual = i;
  sprintf (vir, "%d", i);
  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 0, vir);

  i = GTK_TOGGLE_BUTTON (gw->Abstract)->active;
  gw->met[gw->actual].Abstract = i;
  sprintf (abs, "%d", i);
  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 1, abs);

  i = GTK_TOGGLE_BUTTON (gw->Static)->active;
  gw->met[gw->actual].Static = i;
  sprintf (sta, "%d", i);
  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 2, sta);

  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 3, name);
  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 4, type);

}

void 
Met_del_click( GtkWidget *bot, gpointer data)
{
  
  EPChar        text;
  EUint32       n,i;
  MethodWidgets *gw;

  gw = (MethodWidgets*) data;
  gtk_clist_remove (GTK_CLIST(gw->the_list), gw->actual);
  for (i = gw->actual; i < gw->n; i++)
    gw->met[i] = gw->met[i + 1];
  gw->n--;
}

ESint32 
InitMetForm (MethodWidgets *gw)
{
  gw->build_form = BuildMetForm;

}

ESint32 
BuildMetForm (MethodWidgets *gw, GtkWidget *note)
{   
  GtkWidget *label, *aux, *swindow, *box;

  /* General Info Page */
  gw->table = gtk_table_new (11, 2, TRUE);

  /* General Info Page FIXME: ????????*/
  gw->table = gtk_table_new (1, 3, TRUE);

  swindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swindow),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
  gw->the_list = gtk_clist_new (6);
  
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 0, "V");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 0, 20);
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 1, "A");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 1, 20);
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 2, "S");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 2, 20);
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 3, "Name");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 3, 100);
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 4, "Signature");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 4, 100);

  gtk_clist_column_titles_show (GTK_CLIST(gw->the_list));
  gtk_container_add (GTK_CONTAINER(swindow), gw->the_list);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), swindow, 0, 2, 0, 1);

  gtk_widget_show (gw->the_list);
  gtk_widget_show (swindow);

  box = gtk_vbox_new (FALSE, FALSE);

  label = gtk_label_new ("Name");
  gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 2);
  gtk_widget_show (label);

  gw->Name = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX(box), gw->Name, FALSE, FALSE, 2);
  gtk_widget_show (gw->Name);

  label = gtk_label_new ("Signature");
  gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 2);
  gtk_widget_show (label);

  gw->Signature = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX(box), gw->Signature, FALSE, FALSE, 2);
  gtk_widget_show (gw->Signature);

  gw->Virtual = gtk_check_button_new_with_label ("Virtual");
  gtk_box_pack_start (GTK_BOX(box), gw->Virtual, FALSE, FALSE, 2);
  gtk_widget_show (gw->Virtual);

  gw->Abstract = gtk_check_button_new_with_label ("Abstract");
  gtk_box_pack_start (GTK_BOX(box), gw->Abstract, FALSE, FALSE, 2);
  gtk_widget_show (gw->Abstract);

  gw->Static = gtk_check_button_new_with_label ("Static");
  gtk_box_pack_start (GTK_BOX(box), gw->Static, FALSE, FALSE, 2);
  gtk_widget_show (gw->Static);

  gw->Add = gtk_button_new_with_label ("Add");
  gtk_box_pack_start (GTK_BOX(box), gw->Add, FALSE, FALSE, 2);
  gtk_widget_show (gw->Add);

  gw->Del = gtk_button_new_with_label ("Del");
  gtk_box_pack_start (GTK_BOX(box), gw->Del, FALSE, FALSE, 2);
  gtk_widget_show (gw->Del);

  gw->Set = gtk_button_new_with_label ("Set");
  gtk_box_pack_start (GTK_BOX(box), gw->Set, FALSE, FALSE, 2);
  gtk_widget_show (gw->Set);

  gtk_signal_connect (GTK_OBJECT (gw->Add), "clicked",
		      GTK_SIGNAL_FUNC (Met_add_click), (gpointer) gw);
  gtk_signal_connect (GTK_OBJECT (gw->Del), "clicked",
		      GTK_SIGNAL_FUNC (Met_del_click), (gpointer) gw);
  gtk_signal_connect (GTK_OBJECT (gw->Set), "clicked",
		      GTK_SIGNAL_FUNC (Met_set_click), (gpointer) gw);

  gtk_signal_connect (GTK_OBJECT (gw->the_list), "select_row",
		      GTK_SIGNAL_FUNC (met_click), gw);


  gw->AddConstructor = gtk_button_new_with_label ("Add Constructor");
  gtk_box_pack_start (GTK_BOX(box), gw->AddConstructor, FALSE, FALSE, 2);
  gtk_widget_show (gw->AddConstructor);

  gw->AddDestructor = gtk_button_new_with_label ("Add Destructor");
  gtk_box_pack_start (GTK_BOX(box), gw->AddDestructor, FALSE,FALSE, 2);
  gtk_widget_show (gw->AddDestructor);

  gtk_signal_connect (GTK_OBJECT (gw->AddConstructor), "clicked",
		      GTK_SIGNAL_FUNC (Met_addcons_click), (gpointer) gw);
  gtk_signal_connect (GTK_OBJECT (gw->AddDestructor), "clicked",
		      GTK_SIGNAL_FUNC (Met_adddes_click), (gpointer) gw);

  gtk_widget_show (box);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), box, 2, 3, 0, 1);

  gtk_widget_show (gw->table);
  label = gtk_label_new ("Method");
  gtk_notebook_append_page (GTK_NOTEBOOK (note), gw->table, label);
  
  return 0;
}


ESint32 
MetGetNM (MethodWidgets *gw)
{
  g_print ("Returnning Method number: %d", gw->n);
  return gw->n;
}

ESint32 
MetGetName (MethodWidgets *gw, ESint32 i, EPChar r)
{
  strcpy (r, gw->met[i].Name);
  return 0;
}

ESint32 
MetGetSignature (MethodWidgets *gw, ESint32 i, EPChar r)
{
  strcpy (r, gw->met[i].Sig); 
  return 0;
}

ESint32 
MetGetVirtual (MethodWidgets *gw, ESint32 i)
{
  return gw->met[i].Virtual;
}

ESint32 
MetGetAbstract (MethodWidgets *gw, ESint32 i)
{
  return gw->met[i].Abstract;
}

ESint32 
MetGetStatic (MethodWidgets *gw,
ESint32 i)
{
  return gw->met[i].Static;
}

void 
MetInit(MethodWidgets *gw)
{
  gw->n = 0;
  gw->actual = 0;
  gtk_clist_clear (GTK_CLIST(gw->the_list));
}

void 
MetSet (MethodWidgets *gw, EPChar Name, EPChar Sig,
	EUint32 v, EUint32 a, EUint32 s)
{
  EPChar   text;
  EUint32  n, i;
  EChar    *aux, name[80], type[80], vir[20], abs[20], sta[20];
  gchar    *met_data[] = {vir, abs, sta, name, type, 0};


  strcpy (gw->met[gw->n].Name, Name);
  strcpy (name, Name);
  strcpy (type,Sig);
  strcpy (gw->met[gw->n].Sig, Sig);

  gw->met[gw->n].Virtual = v;
  sprintf (vir, "%d", v);

  gw->met[gw->n].Abstract = a;
  sprintf (abs, "%d", a);

  gw->met[gw->n].Static = s;
  sprintf (sta, "%d", s);
  gw->n++;

  gtk_clist_append (GTK_CLIST(gw->the_list), met_data);
}
