/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.plugins.j3d.View3DWindow;
import com.sun.electric.plugins.j3d.ui.J3DDemoDialog;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;

public class J3DMenu {
    public static MenuBar.Menu add3DMenus(MenuBar.Menu menu) {
        MenuBar.Menu j3DMenu = MenuBar.makeMenu("_3D Window");
        menu.add(j3DMenu);
        j3DMenu.addMenuItem("_3D View", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                J3DMenu.create3DViewCommand(new Boolean(false));
            }
        });
        j3DMenu.addMenuItem("_Capture Frame/Animate", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                J3DDemoDialog.create3DDemoDialog(TopLevel.getCurrentJFrame(), null);
            }
        });
        j3DMenu.addSeparator();
        j3DMenu.addMenuItem("_Test Hardware", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                J3DMenu.runHardwareTest();
            }
        });
        return j3DMenu;
    }

    public static void create3DViewCommand(Boolean transPerNode) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        WindowContent view2D = WindowFrame.getCurrentWindowFrame(false).getContent();
        if (!(view2D instanceof EditWindow)) {
            return;
        }
        WindowFrame frame = new WindowFrame();
        View3DWindow.create3DWindow(curCell, frame, view2D, transPerNode);
    }

    private static void runHardwareTest() {
        Class app3DClass = Resources.getJMFJ3DClass("J3DQueryProperties");
        try {
            Method queryClass = app3DClass.getDeclaredMethod("queryHardwareAcceleration", new Class[0]);
            queryClass.invoke((Object)queryClass, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method queryHardwareAcceleration: ");
        }
    }
}

