/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.CellUsage;
import com.sun.electric.tool.ncc.basic.CompareList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareLists {
    private boolean alreadyCompared(Set compared, CompareList compareList) {
        int num = 0;
        int numComp = 0;
        for (CellContext cc : compareList) {
            if (compared.contains(cc.cell)) {
                ++numComp;
            }
            ++num;
        }
        LayoutLib.error(numComp != 0 && numComp != num, "cell group partially processed");
        return numComp > 0;
    }

    private List<CompareList> getCompareLists(CellUsage use1, CellUsage use2) {
        HashSet<Cell> compared = new HashSet<Cell>();
        HashSet<Cell.CellGroup> visitedGroups = new HashSet<Cell.CellGroup>();
        ArrayList<CompareList> compareLists = new ArrayList<CompareList>();
        Iterator<Cell> it = use1.cellsInReverseTopologicalOrder();
        while (it.hasNext()) {
            Cell cell = it.next();
            CompareList compareList = new CompareList(cell, use1, use2, visitedGroups);
            if (this.alreadyCompared(compared, compareList) || compareList.empty()) continue;
            for (CellContext cc : compareList) {
                compared.add(cc.cell);
            }
            compareLists.add(compareList);
        }
        return compareLists;
    }

    private List<CompareList> getCompareLists1(CellContext cc1, CellContext cc2) {
        CellUsage use1 = CellUsage.getCellUsage(cc1);
        CellUsage use2 = CellUsage.getCellUsage(cc2);
        return this.getCompareLists(use1, use2);
    }

    public static List<CompareList> getCompareLists(CellContext cc1, CellContext cc2) {
        return new CompareLists().getCompareLists1(cc1, cc2);
    }
}

