/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric;

import com.sun.electric.Main;
import com.sun.electric.StartupPrefs;
import com.sun.electric.tool.Regression;
import java.io.File;
import java.io.IOException;

public final class Launcher {
    private static final boolean enableAssertions = true;
    private static final String[] propertiesToCopy = new String[]{"user.home"};

    private Launcher() {
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String str = args[i];
            if (!str.equals("-NOMINMEM") && !str.equals("-help") && !str.equals("-version") && !str.equals("-v")) continue;
            Main.main(args);
            return;
        }
        String program = "java";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            program = javaHome + File.separator + "bin" + File.separator + program;
        }
        if (args.length >= 2 && args[0].equals("-regression") || args.length >= 4 && args[0].equals("-threads") && args[2].equals("-regression") || args.length >= 4 && args[0].equals("-logging") && args[2].equals("-regression")) {
            System.exit(Launcher.invokeRegression(args) ? 0 : 1);
            return;
        }
        try {
            if (program != null) {
                Launcher.invokeElectric(args, program);
            } else {
                Main.main(args);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Main.main(args);
        }
    }

    private static void invokeElectric(String[] args, String program) {
        int i;
        Runtime runtime = Runtime.getRuntime();
        long maxMem = runtime.maxMemory() / 1000000L;
        long maxPermWanted = StartupPrefs.getPermSpace();
        int maxMemWanted = StartupPrefs.getMemorySize();
        if ((long)maxMemWanted <= maxMem && maxPermWanted == 0L) {
            ClassLoader.getSystemClassLoader().setDefaultAssertionStatus(true);
            Main.main(args);
            return;
        }
        String command = program;
        command = command + " -cp " + Launcher.getJarLocation();
        command = command + " -ss2m";
        command = command + " -ea";
        command = command + " -mx" + maxMemWanted + "m";
        if (maxPermWanted > 0L) {
            command = command + " -XX:MaxPermSize=" + maxPermWanted + "m";
        }
        for (i = 0; i < propertiesToCopy.length; ++i) {
            String propValue = System.getProperty(propertiesToCopy[i]);
            if (propValue == null || propValue.length() <= 0) continue;
            if (propValue.indexOf(32) >= 0) {
                propValue = "\"" + propValue + "\"";
            }
            command = command + " -D" + propertiesToCopy[i] + "=" + propValue;
        }
        command = command + " com.sun.electric.Main";
        for (i = 0; i < args.length; ++i) {
            command = command + " " + args[i];
        }
        if ((long)maxMemWanted > maxMem) {
            System.out.println("Current Java memory limit of " + maxMem + "MEG is too small, rerunning Electric with a memory limit of " + maxMemWanted + "MEG");
        }
        if (maxPermWanted > 0L) {
            System.out.println("Setting maximum permanent space (2nd GC) to " + maxPermWanted + "MEG");
        }
        try {
            runtime.exec(command);
            System.exit(0);
        }
        catch (IOException e) {
            Main.main(args);
        }
    }

    static Process invokePipeserver(String electricOptions, boolean withDebugger) throws IOException {
        String javaOptions = " -Xss2m";
        int maxMemWanted = StartupPrefs.getMemorySize();
        javaOptions = javaOptions + " -Xmx" + maxMemWanted + "m";
        long maxPermWanted = StartupPrefs.getPermSpace();
        if (maxPermWanted > 0L) {
            javaOptions = javaOptions + " -XX:MaxPermSize=" + maxPermWanted + "m";
        }
        if (withDebugger) {
            javaOptions = javaOptions + " -Xdebug -Xrunjdwp:transport=dt_socket,server=n,address=localhost:35856";
        }
        return Launcher.invokePipeserver(javaOptions, electricOptions);
    }

    private static boolean invokeRegression(String[] args) {
        String javaOptions = "";
        String electricOptions = " -debug";
        int regressionPos = 0;
        if (args[0].equals("-threads")) {
            regressionPos = 2;
            electricOptions = electricOptions + " -threads " + args[1];
        } else if (args[0].equals("-logging")) {
            regressionPos = 2;
            electricOptions = electricOptions + " -logging " + args[1];
        }
        String script = args[regressionPos + 1];
        for (int i = regressionPos + 2; i < args.length; ++i) {
            javaOptions = javaOptions + " " + args[i];
        }
        Process process = null;
        try {
            process = Launcher.invokePipeserver(javaOptions, electricOptions);
            return Regression.runScript(process, script);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Process invokePipeserver(String javaOptions, String electricOptions) throws IOException {
        String program = "java";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            program = javaHome + File.separator + "bin" + File.separator + program;
        }
        String command = program;
        command = command + " -ea";
        command = command + " -Djava.util.prefs.PreferencesFactory=com.sun.electric.database.text.EmptyPreferencesFactory";
        command = command + javaOptions;
        command = command + " -cp " + Launcher.getJarLocation();
        command = command + " com.sun.electric.Main";
        if (electricOptions != null) {
            command = command + electricOptions;
        }
        command = command + " -pipeserver";
        System.err.println("exec: " + command);
        Runtime runtime = Runtime.getRuntime();
        return runtime.exec(command);
    }

    public static String getJarLocation() {
        String jarPath = System.getProperty("java.class.path", ".");
        if (jarPath.indexOf(32) >= 0) {
            jarPath = "\"" + jarPath + "\"";
        }
        return jarPath;
    }
}

