/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected1;

import com.sun.electric.tool.placement.forceDirected1.metric.AbstractMetric;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Stack;

public class Debug {
    private ArrayList<String> out = new ArrayList();
    private Stack<Long> tick = new Stack();
    private DecimalFormat df = new DecimalFormat("###,###.###");

    public void clear() {
        this.out.clear();
        this.tick.clear();
    }

    public void tick() {
        long now = System.currentTimeMillis();
        this.tick.push(new Long(now));
    }

    public void tack() {
        this.tack("Time");
    }

    public void tack(String label) {
        double t = System.currentTimeMillis() - this.tick.pop();
        this.out.add(this.align(label) + this.df.format(t / 1000.0) + " s");
    }

    public void tack(String label, boolean implicitTick) {
        this.tack(label);
        if (implicitTick) {
            this.tick();
        }
    }

    public String last() {
        return this.out.remove(this.out.size() - 1);
    }

    public void println(String str) {
        this.out.add(str);
    }

    public void println(String label, int value) {
        this.out.add(this.align(label) + value);
    }

    public void println(String label, long value) {
        this.out.add(this.align(label) + value);
    }

    public void println(String label, double value) {
        this.out.add(this.align(label) + this.df.format(value));
    }

    public void println(String label, String str) {
        this.out.add(this.align(label) + str);
    }

    public void println(AbstractMetric metric) {
        this.println(metric.getMetricName(), metric.compute());
    }

    public void flush() {
        this.flush("");
    }

    public void flush(String str) {
        if (this.out.size() == 0) {
            return;
        }
        if (str.length() > 0) {
            System.out.println(str);
        }
        for (String s : this.out) {
            System.out.println(s);
        }
        this.clear();
    }

    private String align(String label) {
        if ((label = label + ":").length() < 8) {
            label = label + "\t ";
        }
        return label + "\t ";
    }
}

