/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PromptAt
extends EDialog {
    private boolean yesNo;
    private String value;
    private boolean goodClicked;
    private String customButtonClicked;
    private boolean closed;
    private Field[] fieldList;
    private Field[][] fieldArray;

    public static boolean showPromptAt(EditWindow_ wnd, NodeInst ni, String title, String label, boolean initial) {
        Field[] fields = new Field[]{new Field(label)};
        PromptAt dialog = new PromptAt(true);
        dialog.initComponents(wnd, ni, title, fields, null);
        dialog.setVisible(true);
        if (dialog.closed) {
            return initial;
        }
        return dialog.goodClicked;
    }

    public static String showPromptAt(EditWindow_ wnd, NodeInst ni, String title, String label, String initial, String[] choices) {
        Field[] fields = new Field[]{new Field(label, choices, initial)};
        PromptAt dialog = new PromptAt(false);
        dialog.initComponents(wnd, ni, title, fields, null);
        dialog.setVisible(true);
        if (!dialog.goodClicked) {
            return null;
        }
        return (String)fields[0].finalValue;
    }

    public static String showPromptAt(EditWindow_ wnd, NodeInst ni, String title, String label, String initial) {
        Field[] fields = new Field[]{new Field(label, initial)};
        PromptAt dialog = new PromptAt(false);
        dialog.initComponents(wnd, ni, title, fields, null);
        dialog.setVisible(true);
        if (!dialog.goodClicked) {
            return null;
        }
        return (String)fields[0].finalValue;
    }

    public static String showPromptAt(EditWindow_ wnd, NodeInst ni, String title, Field[] fields) {
        PromptAt dialog = new PromptAt(false);
        dialog.initComponents(wnd, ni, title, fields, null);
        dialog.setVisible(true);
        if (!dialog.goodClicked) {
            return null;
        }
        return dialog.value;
    }

    public static String showPromptAt(EditWindow_ wnd, NodeInst ni, String title, Field[][] fields) {
        PromptAt dialog = new PromptAt(false);
        dialog.initComponents(wnd, ni, title, null, fields);
        dialog.setVisible(true);
        if (!dialog.goodClicked) {
            return null;
        }
        return dialog.value;
    }

    public PromptAt(boolean yesNo) {
        super((Frame)null, true);
        this.yesNo = yesNo;
        this.closed = false;
    }

    @Override
    protected void escapePressed() {
        this.closed = true;
        this.exit(false);
    }

    private void exit(boolean goodButton) {
        this.goodClicked = goodButton;
        if (this.goodClicked && !this.yesNo) {
            if (this.fieldList != null) {
                for (int i = 0; i < this.fieldList.length; ++i) {
                    this.finishField(this.fieldList[i]);
                }
            } else if (this.fieldArray != null) {
                for (int i = 0; i < this.fieldArray.length; ++i) {
                    Field[] row = this.fieldArray[i];
                    for (int j = 0; j < row.length; ++j) {
                        this.finishField(row[j]);
                    }
                }
            }
            this.value = "";
            if (this.customButtonClicked != null) {
                this.value = this.customButtonClicked;
            }
        }
        this.dispose();
    }

    private void finishField(Field field2) {
        if (field2 == null) {
            return;
        }
        switch (field2.type) {
            case 3: {
                field2.finalValue = field2.textField.getText();
                break;
            }
            case 4: {
                field2.finalValue = field2.combo.getSelectedItem();
                break;
            }
            case 5: {
                Color newColor = PromptAt.parseColor(field2);
                if (newColor == null) break;
                field2.finalValue = newColor;
            }
        }
    }

    private void initComponents(EditWindow_ wnd, NodeInst ni, String title, Field[] fieldList, Field[][] fieldArray) {
        int i;
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(title);
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PromptAt.this.closed = true;
                PromptAt.this.exit(false);
            }
        });
        int buttonRow = 1;
        this.goodClicked = false;
        JComponent centerIt = null;
        this.fieldList = fieldList;
        this.fieldArray = fieldArray;
        if (fieldList != null) {
            for (i = 0; i < fieldList.length; ++i) {
                centerIt = this.initializeField(fieldList[i], i, 0, centerIt);
            }
            buttonRow = fieldList.length + 1;
        } else if (fieldArray != null) {
            for (i = 0; i < fieldArray.length; ++i) {
                Field[] row = fieldArray[i];
                for (int j = 0; j < row.length; ++j) {
                    centerIt = this.initializeField(row[j], i, j, centerIt);
                }
            }
            buttonRow = fieldArray.length + 1;
        }
        if (centerIt == null) {
            centerIt = fieldList[0].labelObj;
        }
        String badButton = this.yesNo ? "No" : "Cancel";
        JButton cancel = new JButton(badButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = buttonRow;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.weightx = 0.5;
        this.getContentPane().add((Component)cancel, gbc);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PromptAt.this.exit(false);
            }
        });
        String goodButton = this.yesNo ? "Yes" : "OK";
        JButton ok = new JButton(goodButton);
        this.getRootPane().setDefaultButton(ok);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = buttonRow;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.weightx = 0.5;
        this.getContentPane().add((Component)ok, gbc);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PromptAt.this.exit(true);
            }
        });
        this.pack();
        Point ew = wnd.getScreenLocationOfCorner();
        Point locInWnd = wnd.databaseToScreen(ni.getAnchorCenterX(), ni.getAnchorCenterY());
        Point textfield = centerIt.getLocation();
        Dimension textSize = centerIt.getSize();
        this.setLocation(locInWnd.x + ew.x - (textfield.x + textSize.width / 2), locInWnd.y + ew.y - (textfield.y + textSize.height / 2 + 20));
    }

    private JComponent initializeField(Field field2, int i, int j, JComponent centerIt) {
        GridBagConstraints gbc;
        if (field2 == null) {
            return centerIt;
        }
        if (field2.label != null) {
            field2.labelObj = new JLabel(field2.label);
            gbc = new GridBagConstraints();
            gbc.gridx = j * 4;
            gbc.gridy = i;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            this.getContentPane().add((Component)field2.labelObj, gbc);
        }
        switch (field2.type) {
            case 3: {
                field2.textField = new JTextField((String)field2.initial);
                gbc = new GridBagConstraints();
                gbc.gridx = j * 4 + 1;
                gbc.gridy = i;
                gbc.gridwidth = 3;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)field2.textField, gbc);
                if (centerIt != null) break;
                field2.textField.selectAll();
                centerIt = field2.textField;
                break;
            }
            case 4: {
                field2.combo = new JComboBox();
                String[] poss = (String[])field2.initial;
                for (int k = 0; k < poss.length; ++k) {
                    field2.combo.addItem(poss[k]);
                }
                field2.combo.setSelectedItem(field2.finalValue);
                gbc = new GridBagConstraints();
                gbc.gridx = j * 4 + 1;
                gbc.gridy = i;
                gbc.gridwidth = 3;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)field2.combo, gbc);
                if (centerIt != null) break;
                centerIt = field2.combo;
                break;
            }
            case 6: {
                JButton but = (JButton)field2.initial;
                but.addActionListener(new CustomButtonActionListener(this, field2));
                gbc = new GridBagConstraints();
                gbc.gridx = j * 4 + 1;
                gbc.gridy = i;
                gbc.gridwidth = 3;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)but, gbc);
                if (centerIt != null) break;
                centerIt = but;
                break;
            }
            case 5: {
                Color col = (Color)field2.initial;
                field2.patch = new JPanel();
                Dimension size2 = new Dimension(25, 25);
                field2.patch.setSize(size2);
                field2.patch.setPreferredSize(size2);
                field2.patch.setBackground(col);
                gbc = new GridBagConstraints();
                gbc.gridx = j * 4 + 1;
                gbc.gridy = i;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)field2.patch, gbc);
                field2.textField = new JTextField();
                field2.textField.setColumns(8);
                field2.textField.setText(col.getRed() + "," + col.getGreen() + "," + col.getBlue());
                gbc = new GridBagConstraints();
                gbc.gridx = j * 4 + 2;
                gbc.gridy = i;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)field2.textField, gbc);
                field2.textField.getDocument().addDocumentListener(new ColorDocumentListener(field2));
                field2.but = new JButton("Set");
                gbc = new GridBagConstraints();
                gbc.gridx = j * 4 + 3;
                gbc.gridy = i;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)field2.but, gbc);
                field2.but.addActionListener(new MixColorActionListener(this, field2));
                if (centerIt != null) break;
                field2.textField.selectAll();
                centerIt = field2.but;
            }
        }
        return centerIt;
    }

    private static Color parseColor(Field field2) {
        int b;
        int g;
        String newColor = field2.textField.getText();
        String[] rgb = newColor.split(",");
        if (rgb.length < 3) {
            return null;
        }
        int r = TextUtils.atoi(rgb[0]);
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if ((g = TextUtils.atoi(rgb[1])) < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if ((b = TextUtils.atoi(rgb[2])) < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    private static class ColorDocumentListener
    implements DocumentListener {
        private Field which;

        private ColorDocumentListener(Field which) {
            this.which = which;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updatePatchColor();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updatePatchColor();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updatePatchColor();
        }

        private void updatePatchColor() {
            Color newColor = PromptAt.parseColor(this.which);
            this.which.patch.setBackground(newColor);
        }
    }

    private static class CustomButtonActionListener
    implements ActionListener {
        private PromptAt top;
        private Field field;

        private CustomButtonActionListener(PromptAt top, Field field2) {
            this.top = top;
            this.field = field2;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.top.customButtonClicked = (String)this.field.finalValue;
            this.top.exit(true);
        }
    }

    private static class MixColorActionListener
    implements ActionListener {
        private PromptAt top;
        private Field field;

        private MixColorActionListener(PromptAt top, Field field2) {
            this.top = top;
            this.field = field2;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Color origColor = PromptAt.parseColor(this.field);
            Color newColor = JColorChooser.showDialog(this.top, "Edit color", origColor);
            if (newColor == null) {
                return;
            }
            this.field.textField.setText(newColor.getRed() + "," + newColor.getGreen() + "," + newColor.getBlue());
            this.field.patch.setBackground(newColor);
        }
    }

    public static class Field {
        private String label;
        private Object initial;
        private Object finalValue;
        private int type;
        private JTextField textField;
        private JComboBox combo;
        private JButton but;
        private JPanel patch;
        private JLabel labelObj;
        private static final int FIELD_MESSAGE = 1;
        private static final int FIELD_BOOL = 2;
        private static final int FIELD_STRING = 3;
        private static final int FIELD_SELECT = 4;
        private static final int FIELD_COLOR = 5;
        private static final int FIELD_BUTTON = 6;

        public Field(String label) {
            this.label = label;
            this.initial = null;
            this.finalValue = null;
            this.type = 1;
        }

        public Field(String label, boolean initial) {
            this.label = label;
            this.finalValue = this.initial = Boolean.valueOf(initial);
            this.type = 2;
        }

        public Field(String label, String initial) {
            this.label = label;
            this.finalValue = this.initial = initial;
            this.type = 3;
        }

        public Field(String label, String[] choices, String initial) {
            this.label = label;
            this.initial = choices;
            this.finalValue = initial;
            this.type = 4;
        }

        public Field(String label, Color initial) {
            this.label = label;
            this.initial = initial;
            this.finalValue = initial;
            this.type = 5;
        }

        public Field(String id, JButton but) {
            this.label = null;
            this.initial = but;
            this.finalValue = id;
            this.type = 6;
        }

        public Object getFinal() {
            return this.finalValue;
        }
    }
}

